/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.List;
import org.infinispan.config.Configuration;
import org.infinispan.config.FluentConfiguration;
import org.jboss.as.clustering.infinispan.subsystem.CacheAdd;
import org.jboss.as.clustering.infinispan.subsystem.Mode;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;

public abstract class ClusteredCacheAdd
extends CacheAdd {
    private final Configuration.CacheMode mode;

    ClusteredCacheAdd(Configuration.CacheMode mode) {
        this.mode = mode;
    }

    void populateMode(ModelNode fromModel, ModelNode toModel) {
        toModel.get("mode").set(Mode.forCacheMode(Configuration.CacheMode.valueOf((String)fromModel.get("cache-mode").asString())).name());
    }

    @Override
    void populateCacheMode(ModelNode fromModel, ModelNode toModel) throws OperationFailedException {
        toModel.get("cache-mode").set(Mode.valueOf(fromModel.require("mode").asString()).apply(this.mode).name());
    }

    @Override
    void populate(ModelNode fromModel, ModelNode toModel) {
        super.populate(fromModel, toModel);
        if (fromModel.hasDefined("queue-size")) {
            toModel.get("queue-size").set(fromModel.get("queue-size"));
        }
        if (fromModel.hasDefined("queue-flush-interval")) {
            toModel.get("queue-flush-interval").set(fromModel.get("queue-flush-interval"));
        }
        if (fromModel.hasDefined("remote-timeout")) {
            toModel.get("remote-timeout").set(fromModel.get("remote-timeout"));
        }
    }

    @Override
    void processModelNode(ModelNode cache, Configuration configuration, List<CacheAdd.AdditionalDependency<?>> additionalDeps) {
        super.processModelNode(cache, configuration, additionalDeps);
        FluentConfiguration fluent = configuration.fluent();
        if (cache.hasDefined("queue-size")) {
            fluent.async().replQueueMaxElements(Integer.valueOf(cache.get("queue-size").asInt()));
        }
        if (cache.hasDefined("queue-flush-interval")) {
            fluent.async().replQueueInterval(Long.valueOf(cache.get("queue-flush-interval").asLong()));
        }
        if (cache.hasDefined("remote-timeout")) {
            // empty if block
        }
    }
}

