/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.infinispan.config.Configuration;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.transaction.LockingMode;
import org.infinispan.util.concurrent.IsolationLevel;
import org.jboss.as.clustering.infinispan.InfinispanLogger;
import org.jboss.as.clustering.infinispan.subsystem.Attribute;
import org.jboss.as.clustering.infinispan.subsystem.Element;
import org.jboss.as.clustering.infinispan.subsystem.Indexing;
import org.jboss.as.clustering.infinispan.subsystem.Mode;
import org.jboss.as.clustering.infinispan.subsystem.Namespace;
import org.jboss.as.clustering.infinispan.subsystem.StartMode;
import org.jboss.as.clustering.infinispan.subsystem.TransactionMode;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class InfinispanSubsystemParser_1_0
implements XMLElementReader<List<ModelNode>>,
XMLElementWriter<SubsystemMarshallingContext> {
    private static final InfinispanSubsystemParser_1_0 INSTANCE = new InfinispanSubsystemParser_1_0();

    public static InfinispanSubsystemParser_1_0 getInstance() {
        return INSTANCE;
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode subsystemAddress = new ModelNode();
        subsystemAddress.add("subsystem", "infinispan");
        subsystemAddress.protect();
        ModelNode subsystem = Util.getEmptyOperation((String)"add", (ModelNode)subsystemAddress);
        block9: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case DEFAULT_CACHE_CONTAINER: {
                    subsystem.get("default-cache-container").set(value);
                    continue block9;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!subsystem.hasDefined("default-cache-container")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.DEFAULT_CACHE_CONTAINER));
        }
        operations.add(subsystem);
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case INFINISPAN_1_0: 
                case INFINISPAN_1_1: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case CACHE_CONTAINER: {
                            this.parseContainer(reader, subsystemAddress, operations);
                            continue block10;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseContainer(XMLExtendedStreamReader reader, ModelNode subsystemAddress, List<ModelNode> operations) throws XMLStreamException {
        ModelNode container = Util.getEmptyOperation((String)"add", null);
        String name = null;
        block16: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block16;
                }
                case DEFAULT_CACHE: {
                    container.get("default-cache").set(value);
                    continue block16;
                }
                case JNDI_NAME: {
                    container.get("jndi-name").set(value);
                    continue block16;
                }
                case LISTENER_EXECUTOR: {
                    container.get("listener-executor").set(value);
                    continue block16;
                }
                case EVICTION_EXECUTOR: {
                    container.get("eviction-executor").set(value);
                    continue block16;
                }
                case REPLICATION_QUEUE_EXECUTOR: {
                    container.get("replication-queue-executor").set(value);
                    continue block16;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (name == null || !container.hasDefined("default-cache")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.NAME, Attribute.DEFAULT_CACHE));
        }
        ModelNode containerAddress = subsystemAddress.clone();
        containerAddress.add("cache-container", name);
        containerAddress.protect();
        container.get("address").set(containerAddress);
        operations.add(container);
        block17: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ALIAS: {
                    container.get("alias").add(reader.getElementText());
                    continue block17;
                }
                case TRANSPORT: {
                    this.parseTransport(reader, containerAddress, operations);
                    continue block17;
                }
                case LOCAL_CACHE: {
                    this.parseLocalCache(reader, containerAddress, operations);
                    continue block17;
                }
                case INVALIDATION_CACHE: {
                    this.parseInvalidationCache(reader, containerAddress, operations);
                    continue block17;
                }
                case REPLICATED_CACHE: {
                    this.parseReplicatedCache(reader, containerAddress, operations);
                    continue block17;
                }
                case DISTRIBUTED_CACHE: {
                    this.parseDistributedCache(reader, containerAddress, operations);
                    continue block17;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseTransport(XMLExtendedStreamReader reader, ModelNode containerAddress, List<ModelNode> operations) throws XMLStreamException {
        ModelNode transport = Util.getEmptyOperation((String)"add", null);
        block8: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case STACK: {
                    transport.get("stack").set(value);
                    continue block8;
                }
                case EXECUTOR: {
                    transport.get("executor").set(value);
                    continue block8;
                }
                case LOCK_TIMEOUT: {
                    transport.get("lock-timeout").set(Long.parseLong(value));
                    continue block8;
                }
                case SITE: {
                    transport.get("site").set(value);
                    continue block8;
                }
                case RACK: {
                    transport.get("rack").set(value);
                    continue block8;
                }
                case MACHINE: {
                    transport.get("machine").set(value);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        ModelNode transportAddress = containerAddress.clone();
        transportAddress.add("singleton", "transport");
        transportAddress.protect();
        transport.get("address").set(transportAddress);
        operations.add(transport);
    }

    private void parseCacheAttribute(XMLExtendedStreamReader reader, int index, Attribute attribute, String value, ModelNode cache) throws XMLStreamException {
        switch (attribute) {
            case NAME: {
                cache.get("name").set(value);
                break;
            }
            case START: {
                try {
                    StartMode mode = StartMode.valueOf(value);
                    cache.get("start").set(mode.name());
                    break;
                }
                catch (IllegalArgumentException e) {
                    throw ParseUtils.invalidAttributeValue((XMLExtendedStreamReader)reader, (int)index);
                }
            }
            case BATCHING: {
                cache.get("batching").set(Boolean.parseBoolean(value));
                break;
            }
            case INDEXING: {
                try {
                    Indexing indexing = Indexing.valueOf(value);
                    cache.get("indexing").set(indexing.name());
                    break;
                }
                catch (IllegalArgumentException e) {
                    throw ParseUtils.invalidAttributeValue((XMLExtendedStreamReader)reader, (int)index);
                }
            }
            default: {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)index);
            }
        }
    }

    private void parseClusteredCacheAttribute(XMLExtendedStreamReader reader, int index, Attribute attribute, String value, ModelNode cache) throws XMLStreamException {
        switch (attribute) {
            case MODE: {
                cache.get("mode").set(value);
                break;
            }
            case QUEUE_SIZE: {
                cache.get("queue-size").set(Integer.parseInt(value));
                break;
            }
            case QUEUE_FLUSH_INTERVAL: {
                cache.get("queue-flush-interval").set(Long.parseLong(value));
                break;
            }
            case REMOTE_TIMEOUT: {
                cache.get("remote-timeout").set(Long.parseLong(value));
                break;
            }
            default: {
                this.parseCacheAttribute(reader, index, attribute, value, cache);
            }
        }
    }

    private void parseLocalCache(XMLExtendedStreamReader reader, ModelNode containerAddress, List<ModelNode> operations) throws XMLStreamException {
        ModelNode cache = Util.getEmptyOperation((String)"add", null);
        ArrayList<ModelNode> additionalConfigurationOperations = new ArrayList<ModelNode>();
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            this.parseCacheAttribute(reader, i, attribute, value, cache);
        }
        if (!cache.hasDefined("name")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.NAME));
        }
        this.addCacheNameToAddress(cache, containerAddress, "local-cache");
        while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            this.parseCacheElement(reader, element, cache, additionalConfigurationOperations);
        }
        operations.add(cache);
        for (ModelNode additionalOperation : additionalConfigurationOperations) {
            operations.add(additionalOperation);
        }
    }

    private void parseDistributedCache(XMLExtendedStreamReader reader, ModelNode containerAddress, List<ModelNode> operations) throws XMLStreamException {
        ModelNode cache = Util.getEmptyOperation((String)"add", null);
        ArrayList<ModelNode> additionalConfigurationOperations = new ArrayList<ModelNode>();
        block8: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case OWNERS: {
                    cache.get("owners").set(Integer.parseInt(value));
                    continue block8;
                }
                case VIRTUAL_NODES: {
                    cache.get("virtual-nodes").set(Integer.parseInt(value));
                    continue block8;
                }
                case L1_LIFESPAN: {
                    cache.get("l1-lifespan").set(Long.parseLong(value));
                    continue block8;
                }
                default: {
                    this.parseClusteredCacheAttribute(reader, i, attribute, value, cache);
                }
            }
        }
        if (!cache.hasDefined("name")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.NAME));
        }
        if (!cache.hasDefined("mode")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.MODE));
        }
        this.addCacheNameToAddress(cache, containerAddress, "distributed-cache");
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case REHASHING: {
                    this.parseRehashing(reader, cache, additionalConfigurationOperations);
                    continue block9;
                }
            }
            this.parseCacheElement(reader, element, cache, additionalConfigurationOperations);
        }
        operations.add(cache);
        for (ModelNode additionalOperation : additionalConfigurationOperations) {
            operations.add(additionalOperation);
        }
    }

    private void parseReplicatedCache(XMLExtendedStreamReader reader, ModelNode containerAddress, List<ModelNode> operations) throws XMLStreamException {
        ModelNode cache = Util.getEmptyOperation((String)"add", null);
        ArrayList<ModelNode> additionalConfigurationOperations = new ArrayList<ModelNode>();
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            this.parseClusteredCacheAttribute(reader, i, attribute, value, cache);
        }
        if (!cache.hasDefined("name")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.NAME));
        }
        if (!cache.hasDefined("mode")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.MODE));
        }
        this.addCacheNameToAddress(cache, containerAddress, "replicated-cache");
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case STATE_TRANSFER: {
                    this.parseStateTransfer(reader, cache, additionalConfigurationOperations);
                    continue block4;
                }
            }
            this.parseCacheElement(reader, element, cache, additionalConfigurationOperations);
        }
        operations.add(cache);
        for (ModelNode additionalOperation : additionalConfigurationOperations) {
            operations.add(additionalOperation);
        }
    }

    private void parseInvalidationCache(XMLExtendedStreamReader reader, ModelNode containerAddress, List<ModelNode> operations) throws XMLStreamException {
        ModelNode cache = Util.getEmptyOperation((String)"add", null);
        ArrayList<ModelNode> additionalConfigurationOperations = new ArrayList<ModelNode>();
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            this.parseClusteredCacheAttribute(reader, i, attribute, value, cache);
        }
        if (!cache.hasDefined("name")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.NAME));
        }
        if (!cache.hasDefined("mode")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.MODE));
        }
        this.addCacheNameToAddress(cache, containerAddress, "invalidation-cache");
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case STATE_TRANSFER: {
                    this.parseStateTransfer(reader, cache, additionalConfigurationOperations);
                    continue block4;
                }
            }
            this.parseCacheElement(reader, element, cache, additionalConfigurationOperations);
        }
        operations.add(cache);
        for (ModelNode additionalOperation : additionalConfigurationOperations) {
            operations.add(additionalOperation);
        }
    }

    private void addCacheNameToAddress(ModelNode cache, ModelNode containerAddress, String cacheType) {
        String name = cache.get("name").asString();
        ModelNode cacheAddress = containerAddress.clone();
        cacheAddress.add(cacheType, name);
        cacheAddress.protect();
        cache.get("address").set(cacheAddress);
        cache.remove("name");
    }

    private void parseCacheElement(XMLExtendedStreamReader reader, Element element, ModelNode cache, List<ModelNode> operations) throws XMLStreamException {
        switch (element) {
            case LOCKING: {
                this.parseLocking(reader, cache, operations);
                break;
            }
            case TRANSACTION: {
                this.parseTransaction(reader, cache, operations);
                break;
            }
            case EVICTION: {
                this.parseEviction(reader, cache, operations);
                break;
            }
            case EXPIRATION: {
                this.parseExpiration(reader, cache, operations);
                break;
            }
            case STORE: {
                this.parseCustomStore(reader, cache.get("store").setEmptyObject());
                break;
            }
            case FILE_STORE: {
                this.parseFileStore(reader, cache.get("file-store").setEmptyObject());
                break;
            }
            case JDBC_STORE: {
                this.parseJDBCStore(reader, cache.get("jdbc-store").setEmptyObject());
                break;
            }
            case REMOTE_STORE: {
                this.parseRemoteStore(reader, cache.get("remote-store").setEmptyObject());
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }
    }

    private void parseRehashing(XMLExtendedStreamReader reader, ModelNode cache, List<ModelNode> operations) throws XMLStreamException {
        ModelNode rehashingAddress = cache.get("address").clone();
        rehashingAddress.add("singleton", "rehashing");
        rehashingAddress.protect();
        ModelNode rehashing = Util.getEmptyOperation((String)"add", (ModelNode)rehashingAddress);
        block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    rehashing.get("enabled").set(Boolean.parseBoolean(value));
                    continue block5;
                }
                case TIMEOUT: {
                    rehashing.get("timeout").set(Long.parseLong(value));
                    continue block5;
                }
                case WAIT: {
                    rehashing.get("wait").set(Long.parseLong(value));
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        operations.add(rehashing);
    }

    private void parseStateTransfer(XMLExtendedStreamReader reader, ModelNode cache, List<ModelNode> operations) throws XMLStreamException {
        ModelNode stateTransferAddress = cache.get("address").clone();
        stateTransferAddress.add("singleton", "state-transfer");
        stateTransferAddress.protect();
        ModelNode stateTransfer = Util.getEmptyOperation((String)"add", (ModelNode)stateTransferAddress);
        block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    stateTransfer.get("enabled").set(Boolean.parseBoolean(value));
                    continue block5;
                }
                case TIMEOUT: {
                    stateTransfer.get("timeout").set(Long.parseLong(value));
                    continue block5;
                }
                case FLUSH_TIMEOUT: {
                    stateTransfer.get("flush-timeout").set(Long.parseLong(value));
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        operations.add(stateTransfer);
    }

    private void parseLocking(XMLExtendedStreamReader reader, ModelNode cache, List<ModelNode> operations) throws XMLStreamException {
        ModelNode lockingAddress = cache.get("address").clone();
        lockingAddress.add("singleton", "locking");
        lockingAddress.protect();
        ModelNode locking = Util.getEmptyOperation((String)"add", (ModelNode)lockingAddress);
        block8: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ISOLATION: {
                    try {
                        IsolationLevel level = IsolationLevel.valueOf((String)value);
                        locking.get("isolation").set(level.name());
                        continue block8;
                    }
                    catch (IllegalArgumentException e) {
                        throw ParseUtils.invalidAttributeValue((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
                case STRIPING: {
                    locking.get("striping").set(Boolean.parseBoolean(value));
                    continue block8;
                }
                case ACQUIRE_TIMEOUT: {
                    locking.get("acquire-timeout").set(Long.parseLong(value));
                    continue block8;
                }
                case CONCURRENCY_LEVEL: {
                    locking.get("concurrency-level").set(Integer.parseInt(value));
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        operations.add(locking);
    }

    private void parseTransaction(XMLExtendedStreamReader reader, ModelNode cache, List<ModelNode> operations) throws XMLStreamException {
        ModelNode transactionAddress = cache.get("address").clone();
        transactionAddress.add("singleton", "transaction");
        transactionAddress.protect();
        ModelNode transaction = Util.getEmptyOperation((String)"add", (ModelNode)transactionAddress);
        block10: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case STOP_TIMEOUT: {
                    transaction.get("stop-timeout").set(Long.parseLong(value));
                    continue block10;
                }
                case MODE: {
                    try {
                        transaction.get("mode").set(TransactionMode.valueOf(value).name());
                        continue block10;
                    }
                    catch (IllegalArgumentException e) {
                        throw ParseUtils.invalidAttributeValue((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
                case LOCKING: {
                    try {
                        transaction.get("locking").set(LockingMode.valueOf((String)value).name());
                        continue block10;
                    }
                    catch (IllegalArgumentException e) {
                        throw ParseUtils.invalidAttributeValue((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
                case EAGER_LOCKING: {
                    InfinispanLogger.ROOT_LOGGER.eagerAttributeDeprecated();
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        operations.add(transaction);
    }

    private void parseEviction(XMLExtendedStreamReader reader, ModelNode cache, List<ModelNode> operations) throws XMLStreamException {
        ModelNode evictionAddress = cache.get("address").clone();
        evictionAddress.add("singleton", "eviction");
        evictionAddress.protect();
        ModelNode eviction = Util.getEmptyOperation((String)"add", (ModelNode)evictionAddress);
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case STRATEGY: {
                    try {
                        EvictionStrategy strategy = EvictionStrategy.valueOf((String)value);
                        eviction.get("strategy").set(strategy.name());
                        continue block7;
                    }
                    catch (IllegalArgumentException e) {
                        throw ParseUtils.invalidAttributeValue((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
                case MAX_ENTRIES: {
                    eviction.get("max-entries").set(Integer.parseInt(value));
                    continue block7;
                }
                case INTERVAL: {
                    InfinispanLogger.ROOT_LOGGER.deprecatedAttribute(attribute.getLocalName(), Element.EVICTION.getLocalName(), "ISPN-1268");
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        operations.add(eviction);
    }

    private void parseExpiration(XMLExtendedStreamReader reader, ModelNode cache, List<ModelNode> operations) throws XMLStreamException {
        ModelNode expirationAddress = cache.get("address").clone();
        expirationAddress.add("singleton", "expiration");
        expirationAddress.protect();
        ModelNode expiration = Util.getEmptyOperation((String)"add", (ModelNode)expirationAddress);
        block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case MAX_IDLE: {
                    expiration.get("max-idle").set(Long.parseLong(value));
                    continue block5;
                }
                case LIFESPAN: {
                    expiration.get("lifespan").set(Long.parseLong(value));
                    continue block5;
                }
                case INTERVAL: {
                    expiration.get("interval").set(Long.parseLong(value));
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        operations.add(expiration);
    }

    private void parseCustomStore(XMLExtendedStreamReader reader, ModelNode store) throws XMLStreamException {
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CLASS: {
                    store.get("class").set(value);
                    continue block3;
                }
                default: {
                    this.parseStoreAttribute(reader, i, attribute, value, store);
                }
            }
        }
        if (!store.hasDefined("class")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.CLASS));
        }
        this.parseStoreProperties(reader, store);
    }

    private void parseFileStore(XMLExtendedStreamReader reader, ModelNode store) throws XMLStreamException {
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case RELATIVE_TO: {
                    store.get("relative-to").set(value);
                    continue block4;
                }
                case PATH: {
                    store.get("path").set(value);
                    continue block4;
                }
                default: {
                    this.parseStoreAttribute(reader, i, attribute, value, store);
                }
            }
        }
        this.parseStoreProperties(reader, store);
    }

    private void parseRemoteStore(XMLExtendedStreamReader reader, ModelNode store) throws XMLStreamException {
        block8: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CACHE: {
                    store.get("cache").set(value);
                    continue block8;
                }
                case SOCKET_TIMEOUT: {
                    store.get("socket-timeout").set(Long.parseLong(value));
                    continue block8;
                }
                case TCP_NO_DELAY: {
                    store.get("tcp-no-delay").set(Boolean.valueOf(value).booleanValue());
                    continue block8;
                }
                default: {
                    this.parseStoreAttribute(reader, i, attribute, value, store);
                }
            }
        }
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case REMOTE_SERVER: {
                    this.parseRemoteServer(reader, store.get("remote-server").add());
                    continue block9;
                }
            }
            this.parseStoreProperty(reader, store);
        }
        if (!store.hasDefined("remote-server")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Element.REMOTE_SERVER));
        }
    }

    private void parseRemoteServer(XMLExtendedStreamReader reader, ModelNode server) throws XMLStreamException {
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case OUTBOUND_SOCKET_BINDING: {
                    server.get("outbound-socket-binding").set(value);
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseJDBCStore(XMLExtendedStreamReader reader, ModelNode store) throws XMLStreamException {
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case DATASOURCE: {
                    store.get("datasource").set(value);
                    continue block7;
                }
                default: {
                    this.parseStoreAttribute(reader, i, attribute, value, store);
                }
            }
        }
        if (!store.hasDefined("datasource")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.DATASOURCE));
        }
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ENTRY_TABLE: {
                    this.parseJDBCStoreTable(reader, store.get("entry-table").setEmptyObject());
                    continue block8;
                }
                case BUCKET_TABLE: {
                    this.parseJDBCStoreTable(reader, store.get("bucket-table").setEmptyObject());
                    continue block8;
                }
            }
            this.parseStoreProperty(reader, store);
        }
    }

    private void parseJDBCStoreTable(XMLExtendedStreamReader reader, ModelNode table) throws XMLStreamException {
        block10: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case PREFIX: {
                    table.get("prefix").set(value);
                    continue block10;
                }
                case FETCH_SIZE: {
                    table.get("fetch-size").set(Integer.parseInt(value));
                    continue block10;
                }
                case BATCH_SIZE: {
                    table.get("batch-size").set(Integer.parseInt(value));
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        block11: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ID_COLUMN: {
                    this.parseJDBCStoreColumn(reader, table.get("id-column").setEmptyObject());
                    continue block11;
                }
                case DATA_COLUMN: {
                    this.parseJDBCStoreColumn(reader, table.get("data-column").setEmptyObject());
                    continue block11;
                }
                case TIMESTAMP_COLUMN: {
                    this.parseJDBCStoreColumn(reader, table.get("timestamp-column").setEmptyObject());
                    continue block11;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseJDBCStoreColumn(XMLExtendedStreamReader reader, ModelNode column) throws XMLStreamException {
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    column.get("name").set(value);
                    continue block4;
                }
                case TYPE: {
                    column.get("type").set(value);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseStoreAttribute(XMLExtendedStreamReader reader, int index, Attribute attribute, String value, ModelNode store) throws XMLStreamException {
        switch (attribute) {
            case SHARED: {
                store.get("shared").set(Boolean.parseBoolean(value));
                break;
            }
            case PRELOAD: {
                store.get("preload").set(Boolean.parseBoolean(value));
                break;
            }
            case PASSIVATION: {
                store.get("passivation").set(Boolean.parseBoolean(value));
                break;
            }
            case FETCH_STATE: {
                store.get("fetch-state").set(Boolean.parseBoolean(value));
                break;
            }
            case PURGE: {
                store.get("purge").set(Boolean.parseBoolean(value));
                break;
            }
            case SINGLETON: {
                store.get("singleton").set(Boolean.parseBoolean(value));
                break;
            }
            default: {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)index);
            }
        }
    }

    private void parseStoreProperties(XMLExtendedStreamReader reader, ModelNode node) throws XMLStreamException {
        while (reader.hasNext() && reader.nextTag() != 2) {
            this.parseStoreProperty(reader, node);
        }
    }

    private void parseStoreProperty(XMLExtendedStreamReader reader, ModelNode node) throws XMLStreamException {
        Element element = Element.forName(reader.getLocalName());
        switch (element) {
            case PROPERTY: {
                int attributes = reader.getAttributeCount();
                String property = null;
                block6: for (int i = 0; i < attributes; ++i) {
                    String value = reader.getAttributeValue(i);
                    Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                    switch (attribute) {
                        case NAME: {
                            property = value;
                            continue block6;
                        }
                        default: {
                            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                        }
                    }
                }
                if (property == null) {
                    throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
                }
                String value = reader.getElementText();
                node.get("property").add(property, value);
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }
    }

    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        context.startSubsystemElement(Namespace.CURRENT.getUri(), false);
        ModelNode model = context.getModelNode();
        if (model.isDefined()) {
            writer.writeAttribute(Attribute.DEFAULT_CACHE_CONTAINER.getLocalName(), model.require("default-cache-container").asString());
            for (Property entry : model.get("cache-container").asPropertyList()) {
                String[] cacheTypes;
                String containerName = entry.getName();
                ModelNode container = entry.getValue();
                writer.writeStartElement(Element.CACHE_CONTAINER.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), containerName);
                this.writeRequired(writer, Attribute.DEFAULT_CACHE, container, "default-cache");
                this.writeOptional(writer, Attribute.JNDI_NAME, container, "jndi-name");
                this.writeOptional(writer, Attribute.LISTENER_EXECUTOR, container, "listener-executor");
                this.writeOptional(writer, Attribute.EVICTION_EXECUTOR, container, "eviction-executor");
                this.writeOptional(writer, Attribute.REPLICATION_QUEUE_EXECUTOR, container, "replication-queue-executor");
                if (container.hasDefined("alias")) {
                    for (ModelNode alias : container.get("alias").asList()) {
                        writer.writeStartElement(Element.ALIAS.getLocalName());
                        writer.writeCharacters(alias.asString());
                        writer.writeEndElement();
                    }
                }
                if (container.hasDefined("singleton")) {
                    writer.writeStartElement(Element.TRANSPORT.getLocalName());
                    ModelNode transport = container.get(new String[]{"singleton", "transport"});
                    this.writeOptional(writer, Attribute.STACK, transport, "stack");
                    this.writeOptional(writer, Attribute.EXECUTOR, transport, "executor");
                    this.writeOptional(writer, Attribute.LOCK_TIMEOUT, transport, "lock-timeout");
                    this.writeOptional(writer, Attribute.SITE, transport, "site");
                    this.writeOptional(writer, Attribute.RACK, transport, "rack");
                    this.writeOptional(writer, Attribute.MACHINE, transport, "machine");
                    writer.writeEndElement();
                }
                ArrayList<Property> cachesPL = new ArrayList<Property>();
                for (String cacheType : cacheTypes = new String[]{"local-cache", "invalidation-cache", "replicated-cache", "distributed-cache"}) {
                    List<Property> cachesOfAType = InfinispanSubsystemParser_1_0.getCachesAsPropertyList(model, containerName, cacheType);
                    if (cachesOfAType == null) continue;
                    cachesPL.addAll(cachesOfAType);
                }
                ArrayList<ModelNode> caches = new ArrayList<ModelNode>();
                for (Property cacheEntry : cachesPL) {
                    caches.add(cacheEntry.getValue());
                }
                for (ModelNode cache : caches) {
                    ModelNode store;
                    Configuration.CacheMode mode = Configuration.CacheMode.valueOf((String)cache.get("cache-mode").asString());
                    if (mode.isClustered()) {
                        if (mode.isDistributed()) {
                            writer.writeStartElement(Element.DISTRIBUTED_CACHE.getLocalName());
                            this.writeOptional(writer, Attribute.OWNERS, cache, "owners");
                            this.writeOptional(writer, Attribute.VIRTUAL_NODES, cache, "virtual-nodes");
                            this.writeOptional(writer, Attribute.L1_LIFESPAN, cache, "l1-lifespan");
                        } else if (mode.isInvalidation()) {
                            writer.writeStartElement(Element.INVALIDATION_CACHE.getLocalName());
                        } else {
                            writer.writeStartElement(Element.REPLICATED_CACHE.getLocalName());
                        }
                        writer.writeAttribute(Attribute.MODE.getLocalName(), Mode.forCacheMode(mode).name());
                        this.writeOptional(writer, Attribute.QUEUE_SIZE, cache, "queue-size");
                        this.writeOptional(writer, Attribute.QUEUE_FLUSH_INTERVAL, cache, "queue-flush-interval");
                        this.writeOptional(writer, Attribute.REMOTE_TIMEOUT, cache, "remote-timeout");
                    } else {
                        writer.writeStartElement(Element.LOCAL_CACHE.getLocalName());
                    }
                    this.writeRequired(writer, Attribute.NAME, cache, "name");
                    this.writeOptional(writer, Attribute.START, cache, "start");
                    this.writeOptional(writer, Attribute.BATCHING, cache, "batching");
                    this.writeOptional(writer, Attribute.INDEXING, cache, "indexing");
                    if (cache.hasDefined("singleton")) {
                        if (cache.get(new String[]{"singleton", "locking"}).isDefined()) {
                            writer.writeStartElement(Element.LOCKING.getLocalName());
                            ModelNode locking = cache.get(new String[]{"singleton", "locking"});
                            this.writeOptional(writer, Attribute.ISOLATION, locking, "isolation");
                            this.writeOptional(writer, Attribute.STRIPING, locking, "striping");
                            this.writeOptional(writer, Attribute.ACQUIRE_TIMEOUT, locking, "acquire-timeout");
                            this.writeOptional(writer, Attribute.CONCURRENCY_LEVEL, locking, "concurrency-level");
                            writer.writeEndElement();
                        }
                        if (cache.get(new String[]{"singleton", "transaction"}).isDefined()) {
                            writer.writeStartElement(Element.TRANSACTION.getLocalName());
                            ModelNode transaction = cache.get(new String[]{"singleton", "transaction"});
                            this.writeOptional(writer, Attribute.STOP_TIMEOUT, transaction, "stop-timeout");
                            this.writeOptional(writer, Attribute.MODE, transaction, "mode");
                            this.writeOptional(writer, Attribute.LOCKING, transaction, "locking");
                            writer.writeEndElement();
                        }
                        if (cache.get(new String[]{"singleton", "eviction"}).isDefined()) {
                            writer.writeStartElement(Element.EVICTION.getLocalName());
                            ModelNode eviction = cache.get(new String[]{"singleton", "eviction"});
                            this.writeOptional(writer, Attribute.STRATEGY, eviction, "strategy");
                            this.writeOptional(writer, Attribute.MAX_ENTRIES, eviction, "max-entries");
                            writer.writeEndElement();
                        }
                        if (cache.get(new String[]{"singleton", "expiration"}).isDefined()) {
                            writer.writeStartElement(Element.EXPIRATION.getLocalName());
                            ModelNode expiration = cache.get(new String[]{"singleton", "expiration"});
                            this.writeOptional(writer, Attribute.MAX_IDLE, expiration, "max-idle");
                            this.writeOptional(writer, Attribute.LIFESPAN, expiration, "lifespan");
                            this.writeOptional(writer, Attribute.INTERVAL, expiration, "interval");
                            writer.writeEndElement();
                        }
                        if (cache.get(new String[]{"singleton", "state-transfer"}).isDefined()) {
                            ModelNode stateTransfer = cache.get(new String[]{"singleton", "state-transfer"});
                            writer.writeStartElement(Element.STATE_TRANSFER.getLocalName());
                            this.writeOptional(writer, Attribute.ENABLED, stateTransfer, "enabled");
                            this.writeOptional(writer, Attribute.TIMEOUT, stateTransfer, "timeout");
                            this.writeOptional(writer, Attribute.FLUSH_TIMEOUT, stateTransfer, "flush-timeout");
                            writer.writeEndElement();
                        }
                        if (cache.get(new String[]{"singleton", "rehashing"}).isDefined()) {
                            ModelNode rehashing = cache.get(new String[]{"singleton", "rehashing"});
                            writer.writeStartElement(Element.REHASHING.getLocalName());
                            this.writeOptional(writer, Attribute.ENABLED, rehashing, "enabled");
                            this.writeOptional(writer, Attribute.TIMEOUT, rehashing, "timeout");
                            this.writeOptional(writer, Attribute.WAIT, rehashing, "wait");
                            writer.writeEndElement();
                        }
                    }
                    if (cache.hasDefined("store")) {
                        store = cache.get("store");
                        writer.writeStartElement(Element.STORE.getLocalName());
                        this.writeRequired(writer, Attribute.CLASS, store, "class");
                        this.writeStoreAttributes(writer, store);
                        this.writeStoreProperties(writer, store);
                        writer.writeEndElement();
                    }
                    if (cache.hasDefined("file-store")) {
                        store = cache.get("file-store");
                        writer.writeStartElement(Element.FILE_STORE.getLocalName());
                        this.writeOptional(writer, Attribute.RELATIVE_TO, store, "relative-to");
                        this.writeOptional(writer, Attribute.PATH, store, "path");
                        this.writeStoreAttributes(writer, store);
                        this.writeStoreProperties(writer, store);
                        writer.writeEndElement();
                    }
                    if (cache.hasDefined("jdbc-store")) {
                        store = cache.get("jdbc-store");
                        writer.writeStartElement(Element.JDBC_STORE.getLocalName());
                        this.writeRequired(writer, Attribute.DATASOURCE, store, "datasource");
                        this.writeStoreAttributes(writer, store);
                        this.writeJDBCStoreTable(writer, Element.ENTRY_TABLE, store, "entry-table");
                        this.writeJDBCStoreTable(writer, Element.BUCKET_TABLE, store, "bucket-table");
                        this.writeStoreProperties(writer, store);
                        writer.writeEndElement();
                    }
                    if (cache.hasDefined("remote-store")) {
                        store = cache.get("remote-store");
                        writer.writeStartElement(Element.REMOTE_STORE.getLocalName());
                        this.writeOptional(writer, Attribute.CACHE, store, "cache");
                        this.writeOptional(writer, Attribute.SOCKET_TIMEOUT, store, "socket-timeout");
                        this.writeOptional(writer, Attribute.TCP_NO_DELAY, store, "tcp-no-delay");
                        this.writeStoreAttributes(writer, store);
                        for (ModelNode remoteServer : store.get("remote-server").asList()) {
                            writer.writeStartElement(Element.REMOTE_SERVER.getLocalName());
                            writer.writeAttribute(Attribute.OUTBOUND_SOCKET_BINDING.getLocalName(), remoteServer.get("outbound-socket-binding").asString());
                            writer.writeEndElement();
                        }
                        this.writeStoreProperties(writer, store);
                        writer.writeEndElement();
                    }
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
        }
        writer.writeEndElement();
    }

    public static List<Property> getCachesAsPropertyList(ModelNode model, String containerName, String cacheType) {
        ModelNode caches = model.get(new String[]{"cache-container", containerName, cacheType});
        if (caches.isDefined() && caches.getType() == ModelType.OBJECT) {
            return caches.asPropertyList();
        }
        return null;
    }

    private void writeJDBCStoreTable(XMLExtendedStreamWriter writer, Element element, ModelNode store, String key) throws XMLStreamException {
        if (store.hasDefined(key)) {
            ModelNode table = store.get(key);
            writer.writeStartElement(element.getLocalName());
            this.writeOptional(writer, Attribute.PREFIX, table, "prefix");
            this.writeOptional(writer, Attribute.BATCH_SIZE, table, "batch-size");
            this.writeOptional(writer, Attribute.FETCH_SIZE, table, "fetch-size");
            this.writeJDBCStoreColumn(writer, Element.ID_COLUMN, table, "id-column");
            this.writeJDBCStoreColumn(writer, Element.DATA_COLUMN, table, "data-column");
            this.writeJDBCStoreColumn(writer, Element.TIMESTAMP_COLUMN, table, "timestamp-column");
            writer.writeEndElement();
        }
    }

    private void writeJDBCStoreColumn(XMLExtendedStreamWriter writer, Element element, ModelNode table, String key) throws XMLStreamException {
        if (table.hasDefined(key)) {
            ModelNode column = table.get(key);
            writer.writeStartElement(element.getLocalName());
            this.writeOptional(writer, Attribute.NAME, column, "name");
            this.writeOptional(writer, Attribute.TYPE, column, "type");
            writer.writeEndElement();
        }
    }

    private void writeStoreAttributes(XMLExtendedStreamWriter writer, ModelNode store) throws XMLStreamException {
        this.writeOptional(writer, Attribute.SHARED, store, "shared");
        this.writeOptional(writer, Attribute.PRELOAD, store, "preload");
        this.writeOptional(writer, Attribute.PASSIVATION, store, "passivation");
        this.writeOptional(writer, Attribute.FETCH_STATE, store, "fetch-state");
        this.writeOptional(writer, Attribute.PURGE, store, "purge");
        this.writeOptional(writer, Attribute.SINGLETON, store, "singleton");
    }

    private void writeStoreProperties(XMLExtendedStreamWriter writer, ModelNode store) throws XMLStreamException {
        if (store.hasDefined("property")) {
            for (Property property : store.get("property").asPropertyList()) {
                writer.writeStartElement(Element.PROPERTY.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), property.getName());
                writer.writeCharacters(property.getValue().asString());
                writer.writeEndElement();
            }
        }
    }

    private void writeOptional(XMLExtendedStreamWriter writer, Attribute attribute, ModelNode model, String key) throws XMLStreamException {
        if (model.hasDefined(key)) {
            writer.writeAttribute(attribute.getLocalName(), model.get(key).asString());
        }
    }

    private void writeRequired(XMLExtendedStreamWriter writer, Attribute attribute, ModelNode model, String key) throws XMLStreamException {
        writer.writeAttribute(attribute.getLocalName(), model.require(key).asString());
    }
}

