/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import javax.management.MBeanServer;
import org.infinispan.manager.CacheContainer;
import org.jboss.as.clustering.impl.CoreGroupCommunicationService;
import org.jboss.as.clustering.infinispan.subsystem.CacheService;
import org.jboss.as.clustering.infinispan.subsystem.CommonAttributes;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerConfiguration;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerConfigurationService;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerService;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanJndiName;
import org.jboss.as.clustering.infinispan.subsystem.StartMode;
import org.jboss.as.clustering.jgroups.ChannelFactory;
import org.jboss.as.clustering.jgroups.subsystem.ChannelFactoryService;
import org.jboss.as.clustering.jgroups.subsystem.ChannelService;
import org.jboss.as.clustering.lock.impl.SharedLocalYieldingClusterLockManagerService;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.jmx.MBeanServerService;
import org.jboss.as.naming.ManagedReferenceInjector;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.server.Services;
import org.jboss.as.threads.ThreadsServices;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;
import org.jgroups.Channel;

public class CacheContainerAdd
extends AbstractAddStepHandler {
    private static final short GROUP_COMMUNICATION_SERVICE_SCOPE = 222;
    private static final Logger log = Logger.getLogger((String)CacheContainerAdd.class.getPackage().getName());
    public static final CacheContainerAdd INSTANCE = new CacheContainerAdd();

    static ModelNode createOperation(ModelNode address, ModelNode existing) throws OperationFailedException {
        ModelNode operation = Util.getEmptyOperation((String)"add", (ModelNode)address);
        CacheContainerAdd.populate(existing, operation);
        return operation;
    }

    private static void populate(ModelNode source, ModelNode target) throws OperationFailedException {
        CommonAttributes.DEFAULT_CACHE.validateAndSet(source, target);
        if (source.hasDefined("aliases")) {
            target.get("aliases").set(source.get("aliases"));
        }
        CommonAttributes.JNDI_NAME.validateAndSet(source, target);
        CommonAttributes.START.validateAndSet(source, target);
        CommonAttributes.LISTENER_EXECUTOR.validateAndSet(source, target);
        CommonAttributes.EVICTION_EXECUTOR.validateAndSet(source, target);
        CommonAttributes.REPLICATION_QUEUE_EXECUTOR.validateAndSet(source, target);
        CommonAttributes.CACHE_CONTAINER_MODULE.validateAndSet(source, target);
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        CacheContainerAdd.populate(operation, model);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        model = Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS));
        newControllers.addAll(this.installRuntimeServices(context, operation, model, verificationHandler));
    }

    Collection<ServiceController<?>> installRuntimeServices(OperationContext context, ModelNode operation, ModelNode containerModel, ServiceVerificationHandler verificationHandler) throws OperationFailedException {
        PathAddress address = this.getCacheContainerAddressFromOperation(operation);
        String name = address.getLastElement().getValue();
        ServiceTarget target = context.getServiceTarget();
        ModelNode resolvedValue = null;
        resolvedValue = CommonAttributes.DEFAULT_CACHE.resolveModelAttribute(context, containerModel);
        String defaultCache = resolvedValue.isDefined() ? resolvedValue.asString() : null;
        resolvedValue = CommonAttributes.JNDI_NAME.resolveModelAttribute(context, containerModel);
        String jndiNameString = resolvedValue.isDefined() ? resolvedValue.asString() : null;
        resolvedValue = CommonAttributes.LISTENER_EXECUTOR.resolveModelAttribute(context, containerModel);
        String listenerExecutor = resolvedValue.isDefined() ? resolvedValue.asString() : null;
        resolvedValue = CommonAttributes.EVICTION_EXECUTOR.resolveModelAttribute(context, containerModel);
        String evictionExecutor = resolvedValue.isDefined() ? resolvedValue.asString() : null;
        resolvedValue = CommonAttributes.REPLICATION_QUEUE_EXECUTOR.resolveModelAttribute(context, containerModel);
        String replicationQueueExecutor = resolvedValue.isDefined() ? resolvedValue.asString() : null;
        ServiceController.Mode initialMode = StartMode.valueOf(CommonAttributes.START.resolveModelAttribute(context, containerModel).asString()).getMode();
        ServiceName[] aliases = null;
        if (containerModel.hasDefined("aliases")) {
            List list = operation.get("aliases").asList();
            aliases = new ServiceName[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                aliases[i] = EmbeddedCacheManagerService.getServiceName(((ModelNode)list.get(i)).asString());
            }
        }
        ModuleIdentifier moduleId = (resolvedValue = CommonAttributes.CACHE_CONTAINER_MODULE.resolveModelAttribute(context, containerModel)).isDefined() ? ModuleIdentifier.fromString((String)resolvedValue.asString()) : null;
        boolean hasTransport = containerModel.hasDefined("transport") && containerModel.get("transport").hasDefined("TRANSPORT");
        String stack = null;
        String cluster = null;
        long lockTimeout = 0L;
        String transportExecutor = null;
        Transport transportConfig = null;
        ArrayList controllers = new ArrayList(6);
        if (hasTransport) {
            ModelNode transport = containerModel.get(new String[]{"transport", "TRANSPORT"});
            resolvedValue = CommonAttributes.STACK.resolveModelAttribute(context, transport);
            stack = resolvedValue.isDefined() ? resolvedValue.asString() : null;
            resolvedValue = CommonAttributes.CLUSTER.resolveModelAttribute(context, transport);
            cluster = resolvedValue.isDefined() ? resolvedValue.asString() : name;
            lockTimeout = CommonAttributes.LOCK_TIMEOUT.resolveModelAttribute(context, transport).asLong();
            resolvedValue = CommonAttributes.EXECUTOR.resolveModelAttribute(context, transport);
            transportExecutor = resolvedValue.isDefined() ? resolvedValue.asString() : null;
            transportConfig = new Transport();
            transportConfig.setLockTimeout(lockTimeout);
            controllers.add(this.installChannelService(target, name, cluster, stack, verificationHandler));
            controllers.add(this.installGroupCommunicationService(target, name, verificationHandler));
            controllers.add(this.installLockManager(target, name, verificationHandler));
        }
        controllers.add(this.installContainerConfigurationService(target, name, defaultCache, moduleId, transportConfig, transportExecutor, listenerExecutor, evictionExecutor, replicationQueueExecutor, verificationHandler));
        controllers.add(this.installContainerService(target, name, aliases, initialMode, verificationHandler));
        controllers.add(this.installJndiService(target, name, jndiNameString, verificationHandler));
        log.debugf("%s cache container installed", (Object)name);
        return controllers;
    }

    void removeRuntimeServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        PathAddress address = this.getCacheContainerAddressFromOperation(operation);
        String containerName = address.getLastElement().getValue();
        ModelNode resolvedValue = null;
        resolvedValue = CommonAttributes.JNDI_NAME.resolveModelAttribute(context, model);
        String jndiNameString = resolvedValue.isDefined() ? resolvedValue.asString() : null;
        String jndiName = InfinispanJndiName.createCacheContainerJndiNameOrDefault(jndiNameString, containerName);
        ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)jndiName);
        context.removeService(bindInfo.getBinderServiceName());
        context.removeService(EmbeddedCacheManagerService.getServiceName(containerName));
        context.removeService(EmbeddedCacheManagerConfigurationService.getServiceName(containerName));
        ServiceName channelServiceName = ChannelService.getServiceName((String)containerName);
        ServiceController channelServiceController = context.getServiceRegistry(false).getService(channelServiceName);
        if (channelServiceController != null) {
            context.removeService(SharedLocalYieldingClusterLockManagerService.getServiceName((String)containerName));
            context.removeService(CoreGroupCommunicationService.getServiceName((String)containerName));
            context.removeService(channelServiceName);
        }
    }

    ServiceController<?> installChannelService(ServiceTarget target, String containerName, String cluster, String stack, ServiceVerificationHandler verificationHandler) {
        ServiceName channelServiceName = ChannelService.getServiceName((String)containerName);
        InjectedValue channelFactory = new InjectedValue();
        return target.addService(channelServiceName, (Service)new ChannelService(cluster, (Value)channelFactory)).addDependency(ChannelFactoryService.getServiceName((String)stack), ChannelFactory.class, (Injector)channelFactory).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
    }

    ServiceController<?> installGroupCommunicationService(ServiceTarget target, String containerName, ServiceVerificationHandler verificationHandler) {
        InjectedValue channel = new InjectedValue();
        InjectedValue loader = new InjectedValue();
        return target.addService(CoreGroupCommunicationService.getServiceName((String)containerName), (Service)new CoreGroupCommunicationService(222, (Value)channel, (Value)loader)).addDependency(CacheService.getServiceName(containerName, null)).addDependency(ChannelService.getServiceName((String)containerName), Channel.class, (Injector)channel).addDependency(Services.JBOSS_SERVICE_MODULE_LOADER, ModuleLoader.class, (Injector)loader).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
    }

    ServiceController<?> installLockManager(ServiceTarget target, String containerName, ServiceVerificationHandler verificationHandler) {
        InjectedValue service = new InjectedValue();
        return target.addService(SharedLocalYieldingClusterLockManagerService.getServiceName((String)containerName), (Service)new SharedLocalYieldingClusterLockManagerService(containerName, (Value)service)).addDependency(CoreGroupCommunicationService.getServiceName((String)containerName), CoreGroupCommunicationService.class, (Injector)service).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
    }

    PathAddress getCacheContainerAddressFromOperation(ModelNode operation) {
        return PathAddress.pathAddress((ModelNode)operation.get("address"));
    }

    ServiceController<?> installContainerConfigurationService(ServiceTarget target, String containerName, String defaultCache, ModuleIdentifier moduleId, Transport transportConfig, String transportExecutor, String listenerExecutor, String evictionExecutor, String replicationQueueExecutor, ServiceVerificationHandler verificationHandler) {
        ServiceName configServiceName = EmbeddedCacheManagerConfigurationService.getServiceName(containerName);
        EmbeddedCacheManagerDependencies dependencies = new EmbeddedCacheManagerDependencies(transportConfig);
        ServiceBuilder configBuilder = target.addService(configServiceName, (Service)new EmbeddedCacheManagerConfigurationService(containerName, defaultCache, moduleId, dependencies)).addDependency(Services.JBOSS_SERVICE_MODULE_LOADER, ModuleLoader.class, dependencies.getModuleLoaderInjector()).addDependency(MBeanServerService.SERVICE_NAME, MBeanServer.class, dependencies.getMBeanServerInjector()).setInitialMode(ServiceController.Mode.ON_DEMAND);
        if (transportConfig != null) {
            if (transportExecutor != null) {
                this.addExecutorDependency((ServiceBuilder<EmbeddedCacheManagerConfiguration>)configBuilder, transportExecutor, transportConfig.getExecutorInjector());
            }
            ServiceName channelServiceName = ChannelService.getServiceName((String)containerName);
            configBuilder.addDependency(channelServiceName, Channel.class, transportConfig.getChannelInjector());
        }
        this.addExecutorDependency((ServiceBuilder<EmbeddedCacheManagerConfiguration>)configBuilder, listenerExecutor, dependencies.getListenerExecutorInjector());
        this.addScheduledExecutorDependency((ServiceBuilder<EmbeddedCacheManagerConfiguration>)configBuilder, evictionExecutor, dependencies.getEvictionExecutorInjector());
        this.addScheduledExecutorDependency((ServiceBuilder<EmbeddedCacheManagerConfiguration>)configBuilder, replicationQueueExecutor, dependencies.getReplicationQueueExecutorInjector());
        return configBuilder.install();
    }

    ServiceController<?> installContainerService(ServiceTarget target, String containerName, ServiceName[] aliases, ServiceController.Mode initialMode, ServiceVerificationHandler verificationHandler) {
        ServiceName containerServiceName = EmbeddedCacheManagerService.getServiceName(containerName);
        ServiceName configServiceName = EmbeddedCacheManagerConfigurationService.getServiceName(containerName);
        InjectedValue config = new InjectedValue();
        return target.addService(containerServiceName, (Service)new EmbeddedCacheManagerService((Value<EmbeddedCacheManagerConfiguration>)config)).addDependency(configServiceName, EmbeddedCacheManagerConfiguration.class, (Injector)config).addAliases(aliases).setInitialMode(initialMode).install();
    }

    ServiceController<?> installJndiService(ServiceTarget target, String containerName, String jndiNameString, ServiceVerificationHandler verificationHandler) {
        String jndiName = InfinispanJndiName.createCacheContainerJndiNameOrDefault(jndiNameString, containerName);
        ServiceName containerServiceName = EmbeddedCacheManagerService.getServiceName(containerName);
        ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)jndiName);
        BinderService binder = new BinderService(bindInfo.getBindName());
        return target.addService(bindInfo.getBinderServiceName(), (Service)binder).addAliases(new ServiceName[]{ContextNames.JAVA_CONTEXT_SERVICE_NAME.append(new String[]{jndiName})}).addDependency(containerServiceName, CacheContainer.class, (Injector)new ManagedReferenceInjector(binder.getManagedObjectInjector())).addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, binder.getNamingStoreInjector()).setInitialMode(ServiceController.Mode.PASSIVE).install();
    }

    private void addExecutorDependency(ServiceBuilder<EmbeddedCacheManagerConfiguration> builder, String executor, Injector<Executor> injector) {
        if (executor != null) {
            builder.addDependency(ThreadsServices.executorName((String)executor), Executor.class, injector);
        }
    }

    private void addScheduledExecutorDependency(ServiceBuilder<EmbeddedCacheManagerConfiguration> builder, String executor, Injector<ScheduledExecutorService> injector) {
        if (executor != null) {
            builder.addDependency(ThreadsServices.executorName((String)executor), ScheduledExecutorService.class, injector);
        }
    }

    static class Transport
    implements EmbeddedCacheManagerConfigurationService.TransportConfiguration {
        private final InjectedValue<Channel> channel = new InjectedValue();
        private final InjectedValue<Executor> executor = new InjectedValue();
        private Long lockTimeout;

        Transport() {
        }

        void setLockTimeout(long lockTimeout) {
            this.lockTimeout = lockTimeout;
        }

        Injector<Channel> getChannelInjector() {
            return this.channel;
        }

        Injector<Executor> getExecutorInjector() {
            return this.executor;
        }

        @Override
        public Channel getChannel() {
            return (Channel)this.channel.getValue();
        }

        @Override
        public Executor getExecutor() {
            return (Executor)this.executor.getOptionalValue();
        }

        @Override
        public Long getLockTimeout() {
            return this.lockTimeout;
        }
    }

    static class EmbeddedCacheManagerDependencies
    implements EmbeddedCacheManagerConfigurationService.Dependencies {
        private final InjectedValue<MBeanServer> mbeanServer = new InjectedValue();
        private final InjectedValue<Executor> listenerExecutor = new InjectedValue();
        private final InjectedValue<ScheduledExecutorService> evictionExecutor = new InjectedValue();
        private final InjectedValue<ScheduledExecutorService> replicationQueueExecutor = new InjectedValue();
        private final EmbeddedCacheManagerConfigurationService.TransportConfiguration transport;
        private final InjectedValue<ModuleLoader> moduleLoader = new InjectedValue();

        EmbeddedCacheManagerDependencies(EmbeddedCacheManagerConfigurationService.TransportConfiguration transport) {
            this.transport = transport;
        }

        Injector<MBeanServer> getMBeanServerInjector() {
            return this.mbeanServer;
        }

        Injector<Executor> getListenerExecutorInjector() {
            return this.listenerExecutor;
        }

        Injector<ScheduledExecutorService> getEvictionExecutorInjector() {
            return this.evictionExecutor;
        }

        Injector<ScheduledExecutorService> getReplicationQueueExecutorInjector() {
            return this.replicationQueueExecutor;
        }

        Injector<ModuleLoader> getModuleLoaderInjector() {
            return this.moduleLoader;
        }

        @Override
        public EmbeddedCacheManagerConfigurationService.TransportConfiguration getTransportConfiguration() {
            return this.transport;
        }

        @Override
        public MBeanServer getMBeanServer() {
            return (MBeanServer)this.mbeanServer.getOptionalValue();
        }

        @Override
        public Executor getListenerExecutor() {
            return (Executor)this.listenerExecutor.getOptionalValue();
        }

        @Override
        public ScheduledExecutorService getEvictionExecutor() {
            return (ScheduledExecutorService)this.evictionExecutor.getOptionalValue();
        }

        @Override
        public ScheduledExecutorService getReplicationQueueExecutor() {
            return (ScheduledExecutorService)this.replicationQueueExecutor.getOptionalValue();
        }

        @Override
        public ModuleLoader getModuleLoader() {
            return (ModuleLoader)this.moduleLoader.getValue();
        }
    }
}

