/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachemanagerlistener.annotation.CacheStarted;
import org.infinispan.notifications.cachemanagerlistener.annotation.CacheStopped;
import org.infinispan.notifications.cachemanagerlistener.event.CacheStartedEvent;
import org.infinispan.notifications.cachemanagerlistener.event.CacheStoppedEvent;
import org.jboss.as.clustering.infinispan.DefaultEmbeddedCacheManager;
import org.jboss.as.clustering.infinispan.InfinispanLogger;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerConfiguration;
import org.jboss.as.clustering.msc.AsynchronousService;
import org.jboss.logging.Logger;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.value.Value;

@Listener
public class EmbeddedCacheManagerService
extends AsynchronousService<EmbeddedCacheManager> {
    private static final Logger log = Logger.getLogger((String)EmbeddedCacheManagerService.class.getPackage().getName());
    private static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"infinispan"});
    private final Value<EmbeddedCacheManagerConfiguration> config;
    private volatile EmbeddedCacheManager container;

    public static ServiceName getServiceName(String name) {
        return name != null ? SERVICE_NAME.append(new String[]{name}) : SERVICE_NAME;
    }

    public EmbeddedCacheManagerService(Value<EmbeddedCacheManagerConfiguration> config) {
        this.config = config;
    }

    public EmbeddedCacheManager getValue() throws IllegalStateException, IllegalArgumentException {
        return this.container;
    }

    protected void start() {
        EmbeddedCacheManagerConfiguration config = (EmbeddedCacheManagerConfiguration)this.config.getValue();
        this.container = new DefaultEmbeddedCacheManager(config.getGlobalConfiguration(), config.getDefaultCache());
        this.container.addListener((Object)this);
        this.container.start();
        log.debugf("%s cache container started", (Object)config.getName());
    }

    protected void stop() {
        if (this.container != null && this.container.getStatus().allowInvocations()) {
            this.container.stop();
            this.container.removeListener((Object)this);
            log.debugf("%s cache container stopped", (Object)((EmbeddedCacheManagerConfiguration)this.config.getValue()).getName());
        }
    }

    @CacheStarted
    public void cacheStarted(CacheStartedEvent event) {
        InfinispanLogger.ROOT_LOGGER.cacheStarted(event.getCacheName(), ((EmbeddedCacheManagerConfiguration)this.config.getValue()).getName());
    }

    @CacheStopped
    public void cacheStopped(CacheStoppedEvent event) {
        InfinispanLogger.ROOT_LOGGER.cacheStopped(event.getCacheName(), ((EmbeddedCacheManagerConfiguration)this.config.getValue()).getName());
    }
}

