/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.clustering.jgroups.subsystem.Namespace;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class LocalDescriptions {
    private LocalDescriptions() {
    }

    static ModelNode getSubsystemDescription(Locale locale) {
        ResourceBundle resources = LocalDescriptions.getResources(locale);
        ModelNode description = LocalDescriptions.createDescription(resources, "jgroups");
        description.get("head-comment-allowed").set(true);
        description.get("tail-comment-allowed").set(true);
        description.get("namespace").set(Namespace.CURRENT.getUri());
        return description;
    }

    static ModelNode getSubsystemAddDescription(Locale locale) {
        ResourceBundle resources = LocalDescriptions.getResources(locale);
        ModelNode description = LocalDescriptions.createSubsystemOperationDescription("add", resources);
        description.get(new String[]{"request-properties", "default-stack", "type"}).set(ModelType.STRING);
        description.get(new String[]{"request-properties", "default-stack", "description"}).set(resources.getString("jgroups.default-stack"));
        description.get(new String[]{"request-properties", "default-stack", "required"}).set(false);
        return description;
    }

    static ModelNode getSubsystemDescribeDescription(Locale locale) {
        ResourceBundle resources = LocalDescriptions.getResources(locale);
        ModelNode description = LocalDescriptions.createSubsystemOperationDescription("describe", resources);
        description.get("request-properties").setEmptyObject();
        description.get(new String[]{"reply-properties", "type"}).set(ModelType.LIST);
        description.get(new String[]{"reply-properties", "value-type"}).set(ModelType.OBJECT);
        return description;
    }

    static ModelNode getProtocolStackDescription(Locale locale) {
        ResourceBundle resources = LocalDescriptions.getResources(locale);
        return LocalDescriptions.createDescription(resources, "jgroups.stack");
    }

    static ModelNode getProtocolStackAddDescription(Locale locale) {
        ResourceBundle resources = LocalDescriptions.getResources(locale);
        ModelNode description = LocalDescriptions.createProtocolStackOperationDescription("add", resources);
        description.get(new String[]{"request-properties", "transport", "type"}).set(ModelType.OBJECT);
        description.get(new String[]{"request-properties", "transport", "description"}).set(resources.getString("jgroups.stack.transport"));
        description.get(new String[]{"request-properties", "protocol", "type"}).set(ModelType.LIST);
        description.get(new String[]{"request-properties", "protocol", "value-type"}).set(ModelType.OBJECT);
        description.get(new String[]{"request-properties", "protocol", "description"}).set(resources.getString("jgroups.stack.protocol"));
        return description;
    }

    static ModelNode getProtocolStackRemoveDescription(Locale locale) {
        ResourceBundle resources = LocalDescriptions.getResources(locale);
        ModelNode description = LocalDescriptions.createProtocolStackOperationDescription("remove", resources);
        description.get("request-properties").setEmptyObject();
        return description;
    }

    private static ResourceBundle getResources(Locale locale) {
        return ResourceBundle.getBundle(LocalDescriptions.class.getName(), locale == null ? Locale.getDefault() : locale);
    }

    private static ModelNode createDescription(ResourceBundle resources, String key) {
        return LocalDescriptions.createOperationDescription(null, resources, key);
    }

    private static ModelNode createOperationDescription(String operation, ResourceBundle resources, String key) {
        ModelNode description = new ModelNode();
        if (operation != null) {
            description.get("operation-name").set(operation);
        }
        description.get("description").set(resources.getString(key));
        return description;
    }

    private static ModelNode createSubsystemOperationDescription(String operation, ResourceBundle resources) {
        return LocalDescriptions.createOperationDescription(operation, resources, "jgroups." + operation);
    }

    private static ModelNode createProtocolStackOperationDescription(String operation, ResourceBundle resources) {
        return LocalDescriptions.createOperationDescription(operation, resources, "jgroups.stack." + operation);
    }
}

