/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.clustering.jgroups.subsystem.Namespace;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class JGroupsDescriptions {
    public static final String RESOURCE_NAME = JGroupsDescriptions.class.getPackage().getName() + ".LocalDescriptions";

    private JGroupsDescriptions() {
    }

    static ModelNode getSubsystemDescription(Locale locale) {
        ResourceBundle resources = JGroupsDescriptions.getResources(locale);
        ModelNode description = JGroupsDescriptions.createDescription(resources, "jgroups");
        description.get("head-comment-allowed").set(true);
        description.get("tail-comment-allowed").set(true);
        description.get("namespace").set(Namespace.CURRENT.getUri());
        return description;
    }

    static ModelNode getSubsystemAddDescription(Locale locale) {
        ResourceBundle resources = JGroupsDescriptions.getResources(locale);
        ModelNode description = JGroupsDescriptions.createSubsystemOperationDescription("add", resources);
        description.get(new String[]{"request-properties", "default-stack", "type"}).set(ModelType.STRING);
        description.get(new String[]{"request-properties", "default-stack", "description"}).set(resources.getString("jgroups.default-stack"));
        description.get(new String[]{"request-properties", "default-stack", "required"}).set(false);
        return description;
    }

    static ModelNode getSubsystemDescribeDescription(Locale locale) {
        ResourceBundle resources = JGroupsDescriptions.getResources(locale);
        ModelNode description = JGroupsDescriptions.createSubsystemOperationDescription("describe", resources);
        description.get("request-properties").setEmptyObject();
        description.get(new String[]{"reply-properties", "type"}).set(ModelType.LIST);
        description.get(new String[]{"reply-properties", "value-type"}).set(ModelType.OBJECT);
        return description;
    }

    static ModelNode getProtocolStackDescription(Locale locale) {
        ResourceBundle resources = JGroupsDescriptions.getResources(locale);
        return JGroupsDescriptions.createDescription(resources, "jgroups.stack");
    }

    static ModelNode getProtocolStackAddDescription(Locale locale) {
        ResourceBundle resources = JGroupsDescriptions.getResources(locale);
        ModelNode description = JGroupsDescriptions.createProtocolStackOperationDescription("add", resources);
        description.get(new String[]{"request-properties", "transport", "type"}).set(ModelType.OBJECT);
        description.get(new String[]{"request-properties", "transport", "description"}).set(resources.getString("jgroups.stack.transport"));
        description.get(new String[]{"request-properties", "protocol", "type"}).set(ModelType.LIST);
        description.get(new String[]{"request-properties", "protocol", "value-type"}).set(ModelType.OBJECT);
        description.get(new String[]{"request-properties", "protocol", "description"}).set(resources.getString("jgroups.stack.protocol"));
        description.get(new String[]{"request-properties", "protocol", "required"}).set(false);
        return description;
    }

    static ModelNode getProtocolStackRemoveDescription(Locale locale) {
        ResourceBundle resources = JGroupsDescriptions.getResources(locale);
        ModelNode description = JGroupsDescriptions.createProtocolStackOperationDescription("remove", resources);
        description.get("request-properties").setEmptyObject();
        return description;
    }

    private static ResourceBundle getResources(Locale locale) {
        return ResourceBundle.getBundle(RESOURCE_NAME, locale == null ? Locale.getDefault() : locale);
    }

    private static ModelNode createDescription(ResourceBundle resources, String key) {
        return JGroupsDescriptions.createOperationDescription(null, resources, key);
    }

    private static ModelNode createOperationDescription(String operation, ResourceBundle resources, String key) {
        ModelNode description = new ModelNode();
        if (operation != null) {
            description.get("operation-name").set(operation);
        }
        description.get("description").set(resources.getString(key));
        return description;
    }

    private static ModelNode createSubsystemOperationDescription(String operation, ResourceBundle resources) {
        return JGroupsDescriptions.createOperationDescription(operation, resources, "jgroups." + operation);
    }

    private static ModelNode createProtocolStackOperationDescription(String operation, ResourceBundle resources) {
        return JGroupsDescriptions.createOperationDescription(operation, resources, "jgroups.stack." + operation);
    }
}

