/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.clustering.jgroups.subsystem.Attribute;
import org.jboss.as.clustering.jgroups.subsystem.Element;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsDescriptions;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSubsystemAdd;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSubsystemDescribe;
import org.jboss.as.clustering.jgroups.subsystem.Namespace;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolStackAdd;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolStackRemove;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.jgroups.protocols.TP;
import org.jgroups.stack.Protocol;

public class JGroupsExtension
implements Extension,
DescriptionProvider,
XMLElementReader<List<ModelNode>>,
XMLElementWriter<SubsystemMarshallingContext> {
    static final String SUBSYSTEM_NAME = "jgroups";
    private static final PathElement stacksPath = PathElement.pathElement((String)"stack");
    private static final JGroupsSubsystemAdd add = new JGroupsSubsystemAdd();
    private static final JGroupsSubsystemDescribe describe = new JGroupsSubsystemDescribe();
    private static final ProtocolStackAdd stackAdd = new ProtocolStackAdd();
    private static final ProtocolStackRemove stackRemove = new ProtocolStackRemove();
    private static final DescriptionProvider stackDescription = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return JGroupsDescriptions.getProtocolStackDescription(locale);
        }
    };

    public void initialize(ExtensionContext context) {
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME);
        subsystem.registerXMLElementWriter((XMLElementWriter)this);
        ManagementResourceRegistration registration = subsystem.registerSubsystemModel((DescriptionProvider)this);
        registration.registerOperationHandler("add", (OperationStepHandler)add, (DescriptionProvider)add, false);
        registration.registerOperationHandler("describe", (OperationStepHandler)describe, (DescriptionProvider)describe, false, OperationEntry.EntryType.PRIVATE);
        ManagementResourceRegistration stacks = registration.registerSubModel(stacksPath, stackDescription);
        stacks.registerOperationHandler("add", (OperationStepHandler)stackAdd, (DescriptionProvider)stackAdd, false);
        stacks.registerOperationHandler("remove", (OperationStepHandler)stackRemove, (DescriptionProvider)stackRemove, false);
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(Namespace.CURRENT.getUri(), (XMLElementReader)this);
    }

    public ModelNode getModelDescription(Locale locale) {
        return JGroupsDescriptions.getSubsystemDescription(locale);
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode address = new ModelNode();
        address.add("subsystem", SUBSYSTEM_NAME);
        address.protect();
        ModelNode subsystem = Util.getEmptyOperation((String)"add", (ModelNode)address);
        block9: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case DEFAULT_STACK: {
                    subsystem.get("default-stack").set(value);
                    continue block9;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!subsystem.hasDefined("default-stack")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.DEFAULT_STACK));
        }
        operations.add(subsystem);
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case JGROUPS_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case STACK: {
                            operations.add(this.parseStack(reader, address));
                            continue block10;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private ModelNode parseStack(XMLExtendedStreamReader reader, ModelNode address) throws XMLStreamException {
        String name = null;
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.NAME));
        }
        ModelNode stack = Util.getEmptyOperation((String)"add", null);
        stack.get("address").set(address).add("stack", name);
        if (!reader.hasNext() || reader.nextTag() == 2 || Element.forName(reader.getLocalName()) != Element.TRANSPORT) {
            throw ParseUtils.missingRequiredElement((XMLExtendedStreamReader)reader, Collections.singleton(Element.TRANSPORT));
        }
        this.parseProtocol(reader, stack.get("transport"), TP.class);
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PROTOCOL: {
                    this.parseProtocol(reader, stack.get("protocol").add(), Protocol.class);
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        return stack;
    }

    private void parseProtocol(XMLExtendedStreamReader reader, ModelNode protocol, Class<? extends Protocol> targetClass) throws XMLStreamException {
        block15: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case TYPE: {
                    try {
                        targetClass.getClassLoader().loadClass("org.jgroups.protocols." + value).asSubclass(targetClass).newInstance();
                        protocol.get("type").set(value);
                        continue block15;
                    }
                    catch (Exception e) {
                        throw ParseUtils.invalidAttributeValue((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
                case SHARED: {
                    protocol.get("shared").set(Boolean.parseBoolean(value));
                    continue block15;
                }
                case SOCKET_BINDING: {
                    protocol.get("socket-binding").set(value);
                    continue block15;
                }
                case DIAGNOSTICS_SOCKET_BINDING: {
                    protocol.get("diagnostics-socket-binding").set(value);
                    continue block15;
                }
                case DEFAULT_EXECUTOR: {
                    protocol.get("default-executor").set(value);
                    continue block15;
                }
                case OOB_EXECUTOR: {
                    protocol.get("oob-executor").set(value);
                    continue block15;
                }
                case TIMER_EXECUTOR: {
                    protocol.get("timer-executor").set(value);
                    continue block15;
                }
                case THREAD_FACTORY: {
                    protocol.get("thread-factory").set(value);
                    continue block15;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!protocol.hasDefined("type")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.TYPE));
        }
        while (reader.hasNext() && reader.nextTag() != 2) {
            if (Element.forName(reader.getLocalName()) != Element.PROPERTY) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            int attributes = reader.getAttributeCount();
            String property = null;
            block17: for (int i = 0; i < attributes; ++i) {
                String value = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case NAME: {
                        property = value;
                        continue block17;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            if (property == null) {
                throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
            }
            String value = reader.getElementText();
            protocol.get("property").add(property, value);
        }
    }

    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        context.startSubsystemElement(Namespace.CURRENT.getUri(), false);
        ModelNode model = context.getModelNode();
        if (model.isDefined()) {
            this.writeOptional(writer, Attribute.DEFAULT_STACK, model, "default-stack");
            for (Property property : model.get("stack").asPropertyList()) {
                writer.writeStartElement(Element.STACK.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), property.getName());
                ModelNode stack = property.getValue();
                this.writeProtocol(writer, stack.get("transport"), Element.TRANSPORT);
                if (stack.hasDefined("protocol")) {
                    for (ModelNode protocol : stack.get("protocol").asList()) {
                        this.writeProtocol(writer, protocol, Element.PROTOCOL);
                    }
                }
                writer.writeEndElement();
            }
        }
        writer.writeEndElement();
    }

    private void writeProtocol(XMLExtendedStreamWriter writer, ModelNode protocol, Element element) throws XMLStreamException {
        writer.writeStartElement(element.getLocalName());
        this.writeRequired(writer, Attribute.TYPE, protocol, "type");
        this.writeOptional(writer, Attribute.SHARED, protocol, "shared");
        this.writeOptional(writer, Attribute.SOCKET_BINDING, protocol, "socket-binding");
        this.writeOptional(writer, Attribute.DIAGNOSTICS_SOCKET_BINDING, protocol, "diagnostics-socket-binding");
        this.writeOptional(writer, Attribute.DEFAULT_EXECUTOR, protocol, "default-executor");
        this.writeOptional(writer, Attribute.OOB_EXECUTOR, protocol, "oob-executor");
        this.writeOptional(writer, Attribute.TIMER_EXECUTOR, protocol, "timer-executor");
        this.writeOptional(writer, Attribute.THREAD_FACTORY, protocol, "thread-factory");
        if (protocol.has("property")) {
            for (Property property : protocol.get("property").asPropertyList()) {
                writer.writeStartElement(Element.PROPERTY.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), property.getName());
                writer.writeCharacters(property.getValue().asString());
                writer.writeEndElement();
            }
        }
        writer.writeEndElement();
    }

    private void writeRequired(XMLExtendedStreamWriter writer, Attribute attribute, ModelNode model, String key) throws XMLStreamException {
        writer.writeAttribute(attribute.getLocalName(), model.require(key).asString());
    }

    private void writeOptional(XMLExtendedStreamWriter writer, Attribute attribute, ModelNode model, String key) throws XMLStreamException {
        if (model.hasDefined(key)) {
            writer.writeAttribute(attribute.getLocalName(), model.get(key).asString());
        }
    }
}

