/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import javax.management.MBeanServer;
import org.jboss.as.clustering.concurrent.ManagedExecutorService;
import org.jboss.as.clustering.concurrent.ManagedScheduledExecutorService;
import org.jboss.as.clustering.jgroups.ChannelFactory;
import org.jboss.as.clustering.jgroups.JGroupsLogger;
import org.jboss.as.clustering.jgroups.ManagedSocketFactory;
import org.jboss.as.clustering.jgroups.MuxChannel;
import org.jboss.as.clustering.jgroups.ProtocolConfiguration;
import org.jboss.as.clustering.jgroups.ProtocolStackConfiguration;
import org.jboss.as.clustering.jgroups.ThreadFactoryAdapter;
import org.jboss.as.clustering.jgroups.TimerSchedulerAdapter;
import org.jboss.as.clustering.jgroups.TopologyAddressGenerator;
import org.jboss.as.clustering.jgroups.TransportConfiguration;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.server.ServerEnvironment;
import org.jgroups.Channel;
import org.jgroups.ChannelListener;
import org.jgroups.JChannel;
import org.jgroups.conf.ProtocolStackConfigurator;
import org.jgroups.jmx.JmxConfigurator;
import org.jgroups.protocols.TP;
import org.jgroups.stack.Protocol;
import org.jgroups.util.SocketFactory;
import org.jgroups.util.ThreadFactory;

public class JChannelFactory
implements ChannelFactory,
ChannelListener,
ProtocolStackConfigurator {
    private final ProtocolStackConfiguration configuration;
    private final Map<Channel, String> channels = Collections.synchronizedMap(new WeakHashMap());

    public JChannelFactory(ProtocolStackConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public ServerEnvironment getServerEnvironment() {
        return this.configuration.getEnvironment();
    }

    @Override
    public ProtocolStackConfiguration getProtocolStackConfiguration() {
        return this.configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Channel createChannel(String id) throws Exception {
        MBeanServer server;
        MuxChannel channel = new MuxChannel(this);
        TP transport = channel.getProtocolStack().getTransport();
        if (transport.isSingleton()) {
            TP tP = transport;
            synchronized (tP) {
                this.init(transport);
            }
        } else {
            this.init(transport);
        }
        channel.setName(this.configuration.getEnvironment().getNodeName() + "/" + id);
        TransportConfiguration.Topology topology = this.configuration.getTransport().getTopology();
        if (topology != null) {
            channel.setAddressGenerator(new TopologyAddressGenerator((Channel)channel, topology.getSite(), topology.getRack(), topology.getMachine()));
        }
        if ((server = this.configuration.getMBeanServer()) != null) {
            try {
                this.channels.put((Channel)channel, id);
                JmxConfigurator.registerChannel((JChannel)channel, (MBeanServer)server, (String)id);
            }
            catch (Exception e) {
                JGroupsLogger.ROOT_LOGGER.warn(e.getMessage(), e);
            }
            channel.addChannelListener(this);
        }
        return channel;
    }

    private void init(TP transport) {
        ScheduledExecutorService timerExecutor;
        ExecutorService oobExecutor;
        ExecutorService defaultExecutor;
        java.util.concurrent.ThreadFactory threadFactory;
        SocketFactory factory;
        TransportConfiguration transportConfig = this.configuration.getTransport();
        SocketBinding binding = transportConfig.getSocketBinding();
        if (binding != null && !((factory = transport.getSocketFactory()) instanceof ManagedSocketFactory)) {
            transport.setSocketFactory((SocketFactory)new ManagedSocketFactory(factory, binding.getSocketBindings()));
        }
        if ((threadFactory = transportConfig.getThreadFactory()) != null && !(transport.getThreadFactory() instanceof ThreadFactoryAdapter)) {
            transport.setThreadFactory((ThreadFactory)new ThreadFactoryAdapter(threadFactory));
        }
        if ((defaultExecutor = transportConfig.getDefaultExecutor()) != null && !(transport.getDefaultThreadPool() instanceof ManagedExecutorService)) {
            transport.setDefaultThreadPool((Executor)new ManagedExecutorService(defaultExecutor));
        }
        if ((oobExecutor = transportConfig.getOOBExecutor()) != null && !(transport.getOOBThreadPool() instanceof ManagedExecutorService)) {
            transport.setOOBThreadPool((Executor)new ManagedExecutorService(oobExecutor));
        }
        if ((timerExecutor = transportConfig.getTimerExecutor()) != null && !(transport.getTimer() instanceof TimerSchedulerAdapter)) {
            this.setValue((Protocol)transport, "timer", new TimerSchedulerAdapter((ScheduledExecutorService)new ManagedScheduledExecutorService(timerExecutor)));
        }
    }

    public String getProtocolStackString() {
        return null;
    }

    public List<org.jgroups.conf.ProtocolConfiguration> getProtocolStack() {
        SocketBinding diagnosticsSocketBinding;
        SocketBinding binding;
        ArrayList<org.jgroups.conf.ProtocolConfiguration> configs = new ArrayList<org.jgroups.conf.ProtocolConfiguration>(this.configuration.getProtocols().size() + 1);
        TransportConfiguration transport = this.configuration.getTransport();
        org.jgroups.conf.ProtocolConfiguration config = this.createProtocol(transport);
        Map properties = config.getProperties();
        if (transport.isShared()) {
            properties.put("singleton_name", this.configuration.getName());
        }
        if ((binding = transport.getSocketBinding()) != null) {
            this.configureBindAddress(transport, config, binding);
            this.configureServerSocket(transport, config, "bind_port", binding);
            this.configureMulticastSocket(transport, config, "mcast_addr", "mcast_port", binding);
        }
        boolean diagnostics = (diagnosticsSocketBinding = transport.getDiagnosticsSocketBinding()) != null;
        properties.put("enable_diagnostics", String.valueOf(diagnostics));
        if (diagnostics) {
            this.configureMulticastSocket(transport, config, "diagnostics_addr", "diagnostics_port", diagnosticsSocketBinding);
        }
        configs.add(config);
        boolean supportsMulticast = transport.hasProperty("mcast_addr");
        for (ProtocolConfiguration protocol : this.configuration.getProtocols()) {
            config = this.createProtocol(protocol);
            binding = protocol.getSocketBinding();
            if (binding != null) {
                this.configureBindAddress(protocol, config, binding);
                this.configureServerSocket(protocol, config, "bind_port", binding);
                this.configureServerSocket(protocol, config, "start_port", binding);
                this.configureMulticastSocket(protocol, config, "mcast_addr", "mcast_port", binding);
            } else if (transport.getSocketBinding() != null) {
                this.configureBindAddress(protocol, config, transport.getSocketBinding());
            }
            if (!supportsMulticast) {
                this.setProperty(protocol, config, "use_mcast_xmit", String.valueOf(false));
            }
            configs.add(config);
        }
        return configs;
    }

    private void configureBindAddress(ProtocolConfiguration protocol, org.jgroups.conf.ProtocolConfiguration config, SocketBinding binding) {
        this.setPropertyNoOverride(protocol, config, "bind_addr", binding.getSocketAddress().getAddress().getHostAddress());
    }

    private void configureServerSocket(ProtocolConfiguration protocol, org.jgroups.conf.ProtocolConfiguration config, String property, SocketBinding binding) {
        this.setPropertyNoOverride(protocol, config, property, String.valueOf(binding.getSocketAddress().getPort()));
    }

    private void configureMulticastSocket(ProtocolConfiguration protocol, org.jgroups.conf.ProtocolConfiguration config, String addressProperty, String portProperty, SocketBinding binding) {
        try {
            InetSocketAddress mcastSocketAddress = binding.getMulticastSocketAddress();
            this.setPropertyNoOverride(protocol, config, addressProperty, mcastSocketAddress.getAddress().getHostAddress());
            this.setPropertyNoOverride(protocol, config, portProperty, String.valueOf(mcastSocketAddress.getPort()));
        }
        catch (IllegalStateException e) {
            JGroupsLogger.ROOT_LOGGER.couldNotSetAddressAndPortNoMulticastSocket(e, config.getProtocolName(), addressProperty, config.getProtocolName(), portProperty, binding.getName());
        }
    }

    private void setPropertyNoOverride(ProtocolConfiguration protocol, org.jgroups.conf.ProtocolConfiguration config, String name, String value) {
        boolean overridden = false;
        String propertyValue = null;
        try {
            overridden = config.getOriginalProperties().containsKey(name);
            if (overridden) {
                propertyValue = (String)config.getOriginalProperties().get(name);
            }
        }
        catch (Exception e) {
            JGroupsLogger.ROOT_LOGGER.unableToAccessProtocolPropertyValue(e, name, protocol.getName());
        }
        if (overridden) {
            JGroupsLogger.ROOT_LOGGER.unableToOverrideSocketBindingValue(name, protocol.getName(), value, propertyValue);
        }
        this.setProperty(protocol, config, name, value);
    }

    private void setProperty(ProtocolConfiguration protocol, org.jgroups.conf.ProtocolConfiguration config, String name, String value) {
        if (protocol.hasProperty(name)) {
            config.getProperties().put(name, value);
        }
    }

    private org.jgroups.conf.ProtocolConfiguration createProtocol(ProtocolConfiguration protocolConfig) {
        String protocol = protocolConfig.getName();
        final HashMap<String, String> properties = new HashMap<String, String>(this.configuration.getDefaults().getProperties(protocol));
        properties.putAll(protocolConfig.getProperties());
        return new org.jgroups.conf.ProtocolConfiguration(protocol, properties){

            public Map<String, String> getOriginalProperties() {
                return properties;
            }
        };
    }

    private void setValue(Protocol protocol, String property, Object value) {
        JGroupsLogger.ROOT_LOGGER.setProtocolPropertyValue(protocol.getName(), property, value);
        try {
            protocol.setValue(property, value);
        }
        catch (IllegalArgumentException e) {
            JGroupsLogger.ROOT_LOGGER.nonExistentProtocolPropertyValue(e, protocol.getName(), property, value);
        }
    }

    public void channelConnected(Channel channel) {
    }

    public void channelDisconnected(Channel channel) {
    }

    public void channelClosed(Channel channel) {
        MBeanServer server = this.configuration.getMBeanServer();
        if (server != null) {
            try {
                JmxConfigurator.unregisterChannel((JChannel)((JChannel)channel), (MBeanServer)server, (String)this.channels.remove(channel));
            }
            catch (Exception e) {
                JGroupsLogger.ROOT_LOGGER.warn(e.getMessage(), e);
            }
        }
    }
}

