/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.registry;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.event.CacheEntryCreatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryRemovedEvent;
import org.infinispan.notifications.cachemanagerlistener.annotation.ViewChanged;
import org.infinispan.notifications.cachemanagerlistener.event.ViewChangedEvent;
import org.infinispan.remoting.transport.Address;
import org.jboss.as.clustering.infinispan.invoker.BatchOperation;
import org.jboss.as.clustering.infinispan.invoker.CacheInvoker;
import org.jboss.as.clustering.msc.AsynchronousService;
import org.jboss.as.clustering.registry.Registry;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;

@Listener(sync=false)
public class RegistryService<K, V>
extends AsynchronousService<Registry<K, V>>
implements Registry<K, V> {
    static final Address LOCAL_ADDRESS = new Address(){};
    private final InjectedValue<Cache> cacheRef = new InjectedValue();
    private final Registry.RegistryEntryProvider<K, V> provider;
    private final Set<Registry.Listener<K, V>> listeners = new CopyOnWriteArraySet<Registry.Listener<K, V>>();
    private volatile Cache<Address, Map.Entry<K, V>> cache;

    public RegistryService(Registry.RegistryEntryProvider<K, V> provider) {
        this.provider = provider;
    }

    public ServiceBuilder<Registry<K, V>> build(ServiceTarget target, ServiceName serviceName, ServiceName cacheServiceName) {
        return target.addService(serviceName, (Service)this).addDependency(cacheServiceName, Cache.class, this.cacheRef);
    }

    public Injector<Cache> getCacheInjector() {
        return this.cacheRef;
    }

    public Registry<K, V> getValue() {
        return this;
    }

    @Override
    public String getName() {
        return this.cache.getCacheManager().getClusterName();
    }

    @Override
    public void addListener(Registry.Listener<K, V> listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(Registry.Listener<K, V> listener) {
        this.listeners.remove(listener);
    }

    @Override
    public Map<K, V> getEntries() {
        HashMap map = new HashMap();
        for (Map.Entry entry : this.cache.values()) {
            map.put(entry.getKey(), entry.getValue());
        }
        return Collections.unmodifiableMap(map);
    }

    @Override
    public Map.Entry<K, V> getLocalEntry() {
        return (Map.Entry)this.cache.get((Object)RegistryService.getLocalAddress(this.cache));
    }

    @Override
    public Map.Entry<K, V> getRemoteEntry(Object address) {
        return (Map.Entry)this.cache.get(address);
    }

    protected void start() {
        this.cache = (Cache)this.cacheRef.getValue();
        this.refreshLocalEntry();
        this.cache.getCacheManager().addListener((Object)this);
        this.cache.addListener((Object)this);
    }

    @Override
    public void refreshLocalEntry() {
        Operation<Void> operation = new Operation<Void>(){

            public Void invoke(Cache<Address, Map.Entry<K, V>> cache) {
                RegistryService.this.addCacheEntry(cache);
                return null;
            }
        };
        this.invoke(operation);
    }

    void addCacheEntry(Cache<Address, Map.Entry<K, V>> cache) {
        K key = this.provider.getKey();
        if (key != null) {
            cache.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_REMOTE_LOOKUP}).put((Object)RegistryService.getLocalAddress(cache), new AbstractMap.SimpleImmutableEntry<K, V>(this.provider.getKey(), this.provider.getValue()));
        }
    }

    protected void stop() {
        if (this.cache != null) {
            this.cache.removeListener((Object)this);
            this.cache.getCacheManager().removeListener((Object)this);
            Operation<Void> operation = new Operation<Void>(){

                public Void invoke(Cache<Address, Map.Entry<K, V>> cache) {
                    cache.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_REMOTE_LOOKUP, Flag.SKIP_LOCKING}).removeAsync((Object)RegistryService.getLocalAddress(cache));
                    return null;
                }
            };
            this.invoke(operation);
        }
    }

    static Address getLocalAddress(Cache<?, ?> cache) {
        Address address = cache.getCacheManager().getAddress();
        return address != null ? address : LOCAL_ADDRESS;
    }

    @ViewChanged
    public void viewChanged(final ViewChangedEvent event) {
        Operation operation = new Operation<Set<K>>(){

            public Set<K> invoke(Cache<Address, Map.Entry<K, V>> cache) {
                List oldMembers = event.getOldMembers();
                List newMembers = event.getNewMembers();
                HashSet removed = new HashSet();
                for (Address member : oldMembers) {
                    Map.Entry old;
                    if (newMembers.contains(member) || (old = (Map.Entry)cache.getAdvancedCache().withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL}).remove((Object)member)) == null) continue;
                    removed.add(old.getKey());
                }
                if (event.isMergeView()) {
                    RegistryService.this.addCacheEntry(cache);
                }
                return removed;
            }
        };
        Set removed = (Set)this.invoke(operation);
        if (!removed.isEmpty()) {
            for (Registry.Listener<K, V> listener : this.listeners) {
                listener.removedEntries(removed);
            }
        }
    }

    @CacheEntryCreated
    public void created(CacheEntryCreatedEvent<Address, Map.Entry<K, V>> event) {
        Map.Entry entry;
        if (event.isPre() || event.isOriginLocal()) {
            return;
        }
        if (!this.listeners.isEmpty() && (entry = (Map.Entry)event.getCache().get(event.getKey())) != null) {
            for (Registry.Listener listener : this.listeners) {
                listener.addedEntries(Collections.singletonMap(entry.getKey(), entry.getValue()));
            }
        }
    }

    @CacheEntryModified
    public void modified(CacheEntryModifiedEvent<Address, Map.Entry<K, V>> event) {
        Map.Entry entry;
        if (event.isPre() || event.isOriginLocal()) {
            return;
        }
        if (!this.listeners.isEmpty() && (entry = (Map.Entry)event.getCache().get(event.getKey())) != null) {
            for (Registry.Listener listener : this.listeners) {
                listener.updatedEntries(Collections.singletonMap(entry.getKey(), entry.getValue()));
            }
        }
    }

    @CacheEntryRemoved
    public void removed(CacheEntryRemovedEvent<Address, Map.Entry<K, V>> event) {
        if (!event.isPre() || event.isOriginLocal()) {
            return;
        }
        Map.Entry entry = (Map.Entry)event.getValue();
        if (entry != null) {
            for (Registry.Listener listener : this.listeners) {
                listener.removedEntries(Collections.singleton(entry.getKey()));
            }
        }
    }

    <R> R invoke(Operation<R> operation) {
        return (R)new BatchOperation(operation).invoke(this.cache);
    }

    abstract class Operation<R>
    implements CacheInvoker.Operation<Address, Map.Entry<K, V>, R> {
        Operation() {
        }
    }
}

