/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.web.infinispan;

import java.io.IOException;
import java.io.Serializable;
import java.security.AccessController;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeoutException;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.context.Flag;
import org.infinispan.distribution.DataLocality;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryActivated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.event.CacheEntryActivatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryRemovedEvent;
import org.infinispan.notifications.cachemanagerlistener.annotation.ViewChanged;
import org.infinispan.notifications.cachemanagerlistener.event.ViewChangedEvent;
import org.infinispan.remoting.transport.Address;
import org.jboss.as.clustering.infinispan.invoker.CacheInvoker;
import org.jboss.as.clustering.lock.SharedLocalYieldingClusterLockManager;
import org.jboss.as.clustering.web.BatchingManager;
import org.jboss.as.clustering.web.DistributableSessionMetadata;
import org.jboss.as.clustering.web.IncomingDistributableSessionData;
import org.jboss.as.clustering.web.LocalDistributableSessionManager;
import org.jboss.as.clustering.web.OutgoingDistributableSessionData;
import org.jboss.as.clustering.web.SessionOwnershipSupport;
import org.jboss.as.clustering.web.impl.IncomingDistributableSessionDataImpl;
import org.jboss.as.clustering.web.infinispan.CacheSource;
import org.jboss.as.clustering.web.infinispan.SessionAttributeStorage;
import org.jboss.as.clustering.web.infinispan.SessionKey;
import org.jboss.as.clustering.web.infinispan.SessionKeyFactory;
import org.jboss.as.clustering.web.infinispan.SessionMapEntry;
import org.jboss.logging.Logger;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.util.loading.ContextClassLoaderSwitcher;

@Listener
public class DistributedCacheManager<T extends OutgoingDistributableSessionData, K extends SessionKey>
implements org.jboss.as.clustering.web.DistributedCacheManager<T>,
SessionOwnershipSupport {
    static final Logger log = Logger.getLogger(DistributedCacheManager.class);
    private static final Random random = new Random();
    private static Map<SharedLocalYieldingClusterLockManager.LockResult, SessionOwnershipSupport.LockResult> results = DistributedCacheManager.lockResultMap();
    final SessionAttributeStorage<T> attributeStorage;
    private final LocalDistributableSessionManager manager;
    private final SharedLocalYieldingClusterLockManager lockManager;
    private final Cache<K, Map<Object, Object>> sessionCache;
    private final CacheInvoker invoker;
    private final BatchingManager batchingManager;
    private final boolean passivationEnabled;
    private final boolean requiresPurge;
    private final JvmRouteHandler jvmRouteHandler;
    private final SessionKeyFactory<K> keyFactory;
    private final ContextClassLoaderSwitcher switcher = (ContextClassLoaderSwitcher)AccessController.doPrivileged(ContextClassLoaderSwitcher.INSTANTIATOR);

    static String mask(String sessionId) {
        if (sessionId == null) {
            return null;
        }
        int length = sessionId.length();
        if (length <= 8) {
            return sessionId;
        }
        return sessionId.substring(0, 2) + "****" + sessionId.substring(length - 6, length);
    }

    static RuntimeException getRuntimeException(String message, Exception e) {
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return new RuntimeException(message != null ? message : e.getMessage(), e);
    }

    private static Map<SharedLocalYieldingClusterLockManager.LockResult, SessionOwnershipSupport.LockResult> lockResultMap() {
        EnumMap<SharedLocalYieldingClusterLockManager.LockResult, SessionOwnershipSupport.LockResult> map = new EnumMap<SharedLocalYieldingClusterLockManager.LockResult, SessionOwnershipSupport.LockResult>(SharedLocalYieldingClusterLockManager.LockResult.class);
        map.put(SharedLocalYieldingClusterLockManager.LockResult.ACQUIRED_FROM_CLUSTER, SessionOwnershipSupport.LockResult.ACQUIRED_FROM_CLUSTER);
        map.put(SharedLocalYieldingClusterLockManager.LockResult.ALREADY_HELD, SessionOwnershipSupport.LockResult.ALREADY_HELD);
        map.put(SharedLocalYieldingClusterLockManager.LockResult.NEW_LOCK, SessionOwnershipSupport.LockResult.NEW_LOCK);
        return map;
    }

    public DistributedCacheManager(ServiceRegistry registry, LocalDistributableSessionManager manager, Cache<K, Map<Object, Object>> sessionCache, CacheSource jvmRouteCacheSource, SharedLocalYieldingClusterLockManager lockManager, SessionAttributeStorage<T> attributeStorage, BatchingManager batchingManager, SessionKeyFactory<K> keyFactory, CacheInvoker invoker) {
        this.manager = manager;
        this.lockManager = lockManager;
        this.sessionCache = sessionCache;
        this.attributeStorage = attributeStorage;
        this.batchingManager = batchingManager;
        this.keyFactory = keyFactory;
        this.invoker = invoker;
        Configuration configuration = this.sessionCache.getConfiguration();
        this.passivationEnabled = configuration.isCacheLoaderPassivation() && !configuration.isCacheLoaderShared();
        this.requiresPurge = false;
        this.jvmRouteHandler = configuration.getCacheMode().isDistributed() ? new JvmRouteHandler(registry, jvmRouteCacheSource, this.manager) : null;
    }

    public void start() {
        this.purge();
        this.sessionCache.addListener((Object)this);
        if (this.jvmRouteHandler != null) {
            EmbeddedCacheManager container = this.sessionCache.getCacheManager();
            container.addListener((Object)this.jvmRouteHandler);
            String jvmRoute = this.manager.getJvmRoute();
            if (jvmRoute != null) {
                this.jvmRouteHandler.getCache().putIfAbsent((Object)container.getAddress(), (Object)jvmRoute);
            }
        }
    }

    public void stop() {
        if (this.jvmRouteHandler != null) {
            this.sessionCache.getCacheManager().removeListener((Object)this.jvmRouteHandler);
        }
        this.sessionCache.removeListener((Object)this);
        this.purge();
    }

    private void purge() {
        if (this.requiresPurge) {
            Operation<Void> operation = new Operation<Void>(){

                public Void invoke(Cache<K, Map<Object, Object>> cache) {
                    for (SessionKey key : cache.getAdvancedCache().withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL}).keySet()) {
                        if (!DistributedCacheManager.this.keyFactory.ours(key)) continue;
                        cache.remove((Object)key);
                    }
                    return null;
                }
            };
            this.batch(operation);
        }
    }

    public BatchingManager getBatchingManager() {
        return this.batchingManager;
    }

    public void sessionCreated(String sessionId) {
        DistributedCacheManager.trace("sessionCreated(%s)", sessionId);
    }

    public void storeSessionData(final T sessionData) {
        final K key = this.keyFactory.createKey(sessionData.getRealId());
        DistributedCacheManager.trace("storeSessionData(%s)", key.getSessionId());
        Operation<Void> operation = new Operation<Void>(){

            public Void invoke(Cache<K, Map<Object, Object>> cache) {
                Map map = (Map)cache.putIfAbsent((Object)key, null);
                SessionMapEntry.VERSION.put(map, sessionData.getVersion());
                SessionMapEntry.METADATA.put(map, sessionData.getMetadata());
                SessionMapEntry.TIMESTAMP.put(map, sessionData.getTimestamp());
                try {
                    DistributedCacheManager.this.attributeStorage.store(map, sessionData);
                }
                catch (IOException e) {
                    throw DistributedCacheManager.getRuntimeException("Failed to store session attributes for session: " + DistributedCacheManager.mask(key.getSessionId()), e);
                }
                return null;
            }
        };
        this.batch(operation);
    }

    public IncomingDistributableSessionData getSessionData(String sessionId, boolean initialLoad) {
        DistributedCacheManager.trace("getSessionData(%s, %s)", sessionId, initialLoad);
        return this.getData(sessionId, true);
    }

    public IncomingDistributableSessionData getSessionData(String sessionId, String dataOwner, boolean includeAttributes) {
        DistributedCacheManager.trace("getSessionData(%s, %s, %s)", sessionId, dataOwner, includeAttributes);
        return dataOwner == null ? this.getData(sessionId, includeAttributes) : null;
    }

    private IncomingDistributableSessionData getData(String sessionId, final boolean includeAttributes) {
        final K key = this.keyFactory.createKey(sessionId);
        Operation<IncomingDistributableSessionData> operation = new Operation<IncomingDistributableSessionData>(){

            public IncomingDistributableSessionData invoke(Cache<K, Map<Object, Object>> cache) {
                Map map = (Map)cache.get((Object)key);
                if (map == null) {
                    return null;
                }
                Integer version = (Integer)SessionMapEntry.VERSION.get(map);
                Long timestamp = (Long)SessionMapEntry.TIMESTAMP.get(map);
                DistributableSessionMetadata metadata = (DistributableSessionMetadata)SessionMapEntry.METADATA.get(map);
                IncomingDistributableSessionDataImpl result = new IncomingDistributableSessionDataImpl(version, timestamp, metadata);
                if (includeAttributes) {
                    try {
                        result.setSessionAttributes(DistributedCacheManager.this.attributeStorage.load(map));
                    }
                    catch (Exception e) {
                        throw DistributedCacheManager.getRuntimeException("Failed to load session attributes for session: " + DistributedCacheManager.mask(key.getSessionId()), e);
                    }
                }
                return result;
            }
        };
        try {
            return (IncomingDistributableSessionData)this.invoker.invoke(this.sessionCache, (CacheInvoker.Operation)operation);
        }
        catch (Exception e) {
            String message = String.format("Problem accessing session [%s]: %s", DistributedCacheManager.mask(sessionId), e.toString());
            log.warn((Object)message);
            log.debug((Object)message, (Throwable)e);
            this.removeSessionLocal(sessionId);
            return null;
        }
    }

    public void removeSession(String sessionId) {
        DistributedCacheManager.trace("removeSession(%s)", sessionId);
        this.removeSession(sessionId, false);
    }

    public void removeSessionLocal(String sessionId) {
        DistributedCacheManager.trace("removeSessionLocal(%s)", sessionId);
        this.removeSession(sessionId, true);
    }

    private void removeSession(String sessionId, final boolean local) {
        final K key = this.keyFactory.createKey(sessionId);
        Operation<Map<Object, Object>> operation = new Operation<Map<Object, Object>>(){

            public Map<Object, Object> invoke(Cache<K, Map<Object, Object>> cache) {
                if (local) {
                    cache.getAdvancedCache().withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL});
                }
                return (Map)cache.remove((Object)key);
            }
        };
        this.invoker.invoke(this.sessionCache, (CacheInvoker.Operation)operation);
    }

    public void removeSessionLocal(String sessionId, String dataOwner) {
        DistributedCacheManager.trace("removeSessionLocal(%s, dataOwner)", sessionId, dataOwner);
        if (dataOwner == null) {
            this.removeSession(sessionId, true);
        }
    }

    public void evictSession(String sessionId) {
        DistributedCacheManager.trace("evictSession(%s)", sessionId);
        final K key = this.keyFactory.createKey(sessionId);
        Operation<Void> operation = new Operation<Void>(){

            public Void invoke(Cache<K, Map<Object, Object>> cache) {
                cache.evict((Object)key);
                return null;
            }
        };
        this.invoker.invoke(this.sessionCache, (CacheInvoker.Operation)operation);
    }

    public void evictSession(String sessionId, String dataOwner) {
        DistributedCacheManager.trace("evictSession(%s, %s)", sessionId, dataOwner);
        if (dataOwner == null) {
            this.evictSession(sessionId);
        }
    }

    public Map<String, String> getSessionIds() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (SessionKey key : this.sessionCache.keySet()) {
            if (!this.keyFactory.ours(key)) continue;
            result.put(key.getSessionId(), null);
        }
        return result;
    }

    public boolean isPassivationEnabled() {
        return this.passivationEnabled;
    }

    public void setForceSynchronous(boolean forceSynchronous) {
        this.invoker.setForceSynchronous(forceSynchronous);
    }

    public SessionOwnershipSupport getSessionOwnershipSupport() {
        return this.lockManager != null ? this : null;
    }

    public SessionOwnershipSupport.LockResult acquireSessionOwnership(String sessionId, boolean newLock) throws TimeoutException, InterruptedException {
        DistributedCacheManager.trace("acquireSessionOwnership(%s, %s)", sessionId, newLock);
        EmbeddedCacheManager container = this.sessionCache.getCacheManager();
        SessionOwnershipSupport.LockResult result = results.get(this.lockManager.lock((Serializable)((Object)this.keyFactory.createKey(sessionId).toString()), container.getGlobalConfiguration().getDistributedSyncTimeout(), newLock));
        DistributedCacheManager.trace("acquireSessionOwnership(%s, %s) = %s", sessionId, newLock, result);
        return result != null ? result : SessionOwnershipSupport.LockResult.UNSUPPORTED;
    }

    public void relinquishSessionOwnership(String sessionId, boolean remove) {
        DistributedCacheManager.trace("relinquishSessionOwnership(%s, %s)", sessionId, remove);
        this.lockManager.unlock((Serializable)((Object)this.keyFactory.createKey(sessionId).toString()), remove);
    }

    public boolean isLocal(String sessionId) {
        DistributionManager manager = this.sessionCache.getAdvancedCache().getDistributionManager();
        if (manager == null) {
            return true;
        }
        DataLocality locality = manager.getLocality((Object)sessionId);
        return locality.isLocal() || locality.isUncertain();
    }

    public String locate(String sessionId) {
        EmbeddedCacheManager container;
        List addresses;
        AdvancedCache cache;
        DistributionManager manager;
        if (this.jvmRouteHandler != null && (manager = (cache = this.sessionCache.getAdvancedCache()).getDistributionManager()) != null && !manager.isRehashInProgress() && !(addresses = manager.locate((Object)sessionId)).contains((container = this.sessionCache.getCacheManager()).getAddress())) {
            Address address = (Address)addresses.get(random.nextInt(addresses.size()));
            String jvmRoute = (String)this.jvmRouteHandler.getCache().get((Object)address);
            if (jvmRoute != null) {
                DistributedCacheManager.trace("%s hashes to %s - next request will route to %s (%s)", sessionId, addresses, address, jvmRoute);
                cache.withFlags(new Flag[]{Flag.FORCE_SYNCHRONOUS});
                return jvmRoute;
            }
        }
        return this.manager.getJvmRoute();
    }

    @CacheEntryRemoved
    public void removed(CacheEntryRemovedEvent<K, Map<Object, Object>> event) {
        if (event.isPre() || event.isOriginLocal()) {
            return;
        }
        K key = this.getEventKey((CacheEntryEvent<K, ?>)event);
        if (this.keyFactory.ours(key)) {
            try {
                this.manager.notifyRemoteInvalidation(key.getSessionId());
            }
            catch (Throwable e) {
                log.warn((Object)e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CacheEntryModified
    public void modified(CacheEntryModifiedEvent<K, Map<Object, Object>> event) {
        if (event.isPre() || event.isOriginLocal()) {
            return;
        }
        K key = this.getEventKey((CacheEntryEvent<K, ?>)event);
        if (this.keyFactory.ours(key)) {
            try {
                ContextClassLoaderSwitcher.SwitchContext context = this.getSwitchContext((CacheEntryEvent)event);
                try {
                    Map map = (Map)event.getValue();
                    if (!map.isEmpty()) {
                        boolean updated;
                        String sessionId = key.getSessionId();
                        Integer version = (Integer)SessionMapEntry.VERSION.get(map);
                        Long timestamp = (Long)SessionMapEntry.TIMESTAMP.get(map);
                        DistributableSessionMetadata metadata = (DistributableSessionMetadata)SessionMapEntry.METADATA.get(map);
                        if (version != null && timestamp != null && metadata != null && !(updated = this.manager.sessionChangedInDistributedCache(sessionId, null, version.intValue(), timestamp.longValue(), metadata))) {
                            log.warnf("Possible concurrency problem: Replicated version id %d is less than or equal to in-memory version for session %s", (Object)version, (Object)DistributedCacheManager.mask(sessionId));
                        }
                    }
                }
                finally {
                    context.reset();
                }
            }
            catch (Throwable e) {
                log.warn((Object)e.getMessage(), e);
            }
        }
    }

    @CacheEntryActivated
    public void activated(CacheEntryActivatedEvent<K, Map<Object, Object>> event) {
        if (event.isPre()) {
            return;
        }
        K key = this.getEventKey((CacheEntryEvent<K, ?>)event);
        if (this.keyFactory.ours(key)) {
            try {
                this.manager.sessionActivated();
            }
            catch (Throwable e) {
                log.warn((Object)e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private K getEventKey(CacheEntryEvent<K, ?> event) {
        ContextClassLoaderSwitcher.SwitchContext context = this.getSwitchContext(event);
        try {
            SessionKey sessionKey = (SessionKey)event.getKey();
            return (K)sessionKey;
        }
        finally {
            context.reset();
        }
    }

    private <V> ContextClassLoaderSwitcher.SwitchContext getSwitchContext(CacheEntryEvent<K, V> event) {
        return this.switcher.getSwitchContext(this.getClass().getClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R> R batch(Operation<R> operation) {
        boolean started = this.sessionCache.startBatch();
        boolean success = false;
        try {
            Object result = this.invoker.invoke(this.sessionCache, operation);
            success = true;
            Object object = result;
            return (R)object;
        }
        finally {
            if (started) {
                this.sessionCache.endBatch(success);
            }
        }
    }

    private static void trace(String message, Object ... args) {
        log.tracef(message, args);
    }

    abstract class Operation<R>
    implements CacheInvoker.Operation<K, Map<Object, Object>, R> {
        Operation() {
        }
    }

    @Listener(sync=false)
    public static class JvmRouteHandler {
        private final ServiceRegistry registry;
        private final LocalDistributableSessionManager manager;
        private final CacheSource source;

        JvmRouteHandler(ServiceRegistry registry, CacheSource source, LocalDistributableSessionManager manager) {
            this.registry = registry;
            this.source = source;
            this.manager = manager;
        }

        Cache<Address, String> getCache() {
            return this.source.getCache(this.registry, this.manager);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        <R> R batch(Operation<R> operation) {
            Cache<Address, String> cache = this.getCache();
            boolean started = cache.startBatch();
            boolean success = false;
            try {
                Object result = operation.invoke(cache);
                success = true;
                Object object = result;
                return (R)object;
            }
            finally {
                if (started) {
                    cache.endBatch(success);
                }
            }
        }

        @ViewChanged
        public void viewChanged(final ViewChangedEvent event) {
            final List oldMembers = event.getOldMembers();
            final List newMembers = event.getNewMembers();
            final String jvmRoute = this.manager.getJvmRoute();
            Operation<Void> operation = new Operation<Void>(){

                public Void invoke(Cache<Address, String> cache) {
                    Address localAddress;
                    for (Address member : oldMembers) {
                        if (newMembers.contains(member) || cache.remove((Object)member) == null) continue;
                        log.infof("Removed stale jvm route entry from web session cache on behalf of member %s", (Object)member);
                    }
                    if (jvmRoute != null && !oldMembers.contains(localAddress = event.getLocalAddress()) && newMembers.contains(localAddress)) {
                        String oldJvmRoute = (String)cache.put((Object)localAddress, (Object)jvmRoute);
                        if (oldJvmRoute == null) {
                            log.info((Object)"Adding missing jvm route entry to web session cache");
                        } else if (!oldJvmRoute.equals(jvmRoute)) {
                            log.infof("Updating jvm route entry in web session cache.  old = %s, new = %s", (Object)oldJvmRoute, (Object)jvmRoute);
                        }
                    }
                    return null;
                }
            };
            try {
                this.batch(operation);
            }
            catch (Throwable e) {
                log.warn((Object)e.getMessage(), e);
            }
        }

        static interface Operation<R>
        extends CacheInvoker.Operation<Address, String, R> {
        }
    }
}

