/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.web.infinispan;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Map;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.remoting.transport.Address;
import org.jboss.as.clustering.CoreGroupCommunicationServiceService;
import org.jboss.as.clustering.infinispan.atomic.AtomicMapCache;
import org.jboss.as.clustering.infinispan.invoker.CacheInvoker;
import org.jboss.as.clustering.infinispan.invoker.RetryingCacheInvoker;
import org.jboss.as.clustering.infinispan.subsystem.CacheService;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerService;
import org.jboss.as.clustering.lock.SharedLocalYieldingClusterLockManager;
import org.jboss.as.clustering.lock.SharedLocalYieldingClusterLockManagerService;
import org.jboss.as.clustering.web.BatchingManager;
import org.jboss.as.clustering.web.ClusteringNotSupportedException;
import org.jboss.as.clustering.web.LocalDistributableSessionManager;
import org.jboss.as.clustering.web.OutgoingDistributableSessionData;
import org.jboss.as.clustering.web.SessionAttributeMarshallerFactory;
import org.jboss.as.clustering.web.impl.SessionAttributeMarshallerFactoryImpl;
import org.jboss.as.clustering.web.impl.TransactionBatchingManager;
import org.jboss.as.clustering.web.infinispan.DistributedCacheManager;
import org.jboss.as.clustering.web.infinispan.InfinispanWebMessages;
import org.jboss.as.clustering.web.infinispan.SessionAttributeStorage;
import org.jboss.as.clustering.web.infinispan.SessionAttributeStorageFactory;
import org.jboss.as.clustering.web.infinispan.SessionAttributeStorageFactoryImpl;
import org.jboss.as.clustering.web.infinispan.SessionKey;
import org.jboss.as.clustering.web.infinispan.SessionKeyFactory;
import org.jboss.as.server.CurrentServiceContainer;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.jboss.ReplicationConfig;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;

public class DistributedCacheManagerFactory
implements org.jboss.as.clustering.web.DistributedCacheManagerFactory {
    public static final String DEFAULT_CACHE_CONTAINER = "web";
    public static final String DEFAULT_JVM_ROUTE_CACHE = "registry";
    public static final Short SCOPE_ID = 222;
    private SessionAttributeStorageFactory storageFactory = new SessionAttributeStorageFactoryImpl();
    private CacheInvoker invoker = new RetryingCacheInvoker(new int[]{10, 100});
    private SessionAttributeMarshallerFactory marshallerFactory = new SessionAttributeMarshallerFactoryImpl();
    private final InjectedValue<Cache> sessionCache = new InjectedValue();
    private final InjectedValue<Cache> jvmRouteCache = new InjectedValue();
    private final InjectedValue<SharedLocalYieldingClusterLockManager> lockManager = new InjectedValue();

    public <T extends OutgoingDistributableSessionData> org.jboss.as.clustering.web.DistributedCacheManager<T> getDistributedCacheManager(LocalDistributableSessionManager manager) throws ClusteringNotSupportedException {
        AdvancedCache sessionCache = ((Cache)this.sessionCache.getValue()).getAdvancedCache().with(this.getClass().getClassLoader());
        if (!sessionCache.getConfiguration().isInvocationBatchingEnabled()) {
            throw new ClusteringNotSupportedException(InfinispanWebMessages.MESSAGES.failedToConfigureWebApp(sessionCache.getCacheManager().getGlobalConfiguration().getCacheManagerName(), sessionCache.getName()));
        }
        Cache jvmRouteCache = (Cache)this.sessionCache.getValue();
        TransactionBatchingManager batchingManager = new TransactionBatchingManager(sessionCache.getTransactionManager());
        SessionAttributeStorage storage = this.storageFactory.createStorage(manager.getReplicationConfig().getReplicationGranularity(), this.marshallerFactory.createMarshaller(manager));
        return new DistributedCacheManager(manager, (Cache<SessionKeyImpl, Map<Object, Object>>)new AtomicMapCache(sessionCache), (Cache<Address, String>)jvmRouteCache, (SharedLocalYieldingClusterLockManager)this.lockManager.getValue(), storage, (BatchingManager)batchingManager, new SessionKeyFactoryImpl(manager), this.invoker);
    }

    public boolean addDependencies(ServiceTarget target, ServiceBuilder<?> builder, JBossWebMetaData metaData) {
        ReplicationConfig config;
        String cacheName;
        ServiceName serviceName;
        ServiceName baseServiceName = EmbeddedCacheManagerService.getServiceName(null);
        if (!baseServiceName.isParentOf(serviceName = ServiceName.parse((String)((cacheName = (config = metaData.getReplicationConfig()) != null ? config.getCacheName() : null) != null ? cacheName : DEFAULT_CACHE_CONTAINER)))) {
            serviceName = baseServiceName.append(serviceName);
        }
        if (serviceName.length() < 4) {
            serviceName = serviceName.append(new String[]{"___defaultcache"});
        }
        if (CurrentServiceContainer.getServiceContainer().getService(serviceName) == null) {
            return false;
        }
        String container = serviceName.getParent().getSimpleName();
        new CoreGroupCommunicationServiceService(SCOPE_ID.shortValue()).build(target, container).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        new SharedLocalYieldingClusterLockManagerService(container).build(target).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        builder.addDependency(serviceName, Cache.class, this.sessionCache);
        builder.addDependency(CacheService.getServiceName((String)container, (String)DEFAULT_JVM_ROUTE_CACHE), Cache.class, this.jvmRouteCache);
        builder.addDependency(SharedLocalYieldingClusterLockManagerService.getServiceName((String)container), SharedLocalYieldingClusterLockManager.class, this.lockManager);
        return true;
    }

    public Injector<Cache> getSessionCacheInjector() {
        return this.sessionCache;
    }

    public Injector<Cache> getJvmRouteCacheInjector() {
        return this.jvmRouteCache;
    }

    public void setSessionAttributeMarshallerFactory(SessionAttributeMarshallerFactory marshallerFactory) {
        this.marshallerFactory = marshallerFactory;
    }

    public void setSessionAttributeStorageFactory(SessionAttributeStorageFactory storageFactory) {
        this.storageFactory = storageFactory;
    }

    public void setCacheInvoker(CacheInvoker invoker) {
        this.invoker = invoker;
    }

    public static class SessionKeyImpl
    implements SessionKey {
        private static final long serialVersionUID = 398539176014850559L;
        private final String application;
        private final String sessionId;
        private transient int hashCode;

        public SessionKeyImpl(String application, String sessionId) {
            this.application = application;
            this.sessionId = sessionId;
            this.computeHashCode();
        }

        @Override
        public String getSessionId() {
            return this.sessionId;
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof SessionKeyImpl)) {
                return false;
            }
            SessionKeyImpl key = (SessionKeyImpl)object;
            return this.hashCode == key.hashCode && this.application.equals(key.application) && this.sessionId.equals(key.sessionId);
        }

        public int hashCode() {
            return this.hashCode;
        }

        private void computeHashCode() {
            this.hashCode = this.application.hashCode() ^ this.sessionId.hashCode();
        }

        public String toString() {
            return String.format("%s/%s", this.application, this.sessionId);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            this.computeHashCode();
        }
    }

    private static class SessionKeyFactoryImpl
    implements SessionKeyFactory<SessionKeyImpl> {
        private final LocalDistributableSessionManager manager;

        public SessionKeyFactoryImpl(LocalDistributableSessionManager manager) {
            this.manager = manager;
        }

        @Override
        public SessionKeyImpl createKey(String sessionId) {
            return new SessionKeyImpl(this.manager.getName(), sessionId);
        }

        @Override
        public boolean ours(SessionKeyImpl key) {
            return this.manager.getName().equals(key.application);
        }
    }
}

