/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import javax.management.MBeanServer;
import org.jboss.as.clustering.jgroups.ChannelFactory;
import org.jboss.as.clustering.jgroups.ManagedSocketFactory;
import org.jboss.as.clustering.jgroups.ProtocolConfiguration;
import org.jboss.as.clustering.jgroups.ProtocolStackConfiguration;
import org.jboss.as.clustering.jgroups.ThreadFactoryAdapter;
import org.jboss.as.clustering.jgroups.TimerSchedulerAdapter;
import org.jboss.as.clustering.jgroups.TransportConfiguration;
import org.jboss.as.server.services.net.SocketBinding;
import org.jboss.logging.Logger;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelListener;
import org.jgroups.JChannel;
import org.jgroups.jmx.JmxConfigurator;
import org.jgroups.protocols.TP;
import org.jgroups.stack.Configurator;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.util.SocketFactory;
import org.jgroups.util.ThreadFactory;

public class DefaultChannelFactory
implements ChannelFactory,
ChannelListener {
    private static final Logger log = Logger.getLogger(DefaultChannelFactory.class);
    private final String name;
    private final ProtocolStackConfiguration configuration;
    private final String logicalName;
    private volatile MBeanServer server = null;

    public DefaultChannelFactory(String name, ProtocolStackConfiguration configuration, String logicalName) {
        this.name = name;
        this.configuration = configuration;
        this.logicalName = logicalName;
    }

    public void setMBeanServer(MBeanServer server) {
        this.server = server;
    }

    @Override
    public Channel createChannel() throws Exception {
        ScheduledExecutorService scheduledExecutor;
        Executor oobExecutor;
        Executor threadPool;
        SocketBinding diagnosticsSocketBinding;
        SocketBinding socketBinding;
        java.util.concurrent.ThreadFactory threadFactory;
        ProtocolStack stack = this.createProtocolStack(this.configuration);
        TransportConfiguration transportConfig = this.configuration.getTransport();
        TP transport = this.getTransport(stack);
        if (transportConfig.isShared() && transport.getValue("singleton_name") == null) {
            transport.setValue("singleton_name", (Object)this.name);
        }
        if ((threadFactory = transportConfig.getThreadFactory()) != null) {
            transport.setThreadFactory((ThreadFactory)new ThreadFactoryAdapter(threadFactory));
        }
        if ((socketBinding = transportConfig.getSocketBinding()) != null) {
            InetSocketAddress socketAddress = socketBinding.getSocketAddress();
            transport.setValue("bind_addr", (Object)socketAddress.getAddress());
            transport.setBindPort(socketAddress.getPort());
            this.configureMulticastSocket((Protocol)transport, socketBinding, "mcast_group_addr", "mcast_port");
            transport.setSocketFactory((SocketFactory)new ManagedSocketFactory(transport.getSocketFactory(), socketBinding.getSocketBindings()));
        }
        boolean diagnostics = (diagnosticsSocketBinding = transportConfig.getDiagnosticsSocketBinding()) != null;
        transport.setValue("enable_diagnostics", (Object)diagnostics);
        if (diagnostics) {
            this.configureMulticastSocket((Protocol)transport, diagnosticsSocketBinding, "diagnostics_addr", "diagnostics_port");
        }
        if ((threadPool = transportConfig.getThreadPool()) != null) {
            transport.setDefaultThreadPool(threadPool);
        }
        if ((oobExecutor = transportConfig.getOOBThreadPool()) != null) {
            transport.setOOBThreadPool(oobExecutor);
        }
        if ((scheduledExecutor = transportConfig.getTimerThreadPool()) != null) {
            transport.getTimer().stop();
            transport.setValue("timer", (Object)new TimerSchedulerAdapter(scheduledExecutor));
        }
        TP protocol = transport;
        for (ProtocolConfiguration protocolConfig : this.configuration.getProtocols()) {
            protocol = protocol.getUpProtocol();
            this.configureMulticastSocket((Protocol)protocol, protocolConfig.getSocketBinding(), "mcast_addr", "mcast_port");
            this.configureServerSocket((Protocol)protocol, protocolConfig.getSocketBinding(), "start_port");
        }
        JChannel channel = new JChannel(false);
        channel.setProtocolStack(stack);
        stack.init();
        channel.setName(this.logicalName);
        if (this.server != null) {
            // empty if block
        }
        return channel;
    }

    private ProtocolStack createProtocolStack(ProtocolStackConfiguration stackConfig) throws Exception {
        ArrayList<org.jgroups.conf.ProtocolConfiguration> protocolConfigs = new ArrayList<org.jgroups.conf.ProtocolConfiguration>(stackConfig.getProtocols().size() + 1);
        protocolConfigs.add(this.createProtocol(stackConfig.getTransport()));
        for (ProtocolConfiguration protocolConfig : stackConfig.getProtocols()) {
            protocolConfigs.add(this.createProtocol(protocolConfig));
        }
        ProtocolStack stack = new ProtocolStack();
        ArrayList<Protocol> protocols = new ArrayList<Protocol>(protocolConfigs.size());
        for (Protocol protocol = new Configurator(stack).setupProtocolStack(protocolConfigs); protocol != null; protocol = protocol.getDownProtocol()) {
            protocols.add(protocol);
        }
        Collections.reverse(protocols);
        stack.addProtocols(protocols);
        return stack;
    }

    private org.jgroups.conf.ProtocolConfiguration createProtocol(final ProtocolConfiguration protocolConfig) {
        return new org.jgroups.conf.ProtocolConfiguration(protocolConfig.getName(), protocolConfig.getProperties()){

            public Map<String, String> getOriginalProperties() {
                return protocolConfig.getProperties();
            }
        };
    }

    private TP getTransport(ProtocolStack stack) {
        List protocols = stack.getProtocols();
        return (TP)protocols.get(protocols.size() - 1);
    }

    private void configureMulticastSocket(Protocol protocol, SocketBinding socketBinding, String addressProperty, String portProperty) {
        if (socketBinding != null) {
            try {
                InetSocketAddress socketAddress = socketBinding.getMulticastSocketAddress();
                this.setValue(protocol, addressProperty, socketAddress.getAddress());
                this.setValue(protocol, portProperty, socketAddress.getPort());
            }
            catch (IllegalStateException e) {
                log.tracef((Throwable)e, "Could not set %s.%s and %s.%s, %s socket binding does not specify a multicast socket", new Object[]{protocol.getName(), addressProperty, protocol.getName(), portProperty, socketBinding.getName()});
            }
        }
    }

    private void configureServerSocket(Protocol protocol, SocketBinding socketBinding, String portProperty) {
        if (socketBinding != null) {
            this.setValue(protocol, portProperty, socketBinding.getSocketAddress().getPort());
        }
    }

    private void setValue(Protocol protocol, String property, Object value) {
        log.tracef("Setting %s.%s=%d", (Object)protocol.getName(), (Object)property, value);
        try {
            protocol.setValue(property, value);
        }
        catch (IllegalArgumentException e) {
            log.tracef((Throwable)e, "Failed to set non-existent %s.%s=%d", (Object)protocol.getName(), (Object)property, value);
        }
    }

    public void channelConnected(Channel channel) {
    }

    public void channelDisconnected(Channel channel) {
    }

    public void channelClosed(Channel channel) {
        if (this.server != null) {
            try {
                JmxConfigurator.unregisterChannel((JChannel)((JChannel)channel), (MBeanServer)this.server, (String)this.getDomain(), (String)this.logicalName);
            }
            catch (Exception e) {
                log.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    @Deprecated
    public void channelShunned() {
    }

    @Deprecated
    public void channelReconnected(Address addr) {
    }

    private String getDomain() {
        return this.server.getDefaultDomain() + ".jgroups";
    }
}

