/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups;

import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jgroups.util.ThreadDecorator;
import org.jgroups.util.ThreadFactory;
import org.jgroups.util.TimeScheduler;

public class TimerSchedulerAdapter
implements TimeScheduler {
    private final ScheduledExecutorService executor;

    public TimerSchedulerAdapter(ScheduledExecutorService executor) {
        this.executor = executor;
    }

    public ThreadDecorator getThreadDecorator() {
        return null;
    }

    public void setThreadDecorator(ThreadDecorator decorator) {
    }

    public void execute(Runnable command) {
        this.executor.execute(command);
    }

    public Future<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return this.executor.schedule(command, delay, unit);
    }

    public Future<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.executor.scheduleWithFixedDelay(command, initialDelay, delay, unit);
    }

    public Future<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.executor.scheduleAtFixedRate(command, initialDelay, period, unit);
    }

    public Future<?> scheduleWithDynamicInterval(TimeScheduler.Task task) {
        throw new UnsupportedOperationException();
    }

    public void setThreadFactory(ThreadFactory factory) {
        this.getExecutor().setThreadFactory((java.util.concurrent.ThreadFactory)factory);
    }

    public String dumpTimerTasks() {
        return this.getExecutor().getQueue().toString();
    }

    public int getMinThreads() {
        return this.getExecutor().getCorePoolSize();
    }

    public void setMinThreads(int size) {
        this.getExecutor().setCorePoolSize(size);
    }

    public int getMaxThreads() {
        return this.getExecutor().getMaximumPoolSize();
    }

    public void setMaxThreads(int size) {
        this.getExecutor().setMaximumPoolSize(size);
    }

    public long getKeepAliveTime() {
        return this.getExecutor().getKeepAliveTime(TimeUnit.MILLISECONDS);
    }

    public void setKeepAliveTime(long time) {
        this.getExecutor().setKeepAliveTime(time, TimeUnit.MILLISECONDS);
    }

    public int getCurrentThreads() {
        return this.getExecutor().getActiveCount();
    }

    public int size() {
        return this.getExecutor().getPoolSize();
    }

    public void stop() {
        this.executor.shutdown();
    }

    public boolean isShutdown() {
        return this.executor.isShutdown();
    }

    private ScheduledThreadPoolExecutor getExecutor() {
        if (!(this.executor instanceof ScheduledThreadPoolExecutor)) {
            throw new UnsupportedOperationException();
        }
        return (ScheduledThreadPoolExecutor)this.executor;
    }
}

