/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.util.AbstractMap;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.infinispan.config.CacheLoaderManagerConfig;
import org.infinispan.config.Configuration;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.config.InfinispanConfiguration;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.loaders.AbstractCacheStoreConfig;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.CacheStoreConfig;
import org.infinispan.manager.CacheContainer;
import org.infinispan.util.concurrent.IsolationLevel;
import org.jboss.as.clustering.infinispan.subsystem.EagerLocking;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerService;
import org.jboss.as.clustering.infinispan.subsystem.FileCacheStoreConfig;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanExtension;
import org.jboss.as.clustering.infinispan.subsystem.LocalDescriptions;
import org.jboss.as.clustering.infinispan.subsystem.SyncPhase;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelAddOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeOperationContext;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.server.services.path.AbstractPathService;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.logging.Logger;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.util.loading.ContextClassLoaderSwitcher;

public class CacheContainerAdd
implements ModelAddOperationHandler,
DescriptionProvider {
    private static final String DEFAULTS = "infinispan-defaults.xml";
    private static final Logger log = Logger.getLogger((String)CacheContainerAdd.class.getPackage().getName());
    final ContextClassLoaderSwitcher switcher = (ContextClassLoaderSwitcher)AccessController.doPrivileged(ContextClassLoaderSwitcher.INSTANTIATOR);
    final GlobalConfiguration global;
    final Configuration defaultConfig;
    final Map<Configuration.CacheMode, Configuration> configs;

    static ModelNode createOperation(ModelNode address, ModelNode existing) {
        ModelNode operation = Util.getEmptyOperation((String)"add", (ModelNode)address);
        CacheContainerAdd.populate(existing, operation);
        return operation;
    }

    private static void populate(ModelNode source, ModelNode target) {
        target.get("default-cache").set(source.require("default-cache"));
        if (source.hasDefined("listener-executor")) {
            target.get("listener-executor").set(source.get("listener-executor"));
        }
        if (source.hasDefined("eviction-executor")) {
            target.get("eviction-executor").set(source.get("eviction-executor"));
        }
        if (source.hasDefined("replication-queue-executor")) {
            target.get("replication-queue-executor").set(source.get("replication-queue-executor"));
        }
        if (source.hasDefined("alias")) {
            ModelNode aliases = target.get("alias");
            for (ModelNode alias : source.get("alias").asList()) {
                aliases.add(alias);
            }
        }
        if (source.hasDefined("transport")) {
            target.get("transport").set(source.get("transport"));
        }
        ModelNode caches = target.get("cache");
        for (ModelNode cache : source.require("cache").asList()) {
            caches.add(cache);
        }
    }

    public CacheContainerAdd() {
        InfinispanConfiguration config = this.load(DEFAULTS);
        this.global = config.parseGlobalConfiguration();
        this.configs = new EnumMap<Configuration.CacheMode, Configuration>(Configuration.CacheMode.class);
        this.defaultConfig = config.parseDefaultConfiguration();
        Map namedConfigs = config.parseNamedConfigurations();
        for (Configuration.CacheMode mode : Configuration.CacheMode.values()) {
            Configuration configuration = this.defaultConfig.clone();
            Configuration override = (Configuration)namedConfigs.get(mode.name());
            if (override != null) {
                configuration.applyOverrides(override);
            }
            configuration.setCacheMode(mode);
            this.configs.put(mode, configuration);
        }
    }

    public ModelNode getModelDescription(Locale locale) {
        return LocalDescriptions.getCacheContainerAddDescription(locale);
    }

    public OperationResult execute(OperationContext context, final ModelNode operation, final ResultHandler resultHandler) throws OperationFailedException {
        ModelNode opAddr = operation.require("address");
        ModelNode removeOperation = Util.getResourceRemoveOperation((ModelNode)opAddr);
        PathAddress address = PathAddress.pathAddress((ModelNode)opAddr);
        final String name = address.getLastElement().getValue();
        CacheContainerAdd.populate(operation, context.getSubModel());
        RuntimeOperationContext runtime = context.getRuntimeContext();
        if (runtime != null) {
            RuntimeTask task = new RuntimeTask(){

                public void execute(RuntimeTaskContext context) throws OperationFailedException {
                    String defaultCache = operation.require("default-cache").asString();
                    ServiceName[] aliases = null;
                    if (operation.hasDefined("alias")) {
                        List list = operation.get("alias").asList();
                        aliases = new ServiceName[list.size()];
                        for (int i = 0; i < list.size(); ++i) {
                            aliases[i] = EmbeddedCacheManagerService.getServiceName(((ModelNode)list.get(i)).asString());
                        }
                    }
                    GlobalConfiguration global = CacheContainerAdd.this.global.clone();
                    String transportExecutor = null;
                    String stack = null;
                    if (operation.hasDefined("transport")) {
                        ModelNode transport = operation.get("transport");
                        if (transport.hasDefined("stack")) {
                            stack = transport.get("stack").asString();
                        }
                        if (transport.hasDefined("executor")) {
                            transportExecutor = transport.get("executor").asString();
                        }
                        if (transport.hasDefined("lock-timeout")) {
                            global.setDistributedSyncTimeout(transport.get("lock-timeout").asLong());
                        }
                        if (transport.hasDefined("site")) {
                            global.setSiteId(transport.get("site").asString());
                        }
                        if (transport.hasDefined("rack")) {
                            global.setRackId(transport.get("rack").asString());
                        }
                        if (transport.hasDefined("machine")) {
                            global.setMachineId(transport.get("machine").asString());
                        }
                    }
                    LinkedList<Map.Entry<String, Injector<String>>> locationInjectors = new LinkedList<Map.Entry<String, Injector<String>>>();
                    LinkedHashMap<String, Configuration> configs = new LinkedHashMap<String, Configuration>();
                    for (ModelNode cache : operation.require("cache").asList()) {
                        String cacheName = cache.require("name").asString();
                        Configuration.CacheMode cacheMode = Configuration.CacheMode.valueOf((String)cache.require("mode").asString());
                        Configuration config = CacheContainerAdd.this.configs.get(cacheMode).clone();
                        if (cache.hasDefined("queue-size")) {
                            int queueSize = cache.get("queue-size").asInt();
                            config.setUseReplQueue(queueSize > 0);
                            config.setReplQueueMaxElements(queueSize);
                        }
                        if (cache.hasDefined("queue-flush-interval")) {
                            config.setReplQueueInterval(cache.get("queue-flush-interval").asLong());
                        }
                        if (cache.hasDefined("remote-timeout")) {
                            config.setSyncReplTimeout(cache.get("remote-timeout").asLong());
                        }
                        if (cache.hasDefined("owners")) {
                            config.setNumOwners(cache.get("owners").asInt());
                        }
                        if (cache.hasDefined("l1-lifespan")) {
                            long lifespan = cache.get("l1-lifespan").asLong();
                            config.setL1CacheEnabled(lifespan > 0L);
                            config.setL1Lifespan(lifespan);
                        }
                        if (cache.hasDefined("locking")) {
                            ModelNode locking = cache.get("locking");
                            if (locking.hasDefined("isolation")) {
                                IsolationLevel level = IsolationLevel.valueOf((String)locking.get("isolation").asString());
                                config.setIsolationLevel(level);
                            }
                            if (locking.hasDefined("striping")) {
                                config.setUseLockStriping(locking.get("striping").asBoolean());
                            }
                            if (locking.hasDefined("acquire-timeout")) {
                                config.setLockAcquisitionTimeout(locking.get("acquire-timeout").asLong());
                            }
                            if (locking.hasDefined("concurrency-level")) {
                                config.setConcurrencyLevel(locking.get("concurrency-level").asInt());
                            }
                        }
                        if (cache.hasDefined("transaction")) {
                            ModelNode transaction = cache.get("transaction");
                            if (transaction.hasDefined("stop-timeout")) {
                                config.setCacheStopTimeout(transaction.get("timeout").asInt());
                            }
                            if (transaction.hasDefined("sync-phase")) {
                                SyncPhase phase = SyncPhase.valueOf(transaction.get("sync-phase").asString());
                                config.setSyncCommitPhase(phase.isCommit());
                                config.setSyncRollbackPhase(phase.isRollback());
                            }
                            if (transaction.hasDefined("eager-locking")) {
                                EagerLocking eager = EagerLocking.valueOf(transaction.get("eager-locking").asString());
                                config.setUseEagerLocking(eager.isEnabled());
                                config.setEagerLockSingleNode(eager.isSingleOwner());
                            }
                        }
                        if (cache.hasDefined("eviction")) {
                            ModelNode eviction = cache.get("eviction");
                            if (eviction.hasDefined("strategy")) {
                                EvictionStrategy strategy = EvictionStrategy.valueOf((String)eviction.get("strategy").asString());
                                config.setEvictionStrategy(strategy);
                            }
                            if (eviction.hasDefined("max-entries")) {
                                config.setEvictionMaxEntries(eviction.get("max-entries").asInt());
                            }
                            if (eviction.hasDefined("interval")) {
                                config.setEvictionWakeUpInterval(eviction.get("interval").asLong());
                            }
                        }
                        if (cache.hasDefined("expiration")) {
                            ModelNode expiration = cache.get("expiration");
                            if (expiration.hasDefined("max-idle")) {
                                config.setExpirationMaxIdle(expiration.get("max-idle").asLong());
                            }
                            if (expiration.hasDefined("lifespan")) {
                                config.setExpirationLifespan(expiration.get("lifespan").asLong());
                            }
                        }
                        if (cache.hasDefined("state-transfer")) {
                            ModelNode stateTransfer = cache.get("state-transfer");
                            if (stateTransfer.hasDefined("enabled")) {
                                config.setFetchInMemoryState(stateTransfer.get("enabled").asBoolean());
                            }
                            if (stateTransfer.hasDefined("timeout")) {
                                config.setStateRetrievalTimeout(stateTransfer.get("timeout").asLong());
                            }
                            if (stateTransfer.hasDefined("flush-timeout")) {
                                config.setStateRetrievalLogFlushTimeout(stateTransfer.get("flush-timeout").asLong());
                            }
                        }
                        if (cache.hasDefined("rehashing")) {
                            ModelNode rehashing = cache.get("rehashing");
                            if (rehashing.hasDefined("enabled")) {
                                config.setRehashEnabled(rehashing.get("enabled").asBoolean());
                            }
                            if (rehashing.hasDefined("timeout")) {
                                config.setRehashRpcTimeout(rehashing.get("timeout").asLong());
                            }
                        }
                        if (cache.hasDefined("store")) {
                            ModelNode store = cache.get("store");
                            CacheLoaderManagerConfig storeManagerConfig = config.getCacheLoaderManagerConfig();
                            storeManagerConfig.setShared(Boolean.valueOf(store.hasDefined("shared") ? store.get("shared").asBoolean() : false));
                            storeManagerConfig.setPreload(Boolean.valueOf(store.hasDefined("preload") ? store.get("preload").asBoolean() : false));
                            storeManagerConfig.setPassivation(Boolean.valueOf(store.hasDefined("passivation") ? store.get("passivation").asBoolean() : true));
                            CacheStoreConfig storeConfig = this.createCacheLoaderConfig(store, locationInjectors);
                            storeConfig.getSingletonStoreConfig().setSingletonStoreEnabled(Boolean.valueOf(store.hasDefined("singleton") ? store.get("singleton").asBoolean() : false));
                            storeConfig.setFetchPersistentState(Boolean.valueOf(store.hasDefined("fetch-state") ? store.get("fetch-state").asBoolean() : true));
                            storeConfig.setPurgeOnStartup(Boolean.valueOf(store.hasDefined("purge") ? store.get("purge").asBoolean() : true));
                            if (store.hasDefined("property") && storeConfig instanceof AbstractCacheStoreConfig) {
                                Properties properties = new Properties();
                                for (Property property : store.get("property").asPropertyList()) {
                                    properties.setProperty(property.getName(), property.getValue().asString());
                                }
                                ((AbstractCacheStoreConfig)storeConfig).setProperties(properties);
                            }
                            storeManagerConfig.addCacheLoaderConfig((CacheLoaderConfig)storeConfig);
                        }
                        configs.put(cacheName, config);
                    }
                    if (!configs.containsKey(defaultCache)) {
                        throw new IllegalArgumentException(String.format("%s is not a valid default cache. The %s cache container does not contain a cache with that name", defaultCache, name));
                    }
                    EmbeddedCacheManagerService service = new EmbeddedCacheManagerService(name, defaultCache, global, CacheContainerAdd.this.defaultConfig.clone(), configs);
                    ServiceBuilder<CacheContainer> builder = service.build(context.getServiceTarget());
                    if (aliases != null) {
                        builder.addAliases(aliases);
                    }
                    service.addTransportDependency(builder, stack);
                    if (operation.hasDefined("listener-executor")) {
                        service.addListenerExecutorDependency(builder, operation.get("listener-executor").asString());
                    }
                    if (operation.hasDefined("eviction-executor")) {
                        service.addEvictionExecutorDependency(builder, operation.get("eviction-executor").asString());
                    }
                    if (operation.hasDefined("replication-queue-executor")) {
                        service.addReplicationQueueExecutorDependency(builder, operation.get("replication-queue-executor").asString());
                    }
                    if (transportExecutor != null) {
                        service.addTransportExecutorDependency(builder, transportExecutor);
                    }
                    for (Map.Entry entry : locationInjectors) {
                        builder.addDependency(AbstractPathService.pathNameOf((String)((String)entry.getKey())), String.class, (Injector)entry.getValue());
                    }
                    builder.install();
                    resultHandler.handleResultComplete();
                }

                private CacheStoreConfig createCacheLoaderConfig(ModelNode store, List<Map.Entry<String, Injector<String>>> injectors) {
                    if (store.hasDefined("class")) {
                        String className = store.get("class").asString();
                        try {
                            CacheStore cacheStore = Class.forName(className).asSubclass(CacheStore.class).newInstance();
                            return cacheStore.getConfigurationClass().asSubclass(CacheStoreConfig.class).newInstance();
                        }
                        catch (Exception e) {
                            throw new IllegalArgumentException(String.format("%s is not a valid cache store", className), e);
                        }
                    }
                    String relativeTo = "jboss.server.data.dir";
                    if (store.hasDefined("relative-to")) {
                        relativeTo = store.get("relative-to").asString();
                    }
                    FileCacheStoreConfig storeConfig = new FileCacheStoreConfig();
                    injectors.add(new AbstractMap.SimpleImmutableEntry<String, Injector<String>>(relativeTo, storeConfig.getRelativeToInjector()));
                    storeConfig.setPath(store.hasDefined("path") ? store.get("path").asString() : name);
                    return storeConfig;
                }
            };
            runtime.setRuntimeTask(task);
        } else {
            resultHandler.handleResultComplete();
        }
        return new BasicOperationResult(removeOperation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InfinispanConfiguration load(String resource) {
        InfinispanConfiguration infinispanConfiguration;
        URL url = InfinispanExtension.class.getClassLoader().getResource(resource);
        if (url == null) {
            throw new IllegalStateException(String.format("Failed to locate %s", resource));
        }
        InputStream input = url.openStream();
        ContextClassLoaderSwitcher.SwitchContext context = this.switcher.getSwitchContext(InfinispanConfiguration.class.getClassLoader());
        try {
            infinispanConfiguration = InfinispanConfiguration.newInfinispanConfiguration((InputStream)input);
        }
        catch (Throwable throwable) {
            try {
                context.reset();
                try {
                    input.close();
                }
                catch (IOException e) {
                    log.warn((Object)e.getMessage(), (Throwable)e);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalStateException(String.format("Failed to parse %s", url), e);
            }
        }
        context.reset();
        try {
            input.close();
        }
        catch (IOException e) {
            log.warn((Object)e.getMessage(), (Throwable)e);
        }
        return infinispanConfiguration;
    }
}

