/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.HashMap;
import java.util.Map;

public enum Element {
    UNKNOWN(null),
    ALIAS("alias"),
    CACHE_CONTAINER("cache-container"),
    DISTRIBUTED_CACHE("distributed-cache"),
    EVICTION("eviction"),
    EXPIRATION("expiration"),
    FILE_STORE("file-store"),
    INVALIDATION_CACHE("invalidation-cache"),
    LOCAL_CACHE("local-cache"),
    LOCKING("locking"),
    PROPERTY("property"),
    REHASHING("rehashing"),
    REPLICATED_CACHE("replicated-cache"),
    STATE_TRANSFER("state-transfer"),
    STORE("store"),
    SUBSYSTEM(org.jboss.as.controller.parsing.Element.SUBSYSTEM.getLocalName()),
    TRANSACTION("transaction"),
    TRANSPORT("transport");

    private final String name;
    private static final Map<String, Element> elements;

    private Element(String name) {
        this.name = name;
    }

    public String getLocalName() {
        return this.name;
    }

    public static Element forName(String localName) {
        Element element = elements.get(localName);
        return element == null ? UNKNOWN : element;
    }

    static {
        HashMap<String, Element> map = new HashMap<String, Element>();
        for (Element element : Element.values()) {
            String name = element.getLocalName();
            if (name == null) continue;
            map.put(name, element);
        }
        elements = map;
    }
}

