/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.Locale;
import org.infinispan.manager.EmbeddedCacheManager;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerService;
import org.jboss.as.clustering.infinispan.subsystem.LocalDescriptions;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelAddOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeOperationContext;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;

public class InfinispanSubsystemAdd
implements ModelAddOperationHandler,
DescriptionProvider {
    private static final Logger log = Logger.getLogger((String)InfinispanSubsystemAdd.class.getPackage().getName());

    static ModelNode createOperation(ModelNode address, ModelNode existing) {
        ModelNode operation = Util.getEmptyOperation((String)"add", (ModelNode)address);
        InfinispanSubsystemAdd.populate(existing, operation);
        return operation;
    }

    private static void populate(ModelNode source, ModelNode target) {
        target.get("default-cache-container").set(source.require("default-cache-container"));
        target.get("cache-container").setEmptyObject();
    }

    public ModelNode getModelDescription(Locale locale) {
        return LocalDescriptions.getSubsystemAddDescription(locale);
    }

    public OperationResult execute(OperationContext context, final ModelNode operation, ResultHandler resultHandler) throws OperationFailedException {
        log.info((Object)"Activating Infinispan subsystem.");
        InfinispanSubsystemAdd.populate(operation, context.getSubModel());
        RuntimeOperationContext runtime = context.getRuntimeContext();
        if (runtime != null) {
            RuntimeTask task = new RuntimeTask(){

                public void execute(RuntimeTaskContext context) throws OperationFailedException {
                    String defaultContainer = operation.require("default-cache-container").asString();
                    InjectedValue container = new InjectedValue();
                    ValueService service = new ValueService((Value)container);
                    context.getServiceTarget().addService(EmbeddedCacheManagerService.getServiceName(), (Service)service).addDependency(EmbeddedCacheManagerService.getServiceName(defaultContainer), EmbeddedCacheManager.class, (Injector)container).install();
                }
            };
            runtime.setRuntimeTask(task);
        }
        BasicOperationResult operationResult = new BasicOperationResult(Util.getResourceRemoveOperation((ModelNode)operation.require("address")));
        resultHandler.handleResultComplete();
        return operationResult;
    }
}

