/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.clustering.infinispan.subsystem.Namespace;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class LocalDescriptions {
    private LocalDescriptions() {
    }

    static ModelNode getSubsystemDescription(Locale locale) {
        ResourceBundle resources = LocalDescriptions.getResources(locale);
        ModelNode description = LocalDescriptions.createDescription(resources, "infinispan");
        description.get("head-comment-allowed").set(true);
        description.get("tail-comment-allowed").set(true);
        description.get("namespace").set(Namespace.CURRENT.getUri());
        return description;
    }

    static ModelNode getSubsystemAddDescription(Locale locale) {
        ResourceBundle resources = LocalDescriptions.getResources(locale);
        ModelNode description = LocalDescriptions.createSubsystemOperationDescription("add", resources);
        description.get(new String[]{"request-properties", "default-cache-container", "type"}).set(ModelType.STRING);
        description.get(new String[]{"request-properties", "default-cache-container", "description"}).set(resources.getString("infinispan.default-container"));
        description.get(new String[]{"request-properties", "default-cache-container", "required"}).set(false);
        return description;
    }

    static ModelNode getSubsystemDescribeDescription(Locale locale) {
        ResourceBundle resources = LocalDescriptions.getResources(locale);
        ModelNode description = LocalDescriptions.createSubsystemOperationDescription("describe", resources);
        description.get("request-properties").setEmptyObject();
        description.get(new String[]{"reply-properties", "type"}).set(ModelType.LIST);
        description.get(new String[]{"reply-properties", "value-type"}).set(ModelType.OBJECT);
        return description;
    }

    static ModelNode getCacheContainerDescription(Locale locale) {
        ResourceBundle resources = LocalDescriptions.getResources(locale);
        return LocalDescriptions.createDescription(resources, "infinispan.container");
    }

    static ModelNode getCacheContainerAddDescription(Locale locale) {
        ResourceBundle resources = LocalDescriptions.getResources(locale);
        ModelNode description = LocalDescriptions.createCacheContainerOperationDescription("add", resources);
        description.get(new String[]{"request-properties", "default-cache", "type"}).set(ModelType.STRING);
        description.get(new String[]{"request-properties", "default-cache", "description"}).set(resources.getString("infinispan.container.default-cache"));
        description.get(new String[]{"request-properties", "listener-executor", "type"}).set(ModelType.STRING);
        description.get(new String[]{"request-properties", "listener-executor", "description"}).set(resources.getString("infinispan.container.listener-executor"));
        description.get(new String[]{"request-properties", "eviction-executor", "type"}).set(ModelType.STRING);
        description.get(new String[]{"request-properties", "eviction-executor", "description"}).set(resources.getString("infinispan.container.eviction-executor"));
        description.get(new String[]{"request-properties", "replication-queue-executor", "type"}).set(ModelType.STRING);
        description.get(new String[]{"request-properties", "replication-queue-executor", "description"}).set(resources.getString("infinispan.container.replication-queue-executor"));
        description.get(new String[]{"request-properties", "alias", "type"}).set(ModelType.LIST);
        description.get(new String[]{"request-properties", "alias", "value-type"}).set(ModelType.STRING);
        description.get(new String[]{"request-properties", "alias", "description"}).set(resources.getString("infinispan.container.alias"));
        description.get(new String[]{"request-properties", "transport", "type"}).set(ModelType.OBJECT);
        description.get(new String[]{"request-properties", "transport", "description"}).set(resources.getString("infinispan.container.transport"));
        description.get(new String[]{"request-properties", "cache", "type"}).set(ModelType.LIST);
        description.get(new String[]{"request-properties", "cache", "value-type"}).set(ModelType.OBJECT);
        description.get(new String[]{"request-properties", "cache", "description"}).set(resources.getString("infinispan.container.cache"));
        return description;
    }

    static ModelNode getCacheContainerRemoveDescription(Locale locale) {
        ResourceBundle resources = LocalDescriptions.getResources(locale);
        ModelNode description = LocalDescriptions.createCacheContainerOperationDescription("remove", resources);
        description.get("request-properties").setEmptyObject();
        return description;
    }

    private static ResourceBundle getResources(Locale locale) {
        return ResourceBundle.getBundle(LocalDescriptions.class.getName(), locale == null ? Locale.getDefault() : locale);
    }

    private static ModelNode createDescription(ResourceBundle resources, String key) {
        return LocalDescriptions.createOperationDescription(null, resources, key);
    }

    private static ModelNode createOperationDescription(String operation, ResourceBundle resources, String key) {
        ModelNode description = new ModelNode();
        if (operation != null) {
            description.get("operation-name").set(operation);
        }
        description.get("description").set(resources.getString(key));
        return description;
    }

    private static ModelNode createSubsystemOperationDescription(String operation, ResourceBundle resources) {
        return LocalDescriptions.createOperationDescription(operation, resources, "infinispan." + operation);
    }

    private static ModelNode createCacheContainerOperationDescription(String operation, ResourceBundle resources) {
        return LocalDescriptions.createOperationDescription(operation, resources, "infinispan.container." + operation);
    }
}

