/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.config.assembly;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.config.assembly.AttributeValue;
import org.jboss.as.config.assembly.ElementNode;
import org.jboss.as.config.assembly.FormattingXMLStreamWriter;
import org.jboss.as.config.assembly.SubsystemConfig;
import org.jboss.as.config.assembly.SubsystemsParser;
import org.jboss.as.config.assembly.TextNode;

public class GenerateSubsystemsDefinition {
    private final List<SubsystemConfig> configs;
    private final String[] profiles;
    private final String filePrefix;
    private final File outputFile;

    public static void main(String[] args) throws Exception {
        String filePrefix;
        if (args == null) {
            throw new IllegalArgumentException("Null args");
        }
        if (args.length < 4) {
            throw new IllegalArgumentException("Invalid args: " + Arrays.asList(args));
        }
        int index = 0;
        if (args[index] == null || args[index].isEmpty()) {
            throw new IllegalArgumentException("No configured subsystems");
        }
        String definitions = args[index++];
        String[] profiles = new String[]{""};
        if (args[index] != null && !args[index].isEmpty()) {
            profiles = args[index].split(",");
        }
        if (args[++index] == null || args[index].isEmpty()) {
            throw new IllegalArgumentException("No file prefix");
        }
        if (!(filePrefix = args[index++]).endsWith("/")) {
            filePrefix = filePrefix + "/";
        }
        if (args[index] == null || args[index].isEmpty()) {
            throw new IllegalArgumentException("No output file");
        }
        File outputFile = new File(args[index++]);
        ArrayList<SubsystemConfig> configs = new ArrayList<SubsystemConfig>();
        for (String spec : definitions.split(",")) {
            String[] split = spec.split(":");
            String subsystem = split[0];
            String supplement = split.length > 1 ? split[1] : null;
            configs.add(new SubsystemConfig(subsystem, supplement));
        }
        new GenerateSubsystemsDefinition(configs, profiles, filePrefix, outputFile).process();
    }

    private GenerateSubsystemsDefinition(List<SubsystemConfig> configs, String[] profiles, String filePrefix, File outputFile) {
        this.configs = configs;
        this.profiles = profiles;
        this.filePrefix = filePrefix;
        this.outputFile = outputFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process() throws XMLStreamException, IOException {
        ElementNode config = new ElementNode(null, "config", SubsystemsParser.NAMESPACE);
        for (String profile : this.profiles) {
            ElementNode subsystems = new ElementNode(config, "subsystems");
            if (!profile.isEmpty()) {
                subsystems.addAttribute("name", new AttributeValue(profile));
            }
            config.addChild(subsystems);
            for (SubsystemConfig sub : this.configs) {
                ElementNode subsystem = new ElementNode(config, "subsystem");
                if (sub.getSupplement() != null) {
                    subsystem.addAttribute("supplement", new AttributeValue(sub.getSupplement()));
                }
                subsystem.addChild(new TextNode(this.filePrefix + sub.getSubsystem() + ".xml"));
                subsystems.addChild(subsystem);
            }
        }
        FileWriter writer = new FileWriter(this.outputFile);
        try {
            XMLOutputFactory factory = XMLOutputFactory.newInstance();
            FormattingXMLStreamWriter xmlwriter = new FormattingXMLStreamWriter(factory.createXMLStreamWriter(writer));
            config.marshall(xmlwriter);
        }
        finally {
            ((Writer)writer).close();
        }
    }
}

