/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.adapters.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.as.connector.adapters.jdbc.JBossWrapper;
import org.jboss.as.connector.adapters.jdbc.WrappedStatement;
import org.jboss.logging.Logger;

public abstract class WrappedResultSet
extends JBossWrapper
implements ResultSet {
    protected static Logger spyLogger = Logger.getLogger((String)"jboss.jdbc.spy");
    private WrappedStatement statement;
    private ResultSet resultSet;
    private AtomicBoolean closed = new AtomicBoolean(false);
    protected final boolean spy;
    protected final String jndiName;

    public WrappedResultSet(WrappedStatement statement, ResultSet resultSet, boolean spy, String jndiName) {
        if (statement == null) {
            throw new IllegalArgumentException("Null statement!");
        }
        if (resultSet == null) {
            throw new IllegalArgumentException("Null result set!");
        }
        this.statement = statement;
        this.resultSet = resultSet;
        this.spy = spy;
        this.jndiName = jndiName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getUnderlyingResultSet() throws SQLException {
        this.statement.lock();
        try {
            this.checkTransaction();
            ResultSet resultSet = this.resultSet;
            return resultSet;
        }
        finally {
            this.statement.unlock();
        }
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] absolute(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)row);
            }
            return this.resultSet.absolute(row);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void afterLast() throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] afterLast()", (Object)this.jndiName, (Object)"ResultSet");
            }
            this.resultSet.afterLast();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] beforeFirst()", (Object)this.jndiName, (Object)"ResultSet");
            }
            this.resultSet.beforeFirst();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] cancelRowUpdates()", (Object)this.jndiName, (Object)"ResultSet");
            }
            this.resultSet.cancelRowUpdates();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] clearWarnings()", (Object)this.jndiName, (Object)"ResultSet");
            }
            this.resultSet.clearWarnings();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.closed.get()) {
            return;
        }
        if (this.spy) {
            spyLogger.debugf("%s [%s] close()", (Object)this.jndiName, (Object)"ResultSet");
        }
        this.closed.set(true);
        this.statement.unregisterResultSet(this);
        this.internalClose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteRow() throws SQLException {
        this.statement.lock();
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] deleteRow()", (Object)this.jndiName, (Object)"ResultSet");
                }
                this.resultSet.deleteRow();
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.statement.unlock();
        }
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] findColumn(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnName);
            }
            return this.resultSet.findColumn(columnName);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public boolean first() throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] first()", (Object)this.jndiName, (Object)"ResultSet");
            }
            return this.resultSet.first();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public Array getArray(int i) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getArray(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)i);
            }
            return this.resultSet.getArray(i);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public Array getArray(String colName) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getArray(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)colName);
            }
            return this.resultSet.getArray(colName);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getAsciiStream(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnIndex);
            }
            return this.resultSet.getAsciiStream(columnIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public InputStream getAsciiStream(String columnName) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getAsciiStream(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnName);
            }
            return this.resultSet.getAsciiStream(columnName);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getBigDecimal(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnIndex);
            }
            return this.resultSet.getBigDecimal(columnIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getBigDecimal(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, scale});
            }
            return this.resultSet.getBigDecimal(columnIndex, scale);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getBigDecimal(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnName);
            }
            return this.resultSet.getBigDecimal(columnName);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getBigDecimal(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnName, scale});
            }
            return this.resultSet.getBigDecimal(columnName, scale);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getBinaryStream(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnIndex);
            }
            return this.resultSet.getBinaryStream(columnIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public InputStream getBinaryStream(String columnName) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getBinaryStream(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnName);
            }
            return this.resultSet.getBinaryStream(columnName);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public Blob getBlob(int i) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getBlob(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)i);
            }
            return this.resultSet.getBlob(i);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public Blob getBlob(String colName) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getBlob(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)colName);
            }
            return this.resultSet.getBlob(colName);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getBoolean(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnIndex);
            }
            return this.resultSet.getBoolean(columnIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public boolean getBoolean(String columnName) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getBoolean(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnName);
            }
            return this.resultSet.getBoolean(columnName);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getByte(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnIndex);
            }
            return this.resultSet.getByte(columnIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public byte getByte(String columnName) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getByte(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnName);
            }
            return this.resultSet.getByte(columnName);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getBytes(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnIndex);
            }
            return this.resultSet.getBytes(columnIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public byte[] getBytes(String columnName) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getBytes(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnName);
            }
            return this.resultSet.getBytes(columnName);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getCharacterStream(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnIndex);
            }
            return this.resultSet.getCharacterStream(columnIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public Reader getCharacterStream(String columnName) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getCharacterStream(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnName);
            }
            return this.resultSet.getCharacterStream(columnName);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public Clob getClob(int i) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getClob(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)i);
            }
            return this.resultSet.getClob(i);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public Clob getClob(String colName) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getClob(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)colName);
            }
            return this.resultSet.getClob(colName);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public int getConcurrency() throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getConcurrency()", (Object)this.jndiName, (Object)"ResultSet");
            }
            return this.resultSet.getConcurrency();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public String getCursorName() throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getCursorName()", (Object)this.jndiName, (Object)"ResultSet");
            }
            return this.resultSet.getCursorName();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getDate(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnIndex);
            }
            return this.resultSet.getDate(columnIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getDate(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, cal});
            }
            return this.resultSet.getDate(columnIndex, cal);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public Date getDate(String columnName) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getDate(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnName);
            }
            return this.resultSet.getDate(columnName);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public Date getDate(String columnName, Calendar cal) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getDate(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnName, cal});
            }
            return this.resultSet.getDate(columnName, cal);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getDouble(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnIndex);
            }
            return this.resultSet.getDouble(columnIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public double getDouble(String columnName) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getDouble(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnName);
            }
            return this.resultSet.getDouble(columnName);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getFetchDirection()", (Object)this.jndiName, (Object)"ResultSet");
            }
            return this.resultSet.getFetchDirection();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getFetchSize()", (Object)this.jndiName, (Object)"ResultSet");
            }
            return this.resultSet.getFetchSize();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getFloat(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnIndex);
            }
            return this.resultSet.getFloat(columnIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public float getFloat(String columnName) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getFloat(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnName);
            }
            return this.resultSet.getFloat(columnName);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getInt(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnIndex);
            }
            return this.resultSet.getInt(columnIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public int getInt(String columnName) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getInt(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnName);
            }
            return this.resultSet.getInt(columnName);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getLong(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnIndex);
            }
            return this.resultSet.getLong(columnIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public long getLong(String columnName) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getLong(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnName);
            }
            return this.resultSet.getLong(columnName);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getMetaData()", (Object)this.jndiName, (Object)"ResultSet");
            }
            return this.resultSet.getMetaData();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getObject(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnIndex);
            }
            return this.resultSet.getObject(columnIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public Object getObject(int i, Map<String, Class<?>> map) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getObject(%s, %s)", new Object[]{this.jndiName, "ResultSet", i, map});
            }
            return this.resultSet.getObject(i, map);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public Object getObject(String columnName) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getObject(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnName);
            }
            return this.resultSet.getObject(columnName);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public Object getObject(String colName, Map<String, Class<?>> map) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getObject(%s, %s)", new Object[]{this.jndiName, "ResultSet", colName, map});
            }
            return this.resultSet.getObject(colName, map);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public Ref getRef(int i) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getRef(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)i);
            }
            return this.resultSet.getRef(i);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public Ref getRef(String colName) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getRef(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)colName);
            }
            return this.resultSet.getRef(colName);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public int getRow() throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getRow()", (Object)this.jndiName, (Object)"ResultSet");
            }
            return this.resultSet.getRow();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getShort(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnIndex);
            }
            return this.resultSet.getShort(columnIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public short getShort(String columnName) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getShort(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnName);
            }
            return this.resultSet.getShort(columnName);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public Statement getStatement() throws SQLException {
        this.checkState();
        if (this.spy) {
            spyLogger.debugf("%s [%s] getStatement()", (Object)this.jndiName, (Object)"ResultSet");
        }
        return this.statement;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getString(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnIndex);
            }
            return this.resultSet.getString(columnIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public String getString(String columnName) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getString(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnName);
            }
            return this.resultSet.getString(columnName);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getTime(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnIndex);
            }
            return this.resultSet.getTime(columnIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getTime(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, cal});
            }
            return this.resultSet.getTime(columnIndex, cal);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public Time getTime(String columnName) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getTime(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnName);
            }
            return this.resultSet.getTime(columnName);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public Time getTime(String columnName, Calendar cal) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getTime(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnName, cal});
            }
            return this.resultSet.getTime(columnName, cal);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getTimestamp(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnIndex);
            }
            return this.resultSet.getTimestamp(columnIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getTimestamp(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, cal});
            }
            return this.resultSet.getTimestamp(columnIndex, cal);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public Timestamp getTimestamp(String columnName) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getTimestamp(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnName);
            }
            return this.resultSet.getTimestamp(columnName);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getTimestamp(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnName, cal});
            }
            return this.resultSet.getTimestamp(columnName, cal);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public int getType() throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getType()", (Object)this.jndiName, (Object)"ResultSet");
            }
            return this.resultSet.getType();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getUnicodeStream(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnIndex);
            }
            return this.resultSet.getUnicodeStream(columnIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(String columnName) throws SQLException {
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getUnicodeStream(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnName);
            }
            return this.resultSet.getUnicodeStream(columnName);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getURL(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnIndex);
            }
            return this.resultSet.getURL(columnIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public URL getURL(String columnName) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getURL(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnName);
            }
            return this.resultSet.getURL(columnName);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getWarnings()", (Object)this.jndiName, (Object)"ResultSet");
            }
            return this.resultSet.getWarnings();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertRow() throws SQLException {
        this.statement.lock();
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] insertRow()", (Object)this.jndiName, (Object)"ResultSet");
                }
                this.resultSet.insertRow();
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.statement.unlock();
        }
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] isAfterLast()", (Object)this.jndiName, (Object)"ResultSet");
            }
            return this.resultSet.isAfterLast();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] isBeforeFirst()", (Object)this.jndiName, (Object)"ResultSet");
            }
            return this.resultSet.isBeforeFirst();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] isFirst()", (Object)this.jndiName, (Object)"ResultSet");
            }
            return this.resultSet.isFirst();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public boolean isLast() throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] isLast()", (Object)this.jndiName, (Object)"ResultSet");
            }
            return this.resultSet.isLast();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public boolean last() throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] last()", (Object)this.jndiName, (Object)"ResultSet");
            }
            return this.resultSet.last();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] moveToCurrentRow()", (Object)this.jndiName, (Object)"ResultSet");
            }
            this.resultSet.moveToCurrentRow();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] moveToInsertRow()", (Object)this.jndiName, (Object)"ResultSet");
            }
            this.resultSet.moveToInsertRow();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public boolean next() throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] next()", (Object)this.jndiName, (Object)"ResultSet");
            }
            return this.resultSet.next();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public boolean previous() throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] previous()", (Object)this.jndiName, (Object)"ResultSet");
            }
            return this.resultSet.previous();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void refreshRow() throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] refreshRow()", (Object)this.jndiName, (Object)"ResultSet");
            }
            this.resultSet.refreshRow();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] relative(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)rows);
            }
            return this.resultSet.relative(rows);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] rowDeleted()", (Object)this.jndiName, (Object)"ResultSet");
            }
            return this.resultSet.rowDeleted();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public boolean rowInserted() throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] rowInserted()", (Object)this.jndiName, (Object)"ResultSet");
            }
            return this.resultSet.rowInserted();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] rowUpdated()", (Object)this.jndiName, (Object)"ResultSet");
            }
            return this.resultSet.rowUpdated();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] setFetchDirection(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)direction);
            }
            this.resultSet.setFetchDirection(direction);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] setFetchSize(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)rows);
            }
            this.resultSet.setFetchSize(rows);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] updateArray(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, x});
            }
            this.resultSet.updateArray(columnIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateArray(String columnName, Array x) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] updateArray(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnName, x});
            }
            this.resultSet.updateArray(columnName, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] updateAsciiStream(%s, %s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, x, length});
            }
            this.resultSet.updateAsciiStream(columnIndex, x, length);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] updateAsciiStream(%s, %s, %s)", new Object[]{this.jndiName, "ResultSet", columnName, x, length});
            }
            this.resultSet.updateAsciiStream(columnName, x, length);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] updateBigDecimal(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, x});
            }
            this.resultSet.updateBigDecimal(columnIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] updateBigDecimal(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnName, x});
            }
            this.resultSet.updateBigDecimal(columnName, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] updateBinaryStream(%s, %s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, x, length});
            }
            this.resultSet.updateBinaryStream(columnIndex, x, length);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] updateBinaryStream(%s, %s, %s)", new Object[]{this.jndiName, "ResultSet", columnName, x, length});
            }
            this.resultSet.updateBinaryStream(columnName, x, length);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] updateBlob(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, x});
            }
            this.resultSet.updateBlob(columnIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateBlob(String columnName, Blob x) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] updateBlob(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnName, x});
            }
            this.resultSet.updateBlob(columnName, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] updateBoolean(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, x});
            }
            this.resultSet.updateBoolean(columnIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateBoolean(String columnName, boolean x) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] updateBoolean(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnName, x});
            }
            this.resultSet.updateBoolean(columnName, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] updateByte(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, x});
            }
            this.resultSet.updateByte(columnIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateByte(String columnName, byte x) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] updateByte(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnName, x});
            }
            this.resultSet.updateByte(columnName, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] updateBytes(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, Arrays.toString(x)});
            }
            this.resultSet.updateBytes(columnIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateBytes(String columnName, byte[] x) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] updateBytes(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnName, Arrays.toString(x)});
            }
            this.resultSet.updateBytes(columnName, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] updateCharacterStream(%s, %s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, x, length});
            }
            this.resultSet.updateCharacterStream(columnIndex, x, length);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] updateCharacterStream(%s, %s, %s)", new Object[]{this.jndiName, "ResultSet", columnName, reader, length});
            }
            this.resultSet.updateCharacterStream(columnName, reader, length);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] updateClob(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, x});
            }
            this.resultSet.updateClob(columnIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateClob(String columnName, Clob x) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] updateClob(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnName, x});
            }
            this.resultSet.updateClob(columnName, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] updateDate(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, x});
            }
            this.resultSet.updateDate(columnIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateDate(String columnName, Date x) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] updateDate(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnName, x});
            }
            this.resultSet.updateDate(columnName, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] updateDouble(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, x});
            }
            this.resultSet.updateDouble(columnIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateDouble(String columnName, double x) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] updateDouble(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnName, x});
            }
            this.resultSet.updateDouble(columnName, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] updateFloat(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, Float.valueOf(x)});
            }
            this.resultSet.updateFloat(columnIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateFloat(String columnName, float x) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] updateFloat(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnName, Float.valueOf(x)});
            }
            this.resultSet.updateFloat(columnName, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] updateInt(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, x});
            }
            this.resultSet.updateInt(columnIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateInt(String columnName, int x) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] updateInt(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnName, x});
            }
            this.resultSet.updateInt(columnName, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] updateLong(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, x});
            }
            this.resultSet.updateLong(columnIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateLong(String columnName, long x) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] updateLong(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnName, x});
            }
            this.resultSet.updateLong(columnName, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] updateNull(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnIndex);
            }
            this.resultSet.updateNull(columnIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateNull(String columnName) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] updateNull(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnName);
            }
            this.resultSet.updateNull(columnName);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] updateObject(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, x});
            }
            this.resultSet.updateObject(columnIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] updateObject(%s, %s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, x, scale});
            }
            this.resultSet.updateObject(columnIndex, x, scale);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateObject(String columnName, Object x) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] updateObject(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnName, x});
            }
            this.resultSet.updateObject(columnName, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] updateObject(%s, %s, %s)", new Object[]{this.jndiName, "ResultSet", columnName, x, scale});
            }
            this.resultSet.updateObject(columnName, x, scale);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] updateRef(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, x});
            }
            this.resultSet.updateRef(columnIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateRef(String columnName, Ref x) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] updateRef(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnName, x});
            }
            this.resultSet.updateRef(columnName, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRow() throws SQLException {
        this.statement.lock();
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] updateRow()", (Object)this.jndiName, (Object)"ResultSet");
                }
                this.resultSet.updateRow();
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.statement.unlock();
        }
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        this.checkState();
        try {
            this.resultSet.updateShort(columnIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateShort(String columnName, short x) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] updateShort(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnName, x});
            }
            this.resultSet.updateShort(columnName, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] updateString(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, x});
            }
            this.resultSet.updateString(columnIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateString(String columnName, String x) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] updateString(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnName, x});
            }
            this.resultSet.updateString(columnName, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] updateTime(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, x});
            }
            this.resultSet.updateTime(columnIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateTime(String columnName, Time x) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] updateTime(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnName, x});
            }
            this.resultSet.updateTime(columnName, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] updateTimestamp(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, x});
            }
            this.resultSet.updateTimestamp(columnIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] updateTimestamp(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnName, x});
            }
            this.resultSet.updateTimestamp(columnName, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.checkState();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] wasNull()", (Object)this.jndiName, (Object)"ResultSet");
            }
            return this.resultSet.wasNull();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        ResultSet resultSet = this.getUnderlyingResultSet();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getHoldability()", (Object)this.jndiName, (Object)"ResultSet");
            }
            return resultSet.getHoldability();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        ResultSet resultSet = this.getUnderlyingResultSet();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getNCharacterStream(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnIndex);
            }
            return resultSet.getNCharacterStream(columnIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        ResultSet resultSet = this.getUnderlyingResultSet();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getNCharacterStream(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnLabel);
            }
            return resultSet.getNCharacterStream(columnLabel);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        ResultSet resultSet = this.getUnderlyingResultSet();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getNClob(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnIndex);
            }
            return resultSet.getNClob(columnIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        ResultSet resultSet = this.getUnderlyingResultSet();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getNClob(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnLabel);
            }
            return resultSet.getNClob(columnLabel);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        ResultSet resultSet = this.getUnderlyingResultSet();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getNString(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnIndex);
            }
            return resultSet.getNString(columnIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        ResultSet resultSet = this.getUnderlyingResultSet();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getNString(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnLabel);
            }
            return resultSet.getNString(columnLabel);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        ResultSet resultSet = this.getUnderlyingResultSet();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getRowId(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnIndex);
            }
            return resultSet.getRowId(columnIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        ResultSet resultSet = this.getUnderlyingResultSet();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getRowId(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnLabel);
            }
            return resultSet.getRowId(columnLabel);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        ResultSet resultSet = this.getUnderlyingResultSet();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getSQLXML(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnIndex);
            }
            return resultSet.getSQLXML(columnIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        ResultSet resultSet = this.getUnderlyingResultSet();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] getSQLXML(%s)", (Object)this.jndiName, (Object)"ResultSet", (Object)columnLabel);
            }
            return resultSet.getSQLXML(columnLabel);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        ResultSet resultSet;
        if (this.spy) {
            spyLogger.debugf("%s [%s] isClosed()", (Object)this.jndiName, (Object)"ResultSet");
        }
        if ((resultSet = this.getWrappedObject()) == null) {
            return true;
        }
        try {
            return resultSet.isClosed();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        ResultSet resultSet = this.getUnderlyingResultSet();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] updateAsciiStream(%s, %s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, x, length});
            }
            resultSet.updateAsciiStream(columnIndex, x, length);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        ResultSet resultSet = this.getUnderlyingResultSet();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] updateAsciiStream(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, x});
            }
            resultSet.updateAsciiStream(columnIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        ResultSet resultSet = this.getUnderlyingResultSet();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] updateAsciiStream(%s, %s, %s)", new Object[]{this.jndiName, "ResultSet", columnLabel, x, length});
            }
            resultSet.updateAsciiStream(columnLabel, x, length);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        ResultSet resultSet = this.getUnderlyingResultSet();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] updateAsciiStream(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnLabel, x});
            }
            resultSet.updateAsciiStream(columnLabel, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        ResultSet resultSet = this.getUnderlyingResultSet();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] updateBinaryStream(%s, %s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, x, length});
            }
            resultSet.updateBinaryStream(columnIndex, x, length);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        ResultSet resultSet = this.getUnderlyingResultSet();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] updateBinaryStream(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, x});
            }
            resultSet.updateBinaryStream(columnIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        ResultSet resultSet = this.getUnderlyingResultSet();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] updateBinaryStream(%s, %s, %s)", new Object[]{this.jndiName, "ResultSet", columnLabel, x, length});
            }
            resultSet.updateBinaryStream(columnLabel, x, length);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        ResultSet resultSet = this.getUnderlyingResultSet();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] updateBinaryStream(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnLabel, x});
            }
            resultSet.updateBinaryStream(columnLabel, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        ResultSet resultSet = this.getUnderlyingResultSet();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] updateBlob(%s, %s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, inputStream, length});
            }
            resultSet.updateBlob(columnIndex, inputStream, length);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        ResultSet resultSet = this.getUnderlyingResultSet();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] updateBlob(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, inputStream});
            }
            resultSet.updateBlob(columnIndex, inputStream);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        ResultSet resultSet = this.getUnderlyingResultSet();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] updateBlob(%s, %s, %s)", new Object[]{this.jndiName, "ResultSet", columnLabel, inputStream, length});
            }
            resultSet.updateBlob(columnLabel, inputStream, length);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        ResultSet resultSet = this.getUnderlyingResultSet();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] updateBlob(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnLabel, inputStream});
            }
            resultSet.updateBlob(columnLabel, inputStream);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        ResultSet resultSet = this.getUnderlyingResultSet();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] updateCharacterStream(%s, %s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, x, length});
            }
            resultSet.updateCharacterStream(columnIndex, x, length);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        ResultSet resultSet = this.getUnderlyingResultSet();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] updateCharacterStream(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, x});
            }
            resultSet.updateCharacterStream(columnIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        ResultSet resultSet = this.getUnderlyingResultSet();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] updateCharacterStream(%s, %s, %s)", new Object[]{this.jndiName, "ResultSet", columnLabel, reader, length});
            }
            resultSet.updateCharacterStream(columnLabel, reader, length);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        ResultSet resultSet = this.getUnderlyingResultSet();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] updateCharacterStream(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnLabel, reader});
            }
            resultSet.updateCharacterStream(columnLabel, reader);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        ResultSet resultSet = this.getUnderlyingResultSet();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] updateClob(%s, %s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, reader, length});
            }
            resultSet.updateClob(columnIndex, reader, length);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        ResultSet resultSet = this.getUnderlyingResultSet();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] updateClob(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, reader});
            }
            resultSet.updateClob(columnIndex, reader);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        ResultSet resultSet = this.getUnderlyingResultSet();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] updateClob(%s, %s, %s)", new Object[]{this.jndiName, "ResultSet", columnLabel, reader, length});
            }
            resultSet.updateClob(columnLabel, reader, length);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        ResultSet resultSet = this.getUnderlyingResultSet();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] updateClob(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnLabel, reader});
            }
            resultSet.updateClob(columnLabel, reader);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        ResultSet resultSet = this.getUnderlyingResultSet();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] updateNCharacterStream(%s, %s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, x, length});
            }
            resultSet.updateNCharacterStream(columnIndex, x, length);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        ResultSet resultSet = this.getUnderlyingResultSet();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] updateNCharacterStream(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, x});
            }
            resultSet.updateNCharacterStream(columnIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        ResultSet resultSet = this.getUnderlyingResultSet();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] updateNCharacterStream(%s, %s, %s)", new Object[]{this.jndiName, "ResultSet", columnLabel, reader, length});
            }
            resultSet.updateNCharacterStream(columnLabel, reader, length);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        ResultSet resultSet = this.getUnderlyingResultSet();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] updateNCharacterStream(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnLabel, reader});
            }
            resultSet.updateNCharacterStream(columnLabel, reader);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateNClob(int columnIndex, NClob clob) throws SQLException {
        ResultSet resultSet = this.getUnderlyingResultSet();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] updateNClob(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, clob});
            }
            resultSet.updateNClob(columnIndex, clob);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        ResultSet resultSet = this.getUnderlyingResultSet();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] updateNClob(%s, %s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, reader, length});
            }
            resultSet.updateNClob(columnIndex, reader, length);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        ResultSet resultSet = this.getUnderlyingResultSet();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] updateNClob(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, reader});
            }
            resultSet.updateNClob(columnIndex, reader);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateNClob(String columnLabel, NClob clob) throws SQLException {
        ResultSet resultSet = this.getUnderlyingResultSet();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] updateNClob(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnLabel, clob});
            }
            resultSet.updateNClob(columnLabel, clob);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        ResultSet resultSet = this.getUnderlyingResultSet();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] updateNClob(%s, %s, %s)", new Object[]{this.jndiName, "ResultSet", columnLabel, reader, length});
            }
            resultSet.updateNClob(columnLabel, reader, length);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        ResultSet resultSet = this.getUnderlyingResultSet();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] updateNClob(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnLabel, reader});
            }
            resultSet.updateNClob(columnLabel, reader);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateNString(int columnIndex, String string) throws SQLException {
        ResultSet resultSet = this.getUnderlyingResultSet();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] updateNString(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, string});
            }
            resultSet.updateNString(columnIndex, string);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateNString(String columnLabel, String string) throws SQLException {
        ResultSet resultSet = this.getUnderlyingResultSet();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] updateNString(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnLabel, string});
            }
            resultSet.updateNString(columnLabel, string);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        ResultSet resultSet = this.getUnderlyingResultSet();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] updateRowId(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, x});
            }
            resultSet.updateRowId(columnIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        ResultSet resultSet = this.getUnderlyingResultSet();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] updateRowId(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnLabel, x});
            }
            resultSet.updateRowId(columnLabel, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        ResultSet resultSet = this.getUnderlyingResultSet();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] updateSQLXML(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnIndex, xmlObject});
            }
            resultSet.updateSQLXML(columnIndex, xmlObject);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        ResultSet resultSet = this.getUnderlyingResultSet();
        try {
            if (this.spy) {
                spyLogger.debugf("%s [%s] updateSQLXML(%s, %s)", new Object[]{this.jndiName, "ResultSet", columnLabel, xmlObject});
            }
            resultSet.updateSQLXML(columnLabel, xmlObject);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    protected ResultSet getWrappedObject() throws SQLException {
        return this.getUnderlyingResultSet();
    }

    protected SQLException checkException(Throwable t) throws SQLException {
        throw this.statement.checkException(t);
    }

    void internalClose() throws SQLException {
        this.closed.set(true);
        this.resultSet.close();
    }

    void checkState() throws SQLException {
        if (this.closed.get()) {
            throw new SQLException("The result set is closed.");
        }
    }

    protected void checkTransaction() throws SQLException {
        this.checkState();
        this.statement.checkTransactionActive();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof WrappedResultSet) {
            return this.resultSet.equals(((WrappedResultSet)o).resultSet);
        }
        if (o instanceof ResultSet) {
            return this.resultSet.equals(o);
        }
        return false;
    }

    public int hashCode() {
        return this.resultSet.hashCode();
    }

    public String toString() {
        return this.resultSet.toString();
    }
}

