/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.deployers.processors;

import java.lang.reflect.Constructor;
import java.sql.Driver;
import java.util.List;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.ServicesAttachment;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;

public final class DriverProcessor
implements DeploymentUnitProcessor {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.connector.deployers.jdbc");

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        ServicesAttachment servicesAttachment = (ServicesAttachment)deploymentUnit.getAttachment(Attachments.SERVICES);
        if (module != null && servicesAttachment != null) {
            ModuleClassLoader classLoader = module.getClassLoader();
            List driverNames = servicesAttachment.getServiceImplementations(Driver.class.getName());
            for (String driverName : driverNames) {
                try {
                    Class<Driver> driverClass = classLoader.loadClass(driverName).asSubclass(Driver.class);
                    Constructor<Driver> constructor = driverClass.getConstructor(new Class[0]);
                    Driver driver = constructor.newInstance(new Object[0]);
                    int majorVersion = driver.getMajorVersion();
                    int minorVersion = driver.getMinorVersion();
                    boolean compliant = driver.jdbcCompliant();
                    if (compliant) {
                        log.infof("Deploying JDBC-compliant driver %s (version %d.%d)", driverClass, (Object)majorVersion, (Object)minorVersion);
                    } else {
                        log.infof("Deploying non-JDBC-compliant driver %s (version %d.%d)", driverClass, (Object)majorVersion, (Object)minorVersion);
                    }
                    phaseContext.getServiceTarget().addService(ServiceName.JBOSS.append(new String[]{"jdbc-driver", driverName, Integer.toString(majorVersion), Integer.toString(minorVersion)}), (Service)new ValueService((Value)new ImmediateValue((Object)driver))).setInitialMode(ServiceController.Mode.ACTIVE).install();
                }
                catch (Exception e) {
                    log.warnf("Unable to instantiate driver class \"%s\": %s", (Object)driverName, (Object)e);
                }
            }
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

