/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.jndi;

import java.util.Hashtable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.resource.Referenceable;
import org.jboss.as.naming.context.ModularReference;
import org.jboss.jca.core.spi.naming.JndiStrategy;
import org.jboss.logging.Logger;
import org.jboss.util.naming.Util;

public class AS7JndiStrategy
implements JndiStrategy {
    private static Logger log = Logger.getLogger((String)"org.jboss.as.connector.jndi");
    private static boolean trace = log.isTraceEnabled();
    private static ConcurrentMap<String, Object> objs = new ConcurrentHashMap<String, Object>();

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        Reference ref = (Reference)obj;
        String className = (String)ref.get("class").getContent();
        String cfname = (String)ref.get("name").getContent();
        return objs.get(AS7JndiStrategy.qualifiedName(cfname, className));
    }

    public String[] bindConnectionFactories(String deployment, Object[] cfs) throws Throwable {
        throw new IllegalStateException("JNDI names are required");
    }

    public String[] bindConnectionFactories(String deployment, Object[] cfs, String[] jndis) throws Throwable {
        this.ensureNotEmpty(deployment, "Deployment");
        this.ensureNotEmpty(cfs, "CFS");
        this.ensureNotEmpty(jndis, "JNDIs");
        if (cfs.length != jndis.length) {
            throw new IllegalArgumentException("Number of connection factories doesn't match number of JNDI names");
        }
        for (int i = 0; i < cfs.length; ++i) {
            String jndiName = jndis[i];
            Object cf = cfs[i];
            this.bindObject(jndiName, cf);
        }
        return jndis;
    }

    public void unbindConnectionFactories(String deployment, Object[] cfs) throws Throwable {
        throw new IllegalStateException("JNDI names are required");
    }

    public void unbindConnectionFactories(String deployment, Object[] cfs, String[] jndis) throws Throwable {
        this.ensureNotEmpty(cfs, "CFS");
        this.ensureNotEmpty(jndis, "JNDIs");
        if (cfs.length != jndis.length) {
            throw new IllegalArgumentException("Number of connection factories doesn't match number of JNDI names");
        }
        for (int i = 0; i < cfs.length; ++i) {
            String jndiName = jndis[i];
            Object cf = cfs[i];
            this.unbindObject(jndiName, cf);
        }
    }

    public String[] bindAdminObjects(String deployment, Object[] aos) throws Throwable {
        throw new IllegalStateException("JNDI names are required");
    }

    public String[] bindAdminObjects(String deployment, Object[] aos, String[] jndis) throws Throwable {
        this.ensureNotEmpty(deployment, "Deployment");
        this.ensureNotEmpty(aos, "AOS");
        this.ensureNotEmpty(jndis, "JNDIs");
        if (aos.length != jndis.length) {
            throw new IllegalArgumentException("Number of admin objects doesn't match number of JNDI names");
        }
        for (int i = 0; i < aos.length; ++i) {
            String jndiName = jndis[i];
            Object ao = aos[i];
            this.bindObject(jndiName, ao);
        }
        return jndis;
    }

    public void unbindAdminObjects(String deployment, Object[] aos) throws Throwable {
        throw new IllegalStateException("JNDI names are required");
    }

    public void unbindAdminObjects(String deployment, Object[] aos, String[] jndis) throws Throwable {
        this.ensureNotEmpty(aos, "AOS");
        this.ensureNotEmpty(jndis, "JNDIs");
        if (aos.length != jndis.length) {
            throw new IllegalArgumentException("Number of admin objects doesn't match number of JNDI names");
        }
        for (int i = 0; i < aos.length; ++i) {
            String jndiName = jndis[i];
            Object ao = aos[i];
            this.unbindObject(jndiName, ao);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bindObject(String jndiName, Object obj) throws Exception {
        this.ensureNotNull(obj, "Bind Object");
        this.ensureNotEmpty(jndiName, "JNDI Name");
        String className = obj.getClass().getName();
        log.tracef("Binding %s under %s", (Object)className, (Object)jndiName);
        ModularReference reference = ModularReference.create((String)className, (RefAddr)new StringRefAddr("class", className), AS7JndiStrategy.class);
        reference.add(new StringRefAddr("name", jndiName));
        if (objs.putIfAbsent(AS7JndiStrategy.qualifiedName(jndiName, className), obj) != null) {
            throw new Exception("Deployment " + className + " failed, " + jndiName + " is already deployed");
        }
        Referenceable referenceable = (Referenceable)obj;
        referenceable.setReference((Reference)reference);
        InitialContext context = new InitialContext();
        try {
            Util.bind((Context)context, (String)jndiName, (Object)obj);
            log.debugf("Bound %s under %s", (Object)className, (Object)jndiName);
        }
        finally {
            this.safeClose(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unbindObject(String jndiName, Object object) throws Exception {
        this.ensureNotNull(object, "Bind Object");
        this.ensureNotEmpty(jndiName, "JNDI Name");
        String className = object.getClass().getName();
        log.tracef("Unbinding %s  under %s", (Object)className, (Object)jndiName);
        InitialContext context = new InitialContext();
        try {
            Util.unbind((Context)context, (String)jndiName);
            objs.remove(AS7JndiStrategy.qualifiedName(jndiName, className));
            log.debugf("Unbound %s under %s", (Object)className, (Object)jndiName);
        }
        catch (Throwable t) {
            log.warn((Object)"Exception during unbind", t);
        }
        finally {
            this.safeClose(context);
        }
    }

    public JndiStrategy clone() throws CloneNotSupportedException {
        return (JndiStrategy)super.clone();
    }

    private static String qualifiedName(String name, String className) {
        return className + "#" + name;
    }

    private void safeClose(Context context) {
        if (context != null) {
            try {
                context.close();
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
    }

    private void ensureNotNull(Object object, String name) {
        if (object == null) {
            throw new IllegalArgumentException(name + " is null");
        }
    }

    private void ensureNotEmpty(String string, String name) {
        this.ensureNotNull(string, name);
        if (string.isEmpty()) {
            throw new IllegalArgumentException(name + " is empty");
        }
    }

    private void ensureNotEmpty(Object[] array, String name) {
        this.ensureNotNull(array, name);
        if (array.length == 0) {
            throw new IllegalArgumentException(name + " is empty");
        }
    }
}

