/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.datasources;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.connector.subsystems.datasources.Attribute;
import org.jboss.as.connector.subsystems.datasources.DataSourcesSubsystemAdd;
import org.jboss.as.connector.subsystems.datasources.DataSourcesSubsystemProviders;
import org.jboss.as.connector.subsystems.datasources.Element;
import org.jboss.as.connector.subsystems.datasources.JdbcDriverAdd;
import org.jboss.as.connector.subsystems.datasources.JdbcDriverDescribe;
import org.jboss.as.connector.subsystems.datasources.JdbcDriverRemove;
import org.jboss.as.connector.subsystems.datasources.Namespace;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ModelQueryOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationHandler;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.CommonDescriptions;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.controller.registry.ModelNodeRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.jca.common.api.metadata.common.CommonPool;
import org.jboss.jca.common.api.metadata.common.CommonXaPool;
import org.jboss.jca.common.api.metadata.ds.DataSource;
import org.jboss.jca.common.api.metadata.ds.DataSources;
import org.jboss.jca.common.api.metadata.ds.DsSecurity;
import org.jboss.jca.common.api.metadata.ds.JdbcAdapterExtension;
import org.jboss.jca.common.api.metadata.ds.Statement;
import org.jboss.jca.common.api.metadata.ds.TimeOut;
import org.jboss.jca.common.api.metadata.ds.Validation;
import org.jboss.jca.common.api.metadata.ds.XaDataSource;
import org.jboss.jca.common.metadata.ds.DsParser;
import org.jboss.logging.Logger;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class DataSourcesExtension
implements Extension {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.datasources");

    public void initialize(ExtensionContext context) {
        log.debugf("Initializing Datasources Extension", new Object[0]);
        SubsystemRegistration registration = context.registerSubsystem("datasources");
        registration.registerXMLElementWriter((XMLElementWriter)NewDataSourceSubsystemParser.INSTANCE);
        ModelNodeRegistration subsystem = registration.registerSubsystemModel(DataSourcesSubsystemProviders.SUBSYSTEM);
        subsystem.registerOperationHandler("add", (OperationHandler)DataSourcesSubsystemAdd.INSTANCE, DataSourcesSubsystemProviders.SUBSYSTEM_ADD_DESC, false);
        subsystem.registerOperationHandler("describe", (OperationHandler)DataSourcesSubsystemDescribeHandler.INSTANCE, (DescriptionProvider)DataSourcesSubsystemDescribeHandler.INSTANCE, false, OperationEntry.EntryType.PRIVATE);
        ModelNodeRegistration jdbcDrivers = subsystem.registerSubModel(PathElement.pathElement((String)"jdbc-driver"), DataSourcesSubsystemProviders.JDBC_DRIVER_DESC);
        jdbcDrivers.registerOperationHandler("add", (OperationHandler)JdbcDriverAdd.INSTANCE, DataSourcesSubsystemProviders.ADD_JDBC_DRIVER_DESC, false);
        jdbcDrivers.registerOperationHandler("remove", (OperationHandler)JdbcDriverRemove.INSTANCE, DataSourcesSubsystemProviders.REMOVE_JDBC_DRIVER_DESC, false);
        jdbcDrivers.registerOperationHandler("describe", (OperationHandler)JdbcDriverDescribe.INSTANCE, DataSourcesSubsystemProviders.DESCRIBE_JDBC_DRIVER_DESC, false, OperationEntry.EntryType.PRIVATE);
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(Namespace.CURRENT.getUriString(), (XMLElementReader)NewDataSourceSubsystemParser.INSTANCE);
    }

    private static ModelNode createEmptyAddSubsystemOperation() {
        ModelNode address = new ModelNode();
        address.add("subsystem", "datasources");
        address.protect();
        ModelNode subsystem = new ModelNode();
        subsystem.get("operation").set("add");
        subsystem.get("address").set(address);
        return subsystem;
    }

    private static class DataSourcesSubsystemDescribeHandler
    implements ModelQueryOperationHandler,
    DescriptionProvider {
        static final DataSourcesSubsystemDescribeHandler INSTANCE = new DataSourcesSubsystemDescribeHandler();

        private DataSourcesSubsystemDescribeHandler() {
        }

        public OperationResult execute(OperationContext context, ModelNode operation, ResultHandler resultHandler) {
            ModelNode add = DataSourcesExtension.createEmptyAddSubsystemOperation();
            ModelNode model = context.getSubModel();
            boolean workaround = true;
            if (workaround) {
                if (model.hasDefined("datasources")) {
                    ModelNode datasources = model.get("datasources");
                    add.get("datasources").set(datasources);
                }
                if (model.hasDefined("jdbc-driver")) {
                    ModelNode jdbcDrivers = model.get("jdbc-driver");
                    add.get("jdbc-driver").set(jdbcDrivers);
                }
            }
            ModelNode result = new ModelNode();
            result.add(add);
            resultHandler.handleResultFragment(Util.NO_LOCATION, result);
            resultHandler.handleResultComplete();
            return new BasicOperationResult();
        }

        public ModelNode getModelDescription(Locale locale) {
            return CommonDescriptions.getSubsystemDescribeOperation((Locale)locale);
        }
    }

    static final class NewDataSourceSubsystemParser
    implements XMLStreamConstants,
    XMLElementReader<List<ModelNode>>,
    XMLElementWriter<SubsystemMarshallingContext> {
        static final NewDataSourceSubsystemParser INSTANCE = new NewDataSourceSubsystemParser();

        NewDataSourceSubsystemParser() {
        }

        public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
            context.startSubsystemElement(Namespace.CURRENT.getUriString(), false);
            ModelNode node = context.getModelNode();
            writer.writeStartElement("datasources");
            if (node.has("datasources")) {
                for (ModelNode dataSourceNode : node.get("datasources").asList()) {
                    boolean statementRequired;
                    boolean timeoutRequired;
                    boolean validationRequired;
                    boolean securityRequired;
                    boolean isXADataSource = this.hasAnyOf(dataSourceNode, "xa-resource-timeout", "xa-data-source-class", "xa-data-source-properties");
                    writer.writeStartElement(isXADataSource ? DataSources.Tag.XA_DATASOURCE.getLocalName() : DataSources.Tag.DATASOURCE.getLocalName());
                    this.writeAttributeIfHas(writer, dataSourceNode, DataSource.Attribute.JNDINAME, "jndi-name");
                    this.writeAttributeIfHas(writer, dataSourceNode, DataSource.Attribute.POOL_NAME, "pool-name");
                    this.writeAttributeIfHas(writer, dataSourceNode, DataSource.Attribute.ENABLED, "enabled");
                    this.writeAttributeIfHas(writer, dataSourceNode, DataSource.Attribute.USEJAVACONTEXT, "use-java-context");
                    this.writeAttributeIfHas(writer, dataSourceNode, DataSource.Attribute.SPY, "spy");
                    if (!isXADataSource) {
                        this.writeElementIfHas(writer, dataSourceNode, DataSource.Tag.CONNECTIONURL, "connection-url");
                        this.writeElementIfHas(writer, dataSourceNode, DataSource.Tag.DRIVERCLASS, "driver-class");
                    }
                    if (isXADataSource) {
                        this.writeElementIfHas(writer, dataSourceNode, XaDataSource.Tag.XADATASOURCECLASS, "xa-data-source-class");
                    }
                    this.writeElementIfHas(writer, dataSourceNode, DataSource.Tag.MODULE, "module");
                    if (!isXADataSource) {
                        // empty if block
                    }
                    if (isXADataSource) {
                        this.writeElementIfHas(writer, dataSourceNode, XaDataSource.Tag.URLDELIMITER, "url-delimiter");
                        this.writeElementIfHas(writer, dataSourceNode, XaDataSource.Tag.URLSELECTORSTRATEGYCLASSNAME, "url-selector-strategy-class-name");
                    }
                    this.writeElementIfHas(writer, dataSourceNode, DataSource.Tag.NEWCONNECTIONSQL, "new-connection-sql");
                    this.writeElementIfHas(writer, dataSourceNode, DataSource.Tag.TRANSACTIONISOLATION, "transaction-isolation");
                    if (!isXADataSource) {
                        this.writeElementIfHas(writer, dataSourceNode, DataSource.Tag.URLDELIMITER, "url-delimiter");
                        this.writeElementIfHas(writer, dataSourceNode, DataSource.Tag.URLSELECTORSTRATEGYCLASSNAME, "url-selector-strategy-class-name");
                    }
                    boolean poolRequired = this.hasAnyOf(dataSourceNode, "min-pool-size", "max-pool-size", "pool-prefill", "pool-use-strict-min");
                    if (isXADataSource) {
                        boolean bl = poolRequired = poolRequired || this.hasAnyOf(dataSourceNode, "same-rm-override", "interliving", "no-tx-separate-pool", "pad-xid", "wrap-xa-datasource");
                    }
                    if (poolRequired) {
                        writer.writeStartElement(isXADataSource ? XaDataSource.Tag.XA_POOL.getLocalName() : DataSource.Tag.POOL.getLocalName());
                        this.writeElementIfHas(writer, dataSourceNode, CommonPool.Tag.MIN_POOL_SIZE, "min-pool-size");
                        this.writeElementIfHas(writer, dataSourceNode, CommonPool.Tag.MAXPOOLSIZE, "max-pool-size");
                        this.writeElementIfHas(writer, dataSourceNode, CommonPool.Tag.PREFILL, "pool-prefill");
                        this.writeElementIfHas(writer, dataSourceNode, CommonPool.Tag.USE_STRICT_MIN, "pool-use-strict-min");
                        if (isXADataSource) {
                            this.writeElementIfHas(writer, dataSourceNode, CommonXaPool.Tag.ISSAMERMOVERRIDEVALUE, "same-rm-override");
                            this.writeEmptyElementIfHasAndTrue(writer, dataSourceNode, CommonXaPool.Tag.ISSAMERMOVERRIDEVALUE, "same-rm-override");
                            this.writeEmptyElementIfHasAndTrue(writer, dataSourceNode, CommonXaPool.Tag.NO_TX_SEPARATE_POOLS, "no-tx-separate-pool");
                            this.writeElementIfHas(writer, dataSourceNode, CommonXaPool.Tag.PAD_XID, "pad-xid");
                            this.writeElementIfHas(writer, dataSourceNode, CommonXaPool.Tag.WRAP_XA_RESOURCE, "wrap-xa-datasource");
                        }
                        writer.writeEndElement();
                    }
                    if (securityRequired = this.hasAnyOf(dataSourceNode, "user-name", "password")) {
                        writer.writeStartElement(DataSource.Tag.SECURITY.getLocalName());
                        this.writeElementIfHas(writer, dataSourceNode, DsSecurity.Tag.USERNAME, "user-name");
                        this.writeElementIfHas(writer, dataSourceNode, DsSecurity.Tag.PASSWORD, "password");
                        this.writeElementIfHas(writer, dataSourceNode, DsSecurity.Tag.SECURITY_DOMAIN, "security-domain");
                        writer.writeEndElement();
                    }
                    if (validationRequired = this.hasAnyOf(dataSourceNode, "valid-connection-checker-class-name", "check-valid-connection-sql", "validate-on-match", "background-validation", "background-validation-minutes", "use-fast-fail", "stale-connection-checker-class-name", "exception-sorter-class-name")) {
                        writer.writeStartElement(DataSource.Tag.VALIDATION.getLocalName());
                        this.writeElementIfHas(writer, dataSourceNode, Validation.Tag.VALIDCONNECTIONCHECKER, "valid-connection-checker-class-name");
                        this.writeElementIfHas(writer, dataSourceNode, Validation.Tag.CHECKVALIDCONNECTIONSQL, "check-valid-connection-sql");
                        this.writeElementIfHas(writer, dataSourceNode, Validation.Tag.VALIDATEONMATCH, "validate-on-match");
                        this.writeElementIfHas(writer, dataSourceNode, Validation.Tag.BACKGROUNDVALIDATION, "background-validation");
                        this.writeElementIfHas(writer, dataSourceNode, Validation.Tag.BACKGROUNDVALIDATIONMINUTES, "background-validation-minutes");
                        this.writeElementIfHas(writer, dataSourceNode, Validation.Tag.USEFASTFAIL, "use-fast-fail");
                        this.writeElementIfHas(writer, dataSourceNode, Validation.Tag.STALECONNECTIONCHECKER, "stale-connection-checker-class-name");
                        this.writeElementIfHas(writer, dataSourceNode, Validation.Tag.EXCEPTIONSORTER, "exception-sorter-class-name");
                        writer.writeEndElement();
                    }
                    if (timeoutRequired = this.hasAnyOf(dataSourceNode, "blocking-timeout-wait-millis", "idle-timeout-minutes", "set-tx-query-timeout", "query-timeout", "use-try-lock", "allocation-retry", "allocation-retry-wait-millis", "xa-resource-timeout")) {
                        this.writeElementIfHas(writer, dataSourceNode, TimeOut.Tag.BLOCKINGTIMEOUTMILLIS, "blocking-timeout-wait-millis");
                        this.writeElementIfHas(writer, dataSourceNode, TimeOut.Tag.IDLETIMEOUTMINUTES, "idle-timeout-minutes");
                        this.writeEmptyElementIfHasAndTrue(writer, dataSourceNode, TimeOut.Tag.SETTXQUERYTIMEOUT, "set-tx-query-timeout");
                        this.writeElementIfHas(writer, dataSourceNode, TimeOut.Tag.QUERYTIMEOUT, "query-timeout");
                        this.writeElementIfHas(writer, dataSourceNode, TimeOut.Tag.USETRYLOCK, "use-try-lock");
                        this.writeElementIfHas(writer, dataSourceNode, TimeOut.Tag.ALLOCATIONRETRY, "allocation-retry");
                        this.writeElementIfHas(writer, dataSourceNode, TimeOut.Tag.ALLOCATIONRETRYWAITMILLIS, "allocation-retry-wait-millis");
                        this.writeElementIfHas(writer, dataSourceNode, TimeOut.Tag.XARESOURCETIMEOUT, "xa-resource-timeout");
                    }
                    if (statementRequired = this.hasAnyOf(dataSourceNode, "track-statements", "prepared-statements-cacheSize", "share-prepared-statements")) {
                        writer.writeStartElement(DataSource.Tag.STATEMENT.getLocalName());
                        this.writeElementIfHas(writer, dataSourceNode, Statement.Tag.TRACKSTATEMENTS, "track-statements");
                        this.writeElementIfHas(writer, dataSourceNode, Statement.Tag.PREPAREDSTATEMENTCACHESIZE, "prepared-statements-cacheSize");
                        this.writeEmptyElementIfHasAndTrue(writer, dataSourceNode, Statement.Tag.SHAREPREPAREDSTATEMENTS, "share-prepared-statements");
                        writer.writeEndElement();
                    }
                    writer.writeEndElement();
                }
            }
            writer.writeEndElement();
            if (node.hasDefined("jdbc-driver")) {
                writer.writeStartElement(Element.DRIVERS.getLocalName());
                for (Property driverProperty : node.get("jdbc-driver").asPropertyList()) {
                    writer.writeStartElement(Element.DRIVER.getLocalName());
                    writer.writeAttribute(Attribute.MODULE.getLocalName(), driverProperty.getValue().require("module").asString());
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }

        private void writeAttributeIfHas(XMLExtendedStreamWriter writer, ModelNode node, DataSource.Attribute attr, String identifier) throws XMLStreamException {
            if (this.has(node, identifier)) {
                writer.writeAttribute(attr.getLocalName(), node.get(identifier).asString());
            }
        }

        private void writeElementIfHas(XMLExtendedStreamWriter writer, ModelNode node, String localName, String identifier) throws XMLStreamException {
            if (this.has(node, identifier)) {
                writer.writeStartElement(localName);
                writer.writeCharacters(node.get(identifier).asString());
                writer.writeEndElement();
            }
        }

        private void writeElementIfHas(XMLExtendedStreamWriter writer, ModelNode node, XaDataSource.Tag element, String identifier) throws XMLStreamException {
            this.writeElementIfHas(writer, node, element.getLocalName(), identifier);
        }

        private void writeElementIfHas(XMLExtendedStreamWriter writer, ModelNode node, DataSource.Tag element, String identifier) throws XMLStreamException {
            this.writeElementIfHas(writer, node, element.getLocalName(), identifier);
        }

        private void writeElementIfHas(XMLExtendedStreamWriter writer, ModelNode node, DsSecurity.Tag element, String identifier) throws XMLStreamException {
            this.writeElementIfHas(writer, node, element.getLocalName(), identifier);
        }

        private void writeElementIfHas(XMLExtendedStreamWriter writer, ModelNode node, CommonPool.Tag element, String identifier) throws XMLStreamException {
            this.writeElementIfHas(writer, node, element.getLocalName(), identifier);
        }

        private void writeElementIfHas(XMLExtendedStreamWriter writer, ModelNode node, CommonXaPool.Tag element, String identifier) throws XMLStreamException {
            this.writeElementIfHas(writer, node, element.getLocalName(), identifier);
        }

        private void writeElementIfHas(XMLExtendedStreamWriter writer, ModelNode node, TimeOut.Tag element, String identifier) throws XMLStreamException {
            this.writeElementIfHas(writer, node, element.getLocalName(), identifier);
        }

        private void writeElementIfHas(XMLExtendedStreamWriter writer, ModelNode node, Validation.Tag element, String identifier) throws XMLStreamException {
            this.writeElementIfHas(writer, node, element.getLocalName(), identifier);
        }

        private void writeElementIfHas(XMLExtendedStreamWriter writer, ModelNode node, Statement.Tag element, String identifier) throws XMLStreamException {
            this.writeElementIfHas(writer, node, element.getLocalName(), identifier);
        }

        private void writeEmptyElementIfHasAndTrue(XMLExtendedStreamWriter writer, ModelNode node, String localName, String identifier) throws XMLStreamException {
            if (node.has(identifier) && node.get(identifier).asBoolean()) {
                writer.writeEmptyElement(localName);
            }
        }

        private void writeEmptyElementIfHasAndTrue(XMLExtendedStreamWriter writer, ModelNode node, Statement.Tag element, String identifier) throws XMLStreamException {
            this.writeEmptyElementIfHasAndTrue(writer, node, element.getLocalName(), identifier);
        }

        private void writeEmptyElementIfHasAndTrue(XMLExtendedStreamWriter writer, ModelNode node, CommonXaPool.Tag element, String identifier) throws XMLStreamException {
            this.writeEmptyElementIfHasAndTrue(writer, node, element.getLocalName(), identifier);
        }

        private void writeEmptyElementIfHasAndTrue(XMLExtendedStreamWriter writer, ModelNode node, TimeOut.Tag element, String identifier) throws XMLStreamException {
            this.writeEmptyElementIfHasAndTrue(writer, node, element.getLocalName(), identifier);
        }

        private boolean hasAnyOf(ModelNode node, String ... names) {
            for (String current : names) {
                if (!this.has(node, current)) continue;
                return true;
            }
            return false;
        }

        private boolean has(ModelNode node, String name) {
            return node.has(name) && node.get(name).isDefined();
        }

        public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
            ModelNode address = new ModelNode();
            address.add("subsystem", "datasources");
            address.protect();
            ModelNode subsystem = new ModelNode();
            subsystem.get("operation").set("add");
            subsystem.get("address").set(address);
            list.add(subsystem);
            DataSources dataSources = null;
            try {
                String localName = null;
                block1 : switch (Namespace.forUri(reader.getNamespaceURI())) {
                    case DATASOURCES_1_0: {
                        localName = reader.getLocalName();
                        Element element = Element.forName(reader.getLocalName());
                        log.tracef("%s -> %s", (Object)localName, (Object)element);
                        switch (element) {
                            case SUBSYSTEM: {
                                DsParser parser = new DsParser();
                                dataSources = parser.parse((XMLStreamReader)reader);
                                this.parseForDrivers(reader, address, list);
                                break block1;
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new XMLStreamException(e);
            }
            if (dataSources != null) {
                ModelNode datasourcesNode = subsystem.get("datasources");
                for (DataSource ds : dataSources.getDataSource()) {
                    Validation validation;
                    TimeOut timeout;
                    Statement statement;
                    DsSecurity security;
                    ModelNode dsModel = new ModelNode();
                    for (Map.Entry entry : ds.getConnectionProperties().entrySet()) {
                        dsModel.get(new String[]{"connection-properties", (String)entry.getKey()}).set((String)entry.getValue());
                    }
                    this.setIfNotNull(dsModel, "connection-url", ds.getConnectionUrl());
                    this.setIfNotNull(dsModel, "driver-class", ds.getDriverClass());
                    this.setIfNotNull(dsModel, "jndi-name", ds.getJndiName());
                    this.setIfNotNull(dsModel, "module", ds.getModule());
                    this.setIfNotNull(dsModel, "new-connection-sql", ds.getNewConnectionSql());
                    this.setIfNotNull(dsModel, "pool-name", ds.getPoolName());
                    this.setIfNotNull(dsModel, "url-delimiter", ds.getUrlDelimiter());
                    this.setIfNotNull(dsModel, "url-selector-strategy-class-name", ds.getUrlSelectorStrategyClassName());
                    this.setIfNotNull(dsModel, "use-java-context", ds.isUseJavaContext());
                    this.setIfNotNull(dsModel, "enabled", ds.isEnabled());
                    CommonPool pool = ds.getPool();
                    if (pool != null) {
                        this.setIfNotNull(dsModel, "max-pool-size", pool.getMaxPoolSize());
                        this.setIfNotNull(dsModel, "min-pool-size", pool.getMinPoolSize());
                        this.setIfNotNull(dsModel, "pool-prefill", pool.isPrefill());
                        this.setIfNotNull(dsModel, "pool-use-strict-min", pool.isUseStrictMin());
                    }
                    if ((security = ds.getSecurity()) != null) {
                        this.setIfNotNull(dsModel, "user-name", security.getUserName());
                        this.setIfNotNull(dsModel, "password", security.getPassword());
                        this.setIfNotNull(dsModel, "security-domain", security.getSecurityDomain());
                    }
                    if ((statement = ds.getStatement()) != null) {
                        this.setIfNotNull(dsModel, "prepared-statements-cacheSize", statement.getPreparedStatementsCacheSize());
                        this.setIfNotNull(dsModel, "share-prepared-statements", statement.isSharePreparedStatements());
                        if (statement.getTrackStatements() != null) {
                            this.setIfNotNull(dsModel, "track-statements", statement.getTrackStatements().name());
                        }
                    }
                    if ((timeout = ds.getTimeOut()) != null) {
                        this.setIfNotNull(dsModel, "allocation-retry", timeout.getAllocationRetry());
                        this.setIfNotNull(dsModel, "allocation-retry-wait-millis", timeout.getAllocationRetryWaitMillis());
                        this.setIfNotNull(dsModel, "blocking-timeout-wait-millis", timeout.getBlockingTimeoutMillis());
                        this.setIfNotNull(dsModel, "idle-timeout-minutes", timeout.getIdleTimeoutMinutes());
                        this.setIfNotNull(dsModel, "query-timeout", timeout.getQueryTimeout());
                        this.setIfNotNull(dsModel, "use-try-lock", timeout.getUseTryLock());
                        this.setIfNotNull(dsModel, "set-tx-query-timeout", timeout.isSetTxQueryTimeout());
                    }
                    if (ds.getTransactionIsolation() != null) {
                        this.setIfNotNull(dsModel, "transaction-isolation", ds.getTransactionIsolation().name());
                    }
                    if (ds.isSpy()) {
                        this.setIfNotNull(dsModel, "spy", ds.isSpy());
                    }
                    if ((validation = ds.getValidation()) != null) {
                        this.setIfNotNull(dsModel, "check-valid-connection-sql", validation.getCheckValidConnectionSql());
                        this.setIfNotNull(dsModel, "exception-sorter-class-name", "exceptionsorter-properties", validation.getExceptionSorter());
                        this.setIfNotNull(dsModel, "stale-connection-checker-class-name", "staleconnectionchecker-properties", validation.getStaleConnectionChecker());
                        this.setIfNotNull(dsModel, "valid-connection-checker-class-name", "validconnectionchecker-properties", validation.getValidConnectionChecker());
                        this.setIfNotNull(dsModel, "background-validation-minutes", validation.getBackgroundValidationMinutes());
                        this.setIfNotNull(dsModel, "background-validation", validation.isBackgroundValidation());
                        this.setIfNotNull(dsModel, "use-fast-fail", validation.isUseFastFail());
                        this.setIfNotNull(dsModel, "validate-on-match", validation.isValidateOnMatch());
                    }
                    datasourcesNode.add(dsModel);
                }
                ModelNode XAdatasourcesNode = subsystem.get("datasources");
                for (XaDataSource xads : dataSources.getXaDataSource()) {
                    TimeOut timeout;
                    Statement statement;
                    DsSecurity security;
                    ModelNode xadsModel = new ModelNode();
                    for (Map.Entry entry : xads.getXaDataSourceProperty().entrySet()) {
                        xadsModel.get(new String[]{"xa-data-source-properties", (String)entry.getKey()}).set((String)entry.getValue());
                    }
                    this.setIfNotNull(xadsModel, "xa-data-source-class", xads.getXaDataSourceClass());
                    this.setIfNotNull(xadsModel, "jndi-name", xads.getJndiName());
                    this.setIfNotNull(xadsModel, "module", xads.getModule());
                    this.setIfNotNull(xadsModel, "new-connection-sql", xads.getNewConnectionSql());
                    this.setIfNotNull(xadsModel, "pool-name", xads.getPoolName());
                    this.setIfNotNull(xadsModel, "url-delimiter", xads.getUrlDelimiter());
                    this.setIfNotNull(xadsModel, "url-selector-strategy-class-name", xads.getUrlSelectorStrategyClassName());
                    this.setIfNotNull(xadsModel, "use-java-context", xads.isUseJavaContext());
                    this.setIfNotNull(xadsModel, "enabled", xads.isEnabled());
                    CommonXaPool pool = xads.getXaPool();
                    if (pool != null) {
                        this.setIfNotNull(xadsModel, "max-pool-size", pool.getMaxPoolSize());
                        this.setIfNotNull(xadsModel, "min-pool-size", pool.getMinPoolSize());
                        this.setIfNotNull(xadsModel, "pool-prefill", pool.isPrefill());
                        this.setIfNotNull(xadsModel, "pool-use-strict-min", pool.isUseStrictMin());
                        this.setIfNotNull(xadsModel, "interliving", pool.isInterleaving());
                        this.setIfNotNull(xadsModel, "no-tx-separate-pool", pool.isNoTxSeparatePool());
                        this.setIfNotNull(xadsModel, "pad-xid", pool.isPadXid());
                        this.setIfNotNull(xadsModel, "same-rm-override", pool.isSameRmOverride());
                        this.setIfNotNull(xadsModel, "wrap-xa-datasource", pool.isWrapXaDataSource());
                    }
                    if ((security = xads.getSecurity()) != null) {
                        this.setIfNotNull(xadsModel, "user-name", security.getUserName());
                        this.setIfNotNull(xadsModel, "password", security.getPassword());
                        this.setIfNotNull(xadsModel, "security-domain", security.getSecurityDomain());
                    }
                    if ((statement = xads.getStatement()) != null) {
                        this.setIfNotNull(xadsModel, "prepared-statements-cacheSize", statement.getPreparedStatementsCacheSize());
                        this.setIfNotNull(xadsModel, "share-prepared-statements", statement.isSharePreparedStatements());
                        if (statement.getTrackStatements() != null) {
                            this.setIfNotNull(xadsModel, "track-statements", statement.getTrackStatements().name());
                        }
                    }
                    if ((timeout = xads.getTimeOut()) != null) {
                        this.setIfNotNull(xadsModel, "allocation-retry", timeout.getAllocationRetry());
                        this.setIfNotNull(xadsModel, "allocation-retry-wait-millis", timeout.getAllocationRetryWaitMillis());
                        this.setIfNotNull(xadsModel, "blocking-timeout-wait-millis", timeout.getBlockingTimeoutMillis());
                        this.setIfNotNull(xadsModel, "idle-timeout-minutes", timeout.getIdleTimeoutMinutes());
                        this.setIfNotNull(xadsModel, "query-timeout", timeout.getQueryTimeout());
                        this.setIfNotNull(xadsModel, "use-try-lock", timeout.getUseTryLock());
                        this.setIfNotNull(xadsModel, "set-tx-query-timeout", timeout.isSetTxQueryTimeout());
                        this.setIfNotNull(xadsModel, "xa-resource-timeout", timeout.getXaResourceTimeout());
                    }
                    if (xads.getTransactionIsolation() != null) {
                        this.setIfNotNull(xadsModel, "transaction-isolation", xads.getTransactionIsolation().name());
                    }
                    if (xads.isSpy()) {
                        this.setIfNotNull(xadsModel, "spy", xads.isSpy());
                    }
                    Validation validation = xads.getValidation();
                    if (xads.getValidation() != null) {
                        this.setIfNotNull(xadsModel, "check-valid-connection-sql", validation.getCheckValidConnectionSql());
                        this.setIfNotNull(xadsModel, "exception-sorter-class-name", "exceptionsorter-properties", validation.getExceptionSorter());
                        this.setIfNotNull(xadsModel, "stale-connection-checker-class-name", "staleconnectionchecker-properties", validation.getStaleConnectionChecker());
                        this.setIfNotNull(xadsModel, "valid-connection-checker-class-name", "validconnectionchecker-properties", validation.getValidConnectionChecker());
                        this.setIfNotNull(xadsModel, "background-validation-minutes", validation.getBackgroundValidationMinutes());
                        this.setIfNotNull(xadsModel, "background-validation", validation.isBackgroundValidation());
                        this.setIfNotNull(xadsModel, "use-fast-fail", validation.isUseFastFail());
                        this.setIfNotNull(xadsModel, "validate-on-match", validation.isValidateOnMatch());
                    }
                    XAdatasourcesNode.add(xadsModel);
                }
            }
        }

        private void setIfNotNull(ModelNode dsModel, String extensionclassname, String extensionProperties, JdbcAdapterExtension extension) {
            if (extension != null) {
                this.setIfNotNull(dsModel, extensionclassname, extension.getClassName());
                if (extension.getConfigPropertiesMap() != null) {
                    for (Map.Entry entry : extension.getConfigPropertiesMap().entrySet()) {
                        dsModel.get(new String[]{extensionProperties, (String)entry.getKey()}).set((String)entry.getValue());
                    }
                }
            }
        }

        private void parseForDrivers(XMLExtendedStreamReader reader, ModelNode parentAddress, List<ModelNode> list) throws XMLStreamException {
            block6: while (reader.hasNext() && reader.nextTag() != 2) {
                switch (Namespace.forUri(reader.getNamespaceURI())) {
                    case DATASOURCES_1_0: {
                        Element element = Element.forName(reader.getLocalName());
                        switch (element) {
                            case DRIVERS: {
                                this.parseDrivers(reader, parentAddress, list);
                                continue block6;
                            }
                        }
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }

        private void parseDrivers(XMLExtendedStreamReader reader, ModelNode parentAddress, List<ModelNode> list) throws XMLStreamException {
            block9: while (reader.hasNext() && reader.nextTag() != 2) {
                switch (Namespace.forUri(reader.getNamespaceURI())) {
                    case DATASOURCES_1_0: {
                        Element element = Element.forName(reader.getLocalName());
                        switch (element) {
                            case DRIVER: {
                                ModelNode op = new ModelNode();
                                list.add(op);
                                op.get("operation").set("add");
                                String moduleName = null;
                                block10: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                                    Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                                    switch (attribute) {
                                        case MODULE: {
                                            moduleName = reader.getAttributeValue(i);
                                            continue block10;
                                        }
                                        default: {
                                            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                                        }
                                    }
                                }
                                if (moduleName == null) {
                                    throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton("module"));
                                }
                                op.get("module").set(moduleName);
                                ModelNode address = parentAddress.clone();
                                address.add("jdbc-driver", moduleName);
                                address.protect();
                                op.get("address").set(address);
                                ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                                continue block9;
                            }
                        }
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }

        private void setIfNotNull(ModelNode node, String identifier, Boolean value) {
            if (value != null) {
                node.get(identifier).set(value.booleanValue());
            }
        }

        private void setIfNotNull(ModelNode node, String identifier, Integer value) {
            if (value != null) {
                node.get(identifier).set(value.intValue());
            }
        }

        private void setIfNotNull(ModelNode node, String identifier, Long value) {
            if (value != null) {
                node.get(identifier).set(value.longValue());
            }
        }

        private void setIfNotNull(ModelNode node, String identifier, String value) {
            if (value != null) {
                node.get(identifier).set(value);
            }
        }
    }
}

