/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.datasources;

import com.arjuna.ats.jbossatx.jta.TransactionManagerService;
import java.sql.Driver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.connector.deployers.processors.DataSourceDefinitionDeployer;
import org.jboss.as.connector.subsystems.datasources.AbstractDataSourceService;
import org.jboss.as.connector.subsystems.datasources.DataSourcesSubsystemProviders;
import org.jboss.as.connector.subsystems.datasources.LocalDataSourceService;
import org.jboss.as.connector.subsystems.datasources.XaDataSourceService;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelAddOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.NamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.naming.service.NamingService;
import org.jboss.as.server.BootOperationContext;
import org.jboss.as.server.BootOperationHandler;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.txn.TxnServices;
import org.jboss.dmr.ModelNode;
import org.jboss.jca.common.api.metadata.common.CommonPool;
import org.jboss.jca.common.api.metadata.common.CommonXaPool;
import org.jboss.jca.common.api.metadata.ds.DataSource;
import org.jboss.jca.common.api.metadata.ds.DataSources;
import org.jboss.jca.common.api.metadata.ds.DsSecurity;
import org.jboss.jca.common.api.metadata.ds.JdbcAdapterExtension;
import org.jboss.jca.common.api.metadata.ds.Statement;
import org.jboss.jca.common.api.metadata.ds.TimeOut;
import org.jboss.jca.common.api.metadata.ds.TransactionIsolation;
import org.jboss.jca.common.api.metadata.ds.Validation;
import org.jboss.jca.common.api.metadata.ds.XaDataSource;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.jca.common.metadata.common.CommonPoolImpl;
import org.jboss.jca.common.metadata.common.CommonXaPoolImpl;
import org.jboss.jca.common.metadata.ds.DataSourceImpl;
import org.jboss.jca.common.metadata.ds.DatasourcesImpl;
import org.jboss.jca.common.metadata.ds.DsSecurityImpl;
import org.jboss.jca.common.metadata.ds.StatementImpl;
import org.jboss.jca.common.metadata.ds.TimeOutImpl;
import org.jboss.jca.common.metadata.ds.ValidationImpl;
import org.jboss.jca.common.metadata.ds.XADataSourceImpl;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.util.Strings;

class DataSourcesSubsystemAdd
implements ModelAddOperationHandler,
BootOperationHandler {
    static final DataSourcesSubsystemAdd INSTANCE = new DataSourcesSubsystemAdd();
    public static final Logger log = Logger.getLogger((String)"org.jboss.as.connector.subsystems.datasources.DataSourcesSubsystemAdd");

    DataSourcesSubsystemAdd() {
    }

    public OperationResult execute(OperationContext context, final ModelNode operation, final ResultHandler resultHandler) {
        ModelNode subModel = context.getSubModel();
        subModel.setEmptyObject();
        boolean workaround = true;
        if (workaround) {
            if (operation.has("datasources")) {
                ModelNode datasources = operation.get("datasources");
                subModel.get("datasources").set(datasources);
            }
            subModel.get("jdbc-driver");
        } else {
            if (operation.has("datasources")) {
                for (ModelNode dataSourceNode : operation.get("datasources").asList()) {
                    if (dataSourceNode.has("connection-properties")) {
                        for (ModelNode property : dataSourceNode.get("connection-properties").asList()) {
                            subModel.get(new String[]{"connection-properties", property.asProperty().getName()}).set(property.asString());
                        }
                    }
                    for (String attribute : DataSourcesSubsystemProviders.DATASOURCE_ATTRIBUTE) {
                        if (!operation.get(attribute).isDefined()) continue;
                        subModel.get(attribute).set(operation.get(attribute));
                    }
                }
            }
            if (operation.has("xa-datasources")) {
                for (ModelNode dataSourceNode : operation.get("xa-datasources").asList()) {
                    Map connectionProperties;
                    if (dataSourceNode.has("xa-data-source-properties")) {
                        connectionProperties = new HashMap(dataSourceNode.get("xa-data-source-properties").asList().size());
                        for (ModelNode property : dataSourceNode.get("xa-data-source-properties").asList()) {
                            subModel.get(new String[]{"xa-data-source-properties", property.asProperty().getName()}).set(property.asString());
                        }
                    } else {
                        connectionProperties = Collections.emptyMap();
                    }
                    for (String attribute : DataSourcesSubsystemProviders.XA_DATASOURCE_ATTRIBUTE) {
                        if (!operation.get(attribute).isDefined()) continue;
                        subModel.get(attribute).set(operation.get(attribute));
                    }
                }
            }
        }
        if (context instanceof BootOperationContext) {
            final BootOperationContext updateContext = (BootOperationContext)BootOperationContext.class.cast(context);
            context.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                public void execute(RuntimeTaskContext context) throws OperationFailedException {
                    String jndiName;
                    ServiceTarget serviceTarget = context.getServiceTarget();
                    DataSources datasources = null;
                    try {
                        datasources = DataSourcesSubsystemAdd.this.buildDataSourcesObject(operation);
                    }
                    catch (ValidateException e) {
                        throw new OperationFailedException((Throwable)e, operation);
                    }
                    for (DataSource dataSource : datasources.getDataSource()) {
                        if (dataSource.isEnabled() != null && !dataSource.isEnabled().booleanValue()) continue;
                        jndiName = dataSource.getJndiName();
                        if (dataSource.isUseJavaContext() != null && dataSource.isUseJavaContext().booleanValue() && !jndiName.startsWith("java:/")) {
                            jndiName = "java:/" + jndiName;
                        }
                        DataSourcesSubsystemAdd.this.installDataSourceService(serviceTarget, jndiName, dataSource.getModule(), new LocalDataSourceService(jndiName, dataSource));
                    }
                    for (XaDataSource xaDataSource : datasources.getXaDataSource()) {
                        if (xaDataSource.isEnabled() != null && !xaDataSource.isEnabled().booleanValue()) continue;
                        jndiName = xaDataSource.getJndiName();
                        if (xaDataSource.isUseJavaContext() != null && xaDataSource.isUseJavaContext().booleanValue() && !jndiName.startsWith("java:/")) {
                            jndiName = "java:/" + jndiName;
                        }
                        DataSourcesSubsystemAdd.this.installDataSourceService(serviceTarget, jndiName, xaDataSource.getModule(), new XaDataSourceService(jndiName, xaDataSource));
                    }
                    updateContext.addDeploymentProcessor(Phase.PARSE, 7424, (DeploymentUnitProcessor)new DataSourceDefinitionDeployer());
                    resultHandler.handleResultComplete();
                }
            });
        } else {
            resultHandler.handleResultComplete();
        }
        ModelNode compensatingOperation = new ModelNode();
        compensatingOperation.get("operation").set("remove");
        compensatingOperation.get("address").set(operation.require("address"));
        return new BasicOperationResult(compensatingOperation);
    }

    private void installDataSourceService(ServiceTarget serviceTarget, String jndiName, String driver, AbstractDataSourceService dataSourceService) {
        ServiceName dataSourceServiceName = AbstractDataSourceService.SERVICE_NAME_BASE.append(new String[]{jndiName});
        ServiceBuilder serviceBuilder = serviceTarget.addService(dataSourceServiceName, (Service)dataSourceService).addDependency(TxnServices.JBOSS_TXN_ARJUNA_TRANSACTION_MANAGER, TransactionManagerService.class, dataSourceService.getTransactionManagerInjector()).addDependency(NamingService.SERVICE_NAME);
        ServiceName driverServiceName = this.getDriverDependency(driver);
        if (driverServiceName != null) {
            serviceBuilder.addDependency(driverServiceName, Driver.class, dataSourceService.getDriverInjector());
        }
        serviceBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
        serviceBuilder.install();
        BinderService binderService = new BinderService(jndiName.substring(6));
        ServiceName binderServiceName = ContextNames.JAVA_CONTEXT_SERVICE_NAME.append(new String[]{jndiName});
        serviceTarget.addService(binderServiceName, (Service)binderService).addDependency(dataSourceServiceName, ManagedReferenceFactory.class, binderService.getManagedObjectInjector()).addDependency(ContextNames.JAVA_CONTEXT_SERVICE_NAME, NamingStore.class, binderService.getNamingStoreInjector()).setInitialMode(ServiceController.Mode.ACTIVE).install();
    }

    private DataSources buildDataSourcesObject(ModelNode operation) throws ValidateException {
        ArrayList<DataSourceImpl> datasourceList = new ArrayList<DataSourceImpl>();
        ArrayList<XADataSourceImpl> xadatasourceList = new ArrayList<XADataSourceImpl>();
        try {
            if (operation.hasDefined("datasources")) {
                for (ModelNode dataSourceNode : operation.get("datasources").asList()) {
                    HashMap<String, String> connectionProperties;
                    if (dataSourceNode.has("connection-properties")) {
                        connectionProperties = new HashMap<String, String>(dataSourceNode.get("connection-properties").asList().size());
                        for (ModelNode property : dataSourceNode.get("connection-properties").asList()) {
                            connectionProperties.put(property.asProperty().getName(), property.asString());
                        }
                    } else {
                        connectionProperties = Collections.EMPTY_MAP;
                    }
                    String connectionUrl = this.getStringIfSetOrGetDefault(dataSourceNode, "connection-url", null);
                    String driverClass = this.getStringIfSetOrGetDefault(dataSourceNode, "driver-class", null);
                    String jndiName = this.getStringIfSetOrGetDefault(dataSourceNode, "jndi-name", null);
                    String module = this.getStringIfSetOrGetDefault(dataSourceNode, "module", null);
                    String newConnectionSql = this.getStringIfSetOrGetDefault(dataSourceNode, "new-connection-sql", null);
                    String poolName = this.getStringIfSetOrGetDefault(dataSourceNode, "pool-name", null);
                    String urlDelimiter = this.getStringIfSetOrGetDefault(dataSourceNode, "url-delimiter", null);
                    String urlSelectorStrategyClassName = this.getStringIfSetOrGetDefault(dataSourceNode, "url-selector-strategy-class-name", null);
                    boolean useJavaContext = this.getBooleanIfSetOrGetDefault(dataSourceNode, "use-java-context", false);
                    boolean enabled = this.getBooleanIfSetOrGetDefault(dataSourceNode, "enabled", false);
                    Integer maxPoolSize = this.getIntIfSetOrGetDefault(dataSourceNode, "max-pool-size", null);
                    Integer minPoolSize = this.getIntIfSetOrGetDefault(dataSourceNode, "min-pool-size", null);
                    boolean prefill = this.getBooleanIfSetOrGetDefault(dataSourceNode, "pool-prefill", false);
                    boolean useStrictMin = this.getBooleanIfSetOrGetDefault(dataSourceNode, "pool-use-strict-min", false);
                    CommonPoolImpl pool = new CommonPoolImpl(minPoolSize, maxPoolSize, Boolean.valueOf(prefill), Boolean.valueOf(useStrictMin));
                    String username = this.getStringIfSetOrGetDefault(dataSourceNode, "user-name", null);
                    String password = this.getStringIfSetOrGetDefault(dataSourceNode, "password", null);
                    String securityDomain = this.getStringIfSetOrGetDefault(dataSourceNode, "security-domain", null);
                    DsSecurityImpl security = new DsSecurityImpl(username, password, securityDomain);
                    boolean sharePreparedStatements = this.getBooleanIfSetOrGetDefault(dataSourceNode, "use-java-context", false);
                    Long preparedStatementsCacheSize = this.getLongIfSetOrGetDefault(dataSourceNode, "prepared-statements-cacheSize", null);
                    Statement.TrackStatementsEnum trackStatements = dataSourceNode.hasDefined("track-statements") ? Statement.TrackStatementsEnum.valueOf((String)dataSourceNode.get("track-statements").asString()) : Statement.TrackStatementsEnum.NOWARN;
                    StatementImpl statement = new StatementImpl(Boolean.valueOf(sharePreparedStatements), preparedStatementsCacheSize, trackStatements);
                    Integer allocationRetry = this.getIntIfSetOrGetDefault(dataSourceNode, "allocation-retry", null);
                    Long allocationRetryWaitMillis = this.getLongIfSetOrGetDefault(dataSourceNode, "allocation-retry-wait-millis", null);
                    Long blockingTimeoutMillis = this.getLongIfSetOrGetDefault(dataSourceNode, "blocking-timeout-wait-millis", null);
                    Long idleTimeoutMinutes = this.getLongIfSetOrGetDefault(dataSourceNode, "idle-timeout-minutes", null);
                    Long queryTimeout = this.getLongIfSetOrGetDefault(dataSourceNode, "query-timeout", null);
                    Integer xaResourceTimeout = this.getIntIfSetOrGetDefault(dataSourceNode, "xa-resource-timeout", null);
                    Long useTryLock = this.getLongIfSetOrGetDefault(dataSourceNode, "use-try-lock", null);
                    boolean setTxQuertTimeout = this.getBooleanIfSetOrGetDefault(dataSourceNode, "set-tx-query-timeout", false);
                    TimeOutImpl timeOut = new TimeOutImpl(blockingTimeoutMillis, idleTimeoutMinutes, allocationRetry, allocationRetryWaitMillis, xaResourceTimeout, Boolean.valueOf(setTxQuertTimeout), queryTimeout, useTryLock);
                    TransactionIsolation transactionIsolation = dataSourceNode.has("transaction-isolation") ? TransactionIsolation.valueOf((String)dataSourceNode.get("transaction-isolation").asString()) : null;
                    String checkValidConnectionSql = this.getStringIfSetOrGetDefault(dataSourceNode, "check-valid-connection-sql", null);
                    JdbcAdapterExtension exceptionSorter = this.extractJdbcAdapterExtension(dataSourceNode, "exception-sorter-class-name", "exceptionsorter-properties");
                    JdbcAdapterExtension staleConnectionChecker = this.extractJdbcAdapterExtension(dataSourceNode, "stale-connection-checker-class-name", "staleconnectionchecker-properties");
                    JdbcAdapterExtension validConnectionChecker = this.extractJdbcAdapterExtension(dataSourceNode, "valid-connection-checker-class-name", "validconnectionchecker-properties");
                    Long backgroundValidationMinutes = this.getLongIfSetOrGetDefault(dataSourceNode, "background-validation-minutes", null);
                    boolean backgroundValidation = this.getBooleanIfSetOrGetDefault(dataSourceNode, "background-validation", false);
                    boolean useFastFail = this.getBooleanIfSetOrGetDefault(dataSourceNode, "use-fast-fail", false);
                    boolean validateOnMatch = this.getBooleanIfSetOrGetDefault(dataSourceNode, "validate-on-match", false);
                    boolean spy = this.getBooleanIfSetOrGetDefault(dataSourceNode, "spy", false);
                    ValidationImpl validation = new ValidationImpl(Boolean.valueOf(backgroundValidation), backgroundValidationMinutes, Boolean.valueOf(useFastFail), validConnectionChecker, checkValidConnectionSql, Boolean.valueOf(validateOnMatch), staleConnectionChecker, exceptionSorter);
                    DataSourceImpl ds = new DataSourceImpl(connectionUrl, driverClass, module, transactionIsolation, connectionProperties, (TimeOut)timeOut, (DsSecurity)security, (Statement)statement, (Validation)validation, urlDelimiter, urlSelectorStrategyClassName, newConnectionSql, useJavaContext, poolName, enabled, jndiName, spy, (CommonPool)pool);
                    datasourceList.add(ds);
                }
            }
            if (operation.hasDefined("xa-datasources")) {
                for (ModelNode dataSourceNode : operation.get("xa-datasources").asList()) {
                    HashMap<String, String> xaDataSourceProperty = new HashMap<String, String>(dataSourceNode.get("xa-data-source-properties").asList().size());
                    for (ModelNode property : dataSourceNode.get("xa-data-source-properties").asList()) {
                        xaDataSourceProperty.put(property.asProperty().getName(), property.asString());
                    }
                    String xaDataSourceClass = this.getStringIfSetOrGetDefault(dataSourceNode, "xa-data-source-class", null);
                    String jndiName = this.getStringIfSetOrGetDefault(dataSourceNode, "jndi-name", null);
                    String module = this.getStringIfSetOrGetDefault(dataSourceNode, "module", null);
                    String newConnectionSql = this.getStringIfSetOrGetDefault(dataSourceNode, "new-connection-sql", null);
                    String poolName = this.getStringIfSetOrGetDefault(dataSourceNode, "pool-name", null);
                    String urlDelimiter = this.getStringIfSetOrGetDefault(dataSourceNode, "url-delimiter", null);
                    String urlSelectorStrategyClassName = this.getStringIfSetOrGetDefault(dataSourceNode, "url-selector-strategy-class-name", null);
                    boolean useJavaContext = this.getBooleanIfSetOrGetDefault(dataSourceNode, "use-java-context", false);
                    boolean enabled = this.getBooleanIfSetOrGetDefault(dataSourceNode, "enabled", false);
                    Integer maxPoolSize = this.getIntIfSetOrGetDefault(dataSourceNode, "max-pool-size", null);
                    Integer minPoolSize = this.getIntIfSetOrGetDefault(dataSourceNode, "min-pool-size", null);
                    boolean prefill = this.getBooleanIfSetOrGetDefault(dataSourceNode, "pool-prefill", false);
                    boolean useStrictMin = this.getBooleanIfSetOrGetDefault(dataSourceNode, "pool-use-strict-min", false);
                    boolean interleaving = this.getBooleanIfSetOrGetDefault(dataSourceNode, "interliving", false);
                    boolean noTxSeparatePool = this.getBooleanIfSetOrGetDefault(dataSourceNode, "no-tx-separate-pool", false);
                    boolean padXid = this.getBooleanIfSetOrGetDefault(dataSourceNode, "pad-xid", false);
                    boolean isSameRmOverride = this.getBooleanIfSetOrGetDefault(dataSourceNode, "same-rm-override", false);
                    boolean wrapXaDataSource = this.getBooleanIfSetOrGetDefault(dataSourceNode, "wrap-xa-datasource", false);
                    CommonXaPoolImpl xaPool = new CommonXaPoolImpl(minPoolSize, maxPoolSize, Boolean.valueOf(prefill), Boolean.valueOf(useStrictMin), Boolean.valueOf(isSameRmOverride), Boolean.valueOf(interleaving), Boolean.valueOf(padXid), Boolean.valueOf(wrapXaDataSource), Boolean.valueOf(noTxSeparatePool));
                    String username = this.getStringIfSetOrGetDefault(dataSourceNode, "user-name", null);
                    String password = this.getStringIfSetOrGetDefault(dataSourceNode, "password", null);
                    String securityDomain = this.getStringIfSetOrGetDefault(dataSourceNode, "security-domain", null);
                    DsSecurityImpl security = new DsSecurityImpl(username, password, securityDomain);
                    boolean sharePreparedStatements = dataSourceNode.has("share-prepared-statements") ? dataSourceNode.get("share-prepared-statements").asBoolean() : false;
                    Long preparedStatementsCacheSize = dataSourceNode.get("prepared-statements-cacheSize").asLong();
                    Statement.TrackStatementsEnum trackStatements = Statement.TrackStatementsEnum.valueOf((String)dataSourceNode.get("track-statements").asString());
                    StatementImpl statement = new StatementImpl(Boolean.valueOf(sharePreparedStatements), preparedStatementsCacheSize, trackStatements);
                    Integer allocationRetry = this.getIntIfSetOrGetDefault(dataSourceNode, "allocation-retry", null);
                    Long allocationRetryWaitMillis = this.getLongIfSetOrGetDefault(dataSourceNode, "allocation-retry-wait-millis", null);
                    Long blockingTimeoutMillis = this.getLongIfSetOrGetDefault(dataSourceNode, "blocking-timeout-wait-millis", null);
                    Long idleTimeoutMinutes = this.getLongIfSetOrGetDefault(dataSourceNode, "idle-timeout-minutes", null);
                    Long queryTimeout = this.getLongIfSetOrGetDefault(dataSourceNode, "query-timeout", null);
                    Integer xaResourceTimeout = this.getIntIfSetOrGetDefault(dataSourceNode, "xa-resource-timeout", null);
                    Long useTryLock = this.getLongIfSetOrGetDefault(dataSourceNode, "use-try-lock", null);
                    boolean setTxQuertTimeout = this.getBooleanIfSetOrGetDefault(dataSourceNode, "set-tx-query-timeout", false);
                    TimeOutImpl timeOut = new TimeOutImpl(blockingTimeoutMillis, idleTimeoutMinutes, allocationRetry, allocationRetryWaitMillis, xaResourceTimeout, Boolean.valueOf(setTxQuertTimeout), queryTimeout, useTryLock);
                    TransactionIsolation transactionIsolation = dataSourceNode.has("transaction-isolation") ? TransactionIsolation.valueOf((String)dataSourceNode.get("transaction-isolation").asString()) : null;
                    String checkValidConnectionSql = this.getStringIfSetOrGetDefault(dataSourceNode, "check-valid-connection-sql", null);
                    JdbcAdapterExtension exceptionSorter = this.extractJdbcAdapterExtension(dataSourceNode, "exception-sorter-class-name", "exceptionsorter-properties");
                    JdbcAdapterExtension staleConnectionChecker = this.extractJdbcAdapterExtension(dataSourceNode, "stale-connection-checker-class-name", "staleconnectionchecker-properties");
                    JdbcAdapterExtension validConnectionChecker = this.extractJdbcAdapterExtension(dataSourceNode, "valid-connection-checker-class-name", "validconnectionchecker-properties");
                    Long backgroundValidationMinutes = this.getLongIfSetOrGetDefault(dataSourceNode, "background-validation-minutes", null);
                    boolean backgroundValidation = this.getBooleanIfSetOrGetDefault(dataSourceNode, "background-validation", false);
                    boolean useFastFail = this.getBooleanIfSetOrGetDefault(dataSourceNode, "use-fast-fail", false);
                    boolean validateOnMatch = this.getBooleanIfSetOrGetDefault(dataSourceNode, "validate-on-match", false);
                    boolean spy = this.getBooleanIfSetOrGetDefault(dataSourceNode, "spy", false);
                    ValidationImpl validation = new ValidationImpl(Boolean.valueOf(backgroundValidation), backgroundValidationMinutes, Boolean.valueOf(useFastFail), validConnectionChecker, checkValidConnectionSql, Boolean.valueOf(validateOnMatch), staleConnectionChecker, exceptionSorter);
                    XADataSourceImpl ds = new XADataSourceImpl(transactionIsolation, (TimeOut)timeOut, (DsSecurity)security, (Statement)statement, (Validation)validation, urlDelimiter, urlSelectorStrategyClassName, useJavaContext, poolName, enabled, jndiName, spy, xaDataSourceProperty, xaDataSourceClass, module, newConnectionSql, (CommonXaPool)xaPool);
                    xadatasourceList.add(ds);
                }
            }
            return new DatasourcesImpl(datasourceList, xadatasourceList);
        }
        catch (ValidateException e) {
            e.printStackTrace();
            throw e;
        }
    }

    private JdbcAdapterExtension extractJdbcAdapterExtension(ModelNode dataSourceNode, String className, String propertyName) throws ValidateException {
        if (dataSourceNode.hasDefined(className)) {
            String exceptionSorterClassName = dataSourceNode.get(className).asString();
            this.getStringIfSetOrGetDefault(dataSourceNode, className, null);
            HashMap<String, String> exceptionSorterProperty = null;
            if (dataSourceNode.hasDefined(propertyName)) {
                exceptionSorterProperty = new HashMap<String, String>(dataSourceNode.get(propertyName).asList().size());
                for (ModelNode property : dataSourceNode.get(propertyName).asList()) {
                    exceptionSorterProperty.put(property.asProperty().getName(), property.asString());
                }
            }
            JdbcAdapterExtension exceptionSorter = new JdbcAdapterExtension(exceptionSorterClassName, exceptionSorterProperty);
            return exceptionSorter;
        }
        return null;
    }

    private ServiceName getDriverDependency(String driver) {
        String driverName = null;
        Integer majorVersion = null;
        Integer minorVersion = null;
        String[] strings = Strings.split((String)driver, (String)"#");
        if (strings.length != 2) {
            throw new IllegalArgumentException("module should define jdbc driver with this format: <driver-name>#<major-version>.<minor-version>");
        }
        driverName = strings[0];
        if ((strings = Strings.split((String)strings[1], (String)".", (int)2)).length != 2) {
            throw new IllegalArgumentException("module should define jdbc driver with this format: <driver-name>#<major-version>.<minor-version>");
        }
        try {
            majorVersion = Integer.valueOf(strings[0]);
            minorVersion = Integer.valueOf(strings[1]);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("module should define jdbc driver with this format: <driver-name>#<major-version>.<minor-version> version number should be valid Integer");
        }
        if (driverName != null & majorVersion != null && minorVersion != null) {
            return ServiceName.JBOSS.append(new String[]{"jdbc-driver", driverName, Integer.toString(majorVersion), Integer.toString(minorVersion)});
        }
        return null;
    }

    private Long getLongIfSetOrGetDefault(ModelNode dataSourceNode, String key, Long defaultValue) {
        if (dataSourceNode.hasDefined(key)) {
            return dataSourceNode.get(key).asLong();
        }
        return defaultValue;
    }

    private Integer getIntIfSetOrGetDefault(ModelNode dataSourceNode, String key, Integer defaultValue) {
        if (dataSourceNode.hasDefined(key)) {
            return dataSourceNode.get(key).asInt();
        }
        return defaultValue;
    }

    private boolean getBooleanIfSetOrGetDefault(ModelNode dataSourceNode, String key, boolean defaultValue) {
        if (dataSourceNode.hasDefined(key)) {
            return dataSourceNode.get(key).asBoolean();
        }
        return defaultValue;
    }

    private String getStringIfSetOrGetDefault(ModelNode dataSourceNode, String key, String defaultValue) {
        if (dataSourceNode.hasDefined(key)) {
            return dataSourceNode.get(key).asString();
        }
        return defaultValue;
    }
}

