/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.resourceadapters;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.connector.subsystems.resourceadapters.Element;
import org.jboss.as.connector.subsystems.resourceadapters.Namespace;
import org.jboss.as.connector.subsystems.resourceadapters.ResourceAdaptersSubsystemAdd;
import org.jboss.as.connector.subsystems.resourceadapters.ResourceAdaptersSubsystemProviders;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ModelQueryOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationHandler;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.CommonDescriptions;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.controller.registry.ModelNodeRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.jboss.jca.common.api.metadata.common.CommonAdminObject;
import org.jboss.jca.common.api.metadata.common.CommonConnDef;
import org.jboss.jca.common.api.metadata.common.CommonPool;
import org.jboss.jca.common.api.metadata.common.CommonSecurity;
import org.jboss.jca.common.api.metadata.common.CommonTimeOut;
import org.jboss.jca.common.api.metadata.common.CommonValidation;
import org.jboss.jca.common.api.metadata.common.CommonXaPool;
import org.jboss.jca.common.api.metadata.resourceadapter.ResourceAdapter;
import org.jboss.jca.common.api.metadata.resourceadapter.ResourceAdapters;
import org.jboss.jca.common.metadata.resourceadapter.ResourceAdapterParser;
import org.jboss.logging.Logger;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class ResourceAdaptersExtension
implements Extension {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.datasources");

    public void initialize(ExtensionContext context) {
        log.debugf("Initializing ResourceAdapters Extension", new Object[0]);
        SubsystemRegistration registration = context.registerSubsystem("resource-adapter");
        registration.registerXMLElementWriter((XMLElementWriter)ResourceAdapterSubsystemParser.INSTANCE);
        ModelNodeRegistration subsystem = registration.registerSubsystemModel(ResourceAdaptersSubsystemProviders.SUBSYSTEM);
        subsystem.registerOperationHandler("add", (OperationHandler)ResourceAdaptersSubsystemAdd.INSTANCE, ResourceAdaptersSubsystemProviders.SUBSYSTEM_ADD_DESC, false);
        subsystem.registerOperationHandler("describe", (OperationHandler)ResourceAdaptersSubsystemDescribeHandler.INSTANCE, (DescriptionProvider)ResourceAdaptersSubsystemDescribeHandler.INSTANCE, false, OperationEntry.EntryType.PRIVATE);
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(Namespace.CURRENT.getUriString(), (XMLElementReader)ResourceAdapterSubsystemParser.INSTANCE);
    }

    private static ModelNode createAddSubsystemOperation() {
        ModelNode address = new ModelNode();
        address.add("subsystem", "resource-adapter");
        address.protect();
        ModelNode subsystem = new ModelNode();
        subsystem.get("operation").set("add");
        subsystem.get("address").set(address);
        return subsystem;
    }

    private static class ResourceAdaptersSubsystemDescribeHandler
    implements ModelQueryOperationHandler,
    DescriptionProvider {
        static final ResourceAdaptersSubsystemDescribeHandler INSTANCE = new ResourceAdaptersSubsystemDescribeHandler();

        private ResourceAdaptersSubsystemDescribeHandler() {
        }

        public OperationResult execute(OperationContext context, ModelNode operation, ResultHandler resultHandler) {
            ModelNode add = ResourceAdaptersExtension.createAddSubsystemOperation();
            ModelNode model = context.getSubModel();
            boolean workaround = true;
            if (workaround && model.hasDefined("resource-adapters")) {
                ModelNode datasources = model.get("resource-adapters");
                add.get("resource-adapters").set(datasources);
            }
            ModelNode result = new ModelNode();
            result.add(add);
            resultHandler.handleResultFragment(Util.NO_LOCATION, result);
            resultHandler.handleResultComplete();
            return new BasicOperationResult();
        }

        public ModelNode getModelDescription(Locale locale) {
            return CommonDescriptions.getSubsystemDescribeOperation((Locale)locale);
        }
    }

    static final class ResourceAdapterSubsystemParser
    implements XMLStreamConstants,
    XMLElementReader<List<ModelNode>>,
    XMLElementWriter<SubsystemMarshallingContext> {
        static final ResourceAdapterSubsystemParser INSTANCE = new ResourceAdapterSubsystemParser();

        ResourceAdapterSubsystemParser() {
        }

        public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
            ModelNode node = context.getModelNode();
            boolean hasChildren = node.hasDefined("resource-adapter") && node.get("resource-adapter").asInt() > 0;
            context.startSubsystemElement(Namespace.CURRENT.getUriString(), !hasChildren);
            if (hasChildren) {
                writer.writeStartElement(Element.RESOURCE_ADAPTERS.getLocalName());
                for (ModelNode ra : node.get("resource-adapter").asList()) {
                    this.writeRaElement(writer, ra);
                }
                writer.writeEndElement();
                writer.writeEndElement();
            }
        }

        private void writeRaElement(XMLExtendedStreamWriter streamWriter, ModelNode ra) throws XMLStreamException {
            streamWriter.writeStartElement(ResourceAdapters.Tag.RESOURCE_ADPTER.getLocalName());
            this.writeElementIfHas(streamWriter, ra, ResourceAdapter.Tag.ARCHIVE, "archive");
            if (ra.has("beanvalidationgroups")) {
                for (ModelNode bvg : ra.get("beanvalidationgroups").asList()) {
                    this.writeElementIfHas(streamWriter, bvg, ResourceAdapter.Tag.BEAN_VALIDATION_GROUP, "beanvalidationgroups");
                }
            }
            this.writeElementIfHas(streamWriter, ra, ResourceAdapter.Tag.BOOTSTRAP_CONTEXT, "bootstrapcontext");
            this.writeElementIfHas(streamWriter, ra, ResourceAdapter.Tag.TRANSACTION_SUPPORT, "transaction-support");
            this.writeConfigProperties(streamWriter, ra);
            if (ra.has("connection-definitions")) {
                streamWriter.writeStartElement(ResourceAdapter.Tag.CONNECTION_DEFINITIONS.getLocalName());
                for (ModelNode conDef : ra.get("connection-definitions").asList()) {
                    this.writeConDef(streamWriter, conDef);
                }
                streamWriter.writeEndElement();
            }
            if (ra.has("admin-objects")) {
                streamWriter.writeStartElement(ResourceAdapter.Tag.ADMIN_OBJECTS.getLocalName());
                for (ModelNode adminObject : ra.get("admin-objects").asList()) {
                    this.writeAdminObject(streamWriter, adminObject);
                }
                streamWriter.writeEndElement();
            }
            streamWriter.writeEndElement();
        }

        private void writeConfigProperties(XMLExtendedStreamWriter streamWriter, ModelNode ra) throws XMLStreamException {
            if (ra.has("config-properties")) {
                for (ModelNode property : ra.get("config-properties").asList()) {
                    streamWriter.writeStartElement(ResourceAdapter.Tag.CONFIG_PROPERTY.getLocalName());
                    streamWriter.writeCharacters(property.asString());
                    streamWriter.writeEndElement();
                }
            }
        }

        private void writeAdminObject(XMLExtendedStreamWriter streamWriter, ModelNode adminObject) throws XMLStreamException {
            streamWriter.writeStartElement(ResourceAdapter.Tag.ADMIN_OBJECT.getLocalName());
            this.writeAttributeIfHas(streamWriter, adminObject, CommonAdminObject.Attribute.CLASS_NAME, "class-name");
            this.writeAttributeIfHas(streamWriter, adminObject, CommonAdminObject.Attribute.JNDINAME, "jndi-name");
            this.writeAttributeIfHas(streamWriter, adminObject, CommonAdminObject.Attribute.ENABLED, "enabled");
            this.writeAttributeIfHas(streamWriter, adminObject, CommonAdminObject.Attribute.USEJAVACONTEXT, "use-java-context");
            this.writeAttributeIfHas(streamWriter, adminObject, CommonAdminObject.Attribute.POOL_NAME, "pool-name");
            this.writeConfigProperties(streamWriter, adminObject);
            streamWriter.writeEndElement();
        }

        private void writeConDef(XMLExtendedStreamWriter streamWriter, ModelNode conDef) throws XMLStreamException {
            streamWriter.writeStartElement(ResourceAdapter.Tag.CONNECTION_DEFINITION.getLocalName());
            this.writeAttributeIfHas(streamWriter, conDef, CommonConnDef.Attribute.CLASS_NAME, "class-name");
            this.writeAttributeIfHas(streamWriter, conDef, CommonConnDef.Attribute.JNDINAME, "jndi-name");
            this.writeAttributeIfHas(streamWriter, conDef, CommonConnDef.Attribute.ENABLED, "enabled");
            this.writeAttributeIfHas(streamWriter, conDef, CommonConnDef.Attribute.USEJAVACONTEXT, "use-java-context");
            this.writeAttributeIfHas(streamWriter, conDef, CommonConnDef.Attribute.POOL_NAME, "pool-name");
            this.writeConfigProperties(streamWriter, conDef);
            if (conDef.has("max-pool-size") || conDef.has("min-pool-size") || conDef.has("pool-use-strict-min") || conDef.has("pool-prefill")) {
                if (conDef.has("interliving") || conDef.has("wrap-xa-datasource") || conDef.has("no-tx-separate-pool") || conDef.has("pad-xid") || conDef.has("same-rm-override")) {
                    streamWriter.writeStartElement(CommonConnDef.Tag.XA_POOL.getLocalName());
                    this.writeElementIfHas(streamWriter, conDef, CommonPool.Tag.MIN_POOL_SIZE, "min-pool-size");
                    this.writeElementIfHas(streamWriter, conDef, CommonPool.Tag.MAXPOOLSIZE, "max-pool-size");
                    this.writeElementIfHas(streamWriter, conDef, CommonPool.Tag.PREFILL, "pool-prefill");
                    this.writeElementIfHas(streamWriter, conDef, CommonPool.Tag.USE_STRICT_MIN, "pool-use-strict-min");
                    this.writeElementIfHas(streamWriter, conDef, CommonXaPool.Tag.ISSAMERMOVERRIDEVALUE, "same-rm-override");
                    this.writeElementIfHas(streamWriter, conDef, CommonXaPool.Tag.INTERLEAVING, "interliving");
                    this.writeElementIfHas(streamWriter, conDef, CommonXaPool.Tag.NO_TX_SEPARATE_POOLS, "no-tx-separate-pool");
                    this.writeElementIfHas(streamWriter, conDef, CommonXaPool.Tag.PAD_XID, "pad-xid");
                    this.writeElementIfHas(streamWriter, conDef, CommonXaPool.Tag.WRAP_XA_RESOURCE, "wrap-xa-datasource");
                    streamWriter.writeEndElement();
                } else {
                    streamWriter.writeStartElement(CommonConnDef.Tag.POOL.getLocalName());
                    this.writeElementIfHas(streamWriter, conDef, CommonPool.Tag.MIN_POOL_SIZE, "min-pool-size");
                    this.writeElementIfHas(streamWriter, conDef, CommonPool.Tag.MAXPOOLSIZE, "max-pool-size");
                    this.writeElementIfHas(streamWriter, conDef, CommonPool.Tag.PREFILL, "pool-prefill");
                    this.writeElementIfHas(streamWriter, conDef, CommonPool.Tag.USE_STRICT_MIN, "pool-use-strict-min");
                    streamWriter.writeEndElement();
                }
            }
            if (conDef.hasDefined("security-application") || conDef.hasDefined("security-domain") || conDef.hasDefined("security-domain-and-application")) {
                streamWriter.writeStartElement(CommonConnDef.Tag.SECURITY.getLocalName());
                this.writeElementIfHas(streamWriter, conDef, CommonSecurity.Tag.APPLICATION, "security-application");
                this.writeElementIfHas(streamWriter, conDef, CommonSecurity.Tag.SECURITY_DOMAIN, "security-domain");
                this.writeElementIfHas(streamWriter, conDef, CommonSecurity.Tag.SECURITY_DOMAIN_AND_APPLICATION, "security-domain-and-application");
                streamWriter.writeEndElement();
            }
            if (conDef.has("blocking-timeout-wait-millis") || conDef.has("idle-timeout-minutes") || conDef.has("allocation-retry") || conDef.has("allocation-retry-wait-millis") || conDef.has("xa-resource-timeout")) {
                streamWriter.writeStartElement(CommonConnDef.Tag.TIMEOUT.getLocalName());
                this.writeElementIfHas(streamWriter, conDef, CommonTimeOut.Tag.BLOCKINGTIMEOUTMILLIS, "blocking-timeout-wait-millis");
                this.writeElementIfHas(streamWriter, conDef, CommonTimeOut.Tag.IDLETIMEOUTMINUTES, "idle-timeout-minutes");
                this.writeElementIfHas(streamWriter, conDef, CommonTimeOut.Tag.ALLOCATIONRETRY, "allocation-retry");
                this.writeElementIfHas(streamWriter, conDef, CommonTimeOut.Tag.ALLOCATIONRETRYWAITMILLIS, "allocation-retry-wait-millis");
                this.writeElementIfHas(streamWriter, conDef, CommonTimeOut.Tag.XARESOURCETIMEOUT, "xa-resource-timeout");
                streamWriter.writeEndElement();
            }
            if (conDef.has("background-validation") || conDef.has("background-validation-minutes") || conDef.has("use-fast-fail")) {
                streamWriter.writeStartElement(CommonConnDef.Tag.VALIDATION.getLocalName());
                this.writeElementIfHas(streamWriter, conDef, CommonValidation.Tag.BACKGROUNDVALIDATION, "background-validation");
                this.writeElementIfHas(streamWriter, conDef, CommonValidation.Tag.BACKGROUNDVALIDATIONMINUTES, "background-validation-minutes");
                this.writeElementIfHas(streamWriter, conDef, CommonValidation.Tag.USEFASTFAIL, "use-fast-fail");
                streamWriter.writeEndElement();
            }
            streamWriter.writeEndElement();
        }

        private void writeElementIfHas(XMLExtendedStreamWriter writer, ModelNode node, String localName, String identifier) throws XMLStreamException {
            if (this.has(node, identifier)) {
                writer.writeStartElement(localName);
                writer.writeCharacters(node.get(identifier).asString());
                writer.writeEndElement();
            }
        }

        private void writeElementIfHas(XMLExtendedStreamWriter writer, ModelNode node, ResourceAdapter.Tag element, String identifier) throws XMLStreamException {
            this.writeElementIfHas(writer, node, element.getLocalName(), identifier);
        }

        private void writeElementIfHas(XMLExtendedStreamWriter writer, ModelNode node, CommonPool.Tag element, String identifier) throws XMLStreamException {
            this.writeElementIfHas(writer, node, element.getLocalName(), identifier);
        }

        private void writeElementIfHas(XMLExtendedStreamWriter writer, ModelNode node, CommonXaPool.Tag element, String identifier) throws XMLStreamException {
            this.writeElementIfHas(writer, node, element.getLocalName(), identifier);
        }

        private void writeElementIfHas(XMLExtendedStreamWriter writer, ModelNode node, CommonSecurity.Tag element, String identifier) throws XMLStreamException {
            this.writeElementIfHas(writer, node, element.getLocalName(), identifier);
        }

        private void writeElementIfHas(XMLExtendedStreamWriter writer, ModelNode node, CommonTimeOut.Tag element, String identifier) throws XMLStreamException {
            this.writeElementIfHas(writer, node, element.getLocalName(), identifier);
        }

        private void writeElementIfHas(XMLExtendedStreamWriter writer, ModelNode node, CommonValidation.Tag element, String identifier) throws XMLStreamException {
            this.writeElementIfHas(writer, node, element.getLocalName(), identifier);
        }

        private boolean has(ModelNode node, String name) {
            return node.has(name) && node.get(name).isDefined();
        }

        private void writeAttributeIfHas(XMLExtendedStreamWriter writer, ModelNode node, CommonAdminObject.Attribute attr, String identifier) throws XMLStreamException {
            if (this.has(node, identifier)) {
                writer.writeAttribute(attr.getLocalName(), node.get(identifier).asString());
            }
        }

        private void writeAttributeIfHas(XMLExtendedStreamWriter writer, ModelNode node, CommonConnDef.Attribute attr, String identifier) throws XMLStreamException {
            if (this.has(node, identifier)) {
                writer.writeAttribute(attr.getLocalName(), node.get(identifier).asString());
            }
        }

        public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
            ModelNode subsystem = ResourceAdaptersExtension.createAddSubsystemOperation();
            list.add(subsystem);
            ResourceAdapters ras = null;
            try {
                String localName = null;
                block1 : switch (Namespace.forUri(reader.getNamespaceURI())) {
                    case RESOURCEADAPTERS_1_0: {
                        localName = reader.getLocalName();
                        Element element = Element.forName(reader.getLocalName());
                        log.tracef("%s -> %s", (Object)localName, (Object)element);
                        switch (element) {
                            case SUBSYSTEM: {
                                ResourceAdapterParser parser = new ResourceAdapterParser();
                                ras = parser.parse((XMLStreamReader)reader);
                                break block1;
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new XMLStreamException(e);
            }
            if (ras != null) {
                ModelNode rasNode = subsystem.get("resource-adapters");
                for (ResourceAdapter ra : ras.getResourceAdapters()) {
                    ModelNode raModel = new ModelNode();
                    for (Map.Entry entry : ra.getConfigProperties().entrySet()) {
                        raModel.get(new String[]{"config-properties", (String)entry.getKey()}).set((String)entry.getValue());
                    }
                    raModel.get("archive").set(ra.getArchive());
                    raModel.get("transaction-support").set(ra.getTransactionSupport().name());
                    raModel.get("bootstrapcontext").set(ra.getBootstrapContext());
                    for (String beanValidationGroup : ra.getBeanValidationGroups()) {
                        raModel.get("beanvalidationgroups").add(beanValidationGroup);
                    }
                    for (CommonConnDef conDef : ra.getConnectionDefinitions()) {
                        raModel.get("connection-definitions").add(this.createConnectionDefinitionModel(conDef));
                    }
                    for (CommonAdminObject adminObject : ra.getAdminObjects()) {
                        raModel.get("admin-objects").add(this.createAdminObjectModel(adminObject));
                    }
                    rasNode.add(raModel);
                }
            }
        }

        private ModelNode createAdminObjectModel(CommonAdminObject adminObject) {
            ModelNode adminObjectModel = new ModelNode();
            for (Map.Entry entry : adminObject.getConfigProperties().entrySet()) {
                adminObjectModel.get(new String[]{"config-properties", (String)entry.getKey()}).set((String)entry.getValue());
            }
            adminObjectModel.get("class-name").set(adminObject.getClassName());
            adminObjectModel.get("jndi-name").set(adminObject.getJndiName());
            adminObjectModel.get("pool-name").set(adminObject.getPoolName());
            adminObjectModel.get("enabled").set(adminObject.isEnabled().booleanValue());
            adminObjectModel.get("use-java-context").set(adminObject.isUseJavaContext().booleanValue());
            return adminObjectModel;
        }

        private ModelNode createConnectionDefinitionModel(CommonConnDef conDef) {
            ModelNode condefModel = new ModelNode();
            for (Map.Entry entry : conDef.getConfigProperties().entrySet()) {
                condefModel.get(new String[]{"config-properties", (String)entry.getKey()}).set((String)entry.getValue());
            }
            condefModel.get("class-name").set(conDef.getClassName());
            condefModel.get("jndi-name").set(conDef.getJndiName());
            condefModel.get("pool-name").set(conDef.getPoolName());
            condefModel.get("enabled").set(conDef.isEnabled().booleanValue());
            condefModel.get("use-java-context").set(conDef.isUseJavaContext().booleanValue());
            if (conDef.getPool() != null) {
                condefModel.get("max-pool-size").set(conDef.getPool().getMaxPoolSize().intValue());
                condefModel.get("min-pool-size").set(conDef.getPool().getMinPoolSize().intValue());
                condefModel.get("pool-prefill").set(conDef.getPool().isPrefill().booleanValue());
                condefModel.get("pool-use-strict-min").set(conDef.getPool().isUseStrictMin().booleanValue());
                if (conDef.isXa().booleanValue()) {
                    CommonXaPool xaPool = (CommonXaPool)conDef.getPool();
                    condefModel.get("interliving").set(xaPool.isInterleaving().booleanValue());
                    condefModel.get("pad-xid").set(xaPool.isPadXid().booleanValue());
                    condefModel.get("same-rm-override").set(xaPool.isSameRmOverride().booleanValue());
                    condefModel.get("no-tx-separate-pool").set(xaPool.isNoTxSeparatePool().booleanValue());
                    condefModel.get("wrap-xa-datasource").set(xaPool.isWrapXaDataSource().booleanValue());
                }
            }
            if (conDef.getTimeOut() != null) {
                condefModel.get("allocation-retry").set(conDef.getTimeOut().getAllocationRetry().intValue());
                condefModel.get("allocation-retry-wait-millis").set(conDef.getTimeOut().getAllocationRetryWaitMillis().longValue());
                condefModel.get("blocking-timeout-wait-millis").set(conDef.getTimeOut().getBlockingTimeoutMillis().longValue());
                condefModel.get("idle-timeout-minutes").set(conDef.getTimeOut().getIdleTimeoutMinutes().longValue());
                condefModel.get("xa-resource-timeout").set(conDef.getTimeOut().getXaResourceTimeout().intValue());
            }
            if (conDef.getSecurity() != null) {
                condefModel.get("security-application").set(conDef.getSecurity().isApplication());
                condefModel.get("security-domain").set(conDef.getSecurity().getSecurityDomain());
                condefModel.get("security-domain-and-application").set(conDef.getSecurity().getSecurityDomainAndApplication());
            }
            if (conDef.getValidation() != null) {
                condefModel.get("background-validation-minutes").set(conDef.getValidation().getBackgroundValidationMinutes().longValue());
                condefModel.get("background-validation").set(conDef.getValidation().isBackgroundValidation().booleanValue());
                condefModel.get("use-fast-fail").set(conDef.getValidation().isUseFastFail().booleanValue());
            }
            return condefModel;
        }
    }
}

