/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.connector;

import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.connector.subsystems.connector.Attribute;
import org.jboss.as.connector.subsystems.connector.ConnectorSubSystemRemove;
import org.jboss.as.connector.subsystems.connector.ConnectorSubsystemAdd;
import org.jboss.as.connector.subsystems.connector.ConnectorSubsystemProviders;
import org.jboss.as.connector.subsystems.connector.Element;
import org.jboss.as.connector.subsystems.connector.Namespace;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ModelQueryOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationHandler;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.CommonDescriptions;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.controller.registry.ModelNodeRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class ConnectorExtension
implements Extension {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.connector");

    public void initialize(ExtensionContext context) {
        log.debugf("Initializing Connector Extension", new Object[0]);
        SubsystemRegistration registration = context.registerSubsystem("connector");
        registration.registerXMLElementWriter((XMLElementWriter)NewConnectorSubsystemParser.INSTANCE);
        ModelNodeRegistration subsystem = registration.registerSubsystemModel(ConnectorSubsystemProviders.SUBSYSTEM);
        subsystem.registerOperationHandler("add", ConnectorSubsystemAdd.INSTANCE, ConnectorSubsystemProviders.SUBSYSTEM_ADD_DESC, false);
        subsystem.registerOperationHandler("remove", ConnectorSubSystemRemove.INSTANCE, ConnectorSubsystemProviders.SUBSYSTEM_REMOVE_DESC, false);
        subsystem.registerOperationHandler("describe", (OperationHandler)ConnectorSubsystemDescribeHandler.INSTANCE, (DescriptionProvider)ConnectorSubsystemDescribeHandler.INSTANCE, false, OperationEntry.EntryType.PRIVATE);
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(Namespace.CURRENT.getUriString(), (XMLElementReader)NewConnectorSubsystemParser.INSTANCE);
    }

    private static ModelNode createEmptyAddOperation() {
        ModelNode address = new ModelNode();
        address.add("subsystem", "connector");
        address.protect();
        ModelNode subsystem = new ModelNode();
        subsystem.get("operation").set("add");
        subsystem.get("address").set(address);
        return subsystem;
    }

    private static class ConnectorSubsystemDescribeHandler
    implements ModelQueryOperationHandler,
    DescriptionProvider {
        static final ConnectorSubsystemDescribeHandler INSTANCE = new ConnectorSubsystemDescribeHandler();

        private ConnectorSubsystemDescribeHandler() {
        }

        public OperationResult execute(OperationContext context, ModelNode operation, ResultHandler resultHandler) {
            ModelNode add = ConnectorExtension.createEmptyAddOperation();
            ModelNode model = context.getSubModel();
            if (model.hasDefined("default-workmanager-short-running-thread-pool")) {
                add.get("default-workmanager-short-running-thread-pool").set(model.get("default-workmanager-short-running-thread-pool"));
            }
            if (model.hasDefined("default-workmanager-long-running-thread-pool")) {
                add.get("default-workmanager-long-running-thread-pool").set(model.get("default-workmanager-long-running-thread-pool"));
            }
            if (model.hasDefined("bean-validation-enabled")) {
                add.get("bean-validation-enabled").set(model.get("bean-validation-enabled"));
            }
            if (model.hasDefined("archive-validation-enabled")) {
                add.get("archive-validation-enabled").set(model.get("archive-validation-enabled"));
            }
            if (model.hasDefined("archive-validation-fail-on-error")) {
                add.get("archive-validation-fail-on-error").set(model.get("archive-validation-fail-on-error"));
            }
            if (model.hasDefined("archive-validation-fail-on-warn")) {
                add.get("archive-validation-fail-on-warn").set(model.get("archive-validation-fail-on-warn"));
            }
            ModelNode result = new ModelNode();
            result.add(add);
            resultHandler.handleResultFragment(Util.NO_LOCATION, result);
            resultHandler.handleResultComplete();
            return new BasicOperationResult();
        }

        public ModelNode getModelDescription(Locale locale) {
            return CommonDescriptions.getSubsystemDescribeOperation((Locale)locale);
        }
    }

    static final class NewConnectorSubsystemParser
    implements XMLStreamConstants,
    XMLElementReader<List<ModelNode>>,
    XMLElementWriter<SubsystemMarshallingContext> {
        static final NewConnectorSubsystemParser INSTANCE = new NewConnectorSubsystemParser();

        NewConnectorSubsystemParser() {
        }

        public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
            context.startSubsystemElement(Namespace.CURRENT.getUriString(), false);
            ModelNode node = context.getModelNode();
            this.writeArchiveValidation(writer, node);
            this.writeBeanValidation(writer, node);
            this.writeDefaultWorkManager(writer, node);
            writer.writeEndElement();
        }

        private void writeArchiveValidation(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
            if (this.hasAnyOf(node, "archive-validation-enabled", "archive-validation-fail-on-error", "archive-validation-fail-on-warn")) {
                writer.writeEmptyElement(Element.ARCHIVE_VALIDATION.getLocalName());
                if (this.has(node, "archive-validation-enabled")) {
                    this.writeAttribute(writer, Attribute.ENABLED, node.require("archive-validation-enabled"));
                }
                if (this.has(node, "archive-validation-fail-on-error")) {
                    this.writeAttribute(writer, Attribute.FAIL_ON_ERROR, node.require("archive-validation-fail-on-error"));
                }
                if (this.has(node, "archive-validation-fail-on-warn")) {
                    this.writeAttribute(writer, Attribute.FAIL_ON_WARN, node.require("archive-validation-fail-on-warn"));
                }
            }
        }

        private void writeBeanValidation(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
            if (this.has(node, "bean-validation-enabled")) {
                writer.writeEmptyElement(Element.BEAN_VALIDATION.getLocalName());
                this.writeAttribute(writer, Attribute.ENABLED, node.require("bean-validation-enabled"));
            }
        }

        private void writeDefaultWorkManager(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
            if (this.hasAnyOf(node, "default-workmanager-short-running-thread-pool", "default-workmanager-long-running-thread-pool")) {
                writer.writeEmptyElement(Element.DEFAULT_WORKMANAGER.getLocalName());
                if (this.has(node, "default-workmanager-short-running-thread-pool")) {
                    this.writeAttribute(writer, Attribute.SHORT_RUNNING_THREAD_POOL, node.require("default-workmanager-short-running-thread-pool"));
                }
                if (this.has(node, "default-workmanager-long-running-thread-pool")) {
                    this.writeAttribute(writer, Attribute.LONG_RUNNING_THREAD_POOL, node.require("default-workmanager-long-running-thread-pool"));
                }
            }
        }

        private boolean hasAnyOf(ModelNode node, String ... names) {
            for (String current : names) {
                if (!this.has(node, current)) continue;
                return true;
            }
            return false;
        }

        private boolean has(ModelNode node, String name) {
            return node.has(name) && node.get(name).isDefined();
        }

        private void writeAttribute(XMLExtendedStreamWriter writer, Attribute attr, ModelNode value) throws XMLStreamException {
            writer.writeAttribute(attr.getLocalName(), value.asString());
        }

        public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
            ModelNode subsystem = ConnectorExtension.createEmptyAddOperation();
            list.add(subsystem);
            EnumSet<Element> visited = EnumSet.noneOf(Element.class);
            EnumSet<Element> requiredElement = EnumSet.of(Element.DEFAULT_WORKMANAGER);
            block8: while (reader.hasNext() && reader.nextTag() != 2) {
                switch (Namespace.forUri(reader.getNamespaceURI())) {
                    case CONNECTOR_1_0: {
                        Element element = Element.forName(reader.getLocalName());
                        if (!visited.add(element)) {
                            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                        }
                        switch (element) {
                            case ARCHIVE_VALIDATION: {
                                this.parseArchiveValidation(reader, subsystem);
                                continue block8;
                            }
                            case BEAN_VALIDATION: {
                                this.parseBeanValidation(reader, subsystem);
                                continue block8;
                            }
                            case DEFAULT_WORKMANAGER: {
                                this.parseDefaultWorkManager(reader, subsystem);
                                requiredElement.remove((Object)Element.DEFAULT_WORKMANAGER);
                                continue block8;
                            }
                        }
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            if (!requiredElement.isEmpty()) {
                throw ParseUtils.missingRequiredElement((XMLExtendedStreamReader)reader, requiredElement);
            }
        }

        private void parseArchiveValidation(XMLExtendedStreamReader reader, ModelNode node) throws XMLStreamException {
            int cnt = reader.getAttributeCount();
            block5: for (int i = 0; i < cnt; ++i) {
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case ENABLED: {
                        node.get("archive-validation-enabled").set(Boolean.parseBoolean(reader.getAttributeValue(i)));
                        continue block5;
                    }
                    case FAIL_ON_ERROR: {
                        node.get("archive-validation-fail-on-error").set(Boolean.parseBoolean(reader.getAttributeValue(i)));
                        continue block5;
                    }
                    case FAIL_ON_WARN: {
                        node.get("archive-validation-fail-on-warn").set(Boolean.parseBoolean(reader.getAttributeValue(i)));
                        continue block5;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        }

        private void parseDefaultWorkManager(XMLExtendedStreamReader reader, ModelNode node) throws XMLStreamException {
            EnumSet<Attribute> required = EnumSet.of(Attribute.SHORT_RUNNING_THREAD_POOL, Attribute.LONG_RUNNING_THREAD_POOL);
            int cnt = reader.getAttributeCount();
            block4: for (int i = 0; i < cnt; ++i) {
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case SHORT_RUNNING_THREAD_POOL: {
                        node.get("default-workmanager-short-running-thread-pool").set(reader.getAttributeValue(i));
                        required.remove((Object)Attribute.SHORT_RUNNING_THREAD_POOL);
                        continue block4;
                    }
                    case LONG_RUNNING_THREAD_POOL: {
                        node.get("default-workmanager-long-running-thread-pool").set(reader.getAttributeValue(i));
                        required.remove((Object)Attribute.LONG_RUNNING_THREAD_POOL);
                    }
                }
            }
            if (!required.isEmpty()) {
                ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
            }
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        }

        private void parseBeanValidation(XMLExtendedStreamReader reader, ModelNode node) throws XMLStreamException {
            boolean enabled = ParseUtils.readBooleanAttributeElement((XMLExtendedStreamReader)reader, (String)Attribute.ENABLED.getLocalName());
            node.get("bean-validation-enabled").set(enabled);
        }
    }
}

