/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.connector;

import org.jboss.as.connector.ConnectorServices;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelRemoveOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationHandler;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;

public class ConnectorSubSystemRemove
implements ModelRemoveOperationHandler {
    static final OperationHandler INSTANCE = new ConnectorSubSystemRemove();

    public OperationResult execute(OperationContext context, ModelNode operation, final ResultHandler resultHandler) {
        ModelNode model = context.getSubModel();
        String name = model.require("name").asString();
        if (context.getRuntimeContext() != null) {
            context.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                public void execute(RuntimeTaskContext context) throws OperationFailedException {
                    ServiceController controller = context.getServiceRegistry().getService(ConnectorServices.CONNECTOR_CONFIG_SERVICE);
                    if (controller != null) {
                        controller.addListener((ServiceListener)new ResultHandler.ServiceRemoveListener(resultHandler));
                    } else {
                        resultHandler.handleResultComplete();
                    }
                }
            });
        } else {
            resultHandler.handleResultComplete();
        }
        ModelNode compensating = new ModelNode();
        compensating.get("address").set(operation.require("address"));
        compensating.get("operation").set("add");
        compensating.get("name").set(name);
        if (model.has("archive-validation-enabled")) {
            compensating.get("archive-validation-enabled").set(model.get("archive-validation-enabled"));
        }
        if (model.has("archive-validation-fail-on-error")) {
            compensating.get("archive-validation-fail-on-error").set(model.get("archive-validation-fail-on-error"));
        }
        if (model.has("archive-validation-fail-on-warn")) {
            compensating.get("archive-validation-fail-on-warn").set(model.get("archive-validation-fail-on-warn"));
        }
        if (model.has("bean-validation-enabled")) {
            compensating.get("bean-validation-enabled").set(model.get("bean-validation-enabled"));
        }
        if (model.has("default-workmanager-long-running-thread-pool")) {
            compensating.get("default-workmanager-long-running-thread-pool").set(model.get("default-workmanager-long-running-thread-pool"));
        }
        if (model.has("default-workmanager-short-running-thread-pool")) {
            compensating.get("default-workmanager-short-running-thread-pool").set(model.get("default-workmanager-short-running-thread-pool"));
        }
        return new BasicOperationResult(compensating);
    }
}

