/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.connector;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.connector.subsystems.connector.Namespace;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

class ConnectorSubsystemProviders {
    static final String RESOURCE_NAME = ConnectorSubsystemProviders.class.getPackage().getName() + ".LocalDescriptions";
    static final DescriptionProvider SUBSYSTEM = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = ConnectorSubsystemProviders.getResourceBundle(locale);
            ModelNode subsystem = new ModelNode();
            subsystem.get("description").set(bundle.getString("connector"));
            subsystem.get("head-comment-allowed").set(true);
            subsystem.get("tail-comment-allowed").set(true);
            subsystem.get("namespace").set(Namespace.CONNECTOR_1_0.getUriString());
            subsystem.get(new String[]{"attributes", "default-workmanager-short-running-thread-pool", "description"}).set(bundle.getString("default-workmanager.short-running-thread-pool"));
            subsystem.get(new String[]{"attributes", "default-workmanager-short-running-thread-pool", "type"}).set(ModelType.STRING);
            subsystem.get(new String[]{"attributes", "default-workmanager-short-running-thread-pool", "required"}).set(true);
            subsystem.get(new String[]{"attributes", "default-workmanager-long-running-thread-pool", "description"}).set(bundle.getString("default-workmanager.long-running-thread-pool"));
            subsystem.get(new String[]{"attributes", "default-workmanager-long-running-thread-pool", "type"}).set(ModelType.STRING);
            subsystem.get(new String[]{"attributes", "default-workmanager-long-running-thread-pool", "required"}).set(true);
            subsystem.get(new String[]{"attributes", "bean-validation-enabled", "description"}).set(bundle.getString("bean-validation.enabled"));
            subsystem.get(new String[]{"attributes", "bean-validation-enabled", "type"}).set(ModelType.BOOLEAN);
            subsystem.get(new String[]{"attributes", "bean-validation-enabled", "required"}).set(true);
            subsystem.get(new String[]{"attributes", "archive-validation-enabled", "description"}).set(bundle.getString("archive-validation.enabled"));
            subsystem.get(new String[]{"attributes", "archive-validation-enabled", "type"}).set(ModelType.BOOLEAN);
            subsystem.get(new String[]{"attributes", "archive-validation-enabled", "required"}).set(false);
            subsystem.get(new String[]{"attributes", "archive-validation-fail-on-error", "description"}).set(bundle.getString("archive-validation.fail-on-error"));
            subsystem.get(new String[]{"attributes", "archive-validation-fail-on-error", "type"}).set(ModelType.BOOLEAN);
            subsystem.get(new String[]{"attributes", "archive-validation-fail-on-error", "required"}).set(false);
            subsystem.get(new String[]{"attributes", "archive-validation-fail-on-warn", "description"}).set(bundle.getString("archive-validation.fail-on-warn"));
            subsystem.get(new String[]{"attributes", "archive-validation-fail-on-warn", "type"}).set(ModelType.BOOLEAN);
            subsystem.get(new String[]{"attributes", "archive-validation-fail-on-warn", "required"}).set(false);
            return subsystem;
        }
    };
    static final DescriptionProvider SUBSYSTEM_ADD_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = ConnectorSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = new ModelNode();
            operation.get("operation-name").set("add");
            operation.get("description").set(bundle.getString("connector.add"));
            operation.get("request-properties").setEmptyObject();
            operation.get("reply-properties").setEmptyObject();
            operation.get(new String[]{"request-properties", "archive-validation-enabled", "description"}).set(bundle.getString("connector.archive-validation.enabled"));
            operation.get(new String[]{"request-properties", "archive-validation-enabled", "type"}).set(ModelType.BOOLEAN);
            operation.get(new String[]{"request-properties", "archive-validation-enabled", "required"}).set(false);
            operation.get(new String[]{"request-properties", "archive-validation-fail-on-error", "description"}).set(bundle.getString("connector.archive-validation.fail-on-error"));
            operation.get(new String[]{"request-properties", "archive-validation-fail-on-error", "type"}).set(ModelType.BOOLEAN);
            operation.get(new String[]{"request-properties", "archive-validation-fail-on-error", "required"}).set(false);
            operation.get(new String[]{"request-properties", "archive-validation-fail-on-warn", "description"}).set(bundle.getString("connector.archive-validation.fail-on-warn"));
            operation.get(new String[]{"request-properties", "archive-validation-fail-on-warn", "type"}).set(ModelType.BOOLEAN);
            operation.get(new String[]{"request-properties", "archive-validation-fail-on-warn", "required"}).set(false);
            operation.get(new String[]{"request-properties", "bean-validation-enabled", "description"}).set(bundle.getString("connector.archive-validation.fail-on-warn"));
            operation.get(new String[]{"request-properties", "bean-validation-enabled", "type"}).set(ModelType.BOOLEAN);
            operation.get(new String[]{"request-properties", "bean-validation-enabled", "required"}).set(false);
            operation.get(new String[]{"request-properties", "default-workmanager-short-running-thread-pool", "description"}).set(bundle.getString("connector.default-workmanager.short-running-thread-pool"));
            operation.get(new String[]{"request-properties", "default-workmanager-short-running-thread-pool", "type"}).set(ModelType.STRING);
            operation.get(new String[]{"request-properties", "default-workmanager-short-running-thread-pool", "required"}).set(true);
            operation.get(new String[]{"request-properties", "default-workmanager-long-running-thread-pool", "description"}).set(bundle.getString("connector.default-workmanager.long-running-thread-pool"));
            operation.get(new String[]{"request-properties", "default-workmanager-long-running-thread-pool", "type"}).set(ModelType.STRING);
            operation.get(new String[]{"request-properties", "default-workmanager-long-running-thread-pool", "required"}).set(false);
            return operation;
        }
    };
    static DescriptionProvider SUBSYSTEM_REMOVE_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = ConnectorSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = new ModelNode();
            operation.get("operation-name").set("remove");
            operation.get("description").set(bundle.getString("connector.archive-validation.remove"));
            operation.get("reply-properties").setEmptyObject();
            return operation;
        }
    };

    ConnectorSubsystemProviders() {
    }

    private static ResourceBundle getResourceBundle(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return ResourceBundle.getBundle(RESOURCE_NAME, locale);
    }
}

