/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.datasources;

import org.jboss.as.connector.subsystems.datasources.AbstractDataSourceService;
import org.jboss.as.connector.subsystems.datasources.AttributeDefinition;
import org.jboss.as.connector.subsystems.datasources.DataSourceReferenceFactoryService;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelRemoveOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;

public abstract class AbstractDataSourceRemove
implements ModelRemoveOperationHandler {
    public static final Logger log = Logger.getLogger((String)"org.jboss.as.connector.subsystems.datasources");

    public OperationResult execute(OperationContext context, ModelNode operation, final ResultHandler resultHandler) throws OperationFailedException {
        ModelNode opAddr = operation.require("address");
        final String jndiName = PathAddress.pathAddress((ModelNode)opAddr).getLastElement().getValue();
        ModelNode model = context.getSubModel();
        ModelNode compensating = Util.getEmptyOperation((String)"add", (ModelNode)opAddr);
        if (model.has("connection-properties")) {
            for (ModelNode property : model.get("connection-properties").asList()) {
                compensating.get(new String[]{"connection-properties", property.asProperty().getName()}).set(property.asString());
            }
        }
        for (AttributeDefinition attribute : this.getModelProperties()) {
            if (!model.get(attribute.getName()).isDefined()) continue;
            compensating.get(attribute.getName()).set(model.get(attribute.getName()));
        }
        if (context.getRuntimeContext() != null) {
            context.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                public void execute(RuntimeTaskContext context) throws OperationFailedException {
                    ServiceName dataSourceServiceName;
                    ServiceController dataSourceController;
                    ServiceName referenceFactoryServiceName;
                    ServiceController referenceFactoryController;
                    ServiceRegistry registry = context.getServiceRegistry();
                    ServiceName binderServiceName = ContextNames.JAVA_CONTEXT_SERVICE_NAME.append(new String[]{jndiName});
                    ServiceController binderController = registry.getService(binderServiceName);
                    if (binderController != null) {
                        binderController.setMode(ServiceController.Mode.REMOVE);
                    }
                    if ((referenceFactoryController = registry.getService(referenceFactoryServiceName = DataSourceReferenceFactoryService.SERVICE_NAME_BASE.append(new String[]{jndiName}))) != null) {
                        referenceFactoryController.setMode(ServiceController.Mode.REMOVE);
                    }
                    if ((dataSourceController = registry.getService(dataSourceServiceName = AbstractDataSourceService.SERVICE_NAME_BASE.append(new String[]{jndiName}))) != null) {
                        dataSourceController.addListener((ServiceListener)new ResultHandler.ServiceRemoveListener(resultHandler));
                    } else {
                        resultHandler.handleResultComplete();
                    }
                }
            });
        } else {
            resultHandler.handleResultComplete();
        }
        return new BasicOperationResult(compensating);
    }

    protected abstract AttributeDefinition[] getModelProperties();
}

