/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.deployers.processors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.sql.DataSourceDefinition;
import javax.annotation.sql.DataSourceDefinitions;
import org.jboss.as.connector.deployers.processors.DirectDataSourceDescription;
import org.jboss.as.ee.component.AbstractComponentConfigProcessor;
import org.jboss.as.ee.component.AbstractComponentDescription;
import org.jboss.as.ee.component.BindingDescription;
import org.jboss.as.ee.component.BindingSourceDescription;
import org.jboss.as.ee.component.InterceptorDescription;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;

public class DataSourceDefinitionDeployer
extends AbstractComponentConfigProcessor {
    private static final DotName DATASOURCE_DEFINITION = DotName.createSimple((String)DataSourceDefinition.class.getName());
    private static final DotName DATASOURCE_DEFINITIONS = DotName.createSimple((String)DataSourceDefinitions.class.getName());

    protected void processComponentConfig(DeploymentUnit deploymentUnit, DeploymentPhaseContext phaseContext, CompositeIndex index, AbstractComponentDescription description) throws DeploymentUnitProcessingException {
        ClassInfo classInfo = index.getClassByName(DotName.createSimple((String)description.getComponentClassName()));
        if (classInfo == null) {
            return;
        }
        description.addAnnotationBindings(this.getDatasourceDefinitions(classInfo));
        Collection interceptorConfigurations = description.getAllInterceptors().values();
        for (InterceptorDescription interceptorConfiguration : interceptorConfigurations) {
            ClassInfo interceptorClassInfo = index.getClassByName(DotName.createSimple((String)interceptorConfiguration.getInterceptorClassName()));
            if (interceptorClassInfo == null) continue;
            description.addAnnotationBindings(this.getDatasourceDefinitions(interceptorClassInfo));
        }
    }

    private List<BindingDescription> getDatasourceDefinitions(ClassInfo classInfo) {
        ArrayList<BindingDescription> configurations = new ArrayList<BindingDescription>();
        Map classAnnotations = classInfo.annotations();
        if (classAnnotations != null) {
            List definitions = (List)classAnnotations.get(DATASOURCE_DEFINITION);
            if (definitions != null) {
                for (AnnotationInstance annotation : definitions) {
                    if (!(annotation.target() instanceof ClassInfo)) continue;
                    configurations.add(this.processDefinition(annotation));
                }
            }
            configurations.addAll(this.processDefinitions(classAnnotations));
        }
        return configurations;
    }

    private BindingDescription processDefinition(AnnotationInstance annotation) {
        AnnotationValue nameValue = annotation.value("name");
        if (nameValue == null || nameValue.asString().isEmpty()) {
            throw new IllegalArgumentException("@DataSourceDefinition annotations must provide a name.");
        }
        String name = nameValue.asString();
        AnnotationValue classValue = annotation.value("className");
        if (classValue == null || classValue.asString().equals(Object.class.getName())) {
            throw new IllegalArgumentException("@DataSourceDefinition annotations must provide a driver class name.");
        }
        String type = classValue.asString();
        DirectDataSourceDescription desc = new DirectDataSourceDescription();
        desc.setClassName(type);
        desc.setDatabaseName(this.asString(annotation, "databaseName"));
        desc.setDescription(this.asString(annotation, "description"));
        desc.setInitialPoolSize(this.asInt(annotation, "initialPoolSize"));
        desc.setIsolationLevel(this.asInt(annotation, "isolationLevel"));
        desc.setLoginTimeout(this.asInt(annotation, "loginTimeout"));
        desc.setMaxIdleTime(this.asInt(annotation, "maxIdleTime"));
        desc.setMaxStatements(this.asInt(annotation, "maxStatements"));
        desc.setMaxPoolSize(this.asInt(annotation, "maxPoolSize"));
        desc.setMinPoolSize(this.asInt(annotation, "minPoolSize"));
        desc.setPassword(this.asString(annotation, "password"));
        desc.setPortNumber(this.asInt(annotation, "portNumber"));
        desc.setProperties(this.asArray(annotation, "properties"));
        desc.setServerName(this.asString(annotation, "serverName"));
        desc.setTransactional(this.asBool(annotation, "transactional"));
        desc.setUrl(this.asString(annotation, "url"));
        desc.setUser(this.asString(annotation, "user"));
        BindingDescription bindingDescription = new BindingDescription(name);
        bindingDescription.setDependency(true);
        bindingDescription.setBindingType(type);
        bindingDescription.setReferenceSourceDescription((BindingSourceDescription)desc);
        return bindingDescription;
    }

    private int asInt(AnnotationInstance annotation, String string) {
        AnnotationValue value = annotation.value(string);
        return value == null ? -1 : value.asInt();
    }

    private String asString(AnnotationInstance annotation, String property) {
        AnnotationValue value = annotation.value(property);
        return value == null ? null : value.asString();
    }

    private boolean asBool(AnnotationInstance annotation, String property) {
        AnnotationValue value = annotation.value(property);
        return value == null ? false : value.asBoolean();
    }

    private String[] asArray(AnnotationInstance annotation, String property) {
        AnnotationValue value = annotation.value(property);
        return value == null ? null : value.asStringArray();
    }

    private List<BindingDescription> processDefinitions(Map<DotName, List<AnnotationInstance>> classAnnotations) {
        List<AnnotationInstance> definitionsAnnotation = classAnnotations.get(DATASOURCE_DEFINITIONS);
        if (definitionsAnnotation == null || definitionsAnnotation.isEmpty()) {
            return Collections.emptyList();
        }
        AnnotationInstance resourcesInstance = definitionsAnnotation.get(0);
        AnnotationInstance[] definitions = resourcesInstance.value().asNestedArray();
        ArrayList<BindingDescription> definitionDescriptions = new ArrayList<BindingDescription>(definitions.length);
        for (AnnotationInstance definition : definitions) {
            definitionDescriptions.add(this.processDefinition(definition));
        }
        return definitionDescriptions;
    }
}

