/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.deployers.processors;

import java.io.File;
import java.net.URL;
import java.util.Set;
import org.jboss.as.connector.ConnectorServices;
import org.jboss.as.connector.metadata.deployment.ResourceAdapterXmlDeploymentService;
import org.jboss.as.connector.metadata.xmldescriptors.ConnectorXmlDescriptor;
import org.jboss.as.connector.registry.ResourceAdapterDeploymentRegistry;
import org.jboss.as.connector.subsystems.connector.ConnectorSubsystemConfiguration;
import org.jboss.as.naming.service.NamingService;
import org.jboss.as.security.service.SubjectFactoryService;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.jca.common.api.metadata.common.CommonIronJacamar;
import org.jboss.jca.common.api.metadata.ironjacamar.IronJacamar;
import org.jboss.jca.common.api.metadata.ra.Connector;
import org.jboss.jca.common.api.metadata.resourceadapter.ResourceAdapter;
import org.jboss.jca.common.api.metadata.resourceadapter.ResourceAdapters;
import org.jboss.jca.common.metadata.merge.Merger;
import org.jboss.jca.core.api.management.ManagementRepository;
import org.jboss.jca.core.spi.mdr.MetadataRepository;
import org.jboss.jca.core.spi.rar.ResourceAdapterRepository;
import org.jboss.jca.core.spi.transaction.TransactionIntegration;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.security.SubjectFactory;

public class RaXmlDeploymentProcessor
implements DeploymentUnitProcessor {
    public static final Logger log = Logger.getLogger((String)"org.jboss.as.connector.deployer.raxmldeployer");
    private final MetadataRepository mdr;

    public RaXmlDeploymentProcessor(MetadataRepository mdr) {
        this.mdr = mdr;
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ConnectorXmlDescriptor connectorXmlDescriptor = (ConnectorXmlDescriptor)deploymentUnit.getAttachment(ConnectorXmlDescriptor.ATTACHMENT_KEY);
        if (connectorXmlDescriptor == null) {
            return;
        }
        ResourceAdapters raxmls = null;
        ServiceController raService = phaseContext.getServiceRegistry().getService(ConnectorServices.RESOURCEADAPTERS_SERVICE);
        if (raService != null) {
            raxmls = (ResourceAdapters)raService.getValue();
        }
        if (raxmls == null) {
            return;
        }
        log.tracef("processing Raxml", new Object[0]);
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        if (module == null) {
            throw new DeploymentUnitProcessingException("Failed to get module attachment for " + deploymentUnit);
        }
        try {
            ServiceTarget serviceTarget = phaseContext.getServiceTarget();
            for (ResourceAdapter raxml : raxmls.getResourceAdapters()) {
                String archive = raxml.getArchive();
                URL deployment = null;
                Set deployments = this.mdr.getResourceAdapters();
                for (String s : deployments) {
                    if (!s.endsWith(archive) && !s.endsWith(archive.substring(0, archive.indexOf(".rar")))) continue;
                    deployment = new URL(s);
                }
                if (deployment == null) continue;
                Connector cmd = this.mdr.getResourceAdapter(deployment.toExternalForm());
                IronJacamar ijmd = this.mdr.getIronJacamar(deployment.toExternalForm());
                File root = this.mdr.getRoot(deployment.toExternalForm());
                cmd = new Merger().mergeConnectorWithCommonIronJacamar((CommonIronJacamar)raxml, cmd);
                String deploymentName = archive.substring(0, archive.indexOf(".rar"));
                ResourceAdapterXmlDeploymentService service = new ResourceAdapterXmlDeploymentService(connectorXmlDescriptor, raxml, cmd, ijmd, module, deploymentName, root);
                serviceTarget.addService(ConnectorServices.RESOURCE_ADAPTER_XML_SERVICE_PREFIX.append(new String[]{deploymentName}), (Service)service).addDependency(ConnectorServices.IRONJACAMAR_MDR, MetadataRepository.class, service.getMdrInjector()).addDependency(ConnectorServices.RA_REPOSISTORY_SERVICE, ResourceAdapterRepository.class, service.getRaRepositoryInjector()).addDependency(ConnectorServices.MANAGEMENT_REPOSISTORY_SERVICE, ManagementRepository.class, service.getManagementRepositoryInjector()).addDependency(ConnectorServices.RESOURCE_ADAPTER_REGISTRY_SERVICE, ResourceAdapterDeploymentRegistry.class, service.getRegistryInjector()).addDependency(ConnectorServices.TRANSACTION_INTEGRATION_SERVICE, TransactionIntegration.class, service.getTxIntegrationInjector()).addDependency(ConnectorServices.CONNECTOR_CONFIG_SERVICE, ConnectorSubsystemConfiguration.class, service.getConfigInjector()).addDependency(SubjectFactoryService.SERVICE_NAME, SubjectFactory.class, service.getSubjectFactoryInjector()).addDependency(NamingService.SERVICE_NAME).setInitialMode(ServiceController.Mode.ACTIVE).install();
            }
        }
        catch (Throwable t) {
            throw new DeploymentUnitProcessingException(t);
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

