/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.datasources;

import org.jboss.as.connector.ConnectorServices;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelQueryOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.server.operations.ServerWriteAttributeOperationHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.jca.core.api.management.DataSource;
import org.jboss.jca.core.api.management.ManagementRepository;
import org.jboss.msc.service.ServiceController;

class DataSourcePoolConfigurationRWHandler {
    static final String[] NO_LOCATION = new String[0];
    static final String[] ATTRIBUTES = new String[]{"max-pool-size", "min-pool-size", "blocking-timeout-wait-millis", "idle-timeout-minutes", "background-validation", "background-validation-minutes", "pool-prefill", "pool-use-strict-min", "use-fast-fail"};

    DataSourcePoolConfigurationRWHandler() {
    }

    static class PoolConfigurationValidator
    implements ParameterValidator {
        static final ModelTypeValidator intValidator = new ModelTypeValidator(ModelType.INT);
        static final ModelTypeValidator longValidator = new ModelTypeValidator(ModelType.LONG);
        static final ModelTypeValidator boolValidator = new ModelTypeValidator(ModelType.BOOLEAN);

        PoolConfigurationValidator() {
        }

        public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
            if ("max-pool-size".equals(parameterName)) {
                intValidator.validateParameter(parameterName, value);
            } else if ("min-pool-size".equals(parameterName)) {
                intValidator.validateParameter(parameterName, value);
            } else if ("blocking-timeout-wait-millis".equals(parameterName)) {
                longValidator.validateParameter(parameterName, value);
            } else if ("idle-timeout-minutes".equals(parameterName)) {
                longValidator.validateParameter(parameterName, value);
            } else if ("background-validation".equals(parameterName)) {
                boolValidator.validateParameter(parameterName, value);
            } else if ("background-validation-minutes".equals(parameterName)) {
                intValidator.validateParameter(parameterName, value);
            } else if ("pool-prefill".equals(parameterName)) {
                boolValidator.validateParameter(parameterName, value);
            } else if ("pool-use-strict-min".equals(parameterName)) {
                boolValidator.validateParameter(parameterName, value);
            } else if ("use-fast-fail".equals(parameterName)) {
                boolValidator.validateParameter(parameterName, value);
            } else {
                throw new OperationFailedException(new ModelNode().set("Wrong parameter name for " + parameterName));
            }
        }

        public void validateResolvedParameter(String parameterName, ModelNode value) throws OperationFailedException {
            this.validateParameter(parameterName, value.resolve());
        }
    }

    static class DataSourcePoolConfigurationWriteHandler
    extends ServerWriteAttributeOperationHandler {
        static DataSourcePoolConfigurationWriteHandler INSTANCE = new DataSourcePoolConfigurationWriteHandler(new PoolConfigurationValidator());

        protected DataSourcePoolConfigurationWriteHandler(ParameterValidator validator) {
            super(validator);
        }

        protected boolean applyUpdateToRuntime(OperationContext context, final ModelNode operation, final ResultHandler resultHandler, final String parameterName, final ModelNode newValue, ModelNode currentValue) throws OperationFailedException {
            if (context.getRuntimeContext() != null) {
                context.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                    public void execute(RuntimeTaskContext runtimeCtx) throws OperationFailedException {
                        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
                        String jndiName = address.getLastElement().getValue();
                        ServiceController managementRepoService = runtimeCtx.getServiceRegistry().getService(ConnectorServices.MANAGEMENT_REPOSISTORY_SERVICE);
                        if (managementRepoService != null) {
                            try {
                                ManagementRepository repository = (ManagementRepository)managementRepoService.getValue();
                                if (repository.getDataSources() != null) {
                                    for (DataSource ds : repository.getDataSources()) {
                                        if (!jndiName.equalsIgnoreCase(ds.getJndiName())) continue;
                                        if ("max-pool-size".equals(parameterName)) {
                                            ds.getPoolConfiguration().setMaxSize(newValue.asInt());
                                        }
                                        if ("min-pool-size".equals(parameterName)) {
                                            ds.getPoolConfiguration().setMinSize(newValue.asInt());
                                        }
                                        if ("blocking-timeout-wait-millis".equals(parameterName)) {
                                            ds.getPoolConfiguration().setBlockingTimeout(newValue.asLong());
                                        }
                                        if ("pool-use-strict-min".equals(parameterName)) {
                                            ds.getPoolConfiguration().setStrictMin(newValue.asBoolean());
                                        }
                                        if (!"use-fast-fail".equals(parameterName)) continue;
                                        ds.getPoolConfiguration().setUseFastFail(newValue.asBoolean());
                                    }
                                }
                                resultHandler.handleResultComplete();
                            }
                            catch (Exception e) {
                                throw new OperationFailedException(new ModelNode().set("failed to set attribute" + e.getMessage()));
                            }
                        } else {
                            resultHandler.handleResultComplete();
                        }
                    }
                });
            } else {
                resultHandler.handleResultComplete();
            }
            return "idle-timeout-minutes".equals(parameterName) || "background-validation".equals(parameterName) || "background-validation-minutes".equals(parameterName) || "pool-prefill".equals(parameterName);
        }
    }

    static class DataSourcePoolConfigurationReadHandler
    implements ModelQueryOperationHandler {
        static DataSourcePoolConfigurationReadHandler INSTANCE = new DataSourcePoolConfigurationReadHandler();

        DataSourcePoolConfigurationReadHandler() {
        }

        public OperationResult execute(OperationContext context, ModelNode operation, ResultHandler resultHandler) throws OperationFailedException {
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
            String jndiName = address.getLastElement().getValue();
            String parameterName = operation.require("name").asString();
            ModelNode submodel = context.getSubModel();
            ModelNode currentValue = submodel.get(parameterName).clone();
            resultHandler.handleResultFragment(new String[0], currentValue);
            resultHandler.handleResultComplete();
            return new BasicOperationResult();
        }
    }
}

