/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.datasources;

import org.jboss.as.connector.ConnectorServices;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelQueryOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.dmr.ModelNode;
import org.jboss.jca.core.api.management.DataSource;
import org.jboss.jca.core.api.management.ManagementRepository;
import org.jboss.msc.service.ServiceController;

class XaDataSourcesMetrics
implements ModelQueryOperationHandler {
    static XaDataSourcesMetrics INSTANCE = new XaDataSourcesMetrics();
    static final String[] NO_LOCATION = new String[0];
    private static final String MAX_POOL_SIZE = "metrics-max-pool-size";
    private static final String MIN_POOL_SIZE = "metrics-min-pool-size";
    private static final String BLOCKING_TIMEOUT = "metrics-blocking-timeout-wait-millis";
    private static final String IDLE_TIMEOUT_MINUTES = "metrics-idle-timeout-minutes";
    private static final String BACKGROUND_VALIDATION = "metrics-background-validation";
    private static final String BACKGROUND_VALIDATION_MINUTES = "metrics-background-validation-minutes";
    private static final String POOL_PREFILL = "metrics-pool-prefill";
    private static final String POOL_USE_STRICT_MIN = "metrics-pool-use-strict-min";
    private static final String USE_FAST_FAIL = "metrics-use-fast-fail";
    static final String[] ATTRIBUTES = new String[]{"metrics-max-pool-size", "metrics-min-pool-size", "metrics-blocking-timeout-wait-millis", "metrics-idle-timeout-minutes", "metrics-background-validation", "metrics-background-validation-minutes", "metrics-pool-prefill", "metrics-pool-use-strict-min", "metrics-use-fast-fail"};

    XaDataSourcesMetrics() {
    }

    public OperationResult execute(OperationContext context, final ModelNode operation, final ResultHandler resultHandler) throws OperationFailedException {
        if (context.getRuntimeContext() != null) {
            context.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                public void execute(RuntimeTaskContext context) throws OperationFailedException {
                    PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
                    String jndiName = address.getLastElement().getValue();
                    String attributeName = operation.require("name").asString();
                    ServiceController managementRepoService = context.getServiceRegistry().getService(ConnectorServices.MANAGEMENT_REPOSISTORY_SERVICE);
                    if (managementRepoService != null) {
                        try {
                            ManagementRepository repository = (ManagementRepository)managementRepoService.getValue();
                            ModelNode result = new ModelNode();
                            if (repository.getDataSources() != null) {
                                for (DataSource ds : repository.getDataSources()) {
                                    if (!jndiName.equalsIgnoreCase(ds.getJndiName())) continue;
                                    if (XaDataSourcesMetrics.MAX_POOL_SIZE.equals(attributeName)) {
                                        result.set("" + ds.getPoolConfiguration().getMaxSize());
                                    }
                                    if (XaDataSourcesMetrics.MIN_POOL_SIZE.equals(attributeName)) {
                                        result.set("" + ds.getPoolConfiguration().getMinSize());
                                    }
                                    if (XaDataSourcesMetrics.BLOCKING_TIMEOUT.equals(attributeName)) {
                                        result.set("" + ds.getPoolConfiguration().getBlockingTimeout());
                                    }
                                    if (XaDataSourcesMetrics.IDLE_TIMEOUT_MINUTES.equals(attributeName)) {
                                        result.set("" + ds.getPoolConfiguration().getIdleTimeout());
                                    }
                                    if (XaDataSourcesMetrics.BACKGROUND_VALIDATION.equals(attributeName)) {
                                        result.set("" + ds.getPoolConfiguration().isBackgroundValidation());
                                    }
                                    if (XaDataSourcesMetrics.BACKGROUND_VALIDATION_MINUTES.equals(attributeName)) {
                                        result.set("" + ds.getPoolConfiguration().getBackgroundValidationMinutes());
                                    }
                                    if (XaDataSourcesMetrics.POOL_PREFILL.equals(attributeName)) {
                                        result.set("" + ds.getPoolConfiguration().isPrefill());
                                    }
                                    if (XaDataSourcesMetrics.POOL_USE_STRICT_MIN.equals(attributeName)) {
                                        result.set("" + ds.getPoolConfiguration().isStrictMin());
                                    }
                                    if (!XaDataSourcesMetrics.USE_FAST_FAIL.equals(attributeName)) continue;
                                    result.set("" + ds.getPoolConfiguration().isUseFastFail());
                                }
                            }
                            resultHandler.handleResultFragment(new String[0], result);
                            resultHandler.handleResultComplete();
                        }
                        catch (Exception e) {
                            throw new OperationFailedException(new ModelNode().set("failed to get metrics" + e.getMessage()));
                        }
                    }
                }
            });
        } else {
            resultHandler.handleResultFragment(NO_LOCATION, new ModelNode().set("no metrics available"));
            resultHandler.handleResultComplete();
        }
        return new BasicOperationResult();
    }
}

