/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.datasources;

import java.sql.Driver;
import java.util.ServiceLoader;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.msc.service.ServiceName;

public class JdbcDriverRemove
extends AbstractRemoveStepHandler {
    static final JdbcDriverRemove INSTANCE = new JdbcDriverRemove();

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        Module module;
        String driverName = model.get("driver-name").asString();
        String moduleName = operation.require("driver-module-name").asString();
        try {
            module = Module.getCallerModuleLoader().loadModule(ModuleIdentifier.create((String)moduleName));
        }
        catch (ModuleLoadException e) {
            throw new OperationFailedException((Throwable)e, new ModelNode().set("Failed to load module for driver [" + moduleName + "]"));
        }
        ServiceLoader serviceLoader = module.loadService(Driver.class);
        if (serviceLoader != null) {
            for (Driver driver : serviceLoader) {
                int majorVersion = driver.getMajorVersion();
                int minorVersion = driver.getMinorVersion();
                context.removeService(ServiceName.JBOSS.append(new String[]{"jdbc-driver", driver.getClass().getName(), Integer.toString(majorVersion), Integer.toString(minorVersion)}));
            }
        }
    }

    protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) {
    }
}

