/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.datasources;

import java.sql.Driver;
import java.util.List;
import javax.sql.DataSource;
import org.jboss.as.connector.ConnectorServices;
import org.jboss.as.connector.registry.DriverRegistry;
import org.jboss.as.connector.subsystems.datasources.AbstractDataSourceService;
import org.jboss.as.connector.subsystems.datasources.AttributeDefinition;
import org.jboss.as.connector.subsystems.datasources.DataSourceReferenceFactoryService;
import org.jboss.as.connector.subsystems.datasources.Util;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.naming.service.NamingService;
import org.jboss.as.security.service.SubjectFactoryService;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.jca.core.api.management.ManagementRepository;
import org.jboss.jca.core.spi.transaction.TransactionIntegration;
import org.jboss.logging.Logger;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.security.SubjectFactory;

public abstract class AbstractDataSourceAdd
extends AbstractAddStepHandler {
    public static final Logger log = Logger.getLogger((String)"org.jboss.as.connector.subsystems.datasources");

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> controllers) throws OperationFailedException {
        final String jndiName = Util.getJndiName(operation);
        ServiceTarget serviceTarget = context.getServiceTarget();
        boolean enabled = !operation.hasDefined("enabled") || operation.get("enabled").asBoolean();
        AbstractDataSourceService dataSourceService = this.createDataSourceService(jndiName);
        ServiceName dataSourceServiceName = AbstractDataSourceService.SERVICE_NAME_BASE.append(new String[]{jndiName});
        ServiceBuilder dataSourceServiceBuilder = serviceTarget.addService(dataSourceServiceName, (Service)dataSourceService).addDependency(ConnectorServices.TRANSACTION_INTEGRATION_SERVICE, TransactionIntegration.class, dataSourceService.getTransactionIntegrationInjector()).addDependency(ConnectorServices.MANAGEMENT_REPOSISTORY_SERVICE, ManagementRepository.class, dataSourceService.getmanagementRepositoryInjector()).addDependency(SubjectFactoryService.SERVICE_NAME, SubjectFactory.class, dataSourceService.getSubjectFactoryInjector()).addDependency(ConnectorServices.JDBC_DRIVER_REGISTRY_SERVICE, DriverRegistry.class, dataSourceService.getDriverRegistryInjector()).addDependency(NamingService.SERVICE_NAME);
        controllers.add(this.startConfigAndAddDependency(dataSourceServiceBuilder, dataSourceService, jndiName, serviceTarget, operation));
        ModelNode node = operation.require("driver-name");
        String driverName = node.asString();
        ServiceName driverServiceName = ServiceName.JBOSS.append(new String[]{"jdbc-driver", driverName.replaceAll("\\.", "_")});
        if (driverServiceName != null) {
            dataSourceServiceBuilder.addDependency(driverServiceName, Driver.class, dataSourceService.getDriverInjector());
        }
        DataSourceReferenceFactoryService referenceFactoryService = new DataSourceReferenceFactoryService();
        ServiceName referenceFactoryServiceName = DataSourceReferenceFactoryService.SERVICE_NAME_BASE.append(new String[]{jndiName});
        ServiceBuilder referenceBuilder = serviceTarget.addService(referenceFactoryServiceName, (Service)referenceFactoryService).addDependency(dataSourceServiceName, DataSource.class, referenceFactoryService.getDataSourceInjector());
        ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)jndiName);
        BinderService binderService = new BinderService(bindInfo.getBindName());
        ServiceBuilder binderBuilder = serviceTarget.addService(bindInfo.getBinderServiceName(), (Service)binderService).addDependency(referenceFactoryServiceName, ManagedReferenceFactory.class, binderService.getManagedObjectInjector()).addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, binderService.getNamingStoreInjector()).addListener((ServiceListener)new AbstractServiceListener<Object>(){

            public void transition(ServiceController<? extends Object> controller, ServiceController.Transition transition) {
                switch (transition) {
                    case STARTING_to_UP: {
                        log.infof("Bound data source [%s]", (Object)jndiName);
                        break;
                    }
                    case START_REQUESTED_to_DOWN: {
                        log.infof("Unbound data source [%s]", (Object)jndiName);
                        break;
                    }
                    case REMOVING_to_REMOVED: {
                        log.debugf("Removed JDBC Data-source [%s]", (Object)jndiName);
                    }
                }
            }
        });
        if (enabled) {
            dataSourceServiceBuilder.setInitialMode(ServiceController.Mode.ACTIVE).addListener((ServiceListener)verificationHandler);
            referenceBuilder.setInitialMode(ServiceController.Mode.ACTIVE).addListener((ServiceListener)verificationHandler);
            binderBuilder.setInitialMode(ServiceController.Mode.ACTIVE).addListener((ServiceListener)verificationHandler);
        } else {
            dataSourceServiceBuilder.setInitialMode(ServiceController.Mode.NEVER);
            referenceBuilder.setInitialMode(ServiceController.Mode.NEVER);
            binderBuilder.setInitialMode(ServiceController.Mode.NEVER);
        }
        controllers.add(dataSourceServiceBuilder.install());
        controllers.add(referenceBuilder.install());
        controllers.add(binderBuilder.install());
    }

    static String cleanupJavaContext(String jndiName) {
        String bindName = jndiName.startsWith("java:/") ? jndiName.substring(6) : (jndiName.startsWith("java:") ? jndiName.substring(5) : jndiName);
        return bindName;
    }

    protected abstract ServiceController<?> startConfigAndAddDependency(ServiceBuilder<?> var1, AbstractDataSourceService var2, String var3, ServiceTarget var4, ModelNode var5) throws OperationFailedException;

    protected abstract void populateModel(ModelNode var1, ModelNode var2);

    protected abstract AbstractDataSourceService createDataSourceService(String var1) throws OperationFailedException;

    static void populateAddModel(ModelNode existingModel, ModelNode newModel, String connectionPropertiesProp, AttributeDefinition[] attributes) {
        if (existingModel.hasDefined(connectionPropertiesProp)) {
            for (Property property : existingModel.get(connectionPropertiesProp).asPropertyList()) {
                newModel.get(new String[]{connectionPropertiesProp, property.getName()}).set(property.getValue().asString());
            }
        }
        for (AttributeDefinition attribute : attributes) {
            if (!existingModel.hasDefined(attribute.getName())) continue;
            newModel.get(attribute.getName()).set(existingModel.get(attribute.getName()));
        }
    }
}

