/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.pool;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jboss.as.connector.ConnectorMessages;
import org.jboss.as.connector.ConnectorServices;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.jca.core.api.management.ConnectionFactory;
import org.jboss.jca.core.api.management.Connector;
import org.jboss.jca.core.api.management.DataSource;
import org.jboss.jca.core.api.management.ManagementRepository;
import org.jboss.jca.core.connectionmanager.pool.mcp.ManagedConnectionPoolStatisticsImpl;
import org.jboss.jca.core.spi.statistics.StatisticsPlugin;
import org.jboss.msc.service.ServiceController;

public abstract class PoolMetrics
implements OperationStepHandler {
    static final String[] NO_LOCATION = new String[0];
    public static final Set<String> ATTRIBUTES = new ManagedConnectionPoolStatisticsImpl(1).getNames();

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (context.getType() == OperationContext.Type.SERVER) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
                    String jndiName = address.getLastElement().getValue();
                    String attributeName = operation.require("name").asString();
                    ServiceController managementRepoService = context.getServiceRegistry(false).getService(ConnectorServices.MANAGEMENT_REPOSISTORY_SERVICE);
                    if (managementRepoService != null) {
                        try {
                            ManagementRepository repository = (ManagementRepository)managementRepoService.getValue();
                            ModelNode result = context.getResult();
                            List<StatisticsPlugin> stats = PoolMetrics.this.getMatchingStats(jndiName, repository);
                            for (StatisticsPlugin stat : stats) {
                                result.set("" + stat.getValue(attributeName));
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            throw new OperationFailedException(new ModelNode().set(ConnectorMessages.MESSAGES.failedToGetMetrics(e.getLocalizedMessage())));
                        }
                    }
                    context.completeStep();
                }
            }, OperationContext.Stage.RUNTIME);
        } else {
            context.getResult().set(ConnectorMessages.MESSAGES.noMetricsAvailable());
        }
        context.completeStep();
    }

    protected abstract List<StatisticsPlugin> getMatchingStats(String var1, ManagementRepository var2);

    public static class RaPoolMetricsHandler
    extends PoolMetrics {
        public static RaPoolMetricsHandler INSTANCE = new RaPoolMetricsHandler();

        @Override
        protected List<StatisticsPlugin> getMatchingStats(String jndiName, ManagementRepository repository) {
            ArrayList<StatisticsPlugin> result = new ArrayList<StatisticsPlugin>(repository.getConnectors().size());
            if (repository.getConnectors() != null) {
                for (Connector c : repository.getConnectors()) {
                    if (!jndiName.equalsIgnoreCase(c.getUniqueId()) || c.getConnectionFactories() == null || c.getConnectionFactories().get(0) == null || ((ConnectionFactory)c.getConnectionFactories().get(0)).getPool() == null) continue;
                    result.add((StatisticsPlugin)((ConnectionFactory)c.getConnectionFactories().get(0)).getPool().getStatistics());
                }
            }
            result.trimToSize();
            return result;
        }
    }

    public static class LocalAndXaDataSourcePoolMetricsHandler
    extends PoolMetrics {
        public static LocalAndXaDataSourcePoolMetricsHandler INSTANCE = new LocalAndXaDataSourcePoolMetricsHandler();

        @Override
        protected List<StatisticsPlugin> getMatchingStats(String jndiName, ManagementRepository repository) {
            ArrayList<StatisticsPlugin> result = new ArrayList<StatisticsPlugin>(repository.getDataSources().size());
            if (repository.getDataSources() != null) {
                for (DataSource ds : repository.getDataSources()) {
                    if (!jndiName.equalsIgnoreCase(ds.getJndiName()) || ds.getPool() == null) continue;
                    result.add((StatisticsPlugin)ds.getPool().getStatistics());
                }
            }
            result.trimToSize();
            return result;
        }
    }
}

