/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.datasources;

import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.connector.ConnectorLogger;
import org.jboss.as.connector.pool.PoolConfigurationRWHandler;
import org.jboss.as.connector.pool.PoolMetrics;
import org.jboss.as.connector.pool.PoolOperations;
import org.jboss.as.connector.subsystems.datasources.AbstractDataSourceAdd;
import org.jboss.as.connector.subsystems.datasources.ConnectionPropertyAdd;
import org.jboss.as.connector.subsystems.datasources.ConnectionPropertyRemove;
import org.jboss.as.connector.subsystems.datasources.Constants;
import org.jboss.as.connector.subsystems.datasources.DataSourceAdd;
import org.jboss.as.connector.subsystems.datasources.DataSourceDisable;
import org.jboss.as.connector.subsystems.datasources.DataSourceEnable;
import org.jboss.as.connector.subsystems.datasources.DataSourceRemove;
import org.jboss.as.connector.subsystems.datasources.DataSourcesSubsystemAdd;
import org.jboss.as.connector.subsystems.datasources.DataSourcesSubsystemProviders;
import org.jboss.as.connector.subsystems.datasources.DisableRequiredWriteAttributeHandler;
import org.jboss.as.connector.subsystems.datasources.DsParser;
import org.jboss.as.connector.subsystems.datasources.Element;
import org.jboss.as.connector.subsystems.datasources.GetInstalledDriverOperationHandler;
import org.jboss.as.connector.subsystems.datasources.InstalledDriversListOperationHandler;
import org.jboss.as.connector.subsystems.datasources.JdbcDriverAdd;
import org.jboss.as.connector.subsystems.datasources.JdbcDriverRemove;
import org.jboss.as.connector.subsystems.datasources.LocalAndXaDataSourcesJdbcMetrics;
import org.jboss.as.connector.subsystems.datasources.Namespace;
import org.jboss.as.connector.subsystems.datasources.XaDataSourceAdd;
import org.jboss.as.connector.subsystems.datasources.XaDataSourcePropertyAdd;
import org.jboss.as.connector.subsystems.datasources.XaDataSourcePropertyRemove;
import org.jboss.as.connector.subsystems.datasources.XaDataSourceRemove;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.CommonDescriptions;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.jca.common.api.metadata.common.CommonPool;
import org.jboss.jca.common.api.metadata.common.CommonXaPool;
import org.jboss.jca.common.api.metadata.common.Extension;
import org.jboss.jca.common.api.metadata.common.Recovery;
import org.jboss.jca.common.api.metadata.ds.DataSource;
import org.jboss.jca.common.api.metadata.ds.DataSources;
import org.jboss.jca.common.api.metadata.ds.Driver;
import org.jboss.jca.common.api.metadata.ds.DsSecurity;
import org.jboss.jca.common.api.metadata.ds.Statement;
import org.jboss.jca.common.api.metadata.ds.TimeOut;
import org.jboss.jca.common.api.metadata.ds.Validation;
import org.jboss.jca.common.api.metadata.ds.XaDataSource;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class DataSourcesExtension
implements Extension {
    public static final String SUBSYSTEM_NAME = "datasources";

    public void initialize(ExtensionContext context) {
        ConnectorLogger.SUBSYSTEM_DATASOURCES_LOGGER.debugf("Initializing Datasources Extension", new Object[0]);
        SubsystemRegistration registration = context.registerSubsystem(SUBSYSTEM_NAME);
        registration.registerXMLElementWriter((XMLElementWriter)NewDataSourceSubsystemParser.INSTANCE);
        ManagementResourceRegistration subsystem = registration.registerSubsystemModel(DataSourcesSubsystemProviders.SUBSYSTEM);
        subsystem.registerOperationHandler("add", (OperationStepHandler)DataSourcesSubsystemAdd.INSTANCE, DataSourcesSubsystemProviders.SUBSYSTEM_ADD_DESC, false);
        subsystem.registerOperationHandler("describe", (OperationStepHandler)DataSourcesSubsystemDescribeHandler.INSTANCE, (DescriptionProvider)DataSourcesSubsystemDescribeHandler.INSTANCE, false, OperationEntry.EntryType.PRIVATE);
        subsystem.registerOperationHandler("installed-drivers-list", (OperationStepHandler)InstalledDriversListOperationHandler.INSTANCE, DataSourcesSubsystemProviders.INSTALLED_DRIVERS_LIST_DESC);
        subsystem.registerOperationHandler("get-installed-driver", (OperationStepHandler)GetInstalledDriverOperationHandler.INSTANCE, DataSourcesSubsystemProviders.GET_INSTALLED_DRIVER_DESC);
        ManagementResourceRegistration jdbcDrivers = subsystem.registerSubModel(PathElement.pathElement((String)"jdbc-driver"), DataSourcesSubsystemProviders.JDBC_DRIVER_DESC);
        jdbcDrivers.registerOperationHandler("add", (OperationStepHandler)JdbcDriverAdd.INSTANCE, DataSourcesSubsystemProviders.ADD_JDBC_DRIVER_DESC, false);
        jdbcDrivers.registerOperationHandler("remove", (OperationStepHandler)JdbcDriverRemove.INSTANCE, DataSourcesSubsystemProviders.REMOVE_JDBC_DRIVER_DESC, false);
        ManagementResourceRegistration dataSources = subsystem.registerSubModel(PathElement.pathElement((String)"data-source"), DataSourcesSubsystemProviders.DATA_SOURCE_DESC);
        dataSources.registerOperationHandler("add", (OperationStepHandler)DataSourceAdd.INSTANCE, DataSourcesSubsystemProviders.ADD_DATA_SOURCE_DESC, false);
        dataSources.registerOperationHandler("remove", (OperationStepHandler)DataSourceRemove.INSTANCE, DataSourcesSubsystemProviders.REMOVE_DATA_SOURCE_DESC, false);
        dataSources.registerOperationHandler("enable", (OperationStepHandler)DataSourceEnable.LOCAL_INSTANCE, DataSourcesSubsystemProviders.ENABLE_DATA_SOURCE_DESC, false);
        dataSources.registerOperationHandler("disable", (OperationStepHandler)DataSourceDisable.INSTANCE, DataSourcesSubsystemProviders.DISABLE_DATA_SOURCE_DESC, false);
        dataSources.registerOperationHandler("flush-idle-connection-in-pool", (OperationStepHandler)PoolOperations.FlushIdleConnectionInPool.DS_INSTANCE, DataSourcesSubsystemProviders.FLUSH_IDLE_CONNECTION_DESC, false);
        dataSources.registerOperationHandler("flush-all-connection-in-pool", (OperationStepHandler)PoolOperations.FlushAllConnectionInPool.DS_INSTANCE, DataSourcesSubsystemProviders.FLUSH_ALL_CONNECTION_DESC, false);
        dataSources.registerOperationHandler("test-connection-in-pool", (OperationStepHandler)PoolOperations.TestConnectionInPool.DS_INSTANCE, DataSourcesSubsystemProviders.TEST_CONNECTION_DESC, false);
        ManagementResourceRegistration configAdapter = dataSources.registerSubModel(PathElement.pathElement((String)Constants.CONNECTION_PROPERTIES.getName()), DataSourcesSubsystemProviders.CONNECTION_PROPERTIES_DESC);
        configAdapter.registerOperationHandler("add", (OperationStepHandler)ConnectionPropertyAdd.INSTANCE, DataSourcesSubsystemProviders.ADD_CONNECTION_PROPERTIES_DESC, false);
        configAdapter.registerOperationHandler("remove", (OperationStepHandler)ConnectionPropertyRemove.INSTANCE, DataSourcesSubsystemProviders.REMOVE_CONNECTION_PROPERTIES_DESC, false);
        for (String attributeName : PoolMetrics.ATTRIBUTES) {
            dataSources.registerMetric(attributeName, (OperationStepHandler)PoolMetrics.LocalAndXaDataSourcePoolMetricsHandler.INSTANCE);
        }
        for (String attributeName : LocalAndXaDataSourcesJdbcMetrics.ATTRIBUTES) {
            dataSources.registerMetric(attributeName, (OperationStepHandler)LocalAndXaDataSourcesJdbcMetrics.INSTANCE);
        }
        for (SimpleAttributeDefinition attribute : DataSourcesSubsystemProviders.DATASOURCE_ATTRIBUTE) {
            if (PoolConfigurationRWHandler.ATTRIBUTES.contains(attribute.getName())) {
                dataSources.registerReadWriteAttribute(attribute.getName(), (OperationStepHandler)PoolConfigurationRWHandler.PoolConfigurationReadHandler.INSTANCE, (OperationStepHandler)PoolConfigurationRWHandler.LocalAndXaDataSourcePoolConfigurationWriteHandler.INSTANCE, AttributeAccess.Storage.CONFIGURATION);
                continue;
            }
            dataSources.registerReadWriteAttribute(attribute.getName(), null, (OperationStepHandler)new DisableRequiredWriteAttributeHandler((AttributeDefinition[])DataSourcesSubsystemProviders.DATASOURCE_ATTRIBUTE), AttributeAccess.Storage.CONFIGURATION);
        }
        ManagementResourceRegistration xaDataSources = subsystem.registerSubModel(PathElement.pathElement((String)"xa-data-source"), DataSourcesSubsystemProviders.XA_DATA_SOURCE_DESC);
        xaDataSources.registerOperationHandler("add", (OperationStepHandler)XaDataSourceAdd.INSTANCE, DataSourcesSubsystemProviders.ADD_XA_DATA_SOURCE_DESC, false);
        xaDataSources.registerOperationHandler("remove", (OperationStepHandler)XaDataSourceRemove.INSTANCE, DataSourcesSubsystemProviders.REMOVE_XA_DATA_SOURCE_DESC, false);
        xaDataSources.registerOperationHandler("enable", (OperationStepHandler)DataSourceEnable.XA_INSTANCE, DataSourcesSubsystemProviders.ENABLE_XA_DATA_SOURCE_DESC, false);
        xaDataSources.registerOperationHandler("disable", (OperationStepHandler)DataSourceDisable.INSTANCE, DataSourcesSubsystemProviders.DISABLE_XA_DATA_SOURCE_DESC, false);
        xaDataSources.registerOperationHandler("flush-idle-connection-in-pool", (OperationStepHandler)PoolOperations.FlushIdleConnectionInPool.DS_INSTANCE, DataSourcesSubsystemProviders.FLUSH_IDLE_CONNECTION_DESC, false);
        xaDataSources.registerOperationHandler("flush-all-connection-in-pool", (OperationStepHandler)PoolOperations.FlushAllConnectionInPool.DS_INSTANCE, DataSourcesSubsystemProviders.FLUSH_ALL_CONNECTION_DESC, false);
        xaDataSources.registerOperationHandler("test-connection-in-pool", (OperationStepHandler)PoolOperations.TestConnectionInPool.DS_INSTANCE, DataSourcesSubsystemProviders.TEST_CONNECTION_DESC, false);
        ManagementResourceRegistration xadatasourcePropertyAdapter = xaDataSources.registerSubModel(PathElement.pathElement((String)Constants.XADATASOURCE_PROPERTIES.getName()), DataSourcesSubsystemProviders.XADATASOURCE_PROPERTIES_DESC);
        xadatasourcePropertyAdapter.registerOperationHandler("add", (OperationStepHandler)XaDataSourcePropertyAdd.INSTANCE, DataSourcesSubsystemProviders.ADD_XADATASOURCE_PROPERTIES_DESC, false);
        xadatasourcePropertyAdapter.registerOperationHandler("remove", (OperationStepHandler)XaDataSourcePropertyRemove.INSTANCE, DataSourcesSubsystemProviders.REMOVE_XADATASOURCE_PROPERTIES_DESC, false);
        for (String attributeName : PoolMetrics.ATTRIBUTES) {
            xaDataSources.registerMetric(attributeName, (OperationStepHandler)PoolMetrics.LocalAndXaDataSourcePoolMetricsHandler.INSTANCE);
        }
        for (String attributeName : LocalAndXaDataSourcesJdbcMetrics.ATTRIBUTES) {
            xaDataSources.registerMetric(attributeName, (OperationStepHandler)LocalAndXaDataSourcesJdbcMetrics.INSTANCE);
        }
        for (SimpleAttributeDefinition attribute : DataSourcesSubsystemProviders.XA_DATASOURCE_ATTRIBUTE) {
            if (PoolConfigurationRWHandler.ATTRIBUTES.contains(attribute.getName())) {
                xaDataSources.registerReadWriteAttribute(attribute.getName(), (OperationStepHandler)PoolConfigurationRWHandler.PoolConfigurationReadHandler.INSTANCE, (OperationStepHandler)PoolConfigurationRWHandler.LocalAndXaDataSourcePoolConfigurationWriteHandler.INSTANCE, AttributeAccess.Storage.CONFIGURATION);
                continue;
            }
            xaDataSources.registerReadWriteAttribute(attribute.getName(), null, (OperationStepHandler)new DisableRequiredWriteAttributeHandler((AttributeDefinition[])DataSourcesSubsystemProviders.XA_DATASOURCE_ATTRIBUTE), AttributeAccess.Storage.CONFIGURATION);
        }
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(Namespace.CURRENT.getUriString(), (XMLElementReader)NewDataSourceSubsystemParser.INSTANCE);
    }

    private static class DataSourcesSubsystemDescribeHandler
    implements OperationStepHandler,
    DescriptionProvider {
        static final DataSourcesSubsystemDescribeHandler INSTANCE = new DataSourcesSubsystemDescribeHandler();

        private DataSourcesSubsystemDescribeHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            ModelNode enableOperation;
            ModelNode addPropOperation;
            ModelNode propAdrress;
            ModelNode dataSource;
            ModelNode addOperation;
            ModelNode address;
            ModelNode result = context.getResult();
            PathAddress rootAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement()});
            ModelNode subModel = context.readModel(PathAddress.EMPTY_ADDRESS);
            ModelNode subsystemAdd = new ModelNode();
            subsystemAdd.get("operation").set("add");
            subsystemAdd.get("address").set(rootAddress.toModelNode());
            result.add(subsystemAdd);
            if (subModel.hasDefined("jdbc-driver")) {
                for (Property jdbcDriver : subModel.get("jdbc-driver").asPropertyList()) {
                    address = rootAddress.toModelNode();
                    address.add("jdbc-driver", jdbcDriver.getName());
                    addOperation = Util.getEmptyOperation((String)"add", (ModelNode)address);
                    addOperation.get(Constants.DRIVER_NAME.getName()).set(jdbcDriver.getValue().get(Constants.DRIVER_NAME.getName()));
                    addOperation.get(Constants.DRIVER_MODULE_NAME.getName()).set(jdbcDriver.getValue().get(Constants.DRIVER_MODULE_NAME.getName()));
                    addOperation.get(Constants.DRIVER_MAJOR_VERSION.getName()).set(jdbcDriver.getValue().get(Constants.DRIVER_MAJOR_VERSION.getName()));
                    addOperation.get(Constants.DRIVER_MINOR_VERSION.getName()).set(jdbcDriver.getValue().get(Constants.DRIVER_MINOR_VERSION.getName()));
                    addOperation.get(Constants.DRIVER_CLASS_NAME.getName()).set(jdbcDriver.getValue().get(Constants.DRIVER_CLASS_NAME.getName()));
                    addOperation.get(Constants.DRIVER_DATASOURCE_CLASS_NAME.getName()).set(jdbcDriver.getValue().get(Constants.DRIVER_DATASOURCE_CLASS_NAME.getName()));
                    addOperation.get(Constants.DRIVER_XA_DATASOURCE_CLASS_NAME.getName()).set(jdbcDriver.getValue().get(Constants.DRIVER_XA_DATASOURCE_CLASS_NAME.getName()));
                    result.add(addOperation);
                }
            }
            if (subModel.hasDefined("data-source")) {
                for (Property dataSourceProp : subModel.get("data-source").asPropertyList()) {
                    address = rootAddress.toModelNode();
                    address.add("data-source", dataSourceProp.getName());
                    addOperation = Util.getEmptyOperation((String)"add", (ModelNode)address);
                    dataSource = dataSourceProp.getValue();
                    AbstractDataSourceAdd.populateAddModel(dataSource, addOperation, Constants.CONNECTION_PROPERTIES.getName(), DataSourcesSubsystemProviders.DATASOURCE_ATTRIBUTE);
                    addOperation.get(Constants.DATASOURCE_DRIVER.getName()).set(dataSourceProp.getValue().get(Constants.DATASOURCE_DRIVER.getName()));
                    result.add(addOperation);
                    if (dataSource.hasDefined(Constants.CONNECTION_PROPERTIES.getName())) {
                        for (Property prop : dataSource.get(Constants.CONNECTION_PROPERTIES.getName()).asPropertyList()) {
                            propAdrress = address.clone();
                            propAdrress.add(Constants.CONNECTION_PROPERTIES.getName(), prop.getName());
                            addPropOperation = Util.getEmptyOperation((String)"add", (ModelNode)propAdrress);
                            addPropOperation.get(Constants.CONNECTION_PROPERTIES.getName()).set(prop.getValue().get("value").asString());
                            result.add(addPropOperation);
                        }
                    }
                    if (dataSource.hasDefined(Constants.ENABLED.getName()) && !dataSource.get(Constants.ENABLED.getName()).asBoolean()) continue;
                    enableOperation = new ModelNode();
                    enableOperation.get("operation").set("enable");
                    enableOperation.get("address").set(address);
                    enableOperation.get("persistent").set(dataSource.hasDefined(Constants.ENABLED.getName()));
                    result.add(enableOperation);
                }
            }
            if (subModel.hasDefined("xa-data-source")) {
                for (Property dataSourceProp : subModel.get("xa-data-source").asPropertyList()) {
                    address = rootAddress.toModelNode();
                    address.add("xa-data-source", dataSourceProp.getName());
                    addOperation = Util.getEmptyOperation((String)"add", (ModelNode)address);
                    dataSource = dataSourceProp.getValue();
                    AbstractDataSourceAdd.populateAddModel(dataSource, addOperation, Constants.XADATASOURCE_PROPERTIES.getName(), DataSourcesSubsystemProviders.XA_DATASOURCE_ATTRIBUTE);
                    addOperation.get(Constants.DATASOURCE_DRIVER.getName()).set(dataSourceProp.getValue().get(Constants.DATASOURCE_DRIVER.getName()));
                    result.add(addOperation);
                    if (dataSource.hasDefined(Constants.XADATASOURCE_PROPERTIES.getName())) {
                        for (Property prop : dataSource.get(Constants.XADATASOURCE_PROPERTIES.getName()).asPropertyList()) {
                            propAdrress = address.clone();
                            propAdrress.add(Constants.XADATASOURCE_PROPERTIES.getName(), prop.getName());
                            addPropOperation = Util.getEmptyOperation((String)"add", (ModelNode)propAdrress);
                            addPropOperation.get(Constants.XADATASOURCE_PROPERTY_VALUE.getName()).set(prop.getValue().get("value").asString());
                            result.add(addPropOperation);
                        }
                    }
                    if (dataSource.hasDefined(Constants.ENABLED.getName()) && !dataSource.get(Constants.ENABLED.getName()).asBoolean()) continue;
                    enableOperation = new ModelNode();
                    enableOperation.get("operation").set("enable");
                    enableOperation.get("address").set(address);
                    enableOperation.get("persistent").set(dataSource.hasDefined(Constants.ENABLED.getName()));
                    result.add(enableOperation);
                }
            }
            context.completeStep();
        }

        public ModelNode getModelDescription(Locale locale) {
            return CommonDescriptions.getSubsystemDescribeOperation((Locale)locale);
        }
    }

    public static final class NewDataSourceSubsystemParser
    implements XMLStreamConstants,
    XMLElementReader<List<ModelNode>>,
    XMLElementWriter<SubsystemMarshallingContext> {
        static final NewDataSourceSubsystemParser INSTANCE = new NewDataSourceSubsystemParser();

        public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
            context.startSubsystemElement(Namespace.CURRENT.getUriString(), false);
            ModelNode node = context.getModelNode();
            writer.writeStartElement(DataSourcesExtension.SUBSYSTEM_NAME);
            if (node.hasDefined("data-source") || node.hasDefined("xa-data-source")) {
                List propertyList;
                List list = propertyList = node.hasDefined("data-source") ? node.get("data-source").asPropertyList() : new LinkedList();
                if (node.hasDefined("xa-data-source")) {
                    propertyList.addAll(node.get("xa-data-source").asPropertyList());
                }
                for (Property property : propertyList) {
                    boolean statementRequired;
                    boolean timeoutRequired;
                    boolean validationRequired;
                    boolean recoveryRequired;
                    boolean securityRequired;
                    boolean poolRequired;
                    ModelNode dataSourceNode = property.getValue();
                    boolean isXADataSource = this.hasAnyOf(dataSourceNode, Constants.XA_RESOURCE_TIMEOUT, Constants.XADATASOURCECLASS, Constants.XADATASOURCE_PROPERTIES);
                    writer.writeStartElement(isXADataSource ? DataSources.Tag.XA_DATASOURCE.getLocalName() : DataSources.Tag.DATASOURCE.getLocalName());
                    Constants.JNDINAME.marshallAsAttribute(dataSourceNode, false, (XMLStreamWriter)writer);
                    Constants.POOLNAME.marshallAsAttribute(dataSourceNode, false, (XMLStreamWriter)writer);
                    Constants.ENABLED.marshallAsAttribute(dataSourceNode, (XMLStreamWriter)writer);
                    Constants.JTA.marshallAsAttribute(dataSourceNode, false, (XMLStreamWriter)writer);
                    Constants.USE_JAVA_CONTEXT.marshallAsAttribute(dataSourceNode, false, (XMLStreamWriter)writer);
                    Constants.SPY.marshallAsAttribute(dataSourceNode, false, (XMLStreamWriter)writer);
                    Constants.USE_CCM.marshallAsAttribute(dataSourceNode, false, (XMLStreamWriter)writer);
                    if (!isXADataSource) {
                        Constants.CONNECTION_URL.marshallAsElement(dataSourceNode, false, (XMLStreamWriter)writer);
                        Constants.DRIVER_CLASS.marshallAsElement(dataSourceNode, false, (XMLStreamWriter)writer);
                        Constants.DATASOURCE_CLASS.marshallAsElement(dataSourceNode, false, (XMLStreamWriter)writer);
                        if (dataSourceNode.hasDefined(Constants.CONNECTION_PROPERTIES.getName())) {
                            for (Property connectionProperty : dataSourceNode.get(Constants.CONNECTION_PROPERTIES.getName()).asPropertyList()) {
                                this.writeProperty(writer, dataSourceNode, connectionProperty.getName(), connectionProperty.getValue().get("value").asString(), DataSource.Tag.CONNECTION_PROPERTY.getLocalName());
                            }
                        }
                    }
                    if (isXADataSource) {
                        if (dataSourceNode.hasDefined(Constants.XADATASOURCE_PROPERTIES.getName())) {
                            for (Property prop : dataSourceNode.get(Constants.XADATASOURCE_PROPERTIES.getName()).asPropertyList()) {
                                this.writeProperty(writer, dataSourceNode, prop.getName(), prop.getValue().get("value").asString(), XaDataSource.Tag.XA_DATASOURCE_PROPERTY.getLocalName());
                            }
                        }
                        Constants.XADATASOURCECLASS.marshallAsElement(dataSourceNode, false, (XMLStreamWriter)writer);
                    }
                    Constants.DATASOURCE_DRIVER.marshallAsElement(dataSourceNode, false, (XMLStreamWriter)writer);
                    if (isXADataSource) {
                        Constants.URL_DELIMITER.marshallAsElement(dataSourceNode, false, (XMLStreamWriter)writer);
                        Constants.URL_SELECTOR_STRATEGY_CLASS_NAME.marshallAsElement(dataSourceNode, false, (XMLStreamWriter)writer);
                    }
                    Constants.NEW_CONNECTION_SQL.marshallAsElement(dataSourceNode, false, (XMLStreamWriter)writer);
                    Constants.TRANSACTION_ISOLATION.marshallAsElement(dataSourceNode, false, (XMLStreamWriter)writer);
                    if (!isXADataSource) {
                        Constants.URL_DELIMITER.marshallAsElement(dataSourceNode, false, (XMLStreamWriter)writer);
                        Constants.URL_SELECTOR_STRATEGY_CLASS_NAME.marshallAsElement(dataSourceNode, false, (XMLStreamWriter)writer);
                    }
                    boolean bl = poolRequired = org.jboss.as.connector.pool.Constants.MIN_POOL_SIZE.isMarshallable(dataSourceNode, false) || org.jboss.as.connector.pool.Constants.MAX_POOL_SIZE.isMarshallable(dataSourceNode, false) || org.jboss.as.connector.pool.Constants.POOL_PREFILL.isMarshallable(dataSourceNode, false) || org.jboss.as.connector.pool.Constants.POOL_USE_STRICT_MIN.isMarshallable(dataSourceNode, false) || org.jboss.as.connector.pool.Constants.POOL_FLUSH_STRATEGY.isMarshallable(dataSourceNode, false);
                    if (isXADataSource) {
                        boolean bl2 = poolRequired = poolRequired || Constants.SAME_RM_OVERRIDE.isMarshallable(dataSourceNode, false) || Constants.INTERLEAVING.isMarshallable(dataSourceNode, false) || Constants.NOTXSEPARATEPOOL.isMarshallable(dataSourceNode, false) || Constants.PAD_XID.isMarshallable(dataSourceNode, false) || Constants.WRAP_XA_RESOURCE.isMarshallable(dataSourceNode, false);
                    }
                    if (poolRequired) {
                        writer.writeStartElement(isXADataSource ? XaDataSource.Tag.XA_POOL.getLocalName() : DataSource.Tag.POOL.getLocalName());
                        org.jboss.as.connector.pool.Constants.MIN_POOL_SIZE.marshallAsElement(dataSourceNode, false, (XMLStreamWriter)writer);
                        org.jboss.as.connector.pool.Constants.MAX_POOL_SIZE.marshallAsElement(dataSourceNode, false, (XMLStreamWriter)writer);
                        org.jboss.as.connector.pool.Constants.POOL_PREFILL.marshallAsElement(dataSourceNode, false, (XMLStreamWriter)writer);
                        org.jboss.as.connector.pool.Constants.POOL_USE_STRICT_MIN.marshallAsElement(dataSourceNode, false, (XMLStreamWriter)writer);
                        org.jboss.as.connector.pool.Constants.POOL_FLUSH_STRATEGY.marshallAsElement(dataSourceNode, false, (XMLStreamWriter)writer);
                        if (isXADataSource) {
                            Constants.SAME_RM_OVERRIDE.marshallAsElement(dataSourceNode, false, (XMLStreamWriter)writer);
                            Constants.INTERLEAVING.marshallAsElement(dataSourceNode, false, (XMLStreamWriter)writer);
                            Constants.NOTXSEPARATEPOOL.marshallAsElement(dataSourceNode, false, (XMLStreamWriter)writer);
                            Constants.PAD_XID.marshallAsElement(dataSourceNode, false, (XMLStreamWriter)writer);
                            Constants.WRAP_XA_RESOURCE.marshallAsElement(dataSourceNode, false, (XMLStreamWriter)writer);
                        }
                        writer.writeEndElement();
                    }
                    boolean bl3 = securityRequired = Constants.USERNAME.isMarshallable(dataSourceNode, false) || Constants.PASSWORD.isMarshallable(dataSourceNode, false) || Constants.SECURITY_DOMAIN.isMarshallable(dataSourceNode, false) || Constants.REAUTHPLUGIN_CLASSNAME.isMarshallable(dataSourceNode, false) || Constants.REAUTHPLUGIN_PROPERTIES.isMarshallable(dataSourceNode, false);
                    if (securityRequired) {
                        writer.writeStartElement(DataSource.Tag.SECURITY.getLocalName());
                        Constants.USERNAME.marshallAsElement(dataSourceNode, false, (XMLStreamWriter)writer);
                        Constants.PASSWORD.marshallAsElement(dataSourceNode, false, (XMLStreamWriter)writer);
                        Constants.SECURITY_DOMAIN.marshallAsElement(dataSourceNode, false, (XMLStreamWriter)writer);
                        if (dataSourceNode.hasDefined(Constants.REAUTHPLUGIN_CLASSNAME.getName())) {
                            writer.writeStartElement(DsSecurity.Tag.REAUTH_PLUGIN.getLocalName());
                            writer.writeAttribute(Extension.Attribute.CLASS_NAME.getLocalName(), dataSourceNode.get(Constants.REAUTHPLUGIN_CLASSNAME.getName()).asString());
                            if (dataSourceNode.hasDefined(Constants.REAUTHPLUGIN_PROPERTIES.getName())) {
                                for (Property connectionProperty : dataSourceNode.get(Constants.REAUTHPLUGIN_PROPERTIES.getName()).asPropertyList()) {
                                    this.writeProperty(writer, dataSourceNode, connectionProperty.getName(), connectionProperty.getValue().asString(), Extension.Tag.CONFIG_PROPERTY.getLocalName());
                                }
                            }
                            writer.writeEndElement();
                        }
                        writer.writeEndElement();
                    }
                    boolean bl4 = recoveryRequired = Constants.RECOVERY_USERNAME.isMarshallable(dataSourceNode, false) || Constants.RECOVERY_PASSWORD.isMarshallable(dataSourceNode, false) || Constants.RECOVERY_SECURITY_DOMAIN.isMarshallable(dataSourceNode, false) || Constants.RECOVERLUGIN_CLASSNAME.isMarshallable(dataSourceNode, false) || Constants.NO_RECOVERY.isMarshallable(dataSourceNode, false) || Constants.RECOVERLUGIN_PROPERTIES.isMarshallable(dataSourceNode, false);
                    if (recoveryRequired) {
                        writer.writeStartElement(XaDataSource.Tag.RECOVERY.getLocalName());
                        Constants.NO_RECOVERY.marshallAsAttribute(dataSourceNode, false, (XMLStreamWriter)writer);
                        if (this.hasAnyOf(dataSourceNode, Constants.RECOVERY_USERNAME, Constants.RECOVERY_PASSWORD, Constants.RECOVERY_SECURITY_DOMAIN)) {
                            writer.writeStartElement(Recovery.Tag.RECOVER_CREDENTIAL.getLocalName());
                            Constants.RECOVERY_USERNAME.marshallAsElement(dataSourceNode, false, (XMLStreamWriter)writer);
                            Constants.RECOVERY_PASSWORD.marshallAsElement(dataSourceNode, false, (XMLStreamWriter)writer);
                            Constants.RECOVERY_SECURITY_DOMAIN.marshallAsElement(dataSourceNode, false, (XMLStreamWriter)writer);
                            writer.writeEndElement();
                        }
                        if (this.hasAnyOf(dataSourceNode, Constants.RECOVERLUGIN_CLASSNAME)) {
                            writer.writeStartElement(Recovery.Tag.RECOVER_PLUGIN.getLocalName());
                            writer.writeAttribute(Extension.Attribute.CLASS_NAME.getLocalName(), dataSourceNode.get(Constants.RECOVERLUGIN_CLASSNAME.getName()).asString());
                            if (dataSourceNode.hasDefined(Constants.RECOVERLUGIN_PROPERTIES.getName())) {
                                for (Property connectionProperty : dataSourceNode.get(Constants.RECOVERLUGIN_PROPERTIES.getName()).asPropertyList()) {
                                    this.writeProperty(writer, dataSourceNode, connectionProperty.getName(), connectionProperty.getValue().asString(), Extension.Tag.CONFIG_PROPERTY.getLocalName());
                                }
                            }
                            writer.writeEndElement();
                        }
                        writer.writeEndElement();
                    }
                    boolean bl5 = validationRequired = Constants.VALIDCONNECTIONCHECKERCLASSNAME.isMarshallable(dataSourceNode, false) || Constants.VALIDCONNECTIONCHECKER_PROPERTIES.isMarshallable(dataSourceNode, false) || Constants.CHECKVALIDCONNECTIONSQL.isMarshallable(dataSourceNode, false) || Constants.VALIDATEONMATCH.isMarshallable(dataSourceNode, false) || org.jboss.as.connector.pool.Constants.BACKGROUNDVALIDATION.isMarshallable(dataSourceNode, false) || org.jboss.as.connector.pool.Constants.BACKGROUNDVALIDATIONMILLIS.isMarshallable(dataSourceNode, false) || org.jboss.as.connector.pool.Constants.USE_FAST_FAIL.isMarshallable(dataSourceNode, false) || Constants.STALECONNECTIONCHECKERCLASSNAME.isMarshallable(dataSourceNode, false) || Constants.STALECONNECTIONCHECKER_PROPERTIES.isMarshallable(dataSourceNode, false) || Constants.EXCEPTIONSORTERCLASSNAME.isMarshallable(dataSourceNode, false) || Constants.EXCEPTIONSORTER_PROPERTIES.isMarshallable(dataSourceNode, false);
                    if (validationRequired) {
                        writer.writeStartElement(DataSource.Tag.VALIDATION.getLocalName());
                        if (dataSourceNode.hasDefined(Constants.VALIDCONNECTIONCHECKERCLASSNAME.getName())) {
                            writer.writeStartElement(Validation.Tag.VALID_CONNECTION_CHECKER.getLocalName());
                            writer.writeAttribute(Extension.Attribute.CLASS_NAME.getLocalName(), dataSourceNode.get(Constants.VALIDCONNECTIONCHECKERCLASSNAME.getName()).asString());
                            if (dataSourceNode.hasDefined(Constants.VALIDCONNECTIONCHECKER_PROPERTIES.getName())) {
                                for (Property connectionProperty : dataSourceNode.get(Constants.VALIDCONNECTIONCHECKER_PROPERTIES.getName()).asPropertyList()) {
                                    this.writeProperty(writer, dataSourceNode, connectionProperty.getName(), connectionProperty.getValue().asString(), Extension.Tag.CONFIG_PROPERTY.getLocalName());
                                }
                            }
                            writer.writeEndElement();
                        }
                        Constants.CHECKVALIDCONNECTIONSQL.marshallAsElement(dataSourceNode, false, (XMLStreamWriter)writer);
                        Constants.VALIDATEONMATCH.marshallAsElement(dataSourceNode, false, (XMLStreamWriter)writer);
                        org.jboss.as.connector.pool.Constants.BACKGROUNDVALIDATION.marshallAsElement(dataSourceNode, false, (XMLStreamWriter)writer);
                        org.jboss.as.connector.pool.Constants.BACKGROUNDVALIDATIONMILLIS.marshallAsElement(dataSourceNode, false, (XMLStreamWriter)writer);
                        org.jboss.as.connector.pool.Constants.USE_FAST_FAIL.marshallAsElement(dataSourceNode, false, (XMLStreamWriter)writer);
                        if (dataSourceNode.hasDefined(Constants.STALECONNECTIONCHECKERCLASSNAME.getName())) {
                            writer.writeStartElement(Validation.Tag.STALE_CONNECTION_CHECKER.getLocalName());
                            writer.writeAttribute(Extension.Attribute.CLASS_NAME.getLocalName(), dataSourceNode.get(Constants.STALECONNECTIONCHECKERCLASSNAME.getName()).asString());
                            if (dataSourceNode.hasDefined(Constants.STALECONNECTIONCHECKER_PROPERTIES.getName())) {
                                for (Property connectionProperty : dataSourceNode.get(Constants.STALECONNECTIONCHECKER_PROPERTIES.getName()).asPropertyList()) {
                                    this.writeProperty(writer, dataSourceNode, connectionProperty.getName(), connectionProperty.getValue().asString(), Extension.Tag.CONFIG_PROPERTY.getLocalName());
                                }
                            }
                            writer.writeEndElement();
                        }
                        if (dataSourceNode.hasDefined(Constants.EXCEPTIONSORTERCLASSNAME.getName())) {
                            writer.writeStartElement(Validation.Tag.EXCEPTION_SORTER.getLocalName());
                            writer.writeAttribute(Extension.Attribute.CLASS_NAME.getLocalName(), dataSourceNode.get(Constants.EXCEPTIONSORTERCLASSNAME.getName()).asString());
                            if (dataSourceNode.hasDefined(Constants.EXCEPTIONSORTER_PROPERTIES.getName())) {
                                for (Property connectionProperty : dataSourceNode.get(Constants.EXCEPTIONSORTER_PROPERTIES.getName()).asPropertyList()) {
                                    this.writeProperty(writer, dataSourceNode, connectionProperty.getName(), connectionProperty.getValue().asString(), Extension.Tag.CONFIG_PROPERTY.getLocalName());
                                }
                            }
                            writer.writeEndElement();
                        }
                        writer.writeEndElement();
                    }
                    boolean bl6 = timeoutRequired = org.jboss.as.connector.pool.Constants.BLOCKING_TIMEOUT_WAIT_MILLIS.isMarshallable(dataSourceNode, false) || org.jboss.as.connector.pool.Constants.IDLETIMEOUTMINUTES.isMarshallable(dataSourceNode, false) || Constants.SETTXQUERYTIMEOUT.isMarshallable(dataSourceNode, false) || Constants.QUERYTIMEOUT.isMarshallable(dataSourceNode, false) || Constants.USETRYLOCK.isMarshallable(dataSourceNode, false) || Constants.ALLOCATION_RETRY.isMarshallable(dataSourceNode, false) || Constants.ALLOCATION_RETRY_WAIT_MILLIS.isMarshallable(dataSourceNode, false) || Constants.XA_RESOURCE_TIMEOUT.isMarshallable(dataSourceNode, false);
                    if (timeoutRequired) {
                        writer.writeStartElement(DataSource.Tag.TIMEOUT.getLocalName());
                        org.jboss.as.connector.pool.Constants.BLOCKING_TIMEOUT_WAIT_MILLIS.marshallAsElement(dataSourceNode, false, (XMLStreamWriter)writer);
                        org.jboss.as.connector.pool.Constants.IDLETIMEOUTMINUTES.marshallAsElement(dataSourceNode, false, (XMLStreamWriter)writer);
                        Constants.SETTXQUERYTIMEOUT.marshallAsAttribute(dataSourceNode, false, (XMLStreamWriter)writer);
                        Constants.QUERYTIMEOUT.marshallAsElement(dataSourceNode, false, (XMLStreamWriter)writer);
                        Constants.USETRYLOCK.marshallAsElement(dataSourceNode, false, (XMLStreamWriter)writer);
                        Constants.ALLOCATION_RETRY.marshallAsElement(dataSourceNode, false, (XMLStreamWriter)writer);
                        Constants.ALLOCATION_RETRY_WAIT_MILLIS.marshallAsElement(dataSourceNode, false, (XMLStreamWriter)writer);
                        Constants.XA_RESOURCE_TIMEOUT.marshallAsElement(dataSourceNode, false, (XMLStreamWriter)writer);
                        writer.writeEndElement();
                    }
                    if (statementRequired = this.hasAnyOf(dataSourceNode, Constants.TRACKSTATEMENTS, Constants.PREPAREDSTATEMENTSCACHESIZE, Constants.SHAREPREPAREDSTATEMENTS)) {
                        writer.writeStartElement(DataSource.Tag.STATEMENT.getLocalName());
                        Constants.TRACKSTATEMENTS.marshallAsElement(dataSourceNode, false, (XMLStreamWriter)writer);
                        Constants.PREPAREDSTATEMENTSCACHESIZE.marshallAsElement(dataSourceNode, false, (XMLStreamWriter)writer);
                        Constants.SHAREPREPAREDSTATEMENTS.marshallAsElement(dataSourceNode, false, (XMLStreamWriter)writer);
                        writer.writeEndElement();
                    }
                    writer.writeEndElement();
                }
            }
            if (node.hasDefined("jdbc-driver")) {
                writer.writeStartElement(DataSources.Tag.DRIVERS.getLocalName());
                for (Property driverProperty : node.get("jdbc-driver").asPropertyList()) {
                    writer.writeStartElement(DataSources.Tag.DRIVER.getLocalName());
                    writer.writeAttribute(Driver.Attribute.NAME.getLocalName(), driverProperty.getValue().require(Constants.DRIVER_NAME.getName()).asString());
                    this.writeAttributeIfHas(writer, driverProperty.getValue(), Driver.Attribute.MODULE, Constants.DRIVER_MODULE_NAME.getName());
                    this.writeAttributeIfHas(writer, driverProperty.getValue(), Driver.Attribute.MAJOR_VERSION, Constants.DRIVER_MAJOR_VERSION.getName());
                    this.writeAttributeIfHas(writer, driverProperty.getValue(), Driver.Attribute.MINOR_VERSION, Constants.DRIVER_MINOR_VERSION.getName());
                    this.writeElementIfHas(writer, driverProperty.getValue(), Driver.Tag.DRIVER_CLASS.getLocalName(), Constants.DRIVER_CLASS_NAME.getName());
                    this.writeElementIfHas(writer, driverProperty.getValue(), Driver.Tag.XA_DATASOURCE_CLASS.getLocalName(), Constants.DRIVER_XA_DATASOURCE_CLASS_NAME.getName());
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
            writer.writeEndElement();
        }

        private void writeAttributeIfHas(XMLExtendedStreamWriter writer, ModelNode node, Recovery.Attribute attr, String identifier) throws XMLStreamException {
            if (this.has(node, identifier)) {
                writer.writeAttribute(attr.getLocalName(), node.get(identifier).asString());
            }
        }

        private void writeAttributeIfHas(XMLExtendedStreamWriter writer, ModelNode node, Driver.Attribute attr, String identifier) throws XMLStreamException {
            if (this.has(node, identifier)) {
                writer.writeAttribute(attr.getLocalName(), node.get(identifier).asString());
            }
        }

        private void writeAttributeIfHas(XMLExtendedStreamWriter writer, ModelNode node, DataSource.Attribute attr, String identifier) throws XMLStreamException {
            if (this.has(node, identifier)) {
                writer.writeAttribute(attr.getLocalName(), node.get(identifier).asString());
            }
        }

        private void writeProperty(XMLExtendedStreamWriter writer, ModelNode node, String name, String value, String localName) throws XMLStreamException {
            writer.writeStartElement(localName);
            writer.writeAttribute("name", name);
            writer.writeCharacters(value);
            writer.writeEndElement();
        }

        private void writeElementIfHas(XMLExtendedStreamWriter writer, ModelNode node, String localName, String identifier) throws XMLStreamException {
            if (this.has(node, identifier)) {
                writer.writeStartElement(localName);
                writer.writeCharacters(node.get(identifier).asString());
                writer.writeEndElement();
            }
        }

        private void writeElementIfHas(XMLExtendedStreamWriter writer, ModelNode node, XaDataSource.Tag element, String identifier) throws XMLStreamException {
            this.writeElementIfHas(writer, node, element.getLocalName(), identifier);
        }

        private void writeElementIfHas(XMLExtendedStreamWriter writer, ModelNode node, DataSource.Tag element, String identifier) throws XMLStreamException {
            this.writeElementIfHas(writer, node, element.getLocalName(), identifier);
        }

        private void writeElementIfHas(XMLExtendedStreamWriter writer, ModelNode node, DsSecurity.Tag element, String identifier) throws XMLStreamException {
            this.writeElementIfHas(writer, node, element.getLocalName(), identifier);
        }

        private void writeElementIfHas(XMLExtendedStreamWriter writer, ModelNode node, CommonPool.Tag element, String identifier) throws XMLStreamException {
            this.writeElementIfHas(writer, node, element.getLocalName(), identifier);
        }

        private void writeElementIfHas(XMLExtendedStreamWriter writer, ModelNode node, CommonXaPool.Tag element, String identifier) throws XMLStreamException {
            this.writeElementIfHas(writer, node, element.getLocalName(), identifier);
        }

        private void writeElementIfHas(XMLExtendedStreamWriter writer, ModelNode node, TimeOut.Tag element, String identifier) throws XMLStreamException {
            this.writeElementIfHas(writer, node, element.getLocalName(), identifier);
        }

        private void writeElementIfHas(XMLExtendedStreamWriter writer, ModelNode node, Validation.Tag element, String identifier) throws XMLStreamException {
            this.writeElementIfHas(writer, node, element.getLocalName(), identifier);
        }

        private void writeElementIfHas(XMLExtendedStreamWriter writer, ModelNode node, Statement.Tag element, String identifier) throws XMLStreamException {
            this.writeElementIfHas(writer, node, element.getLocalName(), identifier);
        }

        private void writeEmptyElementIfHasAndTrue(XMLExtendedStreamWriter writer, ModelNode node, String localName, String identifier) throws XMLStreamException {
            if (node.has(identifier) && node.get(identifier).asBoolean()) {
                writer.writeEmptyElement(localName);
            }
        }

        private void writeEmptyElementIfHasAndTrue(XMLExtendedStreamWriter writer, ModelNode node, Statement.Tag element, String identifier) throws XMLStreamException {
            this.writeEmptyElementIfHasAndTrue(writer, node, element.getLocalName(), identifier);
        }

        private void writeEmptyElementIfHasAndTrue(XMLExtendedStreamWriter writer, ModelNode node, CommonXaPool.Tag element, String identifier) throws XMLStreamException {
            this.writeEmptyElementIfHasAndTrue(writer, node, element.getLocalName(), identifier);
        }

        private void writeEmptyElementIfHasAndTrue(XMLExtendedStreamWriter writer, ModelNode node, TimeOut.Tag element, String identifier) throws XMLStreamException {
            this.writeEmptyElementIfHasAndTrue(writer, node, element.getLocalName(), identifier);
        }

        private boolean hasAnyOf(ModelNode node, SimpleAttributeDefinition ... names) {
            for (SimpleAttributeDefinition current : names) {
                if (!this.has(node, current.getName())) continue;
                return true;
            }
            return false;
        }

        private boolean has(ModelNode node, String name) {
            return node.has(name) && node.get(name).isDefined();
        }

        public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
            ModelNode address = new ModelNode();
            address.add("subsystem", DataSourcesExtension.SUBSYSTEM_NAME);
            address.protect();
            ModelNode subsystem = new ModelNode();
            subsystem.get("operation").set("add");
            subsystem.get("address").set(address);
            list.add(subsystem);
            try {
                String localName = null;
                block1 : switch (Namespace.forUri(reader.getNamespaceURI())) {
                    case DATASOURCES_1_0: {
                        localName = reader.getLocalName();
                        Element element = Element.forName(reader.getLocalName());
                        ConnectorLogger.SUBSYSTEM_DATASOURCES_LOGGER.tracef("%s -> %s", localName, (Object)element);
                        switch (element) {
                            case SUBSYSTEM: {
                                DsParser parser = new DsParser();
                                parser.parse(reader, list, address);
                                ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                                break block1;
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new XMLStreamException(e);
            }
        }
    }
}

