/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.resourceadapters;

import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.connector.subsystems.resourceadapters.Constants;
import org.jboss.as.connector.util.AbstractParser;
import org.jboss.as.connector.util.ParserException;
import org.jboss.dmr.ModelNode;
import org.jboss.jca.common.CommonBundle;
import org.jboss.jca.common.api.metadata.common.CommonAdminObject;
import org.jboss.jca.common.api.metadata.common.CommonConnDef;
import org.jboss.jca.common.api.metadata.common.CommonPool;
import org.jboss.jca.common.api.metadata.common.CommonSecurity;
import org.jboss.jca.common.api.metadata.common.CommonTimeOut;
import org.jboss.jca.common.api.metadata.common.CommonValidation;
import org.jboss.jca.common.api.metadata.common.CommonXaPool;
import org.jboss.jca.common.api.metadata.common.Credential;
import org.jboss.jca.common.api.metadata.common.Recovery;
import org.jboss.jca.common.api.metadata.ds.DataSource;
import org.jboss.jca.common.api.metadata.ds.XaDataSource;
import org.jboss.jca.common.api.metadata.resourceadapter.ResourceAdapter;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.logging.Messages;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public abstract class CommonIronJacamarParser
extends AbstractParser {
    private static CommonBundle bundle = (CommonBundle)Messages.getBundle(CommonBundle.class);

    protected void parseConfigProperties(XMLExtendedStreamReader reader, Map<String, ModelNode> map) throws XMLStreamException {
        String name = this.rawAttributeText((XMLStreamReader)reader, "name");
        ModelNode operation = new ModelNode();
        operation.get("operation").set("add");
        String value = this.rawElementText((XMLStreamReader)reader);
        Constants.CONFIG_PROPERTY_VALUE.parseAndSetParameter(value, operation, reader.getLocation());
        map.put(name, operation);
    }

    protected void parseConnectionDefinitions(XMLExtendedStreamReader reader, Map<String, ModelNode> map, Map<String, HashMap<String, ModelNode>> configMap) throws XMLStreamException, ParserException, ValidateException {
        ModelNode connectionDefinitionNode = new ModelNode();
        connectionDefinitionNode.get("operation").set("add");
        String jndiName = null;
        int attributeSize = reader.getAttributeCount();
        boolean isXa = Boolean.FALSE;
        boolean poolDefined = Boolean.FALSE;
        block21: for (int i = 0; i < attributeSize; ++i) {
            CommonConnDef.Attribute attribute = CommonConnDef.Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    Location location = reader.getLocation();
                    String value = this.rawAttributeText((XMLStreamReader)reader, Constants.ENABLED.getXmlName());
                    Constants.ENABLED.parseAndSetParameter(value, connectionDefinitionNode, location);
                    continue block21;
                }
                case JNDI_NAME: {
                    Location location = reader.getLocation();
                    jndiName = this.rawAttributeText((XMLStreamReader)reader, Constants.JNDINAME.getXmlName());
                    Constants.JNDINAME.parseAndSetParameter(jndiName, connectionDefinitionNode, location);
                    continue block21;
                }
                case POOL_NAME: {
                    Location location = reader.getLocation();
                    String value = this.rawAttributeText((XMLStreamReader)reader, Constants.POOL_NAME.getXmlName());
                    Constants.POOL_NAME.parseAndSetParameter(value, connectionDefinitionNode, location);
                    continue block21;
                }
                case USE_JAVA_CONTEXT: {
                    Location location = reader.getLocation();
                    String value = this.rawAttributeText((XMLStreamReader)reader, Constants.USE_JAVA_CONTEXT.getXmlName());
                    Constants.USE_JAVA_CONTEXT.parseAndSetParameter(value, connectionDefinitionNode, location);
                    continue block21;
                }
                case USE_CCM: {
                    Location location = reader.getLocation();
                    String value = this.rawAttributeText((XMLStreamReader)reader, Constants.USE_CCM.getXmlName());
                    Constants.USE_CCM.parseAndSetParameter(value, connectionDefinitionNode, location);
                    continue block21;
                }
                case CLASS_NAME: {
                    Location location = reader.getLocation();
                    String value = this.rawAttributeText((XMLStreamReader)reader, Constants.CLASS_NAME.getXmlName());
                    Constants.CLASS_NAME.parseAndSetParameter(value, connectionDefinitionNode, location);
                    continue block21;
                }
            }
        }
        if (jndiName == null || jndiName.trim().equals("")) {
            throw new ParserException(bundle.missingJndiName(reader.getLocalName()));
        }
        while (reader.hasNext()) {
            block8 : switch (reader.nextTag()) {
                case 2: {
                    if (ResourceAdapter.Tag.forName((String)reader.getLocalName()) == ResourceAdapter.Tag.CONNECTION_DEFINITION) {
                        map.put(jndiName, connectionDefinitionNode);
                        return;
                    }
                    if (CommonConnDef.Tag.forName((String)reader.getLocalName()) != CommonConnDef.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (CommonConnDef.Tag.forName((String)reader.getLocalName())) {
                        case CONFIG_PROPERTY: {
                            if (!configMap.containsKey(jndiName)) {
                                configMap.put(jndiName, new HashMap(0));
                            }
                            this.parseConfigProperties(reader, (Map<String, ModelNode>)configMap.get(jndiName));
                            break block8;
                        }
                        case SECURITY: {
                            this.parseSecuritySettings(reader, connectionDefinitionNode);
                            break block8;
                        }
                        case TIMEOUT: {
                            this.parseTimeOut(reader, isXa, connectionDefinitionNode);
                            break block8;
                        }
                        case VALIDATION: {
                            this.parseValidation(reader, connectionDefinitionNode);
                            break block8;
                        }
                        case XA_POOL: {
                            if (poolDefined) {
                                throw new ParserException(bundle.multiplePools());
                            }
                            this.parseXaPool(reader, connectionDefinitionNode);
                            isXa = true;
                            poolDefined = true;
                            break block8;
                        }
                        case POOL: {
                            if (poolDefined) {
                                throw new ParserException(bundle.multiplePools());
                            }
                            this.parsePool(reader, connectionDefinitionNode);
                            poolDefined = true;
                            break block8;
                        }
                        case RECOVERY: {
                            this.parseRecovery(reader, connectionDefinitionNode);
                            break block8;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private void parseValidation(XMLExtendedStreamReader reader, ModelNode node) throws XMLStreamException, ParserException {
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (CommonConnDef.Tag.forName((String)reader.getLocalName()) == CommonConnDef.Tag.VALIDATION) {
                        return;
                    }
                    if (CommonValidation.Tag.forName((String)reader.getLocalName()) != CommonValidation.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (CommonValidation.Tag.forName((String)reader.getLocalName())) {
                        case BACKGROUND_VALIDATION: {
                            Location location = reader.getLocation();
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.pool.Constants.BACKGROUNDVALIDATION.parseAndSetParameter(value, node, location);
                            break block0;
                        }
                        case BACKGROUND_VALIDATION_MILLIS: {
                            Location location = reader.getLocation();
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.pool.Constants.BACKGROUNDVALIDATIONMILLIS.parseAndSetParameter(value, node, location);
                            break block0;
                        }
                        case USE_FAST_FAIL: {
                            Location location = reader.getLocation();
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.pool.Constants.USE_FAST_FAIL.parseAndSetParameter(value, node, location);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private void parseTimeOut(XMLExtendedStreamReader reader, Boolean isXa, ModelNode node) throws XMLStreamException, ParserException, ValidateException {
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (CommonConnDef.Tag.forName((String)reader.getLocalName()) == CommonConnDef.Tag.TIMEOUT) {
                        return;
                    }
                    if (CommonTimeOut.Tag.forName((String)reader.getLocalName()) != CommonTimeOut.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (CommonTimeOut.Tag.forName((String)reader.getLocalName())) {
                        case ALLOCATION_RETRY: {
                            Location location = reader.getLocation();
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.ALLOCATION_RETRY.parseAndSetParameter(value, node, location);
                            break block0;
                        }
                        case ALLOCATION_RETRY_WAIT_MILLIS: {
                            Location location = reader.getLocation();
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.ALLOCATION_RETRY_WAIT_MILLIS.parseAndSetParameter(value, node, location);
                            break block0;
                        }
                        case BLOCKING_TIMEOUT_MILLIS: {
                            Location location = reader.getLocation();
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.pool.Constants.BLOCKING_TIMEOUT_WAIT_MILLIS.parseAndSetParameter(value, node, location);
                            break block0;
                        }
                        case IDLE_TIMEOUT_MINUTES: {
                            Location location = reader.getLocation();
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.pool.Constants.IDLETIMEOUTMINUTES.parseAndSetParameter(value, node, location);
                            break block0;
                        }
                        case XA_RESOURCE_TIMEOUT: {
                            Location location = reader.getLocation();
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.XA_RESOURCE_TIMEOUT.parseAndSetParameter(value, node, location);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    protected void parseAdminObjects(XMLExtendedStreamReader reader, Map<String, ModelNode> map, Map<String, HashMap<String, ModelNode>> configMap) throws XMLStreamException, ParserException, ValidateException {
        ModelNode adminObjectNode = new ModelNode();
        adminObjectNode.get("operation").set("add");
        int attributeSize = reader.getAttributeCount();
        String jndiName = null;
        block14: for (int i = 0; i < attributeSize; ++i) {
            CommonAdminObject.Attribute attribute = CommonAdminObject.Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    Location location = reader.getLocation();
                    String value = this.rawAttributeText((XMLStreamReader)reader, Constants.ENABLED.getXmlName());
                    Constants.ENABLED.parseAndSetParameter(value, adminObjectNode, location);
                    continue block14;
                }
                case JNDI_NAME: {
                    Location location = reader.getLocation();
                    jndiName = this.rawAttributeText((XMLStreamReader)reader, Constants.JNDINAME.getXmlName());
                    Constants.JNDINAME.parseAndSetParameter(jndiName, adminObjectNode, location);
                    continue block14;
                }
                case POOL_NAME: {
                    Location location = reader.getLocation();
                    String value = this.rawAttributeText((XMLStreamReader)reader, Constants.POOL_NAME.getXmlName());
                    Constants.POOL_NAME.parseAndSetParameter(value, adminObjectNode, location);
                    continue block14;
                }
                case USE_JAVA_CONTEXT: {
                    Location location = reader.getLocation();
                    String value = this.rawAttributeText((XMLStreamReader)reader, Constants.USE_JAVA_CONTEXT.getXmlName());
                    Constants.USE_JAVA_CONTEXT.parseAndSetParameter(value, adminObjectNode, location);
                    continue block14;
                }
                case CLASS_NAME: {
                    Location location = reader.getLocation();
                    String value = this.rawAttributeText((XMLStreamReader)reader, Constants.CLASS_NAME.getXmlName());
                    Constants.CLASS_NAME.parseAndSetParameter(value, adminObjectNode, location);
                    continue block14;
                }
                default: {
                    throw new ParserException(bundle.unexpectedAttribute(attribute.getLocalName(), reader.getLocalName()));
                }
            }
        }
        if (jndiName == null || jndiName.trim().equals("")) {
            throw new ParserException(bundle.missingJndiName(reader.getLocalName()));
        }
        while (reader.hasNext()) {
            block7 : switch (reader.nextTag()) {
                case 2: {
                    if (ResourceAdapter.Tag.forName((String)reader.getLocalName()) == ResourceAdapter.Tag.ADMIN_OBJECT) {
                        map.put(jndiName, adminObjectNode);
                        return;
                    }
                    if (CommonAdminObject.Tag.forName((String)reader.getLocalName()) != CommonAdminObject.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (CommonAdminObject.Tag.forName((String)reader.getLocalName())) {
                        case CONFIG_PROPERTY: {
                            if (!configMap.containsKey(jndiName)) {
                                configMap.put(jndiName, new HashMap(0));
                            }
                            this.parseConfigProperties(reader, (Map<String, ModelNode>)configMap.get(jndiName));
                            break block7;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    protected void parseXaPool(XMLExtendedStreamReader reader, ModelNode node) throws XMLStreamException, ParserException, ValidateException {
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (XaDataSource.Tag.forName((String)reader.getLocalName()) == XaDataSource.Tag.XA_POOL) {
                        return;
                    }
                    if (CommonXaPool.Tag.forName((String)reader.getLocalName()) != CommonXaPool.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (CommonXaPool.Tag.forName((String)reader.getLocalName())) {
                        case MAX_POOL_SIZE: {
                            Location location = reader.getLocation();
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.pool.Constants.MAX_POOL_SIZE.parseAndSetParameter(value, node, location);
                            break block0;
                        }
                        case MIN_POOL_SIZE: {
                            Location location = reader.getLocation();
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.pool.Constants.MIN_POOL_SIZE.parseAndSetParameter(value, node, location);
                            break block0;
                        }
                        case PREFILL: {
                            Location location = reader.getLocation();
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.pool.Constants.POOL_PREFILL.parseAndSetParameter(value, node, location);
                            break block0;
                        }
                        case USE_STRICT_MIN: {
                            Location location = reader.getLocation();
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.pool.Constants.POOL_USE_STRICT_MIN.parseAndSetParameter(value, node, location);
                            break block0;
                        }
                        case FLUSH_STRATEGY: {
                            Location location = reader.getLocation();
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.pool.Constants.POOL_FLUSH_STRATEGY.parseAndSetParameter(value, node, location);
                            break block0;
                        }
                        case INTERLEAVING: {
                            Location location = reader.getLocation();
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.INTERLEAVING.parseAndSetParameter(value, node, location);
                            break block0;
                        }
                        case IS_SAME_RM_OVERRIDE: {
                            Location location = reader.getLocation();
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.SAME_RM_OVERRIDE.parseAndSetParameter(value, node, location);
                            break block0;
                        }
                        case NO_TX_SEPARATE_POOLS: {
                            Location location = reader.getLocation();
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.NOTXSEPARATEPOOL.parseAndSetParameter(value, node, location);
                            break block0;
                        }
                        case PAD_XID: {
                            Location location = reader.getLocation();
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.PAD_XID.parseAndSetParameter(value, node, location);
                            break block0;
                        }
                        case WRAP_XA_RESOURCE: {
                            Location location = reader.getLocation();
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.WRAP_XA_RESOURCE.parseAndSetParameter(value, node, location);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    protected void parsePool(XMLExtendedStreamReader reader, ModelNode node) throws XMLStreamException, ParserException, ValidateException {
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSource.Tag.forName((String)reader.getLocalName()) == DataSource.Tag.POOL) {
                        return;
                    }
                    if (CommonPool.Tag.forName((String)reader.getLocalName()) != CommonPool.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (CommonPool.Tag.forName((String)reader.getLocalName())) {
                        case MAX_POOL_SIZE: {
                            Location location = reader.getLocation();
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.pool.Constants.MAX_POOL_SIZE.parseAndSetParameter(value, node, location);
                            break block0;
                        }
                        case MIN_POOL_SIZE: {
                            Location location = reader.getLocation();
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.pool.Constants.MIN_POOL_SIZE.parseAndSetParameter(value, node, location);
                            break block0;
                        }
                        case PREFILL: {
                            Location location = reader.getLocation();
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.pool.Constants.POOL_PREFILL.parseAndSetParameter(value, node, location);
                            break block0;
                        }
                        case USE_STRICT_MIN: {
                            Location location = reader.getLocation();
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.pool.Constants.POOL_USE_STRICT_MIN.parseAndSetParameter(value, node, location);
                            break block0;
                        }
                        case FLUSH_STRATEGY: {
                            Location location = reader.getLocation();
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.pool.Constants.POOL_FLUSH_STRATEGY.parseAndSetParameter(value, node, location);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    protected void parseRecovery(XMLExtendedStreamReader reader, ModelNode node) throws XMLStreamException, ParserException, ValidateException {
        block11: for (Recovery.Attribute attribute : Recovery.Attribute.values()) {
            switch (attribute) {
                case NO_RECOVERY: {
                    Location location = reader.getLocation();
                    String value = this.rawAttributeText((XMLStreamReader)reader, Constants.NO_RECOVERY.getXmlName());
                    Constants.NO_RECOVERY.parseAndSetParameter(value, node, location);
                    continue block11;
                }
            }
        }
        while (reader.hasNext()) {
            block3 : switch (reader.nextTag()) {
                case 2: {
                    if (XaDataSource.Tag.forName((String)reader.getLocalName()) == XaDataSource.Tag.RECOVERY) {
                        return;
                    }
                    if (Recovery.Tag.forName((String)reader.getLocalName()) != Recovery.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    Recovery.Tag tag = Recovery.Tag.forName((String)reader.getLocalName());
                    switch (tag) {
                        case RECOVER_CREDENTIAL: {
                            this.parseRecoveryCredential(reader, node);
                            break block3;
                        }
                        case RECOVER_PLUGIN: {
                            this.parseExtension(reader, tag.getLocalName(), node, Constants.RECOVERLUGIN_CLASSNAME, Constants.RECOVERLUGIN_PROPERTIES);
                            break block3;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private void parseSecuritySettings(XMLExtendedStreamReader reader, ModelNode node) throws XMLStreamException, ParserException, ValidateException {
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSource.Tag.forName((String)reader.getLocalName()) == DataSource.Tag.SECURITY) {
                        return;
                    }
                    if (CommonSecurity.Tag.forName((String)reader.getLocalName()) != CommonSecurity.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (CommonSecurity.Tag.forName((String)reader.getLocalName())) {
                        case SECURITY_DOMAIN: {
                            Location location = reader.getLocation();
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.SECURITY_DOMAIN.parseAndSetParameter(value, node, location);
                            break block0;
                        }
                        case SECURITY_DOMAIN_AND_APPLICATION: {
                            Location location = reader.getLocation();
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.SECURITY_DOMAIN_AND_APPLICATION.parseAndSetParameter(value, node, location);
                            break block0;
                        }
                        case APPLICATION: {
                            Location location = reader.getLocation();
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.APPLICATION.parseAndSetParameter(value, node, location);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private void parseRecoveryCredential(XMLExtendedStreamReader reader, ModelNode node) throws XMLStreamException, ParserException, ValidateException {
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSource.Tag.forName((String)reader.getLocalName()) == DataSource.Tag.SECURITY || Recovery.Tag.forName((String)reader.getLocalName()) == Recovery.Tag.RECOVER_CREDENTIAL) {
                        return;
                    }
                    if (Credential.Tag.forName((String)reader.getLocalName()) != Credential.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (Credential.Tag.forName((String)reader.getLocalName())) {
                        case PASSWORD: {
                            Location location = reader.getLocation();
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.RECOVERY_PASSWORD.parseAndSetParameter(value, node, location);
                            break block0;
                        }
                        case USER_NAME: {
                            Location location = reader.getLocation();
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.RECOVERY_USERNAME.parseAndSetParameter(value, node, location);
                            break block0;
                        }
                        case SECURITY_DOMAIN: {
                            Location location = reader.getLocation();
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.RECOVERY_SECURITY_DOMAIN.parseAndSetParameter(value, node, location);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }
}

