/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.deployers.processors;

import java.io.File;
import java.util.List;
import org.jboss.as.connector.ConnectorLogger;
import org.jboss.as.connector.ConnectorMessages;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileFilter;

public class RaNativeProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        VirtualFile deploymentRoot = ((ResourceRoot)phaseContext.getDeploymentUnit().getAttachment(Attachments.DEPLOYMENT_ROOT)).getRoot();
        if (deploymentRoot == null || !deploymentRoot.exists()) {
            return;
        }
        String deploymentRootName = deploymentRoot.getLowerCaseName();
        if (!deploymentRootName.endsWith(".rar")) {
            return;
        }
        try {
            List libs = deploymentRoot.getChildrenRecursively((VirtualFileFilter)new LibraryFilter());
            if (libs != null && libs.size() > 0) {
                for (VirtualFile vf : libs) {
                    String fileName = vf.getLowerCaseName();
                    ConnectorLogger.ROOT_LOGGER.tracef("Processing library: %s", fileName);
                    try {
                        File f = vf.getPhysicalFile();
                        System.load(f.getAbsolutePath());
                        ConnectorLogger.ROOT_LOGGER.debugf("Loaded library: %s", f.getAbsolutePath());
                    }
                    catch (Throwable t) {
                        ConnectorLogger.ROOT_LOGGER.debugf("Unable to load library: %s", fileName);
                    }
                }
            }
        }
        catch (Exception e) {
            throw ConnectorMessages.MESSAGES.failedToLoadNativeLibraries(e);
        }
    }

    public void undeploy(DeploymentUnit context) {
    }

    private static class LibraryFilter
    implements VirtualFileFilter {
        private LibraryFilter() {
        }

        public boolean accepts(VirtualFile vf) {
            String fileName;
            if (vf == null) {
                return false;
            }
            return vf.isFile() && ((fileName = vf.getLowerCaseName()).endsWith(".a") || fileName.endsWith(".so") || fileName.endsWith(".dll"));
        }
    }
}

