/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.datasources;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.connector.subsystems.datasources.Constants;
import org.jboss.as.connector.subsystems.datasources.ModifiableDataSource;
import org.jboss.as.connector.subsystems.datasources.ModifiableXaDataSource;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.jca.common.api.metadata.Defaults;
import org.jboss.jca.common.api.metadata.common.CommonPool;
import org.jboss.jca.common.api.metadata.common.CommonXaPool;
import org.jboss.jca.common.api.metadata.common.Credential;
import org.jboss.jca.common.api.metadata.common.Extension;
import org.jboss.jca.common.api.metadata.common.FlushStrategy;
import org.jboss.jca.common.api.metadata.common.Recovery;
import org.jboss.jca.common.api.metadata.ds.DsSecurity;
import org.jboss.jca.common.api.metadata.ds.Statement;
import org.jboss.jca.common.api.metadata.ds.TimeOut;
import org.jboss.jca.common.api.metadata.ds.TransactionIsolation;
import org.jboss.jca.common.api.metadata.ds.Validation;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.jca.common.metadata.common.CommonPoolImpl;
import org.jboss.jca.common.metadata.common.CommonXaPoolImpl;
import org.jboss.jca.common.metadata.common.CredentialImpl;
import org.jboss.jca.common.metadata.ds.DsSecurityImpl;
import org.jboss.jca.common.metadata.ds.StatementImpl;
import org.jboss.jca.common.metadata.ds.TimeOutImpl;
import org.jboss.jca.common.metadata.ds.ValidationImpl;

class DataSourceModelNodeUtil {
    DataSourceModelNodeUtil() {
    }

    static ModifiableDataSource from(OperationContext operationContext, ModelNode dataSourceNode) throws OperationFailedException, ValidateException {
        Map<String, String> connectionProperties = Collections.emptyMap();
        String connectionUrl = DataSourceModelNodeUtil.getStringIfSetOrGetDefault(dataSourceNode, Constants.CONNECTION_URL, null);
        String driverClass = DataSourceModelNodeUtil.getStringIfSetOrGetDefault(dataSourceNode, Constants.DRIVER_CLASS, null);
        String dataSourceClass = DataSourceModelNodeUtil.getStringIfSetOrGetDefault(dataSourceNode, Constants.DATASOURCE_CLASS, null);
        String jndiName = DataSourceModelNodeUtil.getStringIfSetOrGetDefault(dataSourceNode, Constants.JNDINAME, null);
        String driver = DataSourceModelNodeUtil.getStringIfSetOrGetDefault(dataSourceNode, Constants.DATASOURCE_DRIVER, null);
        String newConnectionSql = DataSourceModelNodeUtil.getStringIfSetOrGetDefault(dataSourceNode, Constants.NEW_CONNECTION_SQL, null);
        String poolName = DataSourceModelNodeUtil.getStringIfSetOrGetDefault(dataSourceNode, Constants.POOLNAME, null);
        String urlDelimiter = DataSourceModelNodeUtil.getStringIfSetOrGetDefault(dataSourceNode, Constants.URL_DELIMITER, null);
        String urlSelectorStrategyClassName = DataSourceModelNodeUtil.getStringIfSetOrGetDefault(dataSourceNode, Constants.URL_SELECTOR_STRATEGY_CLASS_NAME, null);
        boolean useJavaContext = DataSourceModelNodeUtil.getBooleanIfSetOrGetDefault(dataSourceNode, Constants.USE_JAVA_CONTEXT, Defaults.USE_JAVA_CONTEXT);
        boolean enabled = DataSourceModelNodeUtil.getBooleanIfSetOrGetDefault(dataSourceNode, Constants.ENABLED, Defaults.ENABLED);
        boolean jta = DataSourceModelNodeUtil.getBooleanIfSetOrGetDefault(dataSourceNode, Constants.JTA, Defaults.JTA);
        Integer maxPoolSize = DataSourceModelNodeUtil.getIntIfSetOrGetDefault(dataSourceNode, org.jboss.as.connector.pool.Constants.MAX_POOL_SIZE, Defaults.MAX_POOL_SIZE);
        Integer minPoolSize = DataSourceModelNodeUtil.getIntIfSetOrGetDefault(dataSourceNode, org.jboss.as.connector.pool.Constants.MIN_POOL_SIZE, Defaults.MIN_POOL_SIZE);
        boolean prefill = DataSourceModelNodeUtil.getBooleanIfSetOrGetDefault(dataSourceNode, org.jboss.as.connector.pool.Constants.POOL_PREFILL, Defaults.PREFILL);
        boolean useStrictMin = DataSourceModelNodeUtil.getBooleanIfSetOrGetDefault(dataSourceNode, org.jboss.as.connector.pool.Constants.POOL_USE_STRICT_MIN, Defaults.USE_STRICT_MIN);
        FlushStrategy flushStrategy = dataSourceNode.hasDefined(org.jboss.as.connector.pool.Constants.POOL_FLUSH_STRATEGY.getName()) ? FlushStrategy.forName((String)dataSourceNode.get(org.jboss.as.connector.pool.Constants.POOL_FLUSH_STRATEGY.getName()).asString()) : Defaults.FLUSH_STRATEGY;
        CommonPoolImpl pool = new CommonPoolImpl(minPoolSize, maxPoolSize, Boolean.valueOf(prefill), Boolean.valueOf(useStrictMin), flushStrategy);
        String username = DataSourceModelNodeUtil.getStringIfSetOrGetDefault(dataSourceNode, Constants.USERNAME, null);
        String password = DataSourceModelNodeUtil.getResolvedStringIfSetOrGetDefault(operationContext, dataSourceNode, Constants.PASSWORD, null);
        String securityDomain = DataSourceModelNodeUtil.getStringIfSetOrGetDefault(dataSourceNode, Constants.SECURITY_DOMAIN, null);
        Extension reauthPlugin = DataSourceModelNodeUtil.extractExtension(dataSourceNode, Constants.REAUTHPLUGIN_CLASSNAME, Constants.REAUTHPLUGIN_PROPERTIES);
        DsSecurityImpl security = new DsSecurityImpl(username, password, securityDomain, reauthPlugin);
        boolean sharePreparedStatements = DataSourceModelNodeUtil.getBooleanIfSetOrGetDefault(dataSourceNode, Constants.SHAREPREPAREDSTATEMENTS, Defaults.SHARE_PREPARED_STATEMENTS);
        Long preparedStatementsCacheSize = DataSourceModelNodeUtil.getLongIfSetOrGetDefault(dataSourceNode, Constants.PREPAREDSTATEMENTSCACHESIZE, null);
        Statement.TrackStatementsEnum trackStatements = dataSourceNode.hasDefined(Constants.TRACKSTATEMENTS.getName()) ? Statement.TrackStatementsEnum.valueOf((String)dataSourceNode.get(Constants.TRACKSTATEMENTS.getName()).asString()) : Defaults.TRACK_STATEMENTS;
        StatementImpl statement = new StatementImpl(Boolean.valueOf(sharePreparedStatements), preparedStatementsCacheSize, trackStatements);
        Integer allocationRetry = DataSourceModelNodeUtil.getIntIfSetOrGetDefault(dataSourceNode, Constants.ALLOCATION_RETRY, null);
        Long allocationRetryWaitMillis = DataSourceModelNodeUtil.getLongIfSetOrGetDefault(dataSourceNode, Constants.ALLOCATION_RETRY_WAIT_MILLIS, null);
        Long blockingTimeoutMillis = DataSourceModelNodeUtil.getLongIfSetOrGetDefault(dataSourceNode, org.jboss.as.connector.pool.Constants.BLOCKING_TIMEOUT_WAIT_MILLIS, null);
        Long idleTimeoutMinutes = DataSourceModelNodeUtil.getLongIfSetOrGetDefault(dataSourceNode, org.jboss.as.connector.pool.Constants.IDLETIMEOUTMINUTES, null);
        Long queryTimeout = DataSourceModelNodeUtil.getLongIfSetOrGetDefault(dataSourceNode, Constants.QUERYTIMEOUT, null);
        Integer xaResourceTimeout = DataSourceModelNodeUtil.getIntIfSetOrGetDefault(dataSourceNode, Constants.XA_RESOURCE_TIMEOUT, null);
        Long useTryLock = DataSourceModelNodeUtil.getLongIfSetOrGetDefault(dataSourceNode, Constants.USETRYLOCK, null);
        boolean setTxQuertTimeout = DataSourceModelNodeUtil.getBooleanIfSetOrGetDefault(dataSourceNode, Constants.SETTXQUERYTIMEOUT, Defaults.SET_TX_QUERY_TIMEOUT);
        TimeOutImpl timeOut = new TimeOutImpl(blockingTimeoutMillis, idleTimeoutMinutes, allocationRetry, allocationRetryWaitMillis, xaResourceTimeout, Boolean.valueOf(setTxQuertTimeout), queryTimeout, useTryLock);
        TransactionIsolation transactionIsolation = dataSourceNode.hasDefined(Constants.TRANSACTION_ISOLATION.getName()) ? TransactionIsolation.valueOf((String)dataSourceNode.get(Constants.TRANSACTION_ISOLATION.getName()).asString()) : null;
        String checkValidConnectionSql = DataSourceModelNodeUtil.getStringIfSetOrGetDefault(dataSourceNode, Constants.CHECKVALIDCONNECTIONSQL, null);
        Extension exceptionSorter = DataSourceModelNodeUtil.extractExtension(dataSourceNode, Constants.EXCEPTIONSORTERCLASSNAME, Constants.EXCEPTIONSORTER_PROPERTIES);
        Extension staleConnectionChecker = DataSourceModelNodeUtil.extractExtension(dataSourceNode, Constants.STALECONNECTIONCHECKERCLASSNAME, Constants.STALECONNECTIONCHECKER_PROPERTIES);
        Extension validConnectionChecker = DataSourceModelNodeUtil.extractExtension(dataSourceNode, Constants.VALIDCONNECTIONCHECKERCLASSNAME, Constants.VALIDCONNECTIONCHECKER_PROPERTIES);
        Long backgroundValidationMillis = DataSourceModelNodeUtil.getLongIfSetOrGetDefault(dataSourceNode, org.jboss.as.connector.pool.Constants.BACKGROUNDVALIDATIONMILLIS, null);
        boolean backgroundValidation = DataSourceModelNodeUtil.getBooleanIfSetOrGetDefault(dataSourceNode, org.jboss.as.connector.pool.Constants.BACKGROUNDVALIDATION, Defaults.BACKGROUND_VALIDATION);
        boolean useFastFail = DataSourceModelNodeUtil.getBooleanIfSetOrGetDefault(dataSourceNode, org.jboss.as.connector.pool.Constants.USE_FAST_FAIL, Defaults.USE_FAST_FAIl);
        boolean validateOnMatch = DataSourceModelNodeUtil.getBooleanIfSetOrGetDefault(dataSourceNode, Constants.VALIDATEONMATCH, Defaults.VALIDATE_ON_MATCH);
        boolean spy = DataSourceModelNodeUtil.getBooleanIfSetOrGetDefault(dataSourceNode, Constants.SPY, Defaults.SPY);
        boolean useCcm = DataSourceModelNodeUtil.getBooleanIfSetOrGetDefault(dataSourceNode, Constants.USE_CCM, Defaults.USE_CCM);
        ValidationImpl validation = new ValidationImpl(Boolean.valueOf(backgroundValidation), backgroundValidationMillis, Boolean.valueOf(useFastFail), validConnectionChecker, checkValidConnectionSql, Boolean.valueOf(validateOnMatch), staleConnectionChecker, exceptionSorter);
        return new ModifiableDataSource(connectionUrl, driverClass, dataSourceClass, driver, transactionIsolation, connectionProperties, (TimeOut)timeOut, (DsSecurity)security, (Statement)statement, (Validation)validation, urlDelimiter, urlSelectorStrategyClassName, newConnectionSql, useJavaContext, poolName, enabled, jndiName, spy, useCcm, jta, (CommonPool)pool);
    }

    static ModifiableXaDataSource xaFrom(OperationContext operationContext, ModelNode dataSourceNode) throws OperationFailedException, ValidateException {
        Map<String, String> xaDataSourceProperty = Collections.emptyMap();
        String xaDataSourceClass = DataSourceModelNodeUtil.getStringIfSetOrGetDefault(dataSourceNode, Constants.XADATASOURCECLASS, null);
        String jndiName = DataSourceModelNodeUtil.getStringIfSetOrGetDefault(dataSourceNode, Constants.JNDINAME, null);
        String module = DataSourceModelNodeUtil.getStringIfSetOrGetDefault(dataSourceNode, Constants.DATASOURCE_DRIVER, null);
        String newConnectionSql = DataSourceModelNodeUtil.getStringIfSetOrGetDefault(dataSourceNode, Constants.NEW_CONNECTION_SQL, null);
        String poolName = DataSourceModelNodeUtil.getStringIfSetOrGetDefault(dataSourceNode, Constants.POOLNAME, null);
        String urlDelimiter = DataSourceModelNodeUtil.getStringIfSetOrGetDefault(dataSourceNode, Constants.URL_DELIMITER, null);
        String urlSelectorStrategyClassName = DataSourceModelNodeUtil.getStringIfSetOrGetDefault(dataSourceNode, Constants.URL_SELECTOR_STRATEGY_CLASS_NAME, null);
        boolean useJavaContext = DataSourceModelNodeUtil.getBooleanIfSetOrGetDefault(dataSourceNode, Constants.USE_JAVA_CONTEXT, Defaults.USE_JAVA_CONTEXT);
        boolean enabled = DataSourceModelNodeUtil.getBooleanIfSetOrGetDefault(dataSourceNode, Constants.ENABLED, Defaults.ENABLED);
        Integer maxPoolSize = DataSourceModelNodeUtil.getIntIfSetOrGetDefault(dataSourceNode, org.jboss.as.connector.pool.Constants.MAX_POOL_SIZE, Defaults.MAX_POOL_SIZE);
        Integer minPoolSize = DataSourceModelNodeUtil.getIntIfSetOrGetDefault(dataSourceNode, org.jboss.as.connector.pool.Constants.MIN_POOL_SIZE, Defaults.MIN_POOL_SIZE);
        boolean prefill = DataSourceModelNodeUtil.getBooleanIfSetOrGetDefault(dataSourceNode, org.jboss.as.connector.pool.Constants.POOL_PREFILL, Defaults.PREFILL);
        boolean useStrictMin = DataSourceModelNodeUtil.getBooleanIfSetOrGetDefault(dataSourceNode, org.jboss.as.connector.pool.Constants.POOL_USE_STRICT_MIN, Defaults.USE_STRICT_MIN);
        boolean interleaving = DataSourceModelNodeUtil.getBooleanIfSetOrGetDefault(dataSourceNode, Constants.INTERLEAVING, Defaults.INTERLEAVING);
        boolean noTxSeparatePool = DataSourceModelNodeUtil.getBooleanIfSetOrGetDefault(dataSourceNode, Constants.NOTXSEPARATEPOOL, Defaults.NO_TX_SEPARATE_POOL);
        boolean padXid = DataSourceModelNodeUtil.getBooleanIfSetOrGetDefault(dataSourceNode, Constants.PAD_XID, Defaults.PAD_XID);
        boolean isSameRmOverride = DataSourceModelNodeUtil.getBooleanIfSetOrGetDefault(dataSourceNode, Constants.SAME_RM_OVERRIDE, Defaults.IS_SAME_RM_OVERRIDE);
        boolean wrapXaDataSource = DataSourceModelNodeUtil.getBooleanIfSetOrGetDefault(dataSourceNode, Constants.WRAP_XA_RESOURCE, Defaults.WRAP_XA_RESOURCE);
        FlushStrategy flushStrategy = dataSourceNode.hasDefined(org.jboss.as.connector.pool.Constants.POOL_FLUSH_STRATEGY.getName()) ? FlushStrategy.forName((String)dataSourceNode.get(org.jboss.as.connector.pool.Constants.POOL_FLUSH_STRATEGY.getName()).asString()) : Defaults.FLUSH_STRATEGY;
        CommonXaPoolImpl xaPool = new CommonXaPoolImpl(minPoolSize, maxPoolSize, Boolean.valueOf(prefill), Boolean.valueOf(useStrictMin), flushStrategy, Boolean.valueOf(isSameRmOverride), Boolean.valueOf(interleaving), Boolean.valueOf(padXid), Boolean.valueOf(wrapXaDataSource), Boolean.valueOf(noTxSeparatePool));
        String username = DataSourceModelNodeUtil.getStringIfSetOrGetDefault(dataSourceNode, Constants.USERNAME, null);
        String password = DataSourceModelNodeUtil.getResolvedStringIfSetOrGetDefault(operationContext, dataSourceNode, Constants.PASSWORD, null);
        String securityDomain = DataSourceModelNodeUtil.getStringIfSetOrGetDefault(dataSourceNode, Constants.SECURITY_DOMAIN, null);
        Extension reauthPlugin = DataSourceModelNodeUtil.extractExtension(dataSourceNode, Constants.REAUTHPLUGIN_CLASSNAME, Constants.REAUTHPLUGIN_PROPERTIES);
        DsSecurityImpl security = new DsSecurityImpl(username, password, securityDomain, reauthPlugin);
        boolean sharePreparedStatements = dataSourceNode.hasDefined(Constants.SHAREPREPAREDSTATEMENTS.getName()) ? dataSourceNode.get(Constants.SHAREPREPAREDSTATEMENTS.getName()).asBoolean() : Defaults.SHARE_PREPARED_STATEMENTS.booleanValue();
        Long preparedStatementsCacheSize = DataSourceModelNodeUtil.getLongIfSetOrGetDefault(dataSourceNode, Constants.PREPAREDSTATEMENTSCACHESIZE, null);
        Statement.TrackStatementsEnum trackStatements = dataSourceNode.hasDefined(Constants.TRACKSTATEMENTS.getName()) ? Statement.TrackStatementsEnum.valueOf((String)dataSourceNode.get(Constants.TRACKSTATEMENTS.getName()).asString()) : Defaults.TRACK_STATEMENTS;
        StatementImpl statement = new StatementImpl(Boolean.valueOf(sharePreparedStatements), preparedStatementsCacheSize, trackStatements);
        Integer allocationRetry = DataSourceModelNodeUtil.getIntIfSetOrGetDefault(dataSourceNode, Constants.ALLOCATION_RETRY, null);
        Long allocationRetryWaitMillis = DataSourceModelNodeUtil.getLongIfSetOrGetDefault(dataSourceNode, Constants.ALLOCATION_RETRY_WAIT_MILLIS, null);
        Long blockingTimeoutMillis = DataSourceModelNodeUtil.getLongIfSetOrGetDefault(dataSourceNode, org.jboss.as.connector.pool.Constants.BLOCKING_TIMEOUT_WAIT_MILLIS, null);
        Long idleTimeoutMinutes = DataSourceModelNodeUtil.getLongIfSetOrGetDefault(dataSourceNode, org.jboss.as.connector.pool.Constants.IDLETIMEOUTMINUTES, null);
        Long queryTimeout = DataSourceModelNodeUtil.getLongIfSetOrGetDefault(dataSourceNode, Constants.QUERYTIMEOUT, null);
        Integer xaResourceTimeout = DataSourceModelNodeUtil.getIntIfSetOrGetDefault(dataSourceNode, Constants.XA_RESOURCE_TIMEOUT, null);
        Long useTryLock = DataSourceModelNodeUtil.getLongIfSetOrGetDefault(dataSourceNode, Constants.USETRYLOCK, null);
        boolean setTxQuertTimeout = DataSourceModelNodeUtil.getBooleanIfSetOrGetDefault(dataSourceNode, Constants.SETTXQUERYTIMEOUT, Defaults.SET_TX_QUERY_TIMEOUT);
        TimeOutImpl timeOut = new TimeOutImpl(blockingTimeoutMillis, idleTimeoutMinutes, allocationRetry, allocationRetryWaitMillis, xaResourceTimeout, Boolean.valueOf(setTxQuertTimeout), queryTimeout, useTryLock);
        TransactionIsolation transactionIsolation = dataSourceNode.hasDefined(Constants.TRANSACTION_ISOLATION.getName()) ? TransactionIsolation.valueOf((String)dataSourceNode.get(Constants.TRANSACTION_ISOLATION.getName()).asString()) : null;
        String checkValidConnectionSql = DataSourceModelNodeUtil.getStringIfSetOrGetDefault(dataSourceNode, Constants.CHECKVALIDCONNECTIONSQL, null);
        Extension exceptionSorter = DataSourceModelNodeUtil.extractExtension(dataSourceNode, Constants.EXCEPTIONSORTERCLASSNAME, Constants.EXCEPTIONSORTER_PROPERTIES);
        Extension staleConnectionChecker = DataSourceModelNodeUtil.extractExtension(dataSourceNode, Constants.STALECONNECTIONCHECKERCLASSNAME, Constants.STALECONNECTIONCHECKER_PROPERTIES);
        Extension validConnectionChecker = DataSourceModelNodeUtil.extractExtension(dataSourceNode, Constants.VALIDCONNECTIONCHECKERCLASSNAME, Constants.VALIDCONNECTIONCHECKER_PROPERTIES);
        Long backgroundValidationMillis = DataSourceModelNodeUtil.getLongIfSetOrGetDefault(dataSourceNode, org.jboss.as.connector.pool.Constants.BACKGROUNDVALIDATIONMILLIS, null);
        boolean backgroundValidation = DataSourceModelNodeUtil.getBooleanIfSetOrGetDefault(dataSourceNode, org.jboss.as.connector.pool.Constants.BACKGROUNDVALIDATION, Defaults.BACKGROUND_VALIDATION);
        boolean useFastFail = DataSourceModelNodeUtil.getBooleanIfSetOrGetDefault(dataSourceNode, org.jboss.as.connector.pool.Constants.USE_FAST_FAIL, Defaults.USE_FAST_FAIl);
        boolean validateOnMatch = DataSourceModelNodeUtil.getBooleanIfSetOrGetDefault(dataSourceNode, Constants.VALIDATEONMATCH, Defaults.VALIDATE_ON_MATCH);
        boolean spy = DataSourceModelNodeUtil.getBooleanIfSetOrGetDefault(dataSourceNode, Constants.SPY, Defaults.SPY);
        boolean useCcm = DataSourceModelNodeUtil.getBooleanIfSetOrGetDefault(dataSourceNode, Constants.USE_CCM, Defaults.USE_CCM);
        ValidationImpl validation = new ValidationImpl(Boolean.valueOf(backgroundValidation), backgroundValidationMillis, Boolean.valueOf(useFastFail), validConnectionChecker, checkValidConnectionSql, Boolean.valueOf(validateOnMatch), staleConnectionChecker, exceptionSorter);
        String recoveryUsername = DataSourceModelNodeUtil.getStringIfSetOrGetDefault(dataSourceNode, Constants.RECOVERY_USERNAME, null);
        String recoveryPassword = DataSourceModelNodeUtil.getResolvedStringIfSetOrGetDefault(operationContext, dataSourceNode, Constants.RECOVERY_PASSWORD, null);
        String recoverySecurityDomain = DataSourceModelNodeUtil.getStringIfSetOrGetDefault(dataSourceNode, Constants.RECOVERY_SECURITY_DOMAIN, null);
        CredentialImpl credential = new CredentialImpl(recoveryUsername, recoveryPassword, recoverySecurityDomain);
        Extension recoverPlugin = DataSourceModelNodeUtil.extractExtension(dataSourceNode, Constants.RECOVERLUGIN_CLASSNAME, Constants.RECOVERLUGIN_PROPERTIES);
        boolean noRecovery = DataSourceModelNodeUtil.getBooleanIfSetOrGetDefault(dataSourceNode, Constants.NO_RECOVERY, false);
        Recovery recovery = new Recovery((Credential)credential, recoverPlugin, Boolean.valueOf(noRecovery));
        return new ModifiableXaDataSource(transactionIsolation, (TimeOut)timeOut, (DsSecurity)security, (Statement)statement, (Validation)validation, urlDelimiter, urlSelectorStrategyClassName, useJavaContext, poolName, enabled, jndiName, spy, useCcm, xaDataSourceProperty, xaDataSourceClass, module, newConnectionSql, (CommonXaPool)xaPool, recovery);
    }

    private static void setBooleanIfNotNull(ModelNode node, String identifier, Boolean value) {
        if (value != null) {
            node.get(identifier).set(value.booleanValue());
        }
    }

    private static void setBooleanIfTrue(ModelNode node, String identifier, Boolean value) {
        if (value != null && value.booleanValue()) {
            node.get(identifier).set(value.booleanValue());
        }
    }

    private static void setIntegerIfNotNull(ModelNode node, String identifier, Integer value) {
        if (value != null) {
            node.get(identifier).set(value.intValue());
        }
    }

    private static void setLongIfNotNull(ModelNode node, String identifier, Long value) {
        if (value != null) {
            node.get(identifier).set(value.longValue());
        }
    }

    private static void setStringIfNotNull(ModelNode node, String identifier, String value) {
        if (value != null) {
            node.get(identifier).set(value);
        }
    }

    private static void setExtensionIfNotNull(ModelNode dsModel, String extensionclassname, String extensionProperties, Extension extension) {
        if (extension != null) {
            DataSourceModelNodeUtil.setStringIfNotNull(dsModel, extensionclassname, extension.getClassName());
            if (extension.getConfigPropertiesMap() != null) {
                for (Map.Entry entry : extension.getConfigPropertiesMap().entrySet()) {
                    dsModel.get(new String[]{extensionProperties, (String)entry.getKey()}).set((String)entry.getValue());
                }
            }
        }
    }

    private static Long getLongIfSetOrGetDefault(ModelNode dataSourceNode, SimpleAttributeDefinition key, Long defaultValue) {
        if (dataSourceNode.hasDefined(key.getName())) {
            return dataSourceNode.get(key.getName()).asLong();
        }
        return defaultValue;
    }

    private static Integer getIntIfSetOrGetDefault(ModelNode dataSourceNode, SimpleAttributeDefinition key, Integer defaultValue) {
        if (dataSourceNode.hasDefined(key.getName())) {
            return dataSourceNode.get(key.getName()).asInt();
        }
        return defaultValue;
    }

    private static boolean getBooleanIfSetOrGetDefault(ModelNode dataSourceNode, SimpleAttributeDefinition key, boolean defaultValue) {
        if (dataSourceNode.hasDefined(key.getName())) {
            return dataSourceNode.get(key.getName()).asBoolean();
        }
        return defaultValue;
    }

    private static String getResolvedStringIfSetOrGetDefault(OperationContext context, ModelNode dataSourceNode, SimpleAttributeDefinition key, String defaultValue) throws OperationFailedException {
        if (dataSourceNode.hasDefined(key.getName())) {
            return context.resolveExpressions(dataSourceNode.get(key.getName())).asString();
        }
        return defaultValue;
    }

    private static String getStringIfSetOrGetDefault(ModelNode dataSourceNode, SimpleAttributeDefinition key, String defaultValue) {
        if (dataSourceNode.hasDefined(key.getName())) {
            String returnValue = dataSourceNode.get(key.getName()).asString();
            return returnValue != null && returnValue.trim().length() != 0 ? returnValue : null;
        }
        return defaultValue;
    }

    private static Extension extractExtension(ModelNode dataSourceNode, SimpleAttributeDefinition className, SimpleAttributeDefinition propertyName) throws ValidateException {
        if (dataSourceNode.hasDefined(className.getName())) {
            String exceptionSorterClassName = dataSourceNode.get(className.getName()).asString();
            DataSourceModelNodeUtil.getStringIfSetOrGetDefault(dataSourceNode, className, null);
            HashMap<String, String> exceptionSorterProperty = null;
            if (dataSourceNode.hasDefined(propertyName.getName())) {
                exceptionSorterProperty = new HashMap<String, String>(dataSourceNode.get(propertyName.getName()).asList().size());
                for (Property property : dataSourceNode.get(propertyName.getName()).asPropertyList()) {
                    exceptionSorterProperty.put(property.getName(), property.getValue().asString());
                }
            }
            return new Extension(exceptionSorterClassName, exceptionSorterProperty);
        }
        return null;
    }
}

