/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.as.connector.ConnectorMessages;
import org.jboss.msc.service.ServiceName;

public final class ConnectorServices {
    private static Map<String, Set<ServiceName>> resourceAdapterServiceNames = new HashMap<String, Set<ServiceName>>();
    private static Map<String, Set<Integer>> resourceAdapterIdentifiers = new HashMap<String, Set<Integer>>();
    private static Map<String, Set<ServiceName>> deploymentServiceNames = new HashMap<String, Set<ServiceName>>();
    private static Map<String, Set<Integer>> deploymentIdentifiers = new HashMap<String, Set<Integer>>();
    private static Map<String, String> resourceAdapterRepositoryIdentifiers = new HashMap<String, String>();
    public static final ServiceName CONNECTOR_CONFIG_SERVICE = ServiceName.JBOSS.append(new String[]{"connector", "config"});
    public static final ServiceName BEAN_VALIDATION_CONFIG_SERVICE = ServiceName.JBOSS.append(new String[]{"connector", "bean_validation", "config"});
    public static final ServiceName ARCHIVE_VALIDATION_CONFIG_SERVICE = ServiceName.JBOSS.append(new String[]{"connector", "archive_validation", "config"});
    public static final ServiceName BOOTSTRAP_CONTEXT_SERVICE = ServiceName.JBOSS.append(new String[]{"connector", "bootstrapcontext"});
    public static final ServiceName TRANSACTION_INTEGRATION_SERVICE = ServiceName.JBOSS.append(new String[]{"connector", "transactionintegration"});
    public static final ServiceName WORKMANAGER_SERVICE = ServiceName.JBOSS.append(new String[]{"connector", "workmanager"});
    public static final ServiceName RESOURCE_ADAPTER_SERVICE_PREFIX = ServiceName.JBOSS.append(new String[]{"ra"});
    public static final ServiceName RESOURCE_ADAPTER_DEPLOYMENT_SERVICE_PREFIX = RESOURCE_ADAPTER_SERVICE_PREFIX.append(new String[]{"deployment"});
    public static final ServiceName RESOURCE_ADAPTER_DEPLOYER_SERVICE_PREFIX = RESOURCE_ADAPTER_SERVICE_PREFIX.append(new String[]{"deployer"});
    public static final ServiceName RESOURCE_ADAPTER_REGISTRY_SERVICE = ServiceName.JBOSS.append(new String[]{"raregistry"});
    public static final ServiceName RESOURCE_ADAPTER_ACTIVATOR_SERVICE = ServiceName.JBOSS.append(new String[]{"raactivator"});
    public static final ServiceName IRONJACAMAR_MDR = ServiceName.JBOSS.append(new String[]{"ironjacamar", "mdr"});
    public static final ServiceName RA_REPOSISTORY_SERVICE = ServiceName.JBOSS.append(new String[]{"rarepository"});
    public static final ServiceName MANAGEMENT_REPOSISTORY_SERVICE = ServiceName.JBOSS.append(new String[]{"management_repository"});
    public static final ServiceName RESOURCEADAPTERS_SERVICE = ServiceName.JBOSS.append(new String[]{"resourceadapters"});
    public static final ServiceName RA_SERVICE = ServiceName.JBOSS.append(new String[]{"resourceadapters", "ra"});
    public static final ServiceName DATASOURCES_SERVICE = ServiceName.JBOSS.append(new String[]{"datasources"});
    public static final ServiceName JDBC_DRIVER_REGISTRY_SERVICE = ServiceName.JBOSS.append(new String[]{"jdbc-driver", "registry"});
    public static final ServiceName CCM_SERVICE = ServiceName.JBOSS.append(new String[]{"cached-connection-manager"});
    public static final ServiceName IDLE_REMOVER_SERVICE = ServiceName.JBOSS.append(new String[]{"ironjacamar", "idle-remover"});
    public static final ServiceName CONNECTION_VALIDATOR_SERVICE = ServiceName.JBOSS.append(new String[]{"ironjacamar", "connection-validator"});
    private static final String RA_SERVICE_NAME_SEPARATOR = "#";

    private ConnectorServices() {
    }

    public static <T> T notNull(T value) {
        if (value == null) {
            throw ConnectorMessages.MESSAGES.serviceNotStarted();
        }
        return value;
    }

    private static Integer getDeploymentIdentifier(String raName) {
        Set<Integer> entries = deploymentIdentifiers.get(raName);
        if (entries == null) {
            Integer identifier = 1;
            entries = new HashSet<Integer>();
            deploymentIdentifiers.put(raName, entries);
            entries.add(identifier);
            return identifier;
        }
        Integer identifier = 1;
        while (true) {
            if (!entries.contains(identifier)) {
                entries.add(identifier);
                return identifier;
            }
            identifier = identifier + 1;
        }
    }

    public static synchronized ServiceName registerDeployment(String raName) {
        if (raName == null) {
            throw ConnectorMessages.MESSAGES.undefinedVar("RaName");
        }
        Integer identifier = ConnectorServices.getDeploymentIdentifier(raName);
        ServiceName serviceName = RESOURCE_ADAPTER_DEPLOYMENT_SERVICE_PREFIX.append(new String[]{raName + "_" + identifier});
        Set<ServiceName> entries = deploymentServiceNames.get(raName);
        if (entries == null) {
            entries = new HashSet<ServiceName>(1);
            deploymentServiceNames.put(raName, entries);
        }
        if (entries.contains(serviceName)) {
            deploymentIdentifiers.get(raName).remove(identifier);
            throw ConnectorMessages.MESSAGES.serviceAlreadyRegistered(serviceName.getCanonicalName());
        }
        entries.add(serviceName);
        return serviceName;
    }

    public static synchronized void unregisterDeployment(String raName, ServiceName serviceName) {
        if (raName == null) {
            throw ConnectorMessages.MESSAGES.undefinedVar("RaName");
        }
        if (serviceName == null) {
            throw ConnectorMessages.MESSAGES.undefinedVar("ServiceName");
        }
        Set<ServiceName> entries = deploymentServiceNames.get(raName);
        if (entries != null) {
            if (!entries.contains(serviceName)) {
                throw ConnectorMessages.MESSAGES.serviceIsntRegistered(serviceName.getCanonicalName());
            }
            Integer identifier = Integer.valueOf(serviceName.getSimpleName().substring(serviceName.getSimpleName().lastIndexOf("_") + 1));
            deploymentIdentifiers.get(raName).remove(identifier);
            entries.remove(serviceName);
            if (entries.size() == 0) {
                deploymentServiceNames.remove(raName);
                deploymentIdentifiers.remove(raName);
            }
        }
    }

    private static Integer getResourceAdapterIdentifier(String raName) {
        Set<Integer> entries = resourceAdapterIdentifiers.get(raName);
        if (entries == null) {
            Integer identifier = 1;
            entries = new HashSet<Integer>();
            resourceAdapterIdentifiers.put(raName, entries);
            entries.add(identifier);
            return identifier;
        }
        Integer identifier = 1;
        while (true) {
            if (!entries.contains(identifier)) {
                entries.add(identifier);
                return identifier;
            }
            identifier = identifier + 1;
        }
    }

    public static synchronized ServiceName registerResourceAdapter(String raName) {
        ServiceName serviceName;
        if (raName == null || raName.trim().isEmpty()) {
            throw ConnectorMessages.MESSAGES.undefinedVar("RaName");
        }
        Set<ServiceName> serviceNamesForRAActivation = resourceAdapterServiceNames.get(raName);
        if (serviceNamesForRAActivation == null) {
            serviceNamesForRAActivation = new HashSet<ServiceName>();
            resourceAdapterServiceNames.put(raName, serviceNamesForRAActivation);
        }
        if (serviceNamesForRAActivation.isEmpty()) {
            serviceName = RESOURCE_ADAPTER_SERVICE_PREFIX.append(new String[]{raName});
        } else {
            Integer nextId = ConnectorServices.getResourceAdapterIdentifier(raName);
            serviceName = RESOURCE_ADAPTER_SERVICE_PREFIX.append(new String[]{raName}).append(new String[]{RA_SERVICE_NAME_SEPARATOR}).append(new String[]{nextId.toString()});
        }
        serviceNamesForRAActivation.add(serviceName);
        return serviceName;
    }

    public static synchronized void unregisterResourceAdapter(String raName, ServiceName serviceName) {
        if (raName == null || raName.trim().isEmpty()) {
            throw ConnectorMessages.MESSAGES.undefinedVar("RaName");
        }
        if (serviceName == null) {
            throw ConnectorMessages.MESSAGES.undefinedVar("ServiceName");
        }
        Set<ServiceName> registeredServiceNames = resourceAdapterServiceNames.get(raName);
        if (registeredServiceNames == null || registeredServiceNames.isEmpty() || !registeredServiceNames.contains(serviceName)) {
            throw ConnectorMessages.MESSAGES.serviceIsntRegistered(serviceName.getCanonicalName());
        }
        registeredServiceNames.remove(serviceName);
        if (!serviceName.equals(RESOURCE_ADAPTER_SERVICE_PREFIX.append(new String[]{raName}))) {
            Integer numericId;
            ServiceName baseServiceName = RESOURCE_ADAPTER_SERVICE_PREFIX.append(new String[]{raName}).append(new String[]{RA_SERVICE_NAME_SEPARATOR});
            if (!baseServiceName.isParentOf(serviceName)) {
                throw ConnectorMessages.MESSAGES.notResourceAdapterService(serviceName);
            }
            String[] parts = serviceName.toArray();
            String lastPart = parts[parts.length - 1];
            try {
                numericId = Integer.parseInt(lastPart);
            }
            catch (NumberFormatException nfe) {
                throw ConnectorMessages.MESSAGES.notResourceAdapterService(serviceName);
            }
            resourceAdapterIdentifiers.get(raName).remove(numericId);
        }
    }

    public static synchronized Set<ServiceName> getResourceAdapterServiceNames(String raName) {
        if (raName == null || raName.trim().isEmpty()) {
            throw ConnectorMessages.MESSAGES.stringParamCannotBeNullOrEmpty("resource adapter name");
        }
        return Collections.singleton(RESOURCE_ADAPTER_SERVICE_PREFIX.append(new String[]{raName}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getRegisteredResourceAdapterIdentifier(String raName) {
        Map<String, String> map = resourceAdapterRepositoryIdentifiers;
        synchronized (map) {
            return resourceAdapterRepositoryIdentifiers.get(raName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerResourceAdapterIdentifier(String raName, String raIdentifier) {
        Map<String, String> map = resourceAdapterRepositoryIdentifiers;
        synchronized (map) {
            resourceAdapterRepositoryIdentifiers.put(raName, raIdentifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterResourceAdapterIdentifier(String raName) {
        Map<String, String> map = resourceAdapterRepositoryIdentifiers;
        synchronized (map) {
            resourceAdapterRepositoryIdentifiers.remove(raName);
        }
    }
}

