/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.deployers.processors;

import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import org.jboss.as.connector.ConnectorLogger;
import org.jboss.as.connector.ConnectorMessages;
import org.jboss.as.connector.ConnectorServices;
import org.jboss.as.connector.StatisticsDescriptionProvider;
import org.jboss.as.connector.metadata.deployment.ResourceAdapterXmlDeploymentService;
import org.jboss.as.connector.metadata.xmldescriptors.ConnectorXmlDescriptor;
import org.jboss.as.connector.pool.PoolMetrics;
import org.jboss.as.connector.registry.ResourceAdapterDeploymentRegistry;
import org.jboss.as.connector.subsystems.ClearStatisticsHandler;
import org.jboss.as.connector.subsystems.jca.JcaSubsystemConfiguration;
import org.jboss.as.connector.subsystems.resourceadapters.ResourceAdaptersSubsystemProviders;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.OverrideDescriptionProvider;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.naming.service.NamingService;
import org.jboss.as.security.service.SubjectFactoryService;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentModelUtils;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.dmr.ModelNode;
import org.jboss.jca.common.api.metadata.resourceadapter.ResourceAdapter;
import org.jboss.jca.common.api.metadata.resourceadapter.ResourceAdapters;
import org.jboss.jca.core.api.connectionmanager.ccm.CachedConnectionManager;
import org.jboss.jca.core.api.connectionmanager.pool.PoolStatistics;
import org.jboss.jca.core.api.management.ManagementRepository;
import org.jboss.jca.core.spi.mdr.MetadataRepository;
import org.jboss.jca.core.spi.rar.ResourceAdapterRepository;
import org.jboss.jca.core.spi.statistics.StatisticsPlugin;
import org.jboss.jca.core.spi.transaction.TransactionIntegration;
import org.jboss.jca.deployers.common.CommonDeployment;
import org.jboss.modules.Module;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.security.SubjectFactory;

public class RaXmlDeploymentProcessor
implements DeploymentUnitProcessor {
    private final MetadataRepository mdr;

    public RaXmlDeploymentProcessor(MetadataRepository mdr) {
        this.mdr = mdr;
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        final ManagementResourceRegistration registration = (ManagementResourceRegistration)deploymentUnit.getAttachment(DeploymentModelUtils.MUTABLE_REGISTRATION_ATTACHMENT);
        ConnectorXmlDescriptor connectorXmlDescriptor = (ConnectorXmlDescriptor)deploymentUnit.getAttachment(ConnectorXmlDescriptor.ATTACHMENT_KEY);
        if (connectorXmlDescriptor == null) {
            return;
        }
        ResourceAdapters raxmls = null;
        ServiceController raService = phaseContext.getServiceRegistry().getService(ConnectorServices.RESOURCEADAPTERS_SERVICE);
        if (raService != null) {
            raxmls = (ResourceAdapters)raService.getValue();
        }
        if (raxmls == null) {
            return;
        }
        ConnectorLogger.ROOT_LOGGER.tracef("processing Raxml", new Object[0]);
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        if (module == null) {
            throw ConnectorMessages.MESSAGES.failedToGetModuleAttachment(deploymentUnit);
        }
        try {
            ServiceTarget serviceTarget = phaseContext.getServiceTarget();
            for (ResourceAdapter raxml : raxmls.getResourceAdapters()) {
                String deploymentUnitName;
                String deploymentUnitPrefix = "";
                if (deploymentUnit.getParent() != null) {
                    deploymentUnitPrefix = deploymentUnit.getParent().getName() + "#";
                }
                if (!(deploymentUnitName = deploymentUnitPrefix + deploymentUnit.getName()).equals(raxml.getArchive())) continue;
                String deployment = deploymentUnitName.lastIndexOf(46) == -1 ? deploymentUnitName : deploymentUnitName.substring(0, deploymentUnitName.lastIndexOf(46));
                String raName = connectorXmlDescriptor.getDeploymentName();
                ServiceName serviceName = ConnectorServices.registerDeployment(raName);
                ResourceAdapterXmlDeploymentService service = new ResourceAdapterXmlDeploymentService(connectorXmlDescriptor, raxml, module, deployment, serviceName);
                ServiceBuilder builder = serviceTarget.addService(serviceName, (Service)service).addDependency(ConnectorServices.IRONJACAMAR_MDR, MetadataRepository.class, service.getMdrInjector()).addDependency(ConnectorServices.RA_REPOSISTORY_SERVICE, ResourceAdapterRepository.class, service.getRaRepositoryInjector()).addDependency(ConnectorServices.MANAGEMENT_REPOSISTORY_SERVICE, ManagementRepository.class, service.getManagementRepositoryInjector()).addDependency(ConnectorServices.RESOURCE_ADAPTER_REGISTRY_SERVICE, ResourceAdapterDeploymentRegistry.class, service.getRegistryInjector()).addDependency(ConnectorServices.TRANSACTION_INTEGRATION_SERVICE, TransactionIntegration.class, service.getTxIntegrationInjector()).addDependency(ConnectorServices.CONNECTOR_CONFIG_SERVICE, JcaSubsystemConfiguration.class, service.getConfigInjector()).addDependency(SubjectFactoryService.SERVICE_NAME, SubjectFactory.class, service.getSubjectFactoryInjector()).addDependency(ConnectorServices.CCM_SERVICE, CachedConnectionManager.class, service.getCcmInjector()).addDependency(ConnectorServices.IDLE_REMOVER_SERVICE).addDependency(ConnectorServices.CONNECTION_VALIDATOR_SERVICE).addDependency(NamingService.SERVICE_NAME).addDependency(ConnectorServices.RESOURCE_ADAPTER_DEPLOYER_SERVICE_PREFIX.append(new String[]{connectorXmlDescriptor.getDeploymentName()}));
                builder.addListener((ServiceListener)new AbstractServiceListener<Object>(){

                    public void transition(ServiceController<? extends Object> controller, ServiceController.Transition transition) {
                        switch (transition) {
                            case STARTING_to_UP: {
                                PoolStatistics poolStats;
                                CommonDeployment deploymentMD = ((ResourceAdapterXmlDeploymentService)controller.getService()).getRaxmlDeployment();
                                if (deploymentMD.getConnectionManagers() == null || deploymentMD.getConnectionManagers()[0].getPool() == null || (poolStats = deploymentMD.getConnectionManagers()[0].getPool().getStatistics()).getNames().size() == 0) break;
                                StatisticsDescriptionProvider statsResourceDescriptionProvider = new StatisticsDescriptionProvider(ResourceAdaptersSubsystemProviders.RESOURCE_NAME, "statistics", new StatisticsPlugin[]{poolStats});
                                PathElement pe = PathElement.pathElement((String)"subsystem", (String)"resource-adapters");
                                ManagementResourceRegistration overrideRegistration = registration;
                                if (registration.isAllowsOverride()) {
                                    overrideRegistration = registration.registerOverrideModel(deploymentUnitName, new OverrideDescriptionProvider(){

                                        public Map<String, ModelNode> getAttributeOverrideDescriptions(Locale locale) {
                                            return Collections.emptyMap();
                                        }

                                        public Map<String, ModelNode> getChildTypeOverrideDescriptions(Locale locale) {
                                            return Collections.emptyMap();
                                        }
                                    });
                                }
                                if (overrideRegistration.getSubModel(PathAddress.pathAddress((PathElement[])new PathElement[]{pe})) != null) break;
                                ManagementResourceRegistration subRegistration = overrideRegistration.registerSubModel(pe, (DescriptionProvider)statsResourceDescriptionProvider);
                                for (String statName : poolStats.getNames()) {
                                    subRegistration.registerMetric(statName, (OperationStepHandler)new PoolMetrics.ParametrizedPoolMetricsHandler((StatisticsPlugin)poolStats));
                                }
                                subRegistration.registerOperationHandler("clear-statistics", (OperationStepHandler)new ClearStatisticsHandler(new StatisticsPlugin[]{poolStats}), ResourceAdaptersSubsystemProviders.CLEAR_STATISTICS_DESC, false);
                                break;
                            }
                            case UP_to_STOP_REQUESTED: {
                                PathElement pe = PathElement.pathElement((String)"subsystem", (String)"resource-adapters");
                                ManagementResourceRegistration overrideRegistration = registration.getOverrideModel(deploymentUnitName);
                                if (overrideRegistration.getSubModel(PathAddress.pathAddress((PathElement[])new PathElement[]{pe})) == null) break;
                                overrideRegistration.unregisterSubModel(pe);
                                break;
                            }
                        }
                    }
                });
                builder.setInitialMode(ServiceController.Mode.ACTIVE).install();
            }
        }
        catch (Throwable t) {
            throw new DeploymentUnitProcessingException(t);
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

