/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.registry;

import java.sql.Driver;
import org.jboss.as.connector.ConnectorMessages;
import org.jboss.as.connector.registry.DriverRegistry;
import org.jboss.as.connector.registry.InstalledDriver;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class DriverService
implements Service<Driver> {
    private final InjectedValue<DriverRegistry> injectedDriverRegistry = new InjectedValue();
    private final InstalledDriver driverMetaData;
    private final Driver driver;

    public DriverService(InstalledDriver driverMetaData, Driver driver) {
        assert (driverMetaData != null) : ConnectorMessages.MESSAGES.nullVar("driverMetaData");
        assert (driver != null) : ConnectorMessages.MESSAGES.nullVar("driver");
        this.driverMetaData = driverMetaData;
        this.driver = driver;
    }

    public Driver getValue() throws IllegalStateException, IllegalArgumentException {
        return this.driver;
    }

    public void start(StartContext context) throws StartException {
        ((DriverRegistry)this.injectedDriverRegistry.getValue()).registerInstalledDriver(this.driverMetaData);
    }

    public void stop(StopContext context) {
        ((DriverRegistry)this.injectedDriverRegistry.getValue()).unregisterInstalledDriver(this.driverMetaData);
    }

    public Injector<DriverRegistry> getDriverRegistryServiceInjector() {
        return this.injectedDriverRegistry;
    }
}

