/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector;

import java.sql.Driver;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.LogMessage;
import org.jboss.logging.Logger;
import org.jboss.logging.Message;
import org.jboss.logging.MessageLogger;
import org.jboss.msc.service.ServiceName;

@MessageLogger(projectCode="JBAS")
public interface ConnectorLogger
extends BasicLogger {
    public static final ConnectorLogger ROOT_LOGGER = (ConnectorLogger)Logger.getMessageLogger(ConnectorLogger.class, (String)ConnectorLogger.class.getPackage().getName());
    public static final ConnectorLogger DEPLOYER_JDBC_LOGGER = (ConnectorLogger)Logger.getMessageLogger(ConnectorLogger.class, (String)"org.jboss.as.connector.deployers.jdbc");
    public static final ConnectorLogger DEPLOYMENT_CONNECTOR_LOGGER = (ConnectorLogger)Logger.getMessageLogger(ConnectorLogger.class, (String)"org.jboss.as.deployment.connector");
    public static final ConnectorLogger DEPLOYMENT_CONNECTOR_REGISTRY_LOGGER = (ConnectorLogger)Logger.getMessageLogger(ConnectorLogger.class, (String)"org.jboss.as.deployment.connector.registry");
    public static final ConnectorLogger DS_DEPLOYER_LOGGER = (ConnectorLogger)Logger.getMessageLogger(ConnectorLogger.class, (String)"org.jboss.as.connector.deployer.dsdeployer");
    public static final ConnectorLogger MDR_LOGGER = (ConnectorLogger)Logger.getMessageLogger(ConnectorLogger.class, (String)"org.jboss.as.connector.mdr");
    public static final ConnectorLogger SUBSYSTEM_DATASOURCES_LOGGER = (ConnectorLogger)Logger.getMessageLogger(ConnectorLogger.class, (String)"org.jboss.as.connector.subsystems.datasources");
    public static final ConnectorLogger SUBSYSTEM_RA_LOGGER = (ConnectorLogger)Logger.getMessageLogger(ConnectorLogger.class, (String)"org.jboss.as.connector.subsystems.resourceadapters");

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=10400, value="Bound data source [%s]")
    public void boundDataSource(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=10401, value="Bound JCA %s [%s]")
    public void boundJca(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=10402, value="Unable to instantiate driver class \"%s\": %s")
    public void cannotInstantiateDriverClass(String var1, Throwable var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=10403, value="Deploying JDBC-compliant driver %s (version %d.%d)")
    public void deployingCompliantJdbcDriver(Class<? extends Driver> var1, int var2, int var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=10404, value="Deploying non-JDBC-compliant driver %s (version %d.%d)")
    public void deployingNonCompliantJdbcDriver(Class<? extends Driver> var1, int var2, int var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=10405, value="Registered admin object at %s")
    public void registeredAdminObject(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=10406, value="Registered connection factory %s")
    public void registeredConnectionFactory(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=10407, value="Starting service %s")
    public void startingService(ServiceName var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=10408, value="Starting %s Subsystem (%s)")
    public void startingSubsystem(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=10409, value="Unbound data source [%s]")
    public void unboundDataSource(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=10410, value="Unbound JCA %s [%s]")
    public void unboundJca(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=10411, value="<drivers/> in standalone -ds.xml deployments aren't supported: Ignoring %s")
    public void driversElementNotSupported(String var1);

    @Message(id=10412, value="the attribute class-name cannot be null for more than one connection-definition")
    public OperationFailedException classNameNullForMoreCD();

    @Message(id=10413, value="the attribute class-name cannot be null for more than one admin-object")
    public OperationFailedException classNameNullForMoreAO();

    @Message(id=10414, value="the attribute driver-name (%s) cannot be different from driver resource name (%s)")
    public OperationFailedException driverNameAndResourceNameNotEquals(String var1, String var2);
}

