/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.deployers.ra.processors;

import java.util.Map;
import org.jboss.as.connector.annotations.repository.jandex.JandexAnnotationRepositoryImpl;
import org.jboss.as.connector.deployers.ra.processors.AbstractResourceAdapterDeploymentServiceListener;
import org.jboss.as.connector.logging.ConnectorMessages;
import org.jboss.as.connector.metadata.xmldescriptors.ConnectorXmlDescriptor;
import org.jboss.as.connector.metadata.xmldescriptors.IronJacamarXmlDescriptor;
import org.jboss.as.connector.services.mdr.AS7MetadataRepository;
import org.jboss.as.connector.services.resourceadapters.deployment.ResourceAdapterDeploymentService;
import org.jboss.as.connector.services.resourceadapters.deployment.registry.ResourceAdapterDeploymentRegistry;
import org.jboss.as.connector.subsystems.jca.JcaSubsystemConfiguration;
import org.jboss.as.connector.subsystems.resourceadapters.IronJacamarRegistrator;
import org.jboss.as.connector.subsystems.resourceadapters.IronJacamarResourceCreator;
import org.jboss.as.connector.util.ConnectorServices;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.naming.service.NamingService;
import org.jboss.as.security.service.SubjectFactoryService;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentModelUtils;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.AnnotationIndexUtils;
import org.jboss.jandex.Index;
import org.jboss.jca.common.annotations.Annotations;
import org.jboss.jca.common.api.metadata.common.CommonIronJacamar;
import org.jboss.jca.common.api.metadata.ironjacamar.IronJacamar;
import org.jboss.jca.common.api.metadata.ra.Connector;
import org.jboss.jca.common.metadata.merge.Merger;
import org.jboss.jca.common.spi.annotations.repository.AnnotationRepository;
import org.jboss.jca.core.api.connectionmanager.ccm.CachedConnectionManager;
import org.jboss.jca.core.api.management.ManagementRepository;
import org.jboss.jca.core.spi.rar.ResourceAdapterRepository;
import org.jboss.jca.core.spi.transaction.TransactionIntegration;
import org.jboss.jca.deployers.common.CommonDeployment;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.security.SubjectFactory;

public class ParsedRaDeploymentProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        ConnectorXmlDescriptor connectorXmlDescriptor = (ConnectorXmlDescriptor)phaseContext.getDeploymentUnit().getAttachment(ConnectorXmlDescriptor.ATTACHMENT_KEY);
        ManagementResourceRegistration baseRegistration = (ManagementResourceRegistration)phaseContext.getDeploymentUnit().getAttachment(DeploymentModelUtils.MUTABLE_REGISTRATION_ATTACHMENT);
        Resource deploymentResource = (Resource)phaseContext.getDeploymentUnit().getAttachment(DeploymentModelUtils.DEPLOYMENT_RESOURCE);
        if (connectorXmlDescriptor == null) {
            return;
        }
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ManagementResourceRegistration registration = deploymentUnit.getParent() != null ? baseRegistration.getSubModel(PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subdeployment")})) : baseRegistration;
        IronJacamarXmlDescriptor ironJacamarXmlDescriptor = (IronJacamarXmlDescriptor)deploymentUnit.getAttachment(IronJacamarXmlDescriptor.ATTACHMENT_KEY);
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        if (module == null) {
            throw ConnectorMessages.MESSAGES.failedToGetModuleAttachment(phaseContext.getDeploymentUnit());
        }
        ModuleClassLoader classLoader = module.getClassLoader();
        Connector cmd = connectorXmlDescriptor != null ? connectorXmlDescriptor.getConnector() : null;
        IronJacamar ijmd = ironJacamarXmlDescriptor != null ? ironJacamarXmlDescriptor.getIronJacamar() : null;
        try {
            Annotations annotator = new Annotations();
            Map indexes = AnnotationIndexUtils.getAnnotationIndexes((DeploymentUnit)deploymentUnit);
            for (Map.Entry entry : indexes.entrySet()) {
                JandexAnnotationRepositoryImpl repository = new JandexAnnotationRepositoryImpl((Index)entry.getValue(), (ClassLoader)classLoader);
                cmd = annotator.merge(cmd, (AnnotationRepository)repository, (ClassLoader)classLoader);
            }
            if (cmd != null) {
                cmd.validate();
                cmd = new Merger().mergeConnectorWithCommonIronJacamar((CommonIronJacamar)ijmd, cmd);
            }
            ServiceName deployerServiceName = ConnectorServices.RESOURCE_ADAPTER_DEPLOYER_SERVICE_PREFIX.append(new String[]{connectorXmlDescriptor.getDeploymentName()});
            ResourceAdapterDeploymentService raDeploymentService = new ResourceAdapterDeploymentService(connectorXmlDescriptor, cmd, ijmd, module, deployerServiceName);
            ServiceTarget serviceTarget = phaseContext.getServiceTarget();
            ServiceBuilder builder = serviceTarget.addService(deployerServiceName, (Service)raDeploymentService).addDependency(ConnectorServices.IRONJACAMAR_MDR, AS7MetadataRepository.class, raDeploymentService.getMdrInjector()).addDependency(ConnectorServices.RA_REPOSITORY_SERVICE, ResourceAdapterRepository.class, raDeploymentService.getRaRepositoryInjector()).addDependency(ConnectorServices.MANAGEMENT_REPOSITORY_SERVICE, ManagementRepository.class, raDeploymentService.getManagementRepositoryInjector()).addDependency(ConnectorServices.RESOURCE_ADAPTER_REGISTRY_SERVICE, ResourceAdapterDeploymentRegistry.class, raDeploymentService.getRegistryInjector()).addDependency(ConnectorServices.TRANSACTION_INTEGRATION_SERVICE, TransactionIntegration.class, raDeploymentService.getTxIntegrationInjector()).addDependency(ConnectorServices.CONNECTOR_CONFIG_SERVICE, JcaSubsystemConfiguration.class, raDeploymentService.getConfigInjector()).addDependency(SubjectFactoryService.SERVICE_NAME, SubjectFactory.class, raDeploymentService.getSubjectFactoryInjector()).addDependency(ConnectorServices.CCM_SERVICE, CachedConnectionManager.class, raDeploymentService.getCcmInjector()).addDependency(ConnectorServices.IDLE_REMOVER_SERVICE).addDependency(ConnectorServices.CONNECTION_VALIDATOR_SERVICE).addDependency(NamingService.SERVICE_NAME);
            builder.addListener((ServiceListener)new AbstractResourceAdapterDeploymentServiceListener(registration, deploymentUnit.getName(), deploymentResource){

                @Override
                protected void registerIronjacamar(ServiceController<? extends Object> controller, ManagementResourceRegistration subRegistration, Resource subsystemResource) {
                    new IronJacamarRegistrator(subRegistration).invoke();
                    AS7MetadataRepository mdr = ((ResourceAdapterDeploymentService)controller.getService()).getMdr();
                    IronJacamarResourceCreator.INSTANCE.execute(subsystemResource, mdr);
                }

                @Override
                protected CommonDeployment getDeploymentMetadata(ServiceController<? extends Object> controller) {
                    return ((ResourceAdapterDeploymentService)controller.getService()).getRaDeployment();
                }
            });
            builder.setInitialMode(ServiceController.Mode.ACTIVE).install();
        }
        catch (Throwable t) {
            throw new DeploymentUnitProcessingException(t);
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

