package org.jboss.as.console.client.shared.general.model;

import com.google.gwt.user.client.rpc.AsyncCallback;
import org.jboss.as.console.client.domain.model.SimpleCallback;
import org.jboss.as.console.client.shared.BeanFactory;
import org.jboss.as.console.client.shared.dispatch.AsyncCommand;
import org.jboss.as.console.client.shared.dispatch.DispatchAsync;
import org.jboss.as.console.client.shared.dispatch.impl.DMRAction;
import org.jboss.as.console.client.shared.dispatch.impl.DMRResponse;
import org.jboss.as.console.client.widgets.forms.EntityAdapter;
import org.jboss.as.console.client.widgets.forms.PropertyMetaData;
import org.jboss.dmr.client.ModelNode;

import java.util.ArrayList;
import java.util.List;

import static org.jboss.dmr.client.ModelDescriptionConstants.*;

/**
 * @author Heiko Braun
 * @date 6/7/11
 */
public class LoadSocketBindingsCmd implements AsyncCommand<List<SocketBinding>> {

    private DispatchAsync dispatcher;
    private String groupName;
    private BeanFactory factory;
    private PropertyMetaData metaData;
    private EntityAdapter<SocketBinding> entityAdapter;

    public LoadSocketBindingsCmd(DispatchAsync dispatcher, BeanFactory factory, PropertyMetaData metaData, String groupName) {
        this.dispatcher = dispatcher;
        this.factory = factory;
        this.metaData = metaData;
        this.groupName = groupName;
        this.entityAdapter = new EntityAdapter<SocketBinding>(SocketBinding.class, metaData);
    }

    @Override
    public void execute(final AsyncCallback<List<SocketBinding>> callback) {
        // /socket-binding-group=standard-sockets:read-resource(recursive=true)
        ModelNode operation = new ModelNode();
        operation.get(ADDRESS).add("socket-binding-group", groupName);
        operation.get(OP).set(READ_RESOURCE_OPERATION);
        operation.get(RECURSIVE).set(true);

        dispatcher.execute(new DMRAction(operation), new SimpleCallback<DMRResponse>() {

            @Override
            public void onSuccess(DMRResponse result) {

                ModelNode response = ModelNode.fromBase64(result.getResponseText());
                ModelNode payload = response.get("result").asObject();

                List<ModelNode> socketDescriptions= payload.get("socket-binding").asList();

                String defaultInterface = payload.get("default-interface").asString();
                List<SocketBinding> bindings = new ArrayList<SocketBinding>();
                for(ModelNode socket : socketDescriptions)
                {

                    ModelNode value = socket.asProperty().getValue();

                    SocketBinding socketBinding = entityAdapter.fromDMR(value);
                    socketBinding.setGroup(getGroupName());
                    socketBinding.setDefaultInterface(
                            socketBinding.getInterface()!=null ?
                                    socketBinding.getInterface():defaultInterface
                    );
                    socketBinding.setDefaultInterface(defaultInterface);
                    bindings.add(socketBinding);
                }

                callback.onSuccess(bindings);

            }
        });
    }

    private String getGroupName() {
        return groupName;
    }
}
