/*
 * JBoss, Home of Professional Open Source
 * Copyright 2011 Red Hat Inc. and/or its affiliates and other contributors
 * as indicated by the @author tags. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */
package org.jboss.as.console.mbui.model.mapping;

/**
 * @author Harald Pehl
 * @date 11/01/2012
 */
public class ResourceAttribute
{
    private final String name;
    private final String label;

    public ResourceAttribute(final String name)
    {
        this.name = name;
        this.label = null;
    }

    public ResourceAttribute(final String name, final String label)
    {
        this.name = name;
        this.label = label;
    }

    @Override
    public boolean equals(final Object o)
    {
        if (this == o) { return true; }
        if (!(o instanceof ResourceAttribute)) { return false; }

        ResourceAttribute that = (ResourceAttribute) o;
        if (!name.equals(that.name)) { return false; }

        return true;
    }

    @Override
    public int hashCode()
    {
        return name.hashCode();
    }

    @Override
    public String toString()
    {
        return "ResourceAttribute{" + name + '}';
    }

    public String getName()
    {
        return name;
    }

    public String getLabel()
    {
        return label;
    }
}
