package org.jboss.as.console.client.core;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.jboss.as.console.client.ProductConfig;
import org.jboss.ballroom.client.widgets.forms.FormItem;
import org.jboss.ballroom.client.widgets.forms.PlainFormView;
import org.jboss.ballroom.client.widgets.forms.RenderMetaData;
import org.jboss.ballroom.client.widgets.forms.TextItem;

import java.util.ArrayList;
import java.util.Collections;

import static java.util.Arrays.asList;

/**
 * @author Harald Pehl
 * @date 08/04/2013
 */
public class ProductConfigPanel implements IsWidget {

    @Override
    public Widget asWidget() {
        ProductConfig productConfig = GWT.create(ProductConfig.class);

        TextItem consoleVersion = new TextItem("console_version", "HAL version");
        consoleVersion.setValue(productConfig.getConsoleVersion() == null ? "n/a" : productConfig.getConsoleVersion());
        consoleVersion.setUndefined(false);
        TextItem coreVersion = new TextItem("core_version", "Core version");
        coreVersion.setValue(productConfig.getCoreVersion());
        coreVersion.setUndefined(false);
        TextItem productName = new TextItem("product_name", "Product name");
        productName.setValue(productConfig.getProductName());
        productName.setUndefined(false);
        TextItem productVersion = new TextItem("product_version", "Product version");
        productVersion.setValue(productConfig.getProductVersion());
        productVersion.setUndefined(false);
        TextItem profile = new TextItem("profile", "Profile");
        profile.setValue(productConfig.getProfile().name());
        profile.setUndefined(false);

        PlainFormView view = new PlainFormView(new ArrayList<FormItem>(
                asList(consoleVersion, coreVersion, productName, productVersion, profile)));
        view.setNumColumns(1);
        RenderMetaData metaData = new RenderMetaData();
        metaData.setFilteredFields(Collections.<String>emptySet());
        Widget content = view.asWidget(metaData);
        view.refresh(true); // to fill the CellTable

        VerticalPanel layout = new VerticalPanel();
        layout.setStyleName("window-content");
        layout.add(content);
        return layout;
    }
}
