/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.client.helpers.domain.impl;

import org.jboss.as.controller.client.ControllerClientMessages;
import org.jboss.as.controller.client.helpers.domain.DeploymentAction;
import org.jboss.as.controller.client.helpers.domain.RemoveDeploymentPlanBuilder;
import org.jboss.as.controller.client.helpers.domain.ServerGroupDeploymentPlanBuilder;
import org.jboss.as.controller.client.helpers.domain.UndeployDeploymentPlanBuilder;
import org.jboss.as.controller.client.helpers.domain.impl.DeploymentActionImpl;
import org.jboss.as.controller.client.helpers.domain.impl.DeploymentPlanBuilderImpl;
import org.jboss.as.controller.client.helpers.domain.impl.DeploymentSetPlanImpl;
import org.jboss.as.controller.client.helpers.domain.impl.RemoveDeploymentPlanBuilderImpl;

class UndeployDeploymentPlanBuilderImpl
extends DeploymentPlanBuilderImpl
implements UndeployDeploymentPlanBuilder {
    private final DeploymentAction undeployModification;

    UndeployDeploymentPlanBuilderImpl(DeploymentPlanBuilderImpl existing, DeploymentSetPlanImpl setPlan) {
        super(existing, setPlan);
        DeploymentAction modification = setPlan.getLastAction();
        if (modification.getType() != DeploymentAction.Type.UNDEPLOY) {
            throw ControllerClientMessages.MESSAGES.invalidActionType(modification.getType());
        }
        this.undeployModification = modification;
    }

    @Override
    public ServerGroupDeploymentPlanBuilder toServerGroup(String serverGroupName) {
        return super.toServerGroup(serverGroupName);
    }

    @Override
    public RemoveDeploymentPlanBuilder andRemoveUndeployed() {
        DeploymentSetPlanImpl currentSet = this.getCurrentDeploymentSetPlan();
        if (currentSet.hasServerGroupPlans()) {
            throw ControllerClientMessages.MESSAGES.cannotAddDeploymentActionsAfterStart();
        }
        DeploymentActionImpl mod = DeploymentActionImpl.getRemoveAction(this.undeployModification.getDeploymentUnitUniqueName());
        DeploymentSetPlanImpl newSet = currentSet.addAction(mod);
        return new RemoveDeploymentPlanBuilderImpl((DeploymentPlanBuilderImpl)this, newSet);
    }
}

