/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.global;

import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelUpdateOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationHandler;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.operations.validation.InetAddressValidator;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ListValdidator;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class WriteAttributeHandlers {

    public static class ListValidatatingHandler
    extends WriteAttributeOperationHandler {
        public ListValidatatingHandler(ParameterValidator elementValidator) {
            this(elementValidator, false, 1, Integer.MAX_VALUE);
        }

        public ListValidatatingHandler(ParameterValidator elementValidator, boolean nullable) {
            this(elementValidator, nullable, 1, Integer.MAX_VALUE);
        }

        public ListValidatatingHandler(ParameterValidator elementValidator, boolean nullable, int minSize, int maxSize) {
            super(new ListValdidator(elementValidator, nullable, minSize, maxSize));
        }
    }

    public static class InetAddressValidatingHandler
    extends WriteAttributeOperationHandler {
        public InetAddressValidatingHandler(boolean nullable, boolean allowExpressions) {
            super(new InetAddressValidator(nullable, allowExpressions));
        }
    }

    public static class IntRangeValidatingHandler
    extends WriteAttributeOperationHandler {
        public IntRangeValidatingHandler(int min) {
            this(min, Integer.MAX_VALUE, false, true);
        }

        public IntRangeValidatingHandler(int min, boolean nullable) {
            this(min, Integer.MAX_VALUE, nullable, true);
        }

        public IntRangeValidatingHandler(int min, int max, boolean nullable, boolean allowExpressions) {
            super(new IntRangeValidator(min, max, nullable, allowExpressions));
        }
    }

    public static class StringLengthValidatingHandler
    extends WriteAttributeOperationHandler {
        public StringLengthValidatingHandler(int min) {
            this(min, Integer.MAX_VALUE, false, true);
        }

        public StringLengthValidatingHandler(int min, boolean nullable) {
            this(min, Integer.MAX_VALUE, nullable, true);
        }

        public StringLengthValidatingHandler(int min, int max, boolean nullable, boolean allowExpressions) {
            super(new StringLengthValidator(min, max, nullable, allowExpressions));
        }
    }

    public static class ModelTypeValidatingHandler
    extends WriteAttributeOperationHandler {
        public ModelTypeValidatingHandler(ModelType type) {
            this(false, false, false, type, new ModelType[0]);
        }

        public ModelTypeValidatingHandler(ModelType type, boolean nullable) {
            this(nullable, false, false, type, new ModelType[0]);
        }

        public ModelTypeValidatingHandler(ModelType type, boolean nullable, boolean allowExpressions) {
            this(nullable, allowExpressions, false, type, new ModelType[0]);
        }

        public ModelTypeValidatingHandler(ModelType type, boolean nullable, boolean allowExpressions, boolean strict) {
            this(nullable, allowExpressions, strict, type, new ModelType[0]);
        }

        public ModelTypeValidatingHandler(boolean nullable, boolean allowExpressions, boolean strict, ModelType firstValidType, ModelType ... otherValidTypes) {
            super(new ModelTypeValidator(nullable, allowExpressions, strict, firstValidType, otherValidTypes));
        }
    }

    public static class WriteAttributeOperationHandler
    implements ModelUpdateOperationHandler {
        public static OperationHandler INSTANCE = new WriteAttributeOperationHandler();
        final ParameterValidator validator;

        private WriteAttributeOperationHandler() {
            this(null);
        }

        protected WriteAttributeOperationHandler(ParameterValidator validator) {
            this.validator = validator;
        }

        @Override
        public OperationResult execute(OperationContext context, ModelNode operation, ResultHandler resultHandler) throws OperationFailedException {
            String name = operation.require("name").asString();
            ModelNode value = operation.get("value");
            this.validateValue(name, value);
            context.getSubModel().get(name).set(value);
            resultHandler.handleResultComplete();
            return new BasicOperationResult();
        }

        protected void validateValue(String name, ModelNode value) throws OperationFailedException {
            if (this.validator != null) {
                this.validator.validateParameter(name, value);
            }
        }
    }
}

