/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.remote;

import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.remote.ModelControllerOperationHandler;
import org.jboss.as.controller.remote.ModelControllerOperationHandlerImpl;
import org.jboss.as.protocol.MessageHandler;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class ModelControllerOperationHandlerService
implements Service<ModelControllerOperationHandler> {
    private static final Logger log = Logger.getLogger((String)"org.jboss.server.management");
    public static final ServiceName OPERATION_HANDLER_NAME_SUFFIX = ServiceName.of((String[])new String[]{"operation", "handler"});
    private final InjectedValue<ModelController> modelControllerValue = new InjectedValue();
    private volatile ModelControllerOperationHandler handler;

    public InjectedValue<ModelController> getModelControllerValue() {
        return this.modelControllerValue;
    }

    public void start(StartContext context) throws StartException {
        ModelController modelController = (ModelController)this.modelControllerValue.getValue();
        MessageHandler initialMessageHandler = this.getInitialMessageHandler();
        this.handler = this.createOperationHandler(modelController, initialMessageHandler);
    }

    public void stop(StopContext context) {
        this.handler = null;
    }

    public ModelControllerOperationHandler getValue() throws IllegalStateException {
        return this.handler;
    }

    protected void setHandler(ModelControllerOperationHandler handler) {
        this.handler = handler;
    }

    protected MessageHandler getInitialMessageHandler() {
        return MessageHandler.NULL;
    }

    protected ModelControllerOperationHandler createOperationHandler(ModelController modelController, MessageHandler initialMessageHandler) {
        return new ModelControllerOperationHandlerImpl(modelController, initialMessageHandler);
    }
}

